PRAGMA foreign_keys = OFF;

-- ----------------------------
-- Table structure for sec_apps
-- ----------------------------
DROP TABLE IF EXISTS "sec_apps";
CREATE TABLE "sec_apps" (
"app_name"  TEXT(128) COLLATE NOCASE NOT NULL,
"app_type"  TEXT(255) COLLATE NOCASE,
"description"  TEXT(255) COLLATE NOCASE,
PRIMARY KEY ("app_name")
);

-- ----------------------------
-- Records of sec_apps
-- ----------------------------
INSERT INTO "sec_apps" VALUES ('app_change_pswd', 'contr', 'Security Application'), ('app_form_edit_users', 'form', 'Security Application'), ('app_form_sec_apps', 'form', 'Security Application'), ('app_form_sec_groups', 'form', 'Security Application'), ('app_form_sec_groups_apps', 'form', 'Security Application'), ('app_grid_sec_apps', 'cons', 'Security Application'), ('app_grid_sec_groups', 'cons', 'Security Application'), ('app_grid_sec_users', 'cons', 'Security Application'), ('app_grid_sec_users_groups', 'form', 'Security Application'), ('app_Login', 'contr', 'Security Application'), ('app_menu', 'menu', 'Security Application'), ('app_retrieve_pswd', 'contr', 'Security Application'), ('app_search_sec_groups', 'filter', 'Security Application'), ('app_sync_apps', 'contr', 'Security Application'), ('blank_pipeline', 'blank', ''), ('blank_pipeline_ajax', 'blank', ''), ('ctrl_mandrill_send_mail', 'contr', ''), ('form_tb_activities', 'form', ''), ('form_tb_activities_type', 'form', ''), ('form_tb_contacts', 'form', ''), ('form_tb_contacts_emails', 'form', ''), ('form_tb_contacts_phones', 'form', ''), ('form_tb_deals', 'form', ''), ('form_tb_deals_copy', 'form', null), ('form_tb_deals_x_products', 'form', null), ('form_tb_deal_steps', 'form', ''), ('form_tb_lead_source', 'form', ''), ('form_tb_organizations', 'form', ''), ('form_tb_organization_fields', 'form', ''), ('form_tb_participants', 'form', null), ('form_tb_products', 'form', ''), ('form_tb_sellers', 'form', ''), ('grid_tb_activities_history_org', 'cons', null), ('grid_tb_contacts', 'cons', ''), ('grid_tb_deals', 'cons', ''), ('grid_tb_organizations', 'cons', ''), ('grid_tb_products', 'cons', ''), ('grid_tb_sellers', 'cons', ''), ('list_tbl_mandrill_info', 'cons', ''), ('list_tbl_mandrill_templates', 'cons', ''), ('report_tb_deals_history', 'cons', null), ('repport_tb_deals', 'cons', null), ('tbl_mandrill_info', 'form', ''), ('tbl_mandrill_templates', 'form', '');

-- ----------------------------
-- Table structure for sec_groups
-- ----------------------------
DROP TABLE IF EXISTS "sec_groups";
CREATE TABLE "sec_groups" (
"group_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"description"  TEXT(255) COLLATE NOCASE
)

;

-- ----------------------------
-- Records of sec_groups
-- ----------------------------
INSERT INTO "sec_groups" VALUES ('1', 'Administrator'), ('2', 'Seller');

-- ----------------------------
-- Table structure for sec_groups_apps
-- ----------------------------
DROP TABLE IF EXISTS "sec_groups_apps";
CREATE TABLE "sec_groups_apps" (
"group_id"  INTEGER(11) NOT NULL,
"app_name"  TEXT(128) COLLATE NOCASE NOT NULL,
"priv_access"  TEXT(1) COLLATE NOCASE,
"priv_insert"  TEXT(1) COLLATE NOCASE,
"priv_delete"  TEXT(1) COLLATE NOCASE,
"priv_update"  TEXT(1) COLLATE NOCASE,
"priv_export"  TEXT(1) COLLATE NOCASE,
"priv_print"  TEXT(1) COLLATE NOCASE,
PRIMARY KEY ("group_id", "app_name"),
FOREIGN KEY ("group_id") REFERENCES "sec_groups" ("group_id"),
FOREIGN KEY ("app_name") REFERENCES "sec_apps" ("app_name")
)

;

-- ----------------------------
-- Records of sec_groups_apps
-- ----------------------------
INSERT INTO "sec_groups_apps" VALUES ('1', 'app_change_pswd', 'Y', 'N', 'N', 'N', 'N', 'N'), ('1', 'app_form_edit_users', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'app_form_sec_apps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'app_form_sec_groups', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'app_form_sec_groups_apps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'app_grid_sec_apps', 'Y', '', '', '', 'Y', 'Y'), ('1', 'app_grid_sec_groups', 'Y', '', '', '', 'Y', 'Y'), ('1', 'app_grid_sec_users', 'Y', '', '', '', 'Y', 'Y'), ('1', 'app_grid_sec_users_groups', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'app_Login', 'Y', '', '', '', '', ''), ('1', 'app_menu', 'Y', '', '', '', '', ''), ('1', 'app_retrieve_pswd', 'Y', '', '', '', '', ''), ('1', 'app_search_sec_groups', 'Y', '', '', '', '', ''), ('1', 'app_sync_apps', 'Y', '', '', '', '', ''), ('1', 'blank_pipeline', 'Y', '', '', '', '', ''), ('1', 'blank_pipeline_ajax', 'Y', '', '', '', '', ''), ('1', 'ctrl_mandrill_send_mail', 'Y', '', '', '', '', ''), ('1', 'form_tb_activities', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_activities_type', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_contacts', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_contacts_emails', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_contacts_phones', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_deals', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_deals_copy', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_deals_x_products', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_deal_steps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_lead_source', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_organizations', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_organization_fields', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_participants', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_products', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_sellers', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'grid_tb_activities_history_org', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_contacts', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_deals', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_organizations', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_products', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_sellers', 'Y', '', '', '', 'Y', 'Y'), ('1', 'list_tbl_mandrill_info', 'Y', '', '', '', 'Y', 'Y'), ('1', 'list_tbl_mandrill_templates', 'Y', '', '', '', 'Y', 'Y'), ('1', 'report_tb_deals_history', 'Y', '', '', '', 'Y', 'Y'), ('1', 'repport_tb_deals', 'Y', '', '', '', 'Y', 'Y'), ('1', 'tbl_mandrill_info', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'tbl_mandrill_templates', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'app_change_pswd', 'Y', 'N', 'N', 'N', 'N', 'N'), ('2', 'app_form_edit_users', '', '', '', '', '', ''), ('2', 'app_form_sec_apps', '', '', '', '', '', ''), ('2', 'app_form_sec_groups', '', '', '', '', '', ''), ('2', 'app_form_sec_groups_apps', '', '', '', '', '', ''), ('2', 'app_grid_sec_apps', '', '', '', '', '', ''), ('2', 'app_grid_sec_groups', '', '', '', '', '', ''), ('2', 'app_grid_sec_users', '', '', '', '', '', ''), ('2', 'app_grid_sec_users_groups', '', '', '', '', '', ''), ('2', 'app_Login', 'Y', '', '', '', '', ''), ('2', 'app_menu', 'Y', '', '', '', '', ''), ('2', 'app_retrieve_pswd', 'Y', '', '', '', '', ''), ('2', 'app_search_sec_groups', '', '', '', '', '', ''), ('2', 'app_sync_apps', '', '', '', '', '', ''), ('2', 'blank_pipeline', 'Y', '', '', '', '', ''), ('2', 'blank_pipeline_ajax', 'Y', '', '', '', '', ''), ('2', 'ctrl_mandrill_send_mail', 'Y', '', '', '', '', ''), ('2', 'form_tb_activities', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_activities_type', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_contacts', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_contacts_emails', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_contacts_phones', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_deals', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_deals_copy', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_deals_x_products', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_deal_steps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_lead_source', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_organizations', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_organization_fields', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_participants', null, null, null, null, null, null), ('2', 'form_tb_products', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_sellers', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'grid_tb_activities_history_org', null, null, null, null, null, null), ('2', 'grid_tb_contacts', 'Y', '', '', '', 'Y', 'Y'), ('2', 'grid_tb_deals', 'Y', '', '', '', 'Y', 'Y'), ('2', 'grid_tb_organizations', 'Y', '', '', '', 'Y', 'Y'), ('2', 'grid_tb_products', 'Y', '', '', '', 'Y', 'Y'), ('2', 'grid_tb_sellers', 'Y', '', '', '', 'Y', 'Y'), ('2', 'list_tbl_mandrill_info', '', '', '', '', '', ''), ('2', 'list_tbl_mandrill_templates', '', '', '', '', '', ''), ('2', 'report_tb_deals_history', null, null, null, null, null, null), ('2', 'repport_tb_deals', null, null, null, null, null, null), ('2', 'tbl_mandrill_info', '', '', '', '', '', ''), ('2', 'tbl_mandrill_templates', '', '', '', '', '', '');

-- ----------------------------
-- Table structure for sec_users
-- ----------------------------
DROP TABLE IF EXISTS "sec_users";
CREATE TABLE "sec_users" (
"login"  TEXT(255) COLLATE NOCASE NOT NULL,
"pswd"  TEXT(255) COLLATE NOCASE NOT NULL,
"name"  TEXT(64) COLLATE NOCASE,
"email"  TEXT(255) COLLATE NOCASE,
"active"  TEXT(1) COLLATE NOCASE,
"activation_code"  TEXT(32) COLLATE NOCASE,
"priv_admin"  TEXT(1) COLLATE NOCASE,
PRIMARY KEY ("login")
)

;

-- ----------------------------
-- Records of sec_users
-- ----------------------------
INSERT INTO "sec_users" VALUES ('admin', 'admin', 'Admin', 'admin@admin.com', 'Y', null, 'Y'), ('carlos', 'carlos', 'Carlos', 'carlos@scriptcase.net', 'Y', null, 'Y'), ('harry', 'harry', 'Harry', 'harry@scriptcase.net', 'Y', null, 'Y'), ('john', '1234', 'John', 'john@scriptcase.net', 'Y', null, 'Y'), ('marcia', 'marcia', 'Marcia', 'marcia@scriptcase.net', 'Y', null, 'Y'), ('maria', 'maria', 'Maria', 'maria@scriptcase.net', 'Y', null, 'Y'), ('mark', '1234', 'Mark', 'mark@scriptcase.net', 'Y', null, 'Y'), ('matheus', '1234', 'Matheus', 'mts@scriptcase.net', 'Y', null, 'Y'), ('paul', 'paul', 'Paul', 'paul@scriptcase.net', 'Y', null, 'Y');

-- ----------------------------
-- Table structure for sec_users_groups
-- ----------------------------
DROP TABLE IF EXISTS "sec_users_groups";
CREATE TABLE "sec_users_groups" (
"login"  TEXT(255) COLLATE NOCASE NOT NULL,
"group_id"  INTEGER(11) NOT NULL,
PRIMARY KEY ("login", "group_id"),
FOREIGN KEY ("login") REFERENCES "sec_users" ("login"),
FOREIGN KEY ("group_id") REFERENCES "sec_groups" ("group_id")
)

;

-- ----------------------------
-- Records of sec_users_groups
-- ----------------------------
INSERT INTO "sec_users_groups" VALUES ('admin', '1'), ('carlos', '2'), ('harry', '2'), ('john', '2'), ('marcia', '2'), ('maria', '2'), ('mark', '2'), ('matheus', '2'), ('paul', '2');

-- ----------------------------
-- Table structure for tb_activities
-- ----------------------------
DROP TABLE IF EXISTS "tb_activities";
CREATE TABLE "tb_activities" (
"activities_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"activities_type_id"  INTEGER(11) NOT NULL,
"activities_title"  TEXT(150) COLLATE NOCASE,
"deals_id"  INTEGER(11) NOT NULL,
"sellers_id"  INTEGER(11) NOT NULL,
"activities_notes"  TEXT COLLATE NOCASE,
"activities_date"  TEXT COLLATE NOCASE,
"activities_time"  TEXT COLLATE NOCASE,
"activities_done"  TEXT(1) COLLATE NOCASE,
FOREIGN KEY ("activities_type_id") REFERENCES "tb_activities_type" ("activities_type_id"),
FOREIGN KEY ("deals_id") REFERENCES "tb_deals" ("deals_id"),
FOREIGN KEY ("sellers_id") REFERENCES "tb_sellers" ("sellers_id")
)

;

-- ----------------------------
-- Records of tb_activities
-- ----------------------------
INSERT INTO "tb_activities" VALUES ('1', '2', 'Schedule a presentation', '2', '2', 'Didn''t answer', '2018-07-26', '10:00:00', 'Y'), ('2', '2', 'Schedule a presentation', '2', '2', 'New try', '2018-07-30', '11:00:00', 'Y'), ('3', '3', 'Meeting', '3', '2', '', '2018-06-14', '16:00:00', 'N'), ('4', '1', 'Write proposal', '7', '2', '', '2018-07-27', '10:00:00', 'N'), ('5', '2', 'Call', '11', '2', '', '2018-07-27', '10:00:00', 'Y'), ('6', '3', 'In Loco', '11', '1', '', '2018-08-20', '14:00:00', 'N'), ('7', '2', 'Call', '8', '2', '', '2018-07-18', '09:00:00', 'Y'), ('8', '2', 'Schedule a presentation', '8', '2', '', '2018-07-20', '10:00:00', 'Y'), ('9', '1', 'Presentation', '8', '2', '', '2018-07-24', '16:00:00', 'N'), ('17', '2', 'Call', '3', '2', '', '2018-06-15', '14:00:00', 'Y'), ('18', '4', 'Email', '3', '2', '', '2018-06-15', '16:00:00', 'Y'), ('19', '5', 'Presentation', '3', '2', '', '2018-06-22', '16:00:00', 'Y'), ('20', '2', 'Call', '1', '2', '', '2018-07-01', '10:00:00', 'Y'), ('21', '4', 'Email', '1', '2', '', '2018-07-01', '12:00:00', 'Y'), ('22', '6', 'Lunch ', '1', '2', '', '2018-07-04', '13:00:00', 'Y'), ('23', '3', 'Meeting', '1', '2', '', '2018-07-10', '16:00:00', 'Y'), ('24', '2', 'Call', '1', '2', '', '2018-07-16', '09:00:00', 'Y'), ('25', '2', 'Call', '1', '2', '', '2018-07-18', '09:00:00', 'N'), ('26', '1', 'Task', '1', '2', '', '2018-07-20', '14:00:00', 'Y'), ('27', '3', 'Meeting', '1', '2', '', '2018-07-31', '10:00:00', 'Y'), ('28', '2', 'Call', '1', '2', '', '2018-08-03', '14:00:00', 'N'), ('29', '4', 'Email', '1', '2', '', '2018-08-09', null, 'N'), ('30', '6', 'Lunch', '1', '2', '', '2018-08-13', '12:00:00', 'N'), ('31', '2', 'Call', '9', '2', '', '2018-07-26', '14:00:00', 'Y'), ('32', '4', 'Email', '9', '2', '', '2018-07-27', '09:00:00', 'Y'), ('33', '2', 'Call', '9', '2', '', '2018-07-30', '16:00:00', 'N'), ('34', '5', 'Presentation', '9', '2', '', '2018-08-01', '16:00:00', 'Y'), ('35', '4', 'Email', '9', '2', '', '2018-08-01', '18:00:00', 'Y'), ('36', '1', 'Task', '9', '2', '', '2018-08-02', '09:00:00', 'Y'), ('37', '6', 'Lunch', '9', '2', '', '2018-08-06', '12:00:00', 'N'), ('38', '2', 'Call', '9', '2', '', '2018-08-17', '16:00:00', 'Y'), ('39', '5', 'Presentation', '9', '2', '', '2018-09-08', '09:00:00', 'N'), ('40', '4', 'Email', '9', '2', '', '2018-08-09', '14:00:00', 'N'), ('41', '2', 'Call', '9', '2', '', '2018-08-17', '10:00:00', 'N'), ('42', '6', 'Lunch', '9', '2', '', '2018-08-20', '12:00:00', 'N'), ('43', '2', 'Call', '17', '3', '', '2018-08-09', '10:00:00', 'Y'), ('44', '4', 'Email', '17', '3', '', '2018-08-13', '14:00:00', 'N'), ('45', '6', 'Lunch', '17', '3', '', '2018-08-14', '12:00:00', 'N'), ('46', '3', 'Meeting', '17', '3', '', '2018-08-14', '14:00:00', 'N'), ('47', '1', 'Task', '17', '3', '', '2018-08-16', '16:00:00', 'N'), ('48', '3', 'Meeting', '17', '3', '', '2018-08-17', '16:00:00', 'N'), ('49', '2', 'Call', '17', '3', '', '2018-08-20', '10:00:00', 'N'), ('50', '4', 'Email', '17', '3', '', '2018-08-20', '14:00:00', 'N'), ('51', '5', 'Presentation', '17', '3', '', '2018-08-22', '16:00:00', 'N'), ('52', '2', 'Call', '6', '2', '', '2018-07-20', '10:00:00', 'Y'), ('53', '4', 'Email', '6', '2', '', '2018-07-20', '14:00:00', 'Y'), ('54', '4', 'Email', '6', '2', '', '2018-07-23', '09:00:00', 'Y'), ('55', '3', 'Meeting', '6', '2', '', '2018-07-26', '10:00:00', 'Y'), ('56', '6', 'Lunch', '6', '2', '', '2018-07-27', '12:00:00', 'Y'), ('57', '2', 'Call', '6', '2', '', '2018-07-30', '10:00:00', 'N'), ('58', '3', 'Meeting', '6', '2', '', '2018-07-31', '14:00:00', 'Y'), ('59', '5', 'Presentation', '6', '2', '', '2018-08-02', '14:00:00', 'Y'), ('60', '2', 'Call', '6', '2', '', '2018-08-03', '09:00:00', 'N'), ('61', '6', 'Lunch', '6', '2', '', '2018-08-10', '12:00:00', 'Y'), ('62', '2', 'Call', '6', '2', '', '2018-08-14', '14:00:00', 'N'), ('63', '3', 'Meeting', '6', '2', '', '2018-08-15', '14:00:00', 'N'), ('64', '1', 'Task', '6', '2', '', '2018-08-15', '16:00:00', 'N'), ('65', '5', 'Presentation', '6', '2', '', '2018-08-17', '14:00:00', 'N'), ('66', '4', 'Email', '6', '2', '', '2018-08-21', '10:00:00', 'N'), ('67', '2', 'Call', '6', '2', '', '2018-08-22', '14:00:00', 'N'), ('68', '2', 'Call', '6', '2', '', '2018-08-23', '10:00:00', 'N'), ('69', '6', 'Lunch', '6', '2', '', '2018-08-24', '12:00:00', 'N'), ('70', '3', 'Meeting', '6', '2', '', '2018-08-27', '14:00:00', 'N'), ('71', '5', 'Presentation', '6', '2', '', '2018-08-29', '16:00:00', 'N'), ('72', '1', 'Task', '6', '2', '', '2018-08-30', '10:00:00', 'N'), ('73', '2', 'Cal', '11', '2', '', '2018-08-30', '10:00:00', 'N'), ('74', '6', 'Lunch', '11', '2', '', '2018-09-12', '12:00:00', 'N'), ('75', '3', 'In Loco', '11', '2', '', '2018-09-19', '16:00:00', 'N'), ('76', '2', 'Call', '11', '2', '', '2018-11-09', '10:00:00', 'N'), ('77', '5', 'Presentation', '11', '2', '', '2018-11-23', '14:00:00', 'N'), ('78', '1', 'Task', '11', '2', '', '2018-12-14', '09:00:00', 'N'), ('79', '3', 'Meeting', '11', '2', '', '2018-12-28', '14:00:00', 'N'), ('80', '2', 'Skype', '10', '1', '', '2018-07-30', '10:00:00', 'Y'), ('81', '4', 'Briefing', '10', '1', '', '2018-07-31', '14:00:00', 'Y'), ('82', '4', 'Email', '10', '3', '', '2018-08-01', '09:00:00', 'Y'), ('83', '6', 'Lunch', '10', '1', '', '2018-08-03', '12:00:00', 'Y'), ('84', '3', 'In Loco', '10', '1', '', '2018-08-03', '14:00:00', 'Y'), ('85', '5', 'Presentation', '10', '1', '', '2018-08-17', '16:00:00', 'N'), ('86', '1', 'Task', '10', '1', '', '2018-08-17', '18:00:00', 'N'), ('87', '4', 'Email', '10', '1', '', '2018-08-20', '10:00:00', 'N'), ('88', '3', 'In Loco', '10', '1', '', '2018-08-22', '14:00:00', 'N'), ('89', '2', 'Call', '10', '2', '', '2018-09-14', '10:00:00', 'N'), ('90', '4', 'Email', '10', '1', '', '2018-09-17', '09:00:00', 'N'), ('91', '3', 'In Loco', '10', '1', '', '2018-10-05', '14:00:00', 'N'), ('92', '4', 'Email', '10', '1', '', '2018-10-17', '09:00:00', 'N'), ('93', '1', 'Task', '10', '1', '', '2018-10-19', '10:00:00', 'N'), ('94', '2', 'Call', '10', '1', '', '2018-10-25', '14:00:00', 'N'), ('95', '3', 'In Loco', '10', '1', '', '2018-10-31', '10:00:00', 'N'), ('96', '14', 'Llamada', '30', '8', '', '2018-08-18', '10:00:00', 'N'), ('97', '16', 'Schedule a presentation', '13', '5', '', '2018-08-16', '15:00:00', 'N'), ('98', '17', 'Presentación', '24', '3', '', '2018-09-22', '10:00:00', 'N'), ('99', '10', 'Proposta', '53', '4', '', '2018-09-20', '10:00:00', 'N'), ('101', '8', 'Aguardando resposta', '39', '4', '', '2018-11-20', '09:00:00', 'N'), ('102', '16', 'Schedule a presentation', '64', '5', '', '2018-08-29', '10:00:00', 'Y'), ('103', '17', 'Presentación', '64', '6', '', '2018-10-10', '10:00:00', 'N'), ('104', '14', 'Call', '25', '4', '', '2018-09-04', '11:00:00', 'N');

-- ----------------------------
-- Table structure for tb_activities_type
-- ----------------------------
DROP TABLE IF EXISTS "tb_activities_type";
CREATE TABLE "tb_activities_type" (
"activities_type_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"activities_type_descr"  TEXT(150) COLLATE NOCASE NOT NULL,
"activities_type_lang"  TEXT(5) COLLATE NOCASE
)

;

-- ----------------------------
-- Records of tb_activities_type
-- ----------------------------
INSERT INTO "tb_activities_type" VALUES ('1', 'Task', 'en_us'), ('2', 'Call', 'en_us'), ('3', 'Meeting', 'en_us'), ('4', 'Email', 'en_us'), ('5', 'Presentation', 'en_us'), ('6', 'Lunch', 'en_us'), ('7', 'Tarefa', 'pt_br'), ('8', 'Telefonema', 'pt_br'), ('9', 'Reunião', 'pt_br'), ('10', 'E-mail', 'pt_br'), ('11', 'Apresentação', 'pt_br'), ('12', 'Almoço', 'pt_br'), ('13', 'Tarea', 'es'), ('14', 'Llamada', 'es'), ('15', 'Reunión', 'es'), ('16', 'E-mail', 'es'), ('17', 'Presentación', 'es'), ('18', 'Almuerzo', 'es'), ('22', 'Tarea', 'es'), ('26', 'Visita', 'pt_br');

-- ----------------------------
-- Table structure for tb_contacts
-- ----------------------------
DROP TABLE IF EXISTS "tb_contacts";
CREATE TABLE "tb_contacts" (
"contact_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"organization_id"  INTEGER(11) NOT NULL,
"contact_name"  TEXT(150) COLLATE NOCASE NOT NULL,
"contact_title"  TEXT(150) COLLATE NOCASE,
"contact_email"  TEXT(150) COLLATE NOCASE,
"contact_phone"  TEXT(20) COLLATE NOCASE,
"lead_source_id"  INTEGER(11) NOT NULL,
FOREIGN KEY ("lead_source_id") REFERENCES "tb_lead_source" ("lead_source_id"),
FOREIGN KEY ("organization_id") REFERENCES "tb_organizations" ("organization_id")
)

;

-- ----------------------------
-- Records of tb_contacts
-- ----------------------------
INSERT INTO "tb_contacts" VALUES ('1', '1', 'Victor', 'CIO', '', '', '1'), ('2', '1', 'Laurence', 'CFO', '', '', '3'), ('4', '4', 'Mark Zukemberg', 'Owner', '', '', '2'), ('5', '3', 'Sergey Brin', 'Owner', '', '', '5'), ('6', '3', ' Larry Page', 'Owner', '', '', '5'), ('7', '1', 'Márcia Araújo', 'Sales Manager', '', '', '12'), ('8', '5', 'Thiago', 'Owner', '', '', '8'), ('9', '6', 'FRANCISCO RICARDO', 'jdiretor', '', '', '8'), ('10', '5', 'FRANCISCO RICARDO', 'jdiretor', '', '', '8'), ('11', '7', 'Federico', 'Sales Director', '', '', '3'), ('12', '8', 'Billy Gate', 'CEO', '', '', '12'), ('13', '5', 'FRANCISCO RICARDO', 'jdiretor', '', '', '8'), ('15', '4', 'Alex Sanchez', 'CFO', '', '', '10'), ('16', '5', 'FRANCISCO RICARDO', 'jdiretor', '', '', '8');

-- ----------------------------
-- Table structure for tb_contacts_emails
-- ----------------------------
DROP TABLE IF EXISTS "tb_contacts_emails";
CREATE TABLE "tb_contacts_emails" (
"contacts_emails_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"contacts_emails_descr"  TEXT(150) COLLATE NOCASE NOT NULL,
"contact_id"  INTEGER(11) NOT NULL,
FOREIGN KEY ("contact_id") REFERENCES "tb_contacts" ("contact_id")
)

;

-- ----------------------------
-- Records of tb_contacts_emails
-- ----------------------------
INSERT INTO "tb_contacts_emails" VALUES ('1', 'vitor@scriptcase.net', '1'), ('2', 'victor@scriptcase.net', '1'), ('3', 'laur@scriptcase.net', '2'), ('5', 'mark@facebook.com', '4'), ('6', 'sergey@gmail.com', '5'), ('7', 'larry@gmail.com', '6'), ('8', 'marcia@scriptcase.net', '7'), ('9', 'marcia@scriptcase.net', '8'), ('10', 'maria@scriptcase.net', '10'), ('11', 'federico@scriptcase.net', '11'), ('12', 'billy@microsoftware.com', '12');

-- ----------------------------
-- Table structure for tb_contacts_phones
-- ----------------------------
DROP TABLE IF EXISTS "tb_contacts_phones";
CREATE TABLE "tb_contacts_phones" (
"contacts_phones_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"contacts_phones_number"  TEXT(45) COLLATE NOCASE NOT NULL,
"contact_id"  INTEGER(11) NOT NULL,
FOREIGN KEY ("contact_id") REFERENCES "tb_contacts" ("contact_id")
)

;

-- ----------------------------
-- Records of tb_contacts_phones
-- ----------------------------
INSERT INTO "tb_contacts_phones" VALUES ('1', '1111222222', '1'), ('2', '1234567890', '1'), ('3', '551112225544', '2'), ('4', '5511444552211', '2'), ('6', '+1333024985', '4'), ('7', '+1556398785', '5'), ('8', '+1325879547', '6'), ('9', '+558154857967', '7'), ('10', '+558518459776', '10'), ('11', '+558123658974', '11'), ('12', '+1-800-925-0609', '12');

-- ----------------------------
-- Table structure for tb_deal_steps
-- ----------------------------
DROP TABLE IF EXISTS "tb_deal_steps";
CREATE TABLE "tb_deal_steps" (
"deal_steps_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"deal_steps_descr"  TEXT(150) COLLATE NOCASE NOT NULL,
"deal_steps_lang"  TEXT(5) COLLATE NOCASE,
"deal_steps_order"  INTEGER(2),
FOREIGN KEY ("deal_steps_lang") REFERENCES "tb_languages" ("lang_id")
)

;

-- ----------------------------
-- Records of tb_deal_steps
-- ----------------------------
INSERT INTO "tb_deal_steps" VALUES ('1', 'Lead in', 'en_us', '1'), ('2', 'Contact Made', 'en_us', '2'), ('3', 'In Progress', 'en_us', '3'), ('4', 'Proposal Made', 'en_us', '4'), ('5', 'In Negotiation', 'en_us', '5'), ('6', 'Sem Contato', 'pt_br', '1'), ('7', 'Contato Feito', 'pt_br', '2'), ('8', 'Em Progresso', 'pt_br', '3'), ('9', 'Proposta Enviada', 'pt_br', '4'), ('10', 'Em Negociação', 'pt_br', '5'), ('11', 'Sin Contacto', 'es', '1'), ('12', 'Contacto Hecho', 'es', '2'), ('13', 'En Progreso', 'es', '3'), ('14', 'Propuesta Enviada', 'es', '4'), ('15', 'En Negociacion', 'es', '5');

-- ----------------------------
-- Table structure for tb_deals
-- ----------------------------
DROP TABLE IF EXISTS "tb_deals";
CREATE TABLE "tb_deals" (
"deals_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"deals_title"  TEXT(150) COLLATE NOCASE NOT NULL,
"deal_steps_id"  INTEGER(11),
"deal_value"  REAL(9,2),
"deal_start"  TEXT COLLATE NOCASE,
"deal_end"  TEXT COLLATE NOCASE,
"deal_expected_close"  TEXT COLLATE NOCASE,
"contact_id"  INTEGER(11),
"owner_seller"  INTEGER(11),
"deal_evaluation"  INTEGER(11),
"deal_won"  TEXT(1) COLLATE NOCASE,
"deal_lang"  TEXT(5) COLLATE NOCASE,
FOREIGN KEY ("contact_id") REFERENCES "tb_contacts" ("contact_id"),
FOREIGN KEY ("deal_steps_id") REFERENCES "tb_deal_steps" ("deal_steps_id"),
FOREIGN KEY ("owner_seller") REFERENCES "tb_sellers" ("sellers_id")
)

;

-- ----------------------------
-- Records of tb_deals
-- ----------------------------
INSERT INTO "tb_deals" VALUES ('1', 'Deal 1', '1', '30000.00', '2018-06-01', null, '2018-08-31', '2', '2', '3', 'O', 'en_us'), ('2', 'Deal 2', '4', '10000.00', '2018-06-25', null, '2018-10-31', '1', '3', '3', 'O', 'en_us'), ('3', 'Deal 3', '2', '5000.00', '2018-06-14', '2018-06-22', '2018-06-22', '1', '1', '3', 'N', 'en_us'), ('6', 'Deal 6', '3', '8000.00', '2018-07-20', null, '2018-08-31', '1', '2', '3', 'O', 'en_us'), ('7', 'Deal 7', '4', '5000.00', '2018-07-23', '2018-08-15', '2018-08-15', '1', '2', '2', 'Y', 'en_us'), ('8', 'Deal 8', '5', '20000.00', '2018-07-16', null, '2018-10-16', '1', '2', '4', 'O', 'en_us'), ('9', 'Deal 9', '1', '10000.00', '2018-07-26', null, '2018-09-10', '1', '2', '3', 'O', 'en_us'), ('10', 'Deal 10', '4', '50000.00', '2018-07-30', null, '2018-10-31', '1', '1', '5', 'O', 'en_us'), ('11', 'New Deal', '3', '10000.00', '2018-07-26', null, '2018-12-21', '1', '2', '3', 'O', 'en_us'), ('12', 'Novo negócio', '9', '100000.00', '2018-08-07', null, '2018-08-08', '2', '2', '3', 'O', 'pt_br'), ('13', 'Negocio', '14', '745.00', '2018-04-07', null, '2018-08-31', '2', '2', '0', 'O', 'es'), ('14', 'Negocio X', '14', '50000.00', '2018-07-09', null, '2018-10-30', '6', '6', '0', 'O', 'es'), ('15', 'Novo Negócio 1', '7', '699.00', '2018-04-09', null, '2018-10-30', '2', '2', '0', 'O', 'pt_br'), ('16', 'Novo Negócio 2', '8', '1995.00', '2018-07-09', '2018-08-21', '2018-08-30', '2', '1', '0', 'Y', 'pt_br'), ('17', 'New Deal 3', '2', '32385.20', '2018-01-09', null, '2018-09-30', '2', '3', '4', 'O', 'en_us'), ('18', 'Novo Negócio 3', '6', '4893.00', '2018-01-13', null, '2019-03-21', '2', '2', '4', 'O', 'pt_br'), ('19', 'Novo Negócio 4', '8', '898.00', '2018-02-13', null, '2019-04-24', '2', '2', '1', 'O', 'pt_br'), ('20', 'Novo Negócio 5', '6', '1990.00', '2018-08-13', null, '2018-09-29', '4', '5', '2', 'O', 'pt_br'), ('21', 'New Deal 3', '1', '5000.00', '2018-07-09', '2018-08-21', '2018-08-30', '2', '4', '3', 'Y', 'en_us'), ('22', 'New Deal 4', '1', '20000.00', '2018-08-13', null, '2018-10-30', '5', '1', '4', 'O', 'en_us'), ('23', 'New license', '4', '699.00', '2018-06-01', '2018-06-30', '2018-06-20', '7', '1', '3', 'N', 'en_us'), ('24', 'Nuevo Negocio 2', '15', '10000.00', '2018-08-14', null, '2018-09-29', '6', '6', '1', 'O', 'es'), ('25', 'Nuevo Negocio 3', '11', '3000.00', '2018-08-14', null, '2019-03-21', '6', '6', '1', 'O', 'es'), ('26', 'Nuevo Negocio 4', '11', '20000.00', '2018-05-14', '2018-05-23', '2018-05-03', '5', '2', '3', 'Y', 'es'), ('27', 'Nuevo Negocio 5', '13', '5000.00', '2018-08-14', null, '2018-12-21', '6', '6', '2', 'O', 'es'), ('29', 'Negocio', '12', '13000.00', '2018-08-01', null, '2018-12-21', '6', '6', '4', 'O', 'es'), ('30', 'Negocio Teste', '12', '699.00', '2018-08-14', null, '2018-08-31', '7', '6', '4', 'O', 'es'), ('32', 'Nueva oportunidad 3', '11', '30000.00', '2018-08-20', null, '2019-03-21', '2', '4', '3', 'O', 'es'), ('37', 'Nova oportunidade 6', '9', '2000.00', '2018-06-01', '2018-06-30', '2018-06-20', '7', '1', '3', 'N', 'pt_br'), ('38', 'Nova oportunidade 7', '10', '2000.00', '2018-01-21', '2018-03-20', '2018-03-30', '2', '6', '3', 'Y', 'pt_br'), ('39', 'Nova oportunidade 8', '10', '10000.00', '2018-08-21', null, '2018-11-30', '2', '4', '3', 'O', 'pt_br'), ('40', 'Nova oportunidade 3', '10', '3000.00', '2018-05-14', '2018-05-23', '2018-05-03', '5', '2', '3', 'Y', 'pt_br'), ('42', 'Nova oportunidade 7', '7', '20000.00', '2018-08-21', null, '2018-08-31', null, null, null, 'O', 'pt_br'), ('44', 'Nova oportunidade 8', '8', '5000.00', '2018-05-14', '2018-05-23', '2018-05-03', '5', '2', '3', 'Y', 'pt_br'), ('46', 'Nova oportunidade 9', '10', '13000.00', '2018-08-01', '2018-08-08', '2018-08-17', '8', '6', '0', 'N', 'es'), ('48', 'Nova oportunidade 9', '10', '699.00', '2017-11-01', '2017-12-13', '2017-11-30', '9', '6', '1', 'Y', 'pt_br'), ('49', 'Nova oportunidade 6', '10', '30000.00', '2017-12-22', '2018-01-21', '2018-01-21', '8', '6', '0', 'Y', 'pt_br'), ('50', 'Nova oportunidade 7', '8', '45000.00', '2018-04-10', '2018-06-20', '2018-06-20', '12', '6', '0', 'Y', 'pt_br'), ('51', 'Nova oportunidade 8', '6', '8000.00', '2018-08-01', '2018-08-08', '2018-08-17', '8', '6', '0', 'N', 'pt_br'), ('52', 'Nova oportunidade 5', '6', '5000.00', '2018-06-01', '2018-06-30', '2018-06-20', '7', '1', '3', 'N', 'pt_br'), ('53', 'Nova oportunidade 6', '8', '20000.00', '2018-08-22', null, '2018-09-30', '8', '6', '0', 'O', 'pt_br'), ('54', 'Nova oportunidade 7', '9', '10000.00', '2018-06-01', '2018-06-30', '2018-06-20', '7', '1', '3', 'N', 'en_us'), ('55', 'Nova oportunidade 7', '9', '10000.00', '2018-05-01', '2018-06-05', '2018-06-12', '12', '6', '0', 'Y', 'pt_br'), ('59', 'Nova oportunidade 5', '10', '2000.00', '2018-08-23', null, '2018-11-30', '12', '8', '0', 'O', 'pt_br'), ('61', 'Nova oportunidade 7', '8', '10000.00', '2018-08-23', null, '2018-08-23', '15', '8', '3', 'O', 'pt_br'), ('64', 'Nueva oportunidad 3', '12', '50000.00', '2018-08-29', null, '2018-08-29', '2', '4', '5', 'O', 'es'), ('65', 'Nueva oportunidad 4', '11', '50000.00', '2018-08-29', null, '2018-12-15', '4', '4', '5', 'O', 'es');

-- ----------------------------
-- Table structure for tb_deals_x_products
-- ----------------------------
DROP TABLE IF EXISTS "tb_deals_x_products";
CREATE TABLE "tb_deals_x_products" (
"deals_id"  INTEGER(11) NOT NULL,
"product_id"  INTEGER(11) NOT NULL,
"unit_value"  REAL(9,2),
"qty"  INTEGER(5),
"discount"  REAL(9,2),
"total_value"  REAL(9,2),
PRIMARY KEY ("deals_id", "product_id"),
FOREIGN KEY ("deals_id") REFERENCES "tb_deals" ("deals_id"),
FOREIGN KEY ("product_id") REFERENCES "tb_products" ("product_id")
)

;

-- ----------------------------
-- Records of tb_deals_x_products
-- ----------------------------
INSERT INTO "tb_deals_x_products" VALUES ('1', '1', '10000.00', '1', '1000.00', '9000.00'), ('1', '2', '10000.00', '1', '2000.00', '8000.00'), ('1', '3', '12000.00', '1', '2000.00', '10000.00'), ('1', '4', '5000.00', '1', '2000.00', '3000.00'), ('2', '1', '399.00', '10', '0.00', '3990.00'), ('2', '2', '5000.00', '1', '0.00', '5000.00'), ('2', '3', '99.00', '8', '400.00', '392.00'), ('2', '4', '699.00', '1', '0.00', '699.00'), ('3', '1', '3000.00', '1', '0.00', '3000.00'), ('3', '2', '1000.00', '1', '0.00', '1000.00'), ('3', '3', '500.00', '1', '0.00', '500.00'), ('3', '4', '500.00', '1', '0.00', '500.00'), ('6', '1', '1000.00', '1', '200.00', '800.00'), ('6', '2', '400.00', '1', '200.00', '200.00'), ('6', '3', '2000.00', '1', '1000.00', '1000.00'), ('6', '4', '3000.00', '1', '0.00', '3000.00'), ('9', '1', '5000.00', '1', '0.00', '5000.00'), ('9', '2', '4000.00', '1', '0.00', '4000.00'), ('9', '3', '1000.00', '1', '0.00', '1000.00'), ('10', '1', '399.00', '22', '0.00', '8778.00'), ('10', '2', '25000.00', '1', '0.00', '25000.00'), ('10', '3', '99.00', '10', '0.00', '990.00'), ('10', '4', '699.00', '22', '0.00', '15378.00'), ('11', '1', '399.00', '2', '0.00', '798.00'), ('11', '2', '2000.00', '1', '0.00', '2000.00'), ('11', '3', '99.00', '3', '0.00', '297.00'), ('11', '4', '699.00', '10', '0.00', '6990.00'), ('13', '8', '149.00', '5', '0.00', '745.00'), ('15', '4', '699.00', '1', '0.00', '699.00'), ('16', '1', '399.00', '5', '0.00', '1995.00'), ('17', '1', '399.00', '15', '85.00', '5900.00'), ('17', '2', '1199.00', '15', '2985.00', '15000.00'), ('17', '3', '99.00', '15', '0.00', '1485.00'), ('17', '4', '699.00', '15', '485.00', '10000.00'), ('18', '4', '699.00', '7', '0.00', '4893.00'), ('19', '2', '199.00', '1', '0.00', '199.00'), ('19', '4', '699.00', '1', '0.00', '699.00'), ('20', '2', '199.00', '10', '0.00', '1990.00'), ('25', '7', '125.00', '1', '0.00', '125.00');

-- ----------------------------
-- Table structure for tb_emails
-- ----------------------------
DROP TABLE IF EXISTS "tb_emails";
CREATE TABLE "tb_emails" (
"email_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"deals_id"  INTEGER(11) NOT NULL,
"sellers_id"  INTEGER(11) NOT NULL,
"email_sent"  TEXT COLLATE NOCASE,
"email_from"  TEXT(255) COLLATE NOCASE,
"email_to"  TEXT(45) COLLATE NOCASE,
"email_cc"  TEXT(45) COLLATE NOCASE,
"email_bcc"  TEXT(45) COLLATE NOCASE,
"email_subject"  TEXT(45) COLLATE NOCASE,
"email_body"  TEXT COLLATE NOCASE,
FOREIGN KEY ("deals_id") REFERENCES "tb_deals" ("deals_id"),
FOREIGN KEY ("sellers_id") REFERENCES "tb_sellers" ("sellers_id")
)

;

-- ----------------------------
-- Records of tb_emails
-- ----------------------------

-- ----------------------------
-- Table structure for tb_files
-- ----------------------------
DROP TABLE IF EXISTS "tb_files";
CREATE TABLE "tb_files" (
"files_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"files_name"  TEXT(255) COLLATE NOCASE NOT NULL,
"deals_id"  INTEGER(11) NOT NULL,
"files_binary"  BLOB,
"login"  TEXT(255) COLLATE NOCASE NOT NULL,
FOREIGN KEY ("deals_id") REFERENCES "tb_deals" ("deals_id")
)

;

-- ----------------------------
-- Records of tb_files
-- ----------------------------

-- ----------------------------
-- Table structure for tb_languages
-- ----------------------------
DROP TABLE IF EXISTS "tb_languages";
CREATE TABLE "tb_languages" (
"lang_id"  TEXT(5) COLLATE NOCASE NOT NULL,
"lang_descr"  TEXT(50) COLLATE NOCASE,
PRIMARY KEY ("lang_id")
)

;

-- ----------------------------
-- Records of tb_languages
-- ----------------------------
INSERT INTO "tb_languages" VALUES ('en_us', 'English'), ('es', 'Español'), ('pt_br', 'Português');

-- ----------------------------
-- Table structure for tb_lead_source
-- ----------------------------
DROP TABLE IF EXISTS "tb_lead_source";
CREATE TABLE "tb_lead_source" (
"lead_source_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"lead_source_descr"  TEXT(150) COLLATE NOCASE NOT NULL
)

;

-- ----------------------------
-- Records of tb_lead_source
-- ----------------------------
INSERT INTO "tb_lead_source" VALUES ('1', 'Website'), ('2', 'Social Media'), ('3', 'Email Marketing'), ('4', 'Event'), ('5', 'Paid Ads'), ('6', 'Organic Search'), ('7', 'Blogs'), ('8', 'Affiliate / Partner Programs'), ('9', 'Inbound Phone Calls'), ('10', 'Outbound Sales'), ('11', 'Referrals'), ('12', 'Personal Network');

-- ----------------------------
-- Table structure for tb_organization_fields
-- ----------------------------
DROP TABLE IF EXISTS "tb_organization_fields";
CREATE TABLE "tb_organization_fields" (
"organization_fields_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"organization_fields_descr"  TEXT(150) COLLATE NOCASE NOT NULL
)

;

-- ----------------------------
-- Records of tb_organization_fields
-- ----------------------------
INSERT INTO "tb_organization_fields" VALUES ('1', 'IT'), ('2', 'Marketing'), ('3', 'Financing'), ('4', 'Bank');

-- ----------------------------
-- Table structure for tb_organizations
-- ----------------------------
DROP TABLE IF EXISTS "tb_organizations";
CREATE TABLE "tb_organizations" (
"organization_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"organization_descr"  TEXT(150) COLLATE NOCASE NOT NULL,
"organization_fields_id"  INTEGER(11) NOT NULL,
"organization_address"  TEXT(255) COLLATE NOCASE,
"organization_city"  TEXT(255) COLLATE NOCASE,
"organization_country"  TEXT(3) COLLATE NOCASE,
"organization_owner"  INTEGER(11),
FOREIGN KEY ("organization_fields_id") REFERENCES "tb_organization_fields" ("organization_fields_id"),
FOREIGN KEY ("organization_owner") REFERENCES "tb_sellers" ("sellers_id")
)

;

-- ----------------------------
-- Records of tb_organizations
-- ----------------------------
INSERT INTO "tb_organizations" VALUES ('1', 'Netmake', '1', 'Kennedy 1001, Olinda-PE', null, 'BRA', '1'), ('2', 'Test Company', '2', 'Centro, Recife-PE', null, 'BRA', '1'), ('3', 'Coogle LLC', '1', 'Menlo Park, Califórnia', null, 'USA', '3'), ('4', 'MasterCompany', '1', 'Cambridge, Massachusetts, EUA', null, 'USA', '3'), ('5', 'Mapple', '1', 'RUA MAXIMINO CAMARGO N° 137, BARRA MANSA', null, 'BRA', '4'), ('6', 'Ramazon', '1', 'Fifth Avenue,105', null, 'USA', '2'), ('7', 'Scriptcase inc. ', '1', 'Rua Professor Otávio de Freitas, 256', null, 'BRA', '8'), ('8', 'Microsoftware', '1', '231 Good Hope Ave. ', 'Palo Alto', 'USA', '3');

-- ----------------------------
-- Table structure for tb_organizations_x_sellers
-- ----------------------------
DROP TABLE IF EXISTS "tb_organizations_x_sellers";
CREATE TABLE "tb_organizations_x_sellers" (
"organization_id"  INTEGER(11) NOT NULL,
"sellers_id"  INTEGER(11) NOT NULL,
PRIMARY KEY ("organization_id", "sellers_id"),
FOREIGN KEY ("organization_id") REFERENCES "tb_organizations" ("organization_id"),
FOREIGN KEY ("sellers_id") REFERENCES "tb_sellers" ("sellers_id")
)

;

-- ----------------------------
-- Records of tb_organizations_x_sellers
-- ----------------------------
INSERT INTO "tb_organizations_x_sellers" VALUES ('1', '2'), ('3', '2'), ('4', '2'), ('4', '5'), ('6', '4'), ('6', '6'), ('7', '4'), ('7', '5');

-- ----------------------------
-- Table structure for tb_participants
-- ----------------------------
DROP TABLE IF EXISTS "tb_participants";
CREATE TABLE "tb_participants" (
"sellers_id"  INTEGER(11) NOT NULL,
"deals_id"  INTEGER(11) NOT NULL,
PRIMARY KEY ("sellers_id", "deals_id"),
FOREIGN KEY ("deals_id") REFERENCES "tb_deals" ("deals_id"),
FOREIGN KEY ("sellers_id") REFERENCES "tb_sellers" ("sellers_id")
)

;

-- ----------------------------
-- Records of tb_participants
-- ----------------------------
INSERT INTO "tb_participants" VALUES ('1', '2'), ('1', '11'), ('1', '13'), ('1', '29'), ('2', '3'), ('2', '16'), ('2', '29'), ('3', '10'), ('3', '13'), ('3', '16'), ('3', '29'), ('4', '29'), ('5', '29'), ('7', '29'), ('8', '13'), ('8', '29');

-- ----------------------------
-- Table structure for tb_products
-- ----------------------------
DROP TABLE IF EXISTS "tb_products";
CREATE TABLE "tb_products" (
"product_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"product_descr"  TEXT(150) COLLATE NOCASE NOT NULL,
"product_price"  REAL(9,2) NOT NULL
)

;

-- ----------------------------
-- Records of tb_products
-- ----------------------------
INSERT INTO "tb_products" VALUES ('1', 'Scriptcase PE', '399.00'), ('2', 'Scriptcase BI', '199.00'), ('3', 'Tech Support Plan', '99.00'), ('4', 'Scriptcase Lifetime License', '999.00'), ('5', 'Scriptcase Annual Subscription', '599.00'), ('6', 'Hosting Plan', '59.00'), ('7', 'Consulting hour', '125.00'), ('8', 'Online course', '149.00'), ('9', 'On demand course', '49.00'), ('10', 'Dedicated Server', '99.00'), ('11', 'VPS hoost CLOUD', '59.00'), ('12', 'VPS Set up', '50.00');

-- ----------------------------
-- Table structure for tb_sellers
-- ----------------------------
DROP TABLE IF EXISTS "tb_sellers";
CREATE TABLE "tb_sellers" (
"sellers_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"sellers_name"  TEXT(255) COLLATE NOCASE NOT NULL,
"login"  TEXT(255) COLLATE NOCASE,
"sellers_email"  TEXT(255) COLLATE NOCASE
)

;

-- ----------------------------
-- Records of tb_sellers
-- ----------------------------
INSERT INTO "tb_sellers" VALUES ('1', 'Matheus', 'matheus', 'mts@scriptcase.net'), ('2', 'John', 'john', 'john@scriptcase.net'), ('3', 'Mark', 'mark', 'mark@scriptcase.net'), ('4', 'Marcia', 'marcia', 'marcia@scriptcase.net'), ('5', 'Maria', 'maria', 'maria@scriptcase.net'), ('6', 'Carlos', 'carlos', 'carlos@scriptcase.net'), ('7', 'Paul', 'paul', 'paul@scriptcase.net'), ('8', 'Harry', 'harry', 'harry@scriptcase.net');

-- ----------------------------
-- Table structure for tbl_mandrill_emails
-- ----------------------------
DROP TABLE IF EXISTS "tbl_mandrill_emails";
CREATE TABLE "tbl_mandrill_emails" (
"id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"email"  TEXT(225) COLLATE NOCASE
)

;

-- ----------------------------
-- Records of tbl_mandrill_emails
-- ----------------------------

-- ----------------------------
-- Table structure for tbl_mandrill_groups
-- ----------------------------
DROP TABLE IF EXISTS "tbl_mandrill_groups";
CREATE TABLE "tbl_mandrill_groups" (
"id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"group_name"  TEXT(225) COLLATE NOCASE
)

;

-- ----------------------------
-- Records of tbl_mandrill_groups
-- ----------------------------

-- ----------------------------
-- Table structure for tbl_mandrill_info
-- ----------------------------
DROP TABLE IF EXISTS "tbl_mandrill_info";
CREATE TABLE "tbl_mandrill_info" (
"id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"api_key"  TEXT(255) COLLATE NOCASE,
"email"  TEXT(255) COLLATE NOCASE
)

;

-- ----------------------------
-- Records of tbl_mandrill_info
-- ----------------------------

-- ----------------------------
-- Table structure for tbl_mandrill_templates
-- ----------------------------
DROP TABLE IF EXISTS "tbl_mandrill_templates";
CREATE TABLE "tbl_mandrill_templates" (
"id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"template_name"  TEXT(225) COLLATE NOCASE,
"slug_name"  TEXT(225) COLLATE NOCASE,
"from_email"  TEXT(225) COLLATE NOCASE,
"from_name"  TEXT(225) COLLATE NOCASE,
"subject"  TEXT(225) COLLATE NOCASE,
"publish"  TEXT(225) COLLATE NOCASE,
"labels"  TEXT(225) COLLATE NOCASE,
"msgcode"  TEXT COLLATE NOCASE,
"msgtext"  TEXT COLLATE NOCASE
)

;

-- ----------------------------
-- Records of tbl_mandrill_templates
-- ----------------------------
INSERT INTO "tbl_mandrill_templates" VALUES ('1', 'Welcome email', '', 'sales@myorganization.com', 'Mark', 'Welcome to our community!', '0', '3', '<p>test email</p>', '');
INSERT INTO "tbl_mandrill_templates" VALUES ('2', 'Announcement', '', 'sales@scriptcase.net', 'Sales Department', 'New version', '1', '', '<p style="text-align: center;"><strong>Announcement of New Version</strong></p>
<p style="text-align: center;"> </p>
<p style="text-align: left;">There is a new version released!</p>', 'Announcement of New Version');

-- ----------------------------
-- Indexes structure for table sec_groups
-- ----------------------------
CREATE UNIQUE INDEX "description"
ON "sec_groups" ("description");

-- ----------------------------
-- Indexes structure for table sec_groups_apps
-- ----------------------------
CREATE INDEX "sec_groups_apps_ibfk_2"
ON "sec_groups_apps" ("app_name");

-- ----------------------------
-- Indexes structure for table sec_users_groups
-- ----------------------------
CREATE INDEX "sec_users_groups_ibfk_2"
ON "sec_users_groups" ("group_id");

-- ----------------------------
-- Indexes structure for table tb_activities
-- ----------------------------
CREATE INDEX "fk_tb_activities_tb_activities_type1_idx"
ON "tb_activities" ("activities_type_id");
CREATE INDEX "fk_tb_activities_tb_deals1_idx"
ON "tb_activities" ("deals_id");
CREATE INDEX "fk_tb_activities_tb_sellers1_idx"
ON "tb_activities" ("sellers_id");

-- ----------------------------
-- Indexes structure for table tb_contacts
-- ----------------------------
CREATE INDEX "fk_tb_contacts_tb_organizations1_idx"
ON "tb_contacts" ("organization_id");
CREATE INDEX "fk_tb_contacts_tb_lead_source1_idx"
ON "tb_contacts" ("lead_source_id");

-- ----------------------------
-- Indexes structure for table tb_contacts_emails
-- ----------------------------
CREATE INDEX "fk_tb_contacts_emails_tb_contacts1_idx"
ON "tb_contacts_emails" ("contact_id");

-- ----------------------------
-- Indexes structure for table tb_contacts_phones
-- ----------------------------
CREATE INDEX "fk_tb_contacs_phones_tb_contacts1_idx"
ON "tb_contacts_phones" ("contact_id");

-- ----------------------------
-- Indexes structure for table tb_deal_steps
-- ----------------------------
CREATE INDEX "tb_deal_steps_ibfk_1"
ON "tb_deal_steps" ("deal_steps_lang");

-- ----------------------------
-- Indexes structure for table tb_deals
-- ----------------------------
CREATE INDEX "fk_tb_deals_tb_deal_stages1_idx"
ON "tb_deals" ("deal_steps_id");
CREATE INDEX "fk_tb_deals_tb_contacts1_idx"
ON "tb_deals" ("contact_id");
CREATE INDEX "fk_tb_deals_tb_sellers1_idx"
ON "tb_deals" ("owner_seller");

-- ----------------------------
-- Indexes structure for table tb_deals_x_products
-- ----------------------------
CREATE INDEX "fk_tb_deals_has_tb_products_tb_products1_idx"
ON "tb_deals_x_products" ("product_id");
CREATE INDEX "fk_tb_deals_has_tb_products_tb_deals1_idx"
ON "tb_deals_x_products" ("deals_id");

-- ----------------------------
-- Indexes structure for table tb_emails
-- ----------------------------
CREATE INDEX "fk_tb_emails_tb_deals1_idx"
ON "tb_emails" ("deals_id");
CREATE INDEX "fk_tb_emails_tb_sellers1_idx"
ON "tb_emails" ("sellers_id");

-- ----------------------------
-- Indexes structure for table tb_files
-- ----------------------------
CREATE INDEX "fk_tb_files_tb_deals1_idx"
ON "tb_files" ("deals_id");
CREATE INDEX "fk_tb_files_tb_sellers1_idx"
ON "tb_files" ("login");

-- ----------------------------
-- Indexes structure for table tb_organizations
-- ----------------------------
CREATE INDEX "fk_tb_organizations_tb_oragnization_fields_idx"
ON "tb_organizations" ("organization_fields_id");
CREATE INDEX "organization_owner"
ON "tb_organizations" ("organization_owner");

-- ----------------------------
-- Indexes structure for table tb_organizations_x_sellers
-- ----------------------------
CREATE INDEX "fk_tb_organizations_has_tb_sellers_tb_sellers1_idx"
ON "tb_organizations_x_sellers" ("sellers_id");
CREATE INDEX "fk_tb_organizations_has_tb_sellers_tb_organizations1_idx"
ON "tb_organizations_x_sellers" ("organization_id");

-- ----------------------------
-- Indexes structure for table tb_participants
-- ----------------------------
CREATE INDEX "fk_tb_sellers_has_tb_deals_tb_deals1_idx"
ON "tb_participants" ("deals_id");
CREATE INDEX "fk_tb_sellers_has_tb_deals_tb_sellers1_idx"
ON "tb_participants" ("sellers_id");
