<?php

if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976)) {
    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .
        'invalid access to system file.');
}

nm_load_class('page', 'PageLangEdit');
nm_load_class('interface', 'ExternalResource');
nm_load_class('page', 'PageLangIntro');


class nmSentLangs extends nmExternalResource
{
    public static $save_folder = 'lang_feedback';
    public static $datafile_name = 'datafile';
    public static $allowed_scopes = [self::PUBLIC_SCOPE];

    protected $langsData;

    function __construct()
    {
        $files_list = $this->getTemplateList();

        if (!isset($files_list[self::PUBLIC_SCOPE]['files']) || empty($files_list[self::PUBLIC_SCOPE]['files'])) {
            $this->saveTemplateFile([], static::$datafile_name, self::PUBLIC_SCOPE);
        }

        $this->langsData = json_decode($this->getTemplateFileData(static::$datafile_name, self::PUBLIC_SCOPE), true);
    }

    public function getSentLangs()
    {
        return $this->langsData;
    }

    public function getPendingLangs()
    {
        $langStats = $this->createStats();
        $count = 0;
        foreach ($langStats as $idioma => $langs) {
            if (!array_key_exists($idioma, $this->langsData)) {
                foreach ($langs as $folder => $items) {
                    $count += count($items);
                }
            } else {
                foreach ($langs as $folder => $items) {
                    if (!array_key_exists($folder, $this->langsData[$idioma])) {
                        $count += count($items);
                    } else {
                        foreach ($items as $index => $value) {
                            if (!isset($this->langsData[$idioma][$index]) || $this->langsData[$idioma][$index] != $value) {
                                $count++;
                            }
                        }
                    }
                }
            }
        }

        return $count;
    }

    public function createStats() {
        global $nm_template;

        $langPage = new nmPageLangIntro();

        $aLangIni  = nm_conv_ini_array('lang.ini', 'ini');

        $aLangs = $langPage->GetLangsProj(true);

        foreach($aLangIni as $lang => $arrlang)
        {
            if (!isset($aLangs[$lang]))
            {
                unset($aLangIni[$lang]);
            }
        }
        if (is_ver_en() && isset($aLangs['pt_br']))
        {
            unset($aLangs['pt_br']);
        }

        $aScData  = $langPage->loadScLangs($aLangs);
        $aUsrData = $langPage->loadUsrLangs($aLangs);
        $langPage->doScStats($aScData, $aUsrData);

        return $langPage->stats['sc_edited_by_lang'];
    }

    public function setSentLangs($arr_langs)
    {
        foreach ($arr_langs as $idioma => $langs) {
            if (!array_key_exists($idioma, $this->langsData)) {
                $this->langsData[$idioma] = [];
            }
            foreach ($langs as $folder => $items) {
                if (!array_key_exists($folder, $this->langsData[$idioma])) {
                    $this->langsData[$idioma][$folder] = [];
                }
                foreach ($items as $index => $value) {
                    $this->langsData[$idioma][$index] = $value;
                }
            }
        }

        $this->saveTemplateFile($this->langsData, static::$datafile_name, self::PUBLIC_SCOPE);
        $this->langsData = json_decode($this->getTemplateFileData(static::$datafile_name, self::PUBLIC_SCOPE), true);
        return $this;
    }

}
?>