<?php
/**
 * Classe SecurityModule.
 *
 * Modulo de Seguranca.
 *
 * @package     Classes
 * @subpackage  Page
 * @creation    2009/04/14
 * @copyright   NetMake Solucoes em Informatica
 * @author      Juliano Mesquita dos Santos <juliano@netmake.com.br>
 *
 * $Id: nmPageSecurityModule.class.php,v 1.125 2012-02-15 22:23:23 vinicius Exp $
 */

/* Protecao contra hacks */
if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976)) {
    die('invalid access to system file.' .
        '<br /><span style="font-weight: bold">Fatal error</span>: ');
}

/* Classes ancestrais */
nm_load_class('page', 'Page');

/* Definicao da classe */

class nmPageSecurityModule2 extends nmPage
{
    /* ----- Construtor e Destrutor ------------------------------------ */


    var $arr_steps = array('carregar', 'tipo', 'tabela', 'associar', 'config', 'popular', 'popular_app_perfil');
    var $arr_tables_to_import = array('sc_tbapl', 'sc_tbcmp', 'sc_tbevt');
    var $arr_to_replace = array();
    var $step_now;
    var $step_before;
    var $step_after;
    var $arr_tables;

    var $obj_con;

    /**
     * Construtor da classe.
     *
     * Seta o nome da pagina a ser exibida.
     *
     * @access  public
     */
    function __construct()
    {
        global $nm_config;

        if(!$nm_config['has_9_10']){
            echo <<<JS
<script>
    document.location = '{$nm_config['url_iface']}security_module.php';
</script>
JS;
            exit;
        }
        nm_load_class('interface', 'Connection');
        $this->obj_con = nmConnection::singleton($_SESSION['nm_session']['user']['cod_grp']);
        $this->obj_con->GetAllConnections();

        $this->setDocType("HTML");
        $this->CheckLogin();
        $this->SetBody('nmPage');
        $this->SetMargin(0);
        $this->SetPage('SecurityModule');
        $this->SetPageCode(NM_PAGE_COD_PROJ_NEW);
        $this->CheckAjax();

        $this->SetPageSubtitle('');

        //$this->SetScroll('no');
        //$this->setDocType("XHTML 1.0 Transitional");

    } // nmPageApp

    /* ----- Metodos Protegidos ---------------------------------------- */

    /**
     * Checa a entrada via Ajax.
     *
     * @access  protected
     */
    function CheckAjax()
    {
        if (!isset($_REQUEST['nm_ajax']))
            return;

        $this->LoadLang();
        switch ($_REQUEST['nm_option']) {
            case 'deleteProfile':
                echo $this->deleteProfile($_POST['p']);
                break;
            case 'renameProfile':
                echo $this->renameProfile($_POST['p'], $_POST['new_name']);
                break;
            case 'getfields':
                echo $this->GetFields($_SESSION['nm_session']['module_security']['profile']['tabela_conn'], $_POST['nm_table_usu']);
                break;
            case 'getdata':
                echo $this->GetData($_POST['from'], $_POST['field']);
                break;
            case 'verify_tables':
                echo $this->verifyTables($_POST['conn'], $_POST['prefix']);
                break;
            case 'verify_apps':
                echo $this->verifyApps($_POST['prefix']);
                break;
            case 'generate':
                $this->generate_step($_POST['step']);
                break;
            case 'ldap_test':
                $this->LoadLang('SecurityModule');
                echo $this->ldapTest($_POST);
                break;
            case 'getLibs':
                echo nm_get_extenal_libraries_options();
                break;
            case 'verify_profile_name':
                echo $this->verifyProfileName($_POST['p'],$_POST['n']);
                break;
            case 'setorderby':
                echo $this->montaTable($_POST['campo'], $_POST['str_param'], $_POST['option']);
                break;
            case 'add_app_session':
                echo $this->addAppSession($_POST['data']);
                break;
            case 'get_selected_apps':
                echo $this->selectedAppsTable($_POST['data']);
                break;
            case 'seclib':
                echo $this->setSecurityLib($_POST['option']);
                break;
            case 'reload_api':
                $cod_prj = $_SESSION['nm_session']['user']['cod_grp'];
                nm_load_class('interface', 'Group');
                $obj_grupo = nmGroup::singleton();
                $obj_grupo->LoadData($cod_prj);

                $grp_apis = $obj_grupo->GetData('api');

                $arr_apis = nm_get_arr_api(true);

                $str_retorno = $_REQUEST['with_custom'] == 1 ? "<option value='custom'>" . nm_get_text_lang("['custom']") . "</option>" : '';
                $arr_types = explode(';', $_REQUEST['type']);
                $str_retorno_tmp = '';
                if (is_array($arr_apis)) {
                    foreach ($arr_apis as $mod => $arr_api) {
                        $str_retorno_tmp = "<optgroup label='" . nm_get_text_lang("['mod_" . $mod . "']") . "'>";
                        $i = 0;
                        foreach ($arr_api as $k => $api) {
                            if (!in_array($mod . "__NM__" . $k, $grp_apis) || !in_array($api['type'], $arr_types)) continue;


                            $str_retorno_tmp .= "<option value='" . $mod . '__NM__' . $api['name'] . "'>" . $api['name'] . " - " . $api['gateway'] . "</option>";
                            $i++;
                        }
                        if ($i > 0) {
                            $str_retorno .= $str_retorno_tmp . "</optgroup>";
                        }
                    }
                }

                echo $str_retorno;
                break;
            case 'get_app_tabs':
                $arr_tabs = [];
                if(isset($_SESSION['nm_session']['control_abas']['apps']) && !empty($_SESSION['nm_session']['control_abas']['apps'])){
                    foreach($_SESSION['nm_session']['control_abas']['apps'] as $item){
                        $arr_tabs[] = $item['frame'];
                    }
                }
                echo json_encode($arr_tabs);
                break;
        }
        exit;
    } // DisplayContent

    function deleteProfile($profile){
        global $nm_config;
        list($type, $profile) = explode('#@NM@#', $profile);
        $profile  = strtr($profile, ['..' => '']);
        $arr_paths = array(
            'scriptcase' => $nm_config['path_scriptcase'] . 'securitymodule/',
            'sys' => $nm_config['path_sys'] . 'securitymodule/',
            'grp' => $nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . '/securitymodule/',
            'usr' => $nm_config['path_usr'] . $_SESSION['nm_session']['user']['login'] . '/securitymodule/'
        );
        if(file_exists($arr_paths[$type] . $profile)) {
            unlink($arr_paths[$type] . $profile);
        }
        return 'ok';
    }

    function renameProfile($profile, $new_name){
        global $nm_config;
        list($type, $profile) = explode('#@NM@#', $profile);
        $profile  = strtr($profile, ['..' => '']);
        $arr_paths = array(
            'scriptcase' => $nm_config['path_scriptcase'] . 'securitymodule/',
            'sys' => $nm_config['path_sys'] . 'securitymodule/',
            'grp' => $nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . '/securitymodule/',
            'usr' => $nm_config['path_usr'] . $_SESSION['nm_session']['user']['login'] . '/securitymodule/'
        );
        $message = "";
        if(empty($new_name) || '' != preg_replace('/[a-z0-9_]+/i', '', $new_name) || preg_match('/^[0-9]/i', $new_name)){
            $message =  nm_get_text_lang("['profile_incorrect']");
        }else if(file_exists($arr_paths[$type] . $profile)){
            if($this->templateNameExists($type, $profile, $new_name)){
                $message = nm_get_text_lang("['profile']['name_exists']");
            }else{
                $_content = file_get_contents($arr_paths[$type] . $profile);
                if(substr($_content, 0, 8) == "<?php /*")
                {
                    $_content = substr($_content, 8, -5);
                }
                $data = unserialize($_content, ['allowed_classes' => false]);
                $data['perfil_save_name'] = $new_name;
                file_put_contents($arr_paths[$type] . $profile, serialize($data));
                $message = 'ok';
            }
        }else{
            $message = nm_get_text_lang("['general_error']");
        }
        return $message;
    }

    function templateNameExists($type,$profile,$new_name){
        global $nm_config;
        $response  = false;
        $arr_paths = array(
            'scriptcase' => $nm_config['path_scriptcase'] . 'securitymodule/',
            'sys' => $nm_config['path_sys'] . 'securitymodule/',
            'grp' => $nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . '/securitymodule/',
            'usr' => $nm_config['path_usr'] . $_SESSION['nm_session']['user']['login'] . '/securitymodule/'
        );
        $files = array_diff(scandir($arr_paths[$type]),array('..','.','index.html',$profile));
        if(!empty($files)){
            foreach($files as $file){

                if(is_file($arr_paths[$type].$file))
                {
                    try {
                        $_content = file_get_contents($arr_paths[$type].$file);
                        if(substr($_content, 0, 8) == "<?php /*")
                        {
                            $_content = substr($_content, 8, -5);
                        }
                        $data_temp = @unserialize($_content, ['allowed_classes' => false]);

                        if(!$data_temp)
                        {
                            $data_temp = array();
                        }
                    } catch(ErrorException $e) {
                        $data_temp = array();
                    }
                }
                else{
                    $data_temp = array();
                }

                if(isset($data_temp['perfil_save_name']) && $data_temp['perfil_save_name'] == $new_name){
                    $response = true;
                    break;
                }
            }
        }
        return $response;
    }

    function verifyProfileName($type,$profile){
        global $nm_config;
        $response  = 'ok';
        $arr_paths = array(
            'scriptcase' => $nm_config['path_scriptcase'] . 'securitymodule/',
            'sys' => $nm_config['path_sys'] . 'securitymodule/',
            'grp' => $nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . '/securitymodule/',
            'usr' => $nm_config['path_usr'] . $_SESSION['nm_session']['user']['login'] . '/securitymodule/'
        );
        if(isset($_SESSION['nm_session']['module_security']['profile']['profile']) &&
                $_SESSION['nm_session']['module_security']['profile']['profile'] == 'use' &&
                $_SESSION['nm_session']['module_security']['profile']['perfil_save_name'] == $profile)
        {
            $response = 'ok';
        }else if(is_file($arr_paths[$type].$profile.'.sc.php')){
            $response =  nm_get_text_lang("['profile']['name_exists']");
        }
        return $response;
    }

    function addAppSession($arr_apl){
        global $nm_template;
        if(isset($_SESSION['nm_session']['module_security']['profile']['pop_app']['selected_apps'])){
            unset($_SESSION['nm_session']['module_security']['profile']['pop_app']['selected_apps']);
        }
        $_SESSION['nm_session']['module_security']['profile']['pop_app']['selected_apps'] = $arr_apl;
        $nm_template->SetVar('selected_apps', $_SESSION['nm_session']['module_security']['profile']['pop_app']['selected_apps']);
        echo 'ok';
    }

    function montaTable($str_field, $str_param, $option)
    {
        global $nm_config;

        $arr_selected_apls = (isset($_SESSION['nm_session']['module_security']['profile']['pop_app']['selected_apps']) ? $_SESSION['nm_session']['module_security']['profile']['pop_app']['selected_apps']: '');

        $arr_apl = $this->setAplArray(true, "Cod_Prj, Versao, " . $str_field . ' ' . $str_param);
        $str_retorno = "";
        $str_retorno .= "<input type='".$option."' name='field_app' value='' style='display:none' />";
        $str_retorno .= "<table border='0' class='ui celled unstackable table'>";
        $str_retorno .= "<thead>";
        $str_retorno .= "  <tr>";
        $str_retorno .= "   <th style='vertical-align: center; white-space: nowrap; text-align: center;'>";

        if($option != 'radio') {
            $str_retorno .= "	<a href='javascript: nm_check_all(true)'><img src='" . $nm_config['url_scriptcase_img'] . "img_select_all.gif' style='border-width: 0px; height: 16px; width: 16px; vertical-align: middle' title='" . nm_get_text_lang("['check_all']") . "' /></a>";
            $str_retorno .= "	<a href='javascript: nm_check_all(false)'><img src='" . $nm_config['url_scriptcase_img'] . "img_select_none.gif' style='border-width: 0px; height: 16px; width: 16px; vertical-align: middle' title='" . nm_get_text_lang("['uncheck_all']") . "' /></a>";
        }
        $str_retorno .= "   </th>";
        $str_retorno .= "   <th style='text-align: left;min-width: 200px;'><a href=\"javascript:setOrderBy('Cod_Apl');\"   >".nm_get_text_lang("['table']['app']")."</a></th>";
        $str_retorno .= "   <th style='text-align: left;min-width: 200px;'><a href=\"javascript:setOrderBy('Folder');\"    >".nm_get_text_lang("['table']['folder']")."</a></th>";
        $str_retorno .= "   <th style='text-align: left'><a href=\"javascript:setOrderBy('Data_Inc');\"  >".nm_get_text_lang("['tipo_apl']")."</a></th>";
        $str_retorno .= "   <th style='text-align: left'><a href=\"javascript:setOrderBy('Descricao');\" >".nm_get_text_lang("['table']['descricao']")."</a></th>";
        $str_retorno .= "  </tr>";
        $str_retorno .= "</thead>";
        $str_retorno .= "<tbody>";
        $apl_checked  = '';
        foreach ($arr_apl as $apl)
        {
            if($apl[0] != $_SESSION['nm_session']['app']['cod'])
            {

                if(!empty($arr_selected_apls)){
                    $apl_checked  = (in_array($apl[0],$arr_selected_apls) ? 'checked="checked"': '');
                }
                switch($apl[5]){
                    case NM_APP_TYPE_CONTROLUSR:
                        $apl[5] = NM_APP_TYPE_CONTROL;
                    break;
                    case NM_APP_TYPE_MENU2:
                        $apl[5] = NM_APP_TYPE_MENU;
                    break;
                    case NM_APP_TYPE_PROC:
                        $apl[5] = NM_APP_TYPE_GRID;
                    break;
                    case NM_APP_TYPE_RPDFPROC:
                        $apl[5] = NM_APP_TYPE_REPORTPDF;
                    break;
                }
                $str_retorno .= "<tr onclick=\"$(this).find('input').prop('checked', !$(this).find('input').prop('checked'))\">";
                $str_retorno .= "  <td style='text-align: center'><input onclick='event.stopPropagation()' type='".$option."' name='field_app' value='".$apl[0]."' ".$apl_checked."></td>";
                $str_retorno .= "  <td class='searchable_cell'>".$apl[0]."</td>";
                $str_retorno .= "  <td class='searchable_cell' style='max-width: 40px; overflow: hidden; text-overflow: ellipsis;' title='".$apl[1]."'>".$apl[1]."</td>";
                $str_retorno .= "  <td class='type_cell app_type_".$apl[5]."'>".nm_get_text_lang("['wiz_dados_app']['" . $apl[5] . "']")."</td>";
                $str_retorno .= "  <td class='searchable_cell'>".conv_utf8_all($apl[3])."</td>";
                $str_retorno .= "</tr>";
            }
        }

        if($option != 'radio')
        {
            $str_retorno .= "<tr>";
            $str_retorno .= "  <td colspan='5' align='left'>";
            $str_retorno .= "  </td>";
            $str_retorno .= "</tr>";
        }
        $str_retorno .= "</tbody>";
        $str_retorno .= "</table>";
        return $str_retorno;
    }
    function setAplArray($retorno=false, $orderby="Cod_Prj, Versao")
    {
        global $nm_template;

        nm_load_class('interface', 'Application');
        $obj_app = new nmApplication();
        $obj_app->SetApplication($_SESSION['nm_session']['user']['cod_grp'],
            $_SESSION['nm_session']['app']['cod'],
            $_SESSION['nm_session']['user']['cod_ver']);
        if($retorno)
        {
            return $obj_app->GetApplicationByPrj($_SESSION['nm_session']['user']['cod_grp'], $_SESSION['nm_session']['user']['cod_ver'], $orderby);
        }else
        {
            $nm_template->SetVar('arr_apl', $obj_app->GetApplicationByPrj($_SESSION['nm_session']['user']['cod_grp'], $_SESSION['nm_session']['user']['cod_ver'], $orderby));
        }
    }

    function selectedAppsTable($str_apls){
        if(empty($str_apls)){
            return '';
        }
        $arr_apl = $this->setAplArray(true);
        $str_retorno  = "<p>".nm_get_text_lang("['pop_app']['selected_apps']")."</p>";
        $str_retorno .= "<div style='overflow-x: scroll;max-height: 260px;overflow-x: hidden;'>";
        $str_retorno .= "<table border='0' class='ui celled unstackable table scrolling'>";
        $str_retorno .= "<thead>";
        $str_retorno .= "  <tr>";
        $str_retorno .= "   <th style='text-align: left;min-width: 200px;'>".nm_get_text_lang("['table']['app']")."</th>";
        $str_retorno .= "   <th style='text-align: left;min-width: 200px;'>".nm_get_text_lang("['table']['folder']")."</th>";
        $str_retorno .= "   <th style='text-align: left'>".nm_get_text_lang("['tipo_apl']")."</th>";
        $str_retorno .= "   <th style='text-align: left'>".nm_get_text_lang("['table']['descricao']")."</th>";
        $str_retorno .= "  </tr>";
        $str_retorno .= "</thead>";
        $str_retorno .= "<tbody>";
        foreach($arr_apl as $apl){
            if(array_search($apl[0], $str_apls) !== false ){
                switch($apl[5]){
                    case NM_APP_TYPE_CONTROLUSR:
                        $apl[5] = NM_APP_TYPE_CONTROL;
                        break;
                    case NM_APP_TYPE_MENU2:
                        $apl[5] = NM_APP_TYPE_MENU;
                        break;
                    case NM_APP_TYPE_PROC:
                        $apl[5] = NM_APP_TYPE_GRID;
                        break;
                    case NM_APP_TYPE_RPDFPROC:
                        $apl[5] = NM_APP_TYPE_REPORTPDF;
                    break;
                }
                $str_retorno .= "<tr>";
                $str_retorno .= "  <td >".$apl[0]."</td>";
                $str_retorno .= "  <td style='max-width: 40px; overflow: hidden; text-overflow: ellipsis;' title='".$apl[1]."'>".$apl[1]."</td>";
                $str_retorno .= "  <td >".nm_get_text_lang("['wiz_dados_app']['" . $apl[5] . "']")."</td>";
                $str_retorno .= "  <td >".conv_utf8_all($apl[3])."</td>";
                $str_retorno .= "</tr>";
            }
        }
        $str_retorno .= "</tbody>";
        $str_retorno .= "</table>";
        $str_retorno .= "</div>";
        return $str_retorno;
    }

    function setSecurityLib($str_tipo){
        nm_load_class('interface', 'Group');
        $obj_grp = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
        $obj_grp->LoadData($_SESSION['nm_session']['user']['cod_grp']);
        $arr_libraries  = $obj_grp->GetData('libraries');
        $do_update      = false;
        if($str_tipo == 'enable'){
            if(!isset($arr_libraries['scriptcase']) || array_search('security',$arr_libraries['scriptcase']) === false){
                $arr_libraries['scriptcase'][] = 'security';
                $do_update = true;
            }
        }else if($str_tipo == 'disable'){
            if(isset($arr_libraries['scriptcase']) && array_search('security',$arr_libraries['scriptcase']) !== false){
                $key = array_search('security',$arr_libraries['scriptcase']);
                unset($arr_libraries['scriptcase'][$key]);
                $do_update = true;
            }
        }
        if($do_update){
            $obj_grp->SetData('libraries', $arr_libraries);
            $obj_grp->AtuData($_SESSION['nm_session']['user']['cod_grp']);
            nm_apaga_geracao_library("", true);
        }
        return $do_update;
    }
    /**
     * Recupera Campos da tabelas.
     *
     * @access  protected
     */
    function GetFields($str_conn, $str_tab, $search = '@@@@')
    {
        if (empty($str_tab)) {
            return '';
        }
        $charset = $this->getCharset();
        $arr_flds = nm_db_fields($str_conn, nm_decode_utf8_charset($str_tab, $charset), __FILE__, __LINE__, false, "", $this->obj_con);
        $arr_conn = $this->obj_con->GetConnection($str_conn);

        $html = "<option value=''></option>\n";
        foreach ($arr_flds as $fld) {
            $selected = '';
            if ($search != '@@@@' && stripos($fld, $search) !== false) {
                $selected = "selected='selected'";
                $_REQUEST['search'] = "@@@@";
            }
            $field = str_replace('"','', conv_utf8_all(strtr(trataCampoTabela($fld, $arr_conn['dbms']), array("'" => "\'")), $charset));
            $html .= "<option " . $selected . " value='" . $field . "'>" . $field . "</option>\n";
        }
        return $html;

    }

    function getCharset()
    {
        if (!isset($_SESSION['nm_session']['module_security']['prj_charset'][$_SESSION['nm_session']['user']['cod_grp']])) {
            nm_load_class('interface', 'Group');
            $obj_grupo = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
            $arr_lang_charset = get_lang_charset('', '', $obj_grupo->GetData('locale_default'), $obj_grupo->GetData('locales'), $obj_grupo->GetData('locales_charset'));
            $_SESSION['nm_session']['module_security']['prj_charset'][$_SESSION['nm_session']['user']['cod_grp']] = $arr_lang_charset['charset'];
            return $arr_lang_charset['charset'];
        }
        return $_SESSION['nm_session']['module_security']['prj_charset'][$_SESSION['nm_session']['user']['cod_grp']];
    }//source2array

    function verifyTables($str_conn, $prefix)
    {
        $arr_tables = nm_db_tables($str_conn, __FILE__, __LINE__, FALSE);

        if (is_array($arr_tables) && !empty($arr_tables)) {
            foreach ($arr_tables as $tbl) {
                if (strpos($tbl, ".") !== false) {
                    $arr_tables[] = substr($tbl, strpos($tbl, ".") + 1);
                }
            }
            $arr_new_tables = $this->returnLevelTables();
            foreach ($arr_new_tables as $table) {
                if (in_array($prefix . $table, $arr_tables) || in_array(strtolower($prefix . $table), $arr_tables) || in_array(strtoupper($prefix . $table), $arr_tables)) {
                    return 'tem';
                }
            }
        }
        return 'no';
    }//verifyTables

    /**
     * Retorna array com as tabelas, dependendo do n&iacute;vel de seguranca.
     *
     *
     * @access  protected
     * @global  array $nm_config Array com configuracao do ScriptCase.
     */
    function returnLevelTables($logged = 'N', $social_login = 'N')
    {
        //users_groups, users, users_apps, groups, groups_apps, apps
        switch ($_SESSION['nm_session']['module_security']['profile']['tipo_nivel']) {
            case 'usr':
                $_arr = array('users', 'settings');
                break;

            case 'grp':
                $_arr = array('users', 'apps', 'groups', 'users_groups', 'groups_apps', 'settings');
                break;

            case 'ldap_app':
            case 'ldap':
            case 'app':
                $_arr = array('users', 'apps', 'users_apps', 'settings');
                break;
        }

        if ($logged == 'S') {
            $_arr[] = 'logged';
        }
        if ($social_login == 'S') {
            $_arr[] = 'users_social';
        }
        return $_arr;

    }//ChangeDisplay

    function verifyApps($prefix)
    {
        nm_load_class('interface', 'Application');
        $obj_app = new nmApplication();
        $datas = $obj_app->GetApplications($_SESSION['nm_session']['user']['cod_grp'], $_SESSION['nm_session']['user']['cod_ver'], array('Cod_Apl'));
        $c_prefix = strlen($prefix);
        foreach ($datas as $data) {
            if (substr($data['Cod_Apl'], 0, $c_prefix) == $prefix)
                return 'tem';
        }
        return 'no';
    }

    function generate_step($step)
    {
        switch ($step) {
            case 1:
                if ($_SESSION['nm_session']['module_security']['profile']['perfil_save_perfil'] == 'S') {
                    $this->SaveProfile();
                }
                break;
            case 2:
                $this->load_variable_replace();

                $this->doReplace();
                break;
            case 3:
                $this->load_variable_replace();
                $this->ActiveSecurity();
                $this->putLib();
                $this->normalizeFolders();
                nm_apaga_geracao_lang($_SESSION['nm_session']['user']['cod_grp'], true);
                nm_load_class('interface', 'LangGenerator');
                $obj_lang = new nmLangGenerator();
                $obj_lang->geraLang();
                nm_cria_geracao_lang($_SESSION['nm_session']['user']['cod_grp']);
                unset($_SESSION['nm_session']['user']['lang_labels'][$_SESSION['nm_session']['user']['cod_grp']]);
                break;
            case 4:
                $arr_session = $_SESSION['nm_session']['module_security']['profile'];

                nm_load_class('interface', 'Group');
                $obj_group = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
                $force_utf8 = ($obj_group->GetData('force_db_utf8') == 'S');

                $nm_db_usu = nm_db_connect($this->obj_con->GetConnection($arr_session['tabela_conn']), __FILE__, __LINE__, true, "", $force_utf8);
                //$this->createGroupDefault($nm_db_usu);
                $this->populate($nm_db_usu);
                if(isset($_SESSION['nm_session']['module_security']['profile']['tabela_seg_create_filename']) && isset($_SESSION['nm_session']['module_security']['profile']['sql_security_commands'])) {
                    file_put_contents($_SESSION['nm_session']['module_security']['profile']['tabela_seg_create_filename'], $_SESSION['nm_session']['module_security']['profile']['sql_security_commands']);
                    $_SESSION['nm_session']['module_security']['profile']['sql_security_commands'] = '';
                }

                break;
        }
    }

    function SaveProfile()
    {
        $arr_profile = $_SESSION['nm_session']['module_security']['profile'];
        global $nm_config;
        $arr = "<?php /*" . serialize($arr_profile) . "*/ ?>";

        switch ($arr_profile['perfil_data_mod']) {
            case 'scriptcase':
                $str_path = $nm_config['path_scriptcase'] . 'securitymodule/';
                break;
            case 'sys':
                $str_path = $nm_config['path_sys'] . 'securitymodule/';
                break;
            case 'grp':
                $str_path = $nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . '/securitymodule/';
                break;

            default:
            case 'usr':
                $str_path = $nm_config['path_usr'] . $_SESSION['nm_session']['user']['login'] . '/securitymodule/';
                break;
        }
        if (!is_dir($str_path)) {
            mkdir($str_path, 0777, true);
        }
        $a = file_put_contents($str_path . $arr_profile['perfil_save_name'] . ".sc.php", $arr);
        return $a;
    }

    /**
     * Retorna a variavel com as configuracoes para replace.
     *
     *
     * @access  protected
     * @global  array $nm_config Array com configuracao do ScriptCase.
     */
    function load_variable_replace()
    {
        global $nm_config, $obj_lic;
        $arr_session = $_SESSION['nm_session']['module_security']['profile'];

        nm_load_class('interface', 'Group');
        $obj_grupo = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);

        $this->arr_to_replace = array();
        $this->arr_to_replace['sc_tbapl']['Cod_Prj'] = $_SESSION['nm_session']['user']['cod_grp'];
        $this->arr_to_replace['sc_tbapl']['Versao'] = $_SESSION['nm_session']['user']['cod_ver'];
        $this->arr_to_replace['sc_tbapl']['Login'] = $_SESSION['nm_session']['user']['login'];
        $this->arr_to_replace['sc_tbapl']['Data_Inc'] = date('Ymd');
        $this->arr_to_replace['sc_tbapl']['Hora_Inc'] = date('His');
        $this->arr_to_replace['sc_tbapl']['NomeConexao'] = $arr_session['tabela_conn'];


        $this->arr_to_replace['sc_tbapl']['Data_Uacc'] = date('Ymd');
        $this->arr_to_replace['sc_tbapl']['Hora_Uacc'] = date('His');
        $this->arr_to_replace['sc_tbapl']['Folder'] = 'root/' . $arr_session['config_general']['folder_security'];
        $this->arr_to_replace['sc_tbapl']['Idioma'] = $obj_grupo->GetData('locale_default');
        $this->arr_to_replace['sc_tbapl']['SchemaAll'] = $arr_session['config_general']['theme'];
        $this->arr_to_replace['sc_tbapl']['SchemaSearch'] = $arr_session['config_general']['theme'];
        $this->arr_to_replace['sc_tbapl']['Attr1'] = array();
        $this->arr_to_replace['sc_tbapl']['Attr1']['lang_locale'] = $obj_grupo->GetData('locale_default');
        $this->arr_to_replace['sc_tbapl']['Attr1']['sc_version'] = $_SESSION['nm_session']['status']['ver_sc'];
        $this->arr_to_replace['sc_tbapl']['Attr4']['Imagem_Path'] = $nm_config['path_scase'] . 'file/img';
        $this->arr_to_replace['sc_tbapl']['Attr3']['log_schema'] = $arr_session['config_general']['log'];
        if ($arr_session['config_general']['log'] == '') {
            $this->arr_to_replace['sc_tbapl']['Attr3']['log_events'] = array();
        } else {
            nm_load_class('interface', 'Log');
            $log = nmLog::singleton($_SESSION['nm_session']['user']['cod_grp'], $_SESSION['nm_session']['user']['cod_ver'], $arr_session['config_general']['log']);
            $log->CheckAttr1();
            $data_log = $log->attr1->GetData();
            $data_log = $data_log['DefaultEvents'];
            $this->arr_to_replace['sc_tbapl']['Attr3']['log_all_fields'] = $log->GetData('rec_mode');
            $this->arr_to_replace['sc_tbapl']['Attr3']['log_events'] = $data_log;
        }

        $arr = $obj_grupo->GetData('locales_charset');
        $this->arr_to_replace['sc_tbapl']['Attr1']['charset_html'] = isset($arr[$this->arr_to_replace['sc_tbapl']['Attr1']['lang_locale']]) ? $arr[$this->arr_to_replace['sc_tbapl']['Attr1']['lang_locale']] : '';


        $this->arr_to_replace['sc_tbevt']['Cod_Prj'] = $_SESSION['nm_session']['user']['cod_grp'];
        $this->arr_to_replace['sc_tbevt']['Versao'] = $_SESSION['nm_session']['user']['cod_ver'];

        $this->arr_to_replace['sc_tbcmp']['Cod_Prj'] = $_SESSION['nm_session']['user']['cod_grp'];
        $this->arr_to_replace['sc_tbcmp']['Versao'] = $_SESSION['nm_session']['user']['cod_ver'];
        $this->arr_to_replace['sc_tbcmp']['Login'] = $_SESSION['nm_session']['user']['login'];

        $this->arr_to_replace['campos'] = array(
            'sec_users' => $arr_session['usr'] ?? '',
            'sec_apps' => isset($arr_session['app']) ? $arr_session['app'] : '',
            'sec_groups' => isset($arr_session['grp']) ? $arr_session['grp'] : '',
            'sec_groups_apps' => isset($arr_session['grp_app']) ? $arr_session['grp_app'] : '',
            'sec_users_groups' => isset($arr_session['usr_grp']) ? $arr_session['usr_grp'] : '',
            'sec_users_apps' => isset($arr_session['usr_app']) ? $arr_session['usr_app'] : '',
            'sec_users_social' => isset($arr_session['usr_social']) ? $arr_session['usr_social'] : '',
            'sec_logged' => isset($arr_session['logged']) ? $arr_session['logged'] : '',
            'sec_settings' => isset($arr_session['settings']) ? $arr_session['settings'] : '',
        );


        $this->arr_to_replace['tabelas'] = array(
            'sec_users' => $arr_session['usr']['table'] ?? '',
            'sec_apps' => isset($arr_session['app']['table']) ? $arr_session['app']['table'] : '',
            'sec_groups' => isset($arr_session['grp']['table']) ? $arr_session['grp']['table'] : '',
            'sec_groups_apps' => isset($arr_session['grp_app']['table']) ? $arr_session['grp_app']['table'] : '',
            'sec_users_groups' => isset($arr_session['usr_grp']['table']) ? $arr_session['usr_grp']['table'] : '',
            'sec_users_apps' => isset($arr_session['usr_app']['table']) ? $arr_session['usr_app']['table'] : '',
            'sec_users_social' => isset($arr_session['usr_social']['table']) ? $arr_session['usr_social']['table'] : '',
            'sec_logged' => isset($arr_session['logged']['table']) ? $arr_session['logged']['table'] : '',
            'sec_settings' => isset($arr_session['settings']['table']) ? $arr_session['settings']['table'] : '',
        );


        $this->arr_to_replace['others']['nmapp_Login']['login']['Tam_Minimo'] = $arr_session['config_login']['usu_tam_min'];
        $this->arr_to_replace['others']['nmapp_Login']['login']['Tam_Maximo'] = $arr_session['config_login']['usu_tam_max'];
        $this->arr_to_replace['others']['nmapp_Login']['pswd']['Tam_Minimo'] = $arr_session['config_login']['pass_tam_min'];
        $this->arr_to_replace['others']['nmapp_Login']['pswd']['Tam_Maximo'] = $arr_session['config_login']['pass_tam_max'];

        $this->arr_to_replace['others']['nmapp_form_add_users']['login']['Tam_Minimo'] = $arr_session['config_login']['usu_tam_min'];
        $this->arr_to_replace['others']['nmapp_form_add_users']['login']['Tam_Maximo'] = $arr_session['config_login']['usu_tam_max'];
        $this->arr_to_replace['others']['nmapp_form_add_users']['pswd']['Tam_Minimo'] = $arr_session['config_login']['pass_tam_min'];
        $this->arr_to_replace['others']['nmapp_form_add_users']['pswd']['Tam_Maximo'] = $arr_session['config_login']['pass_tam_max'];
        $this->arr_to_replace['others']['nmapp_form_add_users']['confirm_pswd']['Tam_Minimo'] = $arr_session['config_login']['pass_tam_min'];
        $this->arr_to_replace['others']['nmapp_form_add_users']['confirm_pswd']['Tam_Maximo'] = $arr_session['config_login']['pass_tam_max'];

        $this->arr_to_replace['others']['nmapp_form_edit_users']['login']['Tam_Minimo'] = $arr_session['config_login']['usu_tam_min'];
        $this->arr_to_replace['others']['nmapp_form_edit_users']['login']['Tam_Maximo'] = $arr_session['config_login']['usu_tam_max'];
        $this->arr_to_replace['others']['nmapp_form_edit_users']['pswd']['Tam_Minimo'] = $arr_session['config_login']['pass_tam_min'];
        $this->arr_to_replace['others']['nmapp_form_edit_users']['pswd']['Tam_Maximo'] = $arr_session['config_login']['pass_tam_max'];
        $this->arr_to_replace['others']['nmapp_form_edit_users']['confirm_pswd']['Tam_Minimo'] = $arr_session['config_login']['pass_tam_min'];
        $this->arr_to_replace['others']['nmapp_form_edit_users']['confirm_pswd']['Tam_Maximo'] = $arr_session['config_login']['pass_tam_max'];

        $this->arr_to_replace['others']['nmapp_retrieve_pswd']['login']['Tam_Minimo'] = $arr_session['config_login']['usu_tam_min'];
        $this->arr_to_replace['others']['nmapp_retrieve_pswd']['login']['Tam_Maximo'] = $arr_session['config_login']['usu_tam_max'];

        $this->arr_to_replace['others']['nmapp_change_pswd']['old_pswd']['Tam_Minimo'] = $arr_session['config_login']['pass_tam_min'];
        $this->arr_to_replace['others']['nmapp_change_pswd']['old_pswd']['Tam_Maximo'] = $arr_session['config_login']['pass_tam_max'];
        $this->arr_to_replace['others']['nmapp_change_pswd']['pswd']['Tam_Minimo'] = $arr_session['config_login']['pass_tam_min'];
        $this->arr_to_replace['others']['nmapp_change_pswd']['pswd']['Tam_Maximo'] = $arr_session['config_login']['pass_tam_max'];
        $this->arr_to_replace['others']['nmapp_change_pswd']['confirm_pswd']['Tam_Minimo'] = $arr_session['config_login']['pass_tam_min'];
        $this->arr_to_replace['others']['nmapp_change_pswd']['confirm_pswd']['Tam_Maximo'] = $arr_session['config_login']['pass_tam_max'];
        $this->arr_to_replace['others']['nmapp_settings']['password_min']['Tam_Minimo'] = $arr_session['config_login']['pass_tam_min'];

        $this->arr_to_replace['others']['nmapp_Login']['login']['Texto_Xml'] = serialize(array('letras' => (($arr_session['config_login']['usu_carac_letra'] == 'S') ? 'S' : 'N'),
            'numeros' => (($arr_session['config_login']['usu_carac_num'] == 'S') ? 'S' : 'N'),
            'acentuacao' => ((isset($arr_session['config_login']['usu_carac_sinais']) && $arr_session['config_login']['usu_carac_sinais'] == 'S') ? 'S' : 'N'),
            'cedilha' => (($arr_session['config_login']['usu_carac_cedilla'] == 'S') ? 'S' : 'N'),
            'espaco' => (($arr_session['config_login']['usu_carac_space'] == 'S') ? 'S' : 'N'),
            'ponto' => (($arr_session['config_login']['usu_carac_dot'] == 'S') ? 'S' : 'N'),
            'virgula' => (($arr_session['config_login']['usu_carac_comma'] == 'S') ? 'S' : 'N'),
            'todos' => (($arr_session['config_login']['usu_todos_carac'] == 'all') ? 'S' : 'N'),
            'mais' => '',
            'menos' => ''
        ));

        $this->arr_to_replace['others']['nmapp_Login']['pswd']['Texto_Xml'] = serialize(array('letras' => (($arr_session['config_login']['pass_carac_letra'] == 'S') ? 'S' : 'N'),
            'numeros' => (($arr_session['config_login']['pass_carac_num'] == 'S') ? 'S' : 'N'),
            'acentuacao' => ((isset($arr_session['config_login']['pass_carac_sinais']) && $arr_session['config_login']['pass_carac_sinais'] == 'S') ? 'S' : 'N'),
            'cedilha' => (($arr_session['config_login']['pass_carac_cedilla'] == 'S') ? 'S' : 'N'),
            'espaco' => (($arr_session['config_login']['pass_carac_space'] == 'S') ? 'S' : 'N'),
            'ponto' => (($arr_session['config_login']['pass_carac_dot'] == 'S') ? 'S' : 'N'),
            'virgula' => (($arr_session['config_login']['pass_carac_comma'] == 'S') ? 'S' : 'N'),
            'todos' => (($arr_session['config_login']['pass_todos_carac'] == 'all') ? 'S' : 'N'),
            'mais' => '',
            'menos' => ''
        ));
        if ($arr_session['config_general']['use_captcha'] == 'recaptchav3' && !$obj_lic->hasRightToVersion('9.12.000')) {
            $arr_session['config_general']['use_captcha'] = 'N';
        }
        $this->arr_to_replace['others']['nmapp_Login']['Attr1']['captcha_usar'] = $arr_session['config_general']['use_captcha'] == 'N' ? 'S' : $arr_session['config_general']['use_captcha'];
        if($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'ldap' || $_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'ldap_app'){
            $this->arr_to_replace['others']['nmapp_Login']['Attr1']['captcha_usar'] = $arr_session['config_general']['use_captcha'];
        }

        if ($arr_session['config_general']['use_captcha'] == 'recaptcha' || $arr_session['config_general']['use_captcha'] == 'recaptchav3') {

            $this->arr_to_replace['others']['nmapp_Login']['Attr1']['recaptcha_site_key'] = $arr_session['config_general']['recaptcha_site_key'];
            $this->arr_to_replace['others']['nmapp_Login']['Attr1']['recaptcha_secret_key'] = $arr_session['config_general']['recaptcha_secret_key'];
        }

        

        //$this->arr_to_replace['others']['nmapp_Login']['Attr1'][]

//		$arr_conn   = $this->obj_con->GetConnection($arr_session['tabela_conn']);
        $arr_table_fields = array();
        $arr_table_fields_all = array();
        foreach ($this->arr_to_replace['tabelas'] as $k => $v) {
            if (isset($this->arr_to_replace['campos'][$k]) && is_array($this->arr_to_replace['campos'][$k])) {
                foreach ($this->arr_to_replace['campos'][$k] as $kc => $vc) {
                    if ($kc == 'table') {
                        $arr_table_fields[$k] = $v;
                    }
                    $arr_table_fields[$k . "." . $kc] = $vc;
                    $arr_table_fields_all[$kc] = $vc;
                }
            }
        }
        $this->arr_to_replace['others']['mixTableFields'] = $arr_table_fields;
        $this->arr_to_replace['others']['justAllFields'] = $arr_table_fields_all;


        $this->arr_to_replace['others']['protected_var'] = array();
        $this->arr_to_replace['others']['protected_fields'] = $arr_table_fields;

        $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_security']['profile']['tabela_conn']);
        if (in_array(nm_db_type($arr_conn['dbms']), array('interbase', 'mssql', 'postgres', 'oracle'))) {
            foreach ($this->arr_to_replace['others']['mixTableFields'] as $k => $v) {
                $this->arr_to_replace['others']['protected_fields'][$k] = addslashes($v);
                $this->arr_to_replace['others']['protected_var']["{" . addslashes($v) . "}"] = "{" . unTrataCampoTabela($v) . "}";
                $this->arr_to_replace['others']['protected_var']["[" . addslashes($v) . "]"] = "[" . unTrataCampoTabela($v) . "]";
            }
        }

    }

    function doReplace()
    {
        global $nm_db, $nm_config;

        $arr_sql = $this->load_sql($_SESSION['nm_session']['module_security']['profile']['tipo_nivel']);

        nm_load_class('interface', 'Application');
        nm_load_class('interface', 'MenuApp');
        nm_load_class('interface', 'Field');
        nm_load_class('interface', 'Event');
        $obj_fld = new nmField();
        $obj_app = new nmApplication();
        $obj_menu2 = new nmMenuApp();
        $obj_evt = new nmEvent();
        $arr_apps = array();

        //Alterar o menu
        if ($_SESSION['nm_session']['module_security']['profile']['config_general']['menu'] != 'new_menu') {
            $app = explode("#@#", $_SESSION['nm_session']['module_security']['profile']['config_general']['menu']);
            $obj_app->SetApplication($_SESSION['nm_session']['user']['cod_grp'], $app[0], $_SESSION['nm_session']['user']['cod_ver']);
            $obj_app->SetCodField('Cod_Apl');
            $obj_app->SetData('ComandoSelect', '');
            $obj_app->SetData('NomeConexao', $_SESSION['nm_session']['module_security']['profile']['tabela_conn']);
            $obj_app->setFieldsAsData();
            $obj_app->RetrieveData();

//verificar menu2
            $arr_apps[] = $_SESSION['nm_session']['module_security']['profile']['config_general']['menu'];

            if($app[1] == 'menu2') {
                $obj_menu2->SetApplication($_SESSION['nm_session']['user']['cod_grp'], $app[0], $_SESSION['nm_session']['user']['cod_ver']);
                $obj_menu2->SetCodField('Cod_Apl');
                $obj_menu2->SetData('NomeConexao', $_SESSION['nm_session']['module_security']['profile']['tabela_conn']);
//                $obj_menu2->RetrieveData();
                $obj_menu2->CheckAttr2();

                $arr_data_menu = $obj_menu2->attr2->getTag('navmenu_itens');

                $menu_CS_navmenu = json_decode($arr_data_menu, true);
                $this->maior_id($menu_CS_navmenu['items'], $item, 2);

                $c = $arr_sql['nmapp_menu']['sc_tbapl'][0]['Attr2'];
                $navmenu_itens = json_decode($c['navmenu_itens'], true);
                $this->correct_id($navmenu_itens['items'], $item, 2);
                $navmenu_itens['items'] = $this->normalizeMenu($navmenu_itens['items'], 2);
                $menu_CS_navmenu['items'] = array_merge_recursive($menu_CS_navmenu['items'], $navmenu_itens['items']);

                $menu_CS_navmenu['username'] = '[usr_name]';
                $menu_CS_navmenu['userimage'] = '[usr_picture]';
                $menu_CS_navmenu['userdesc'] = '[usr_login] / [usr_email] / [usr_phone]';
                $menu_CS_navmenu['user_items'] = array();
                $menu_CS_navmenu['user_items'][] = array(
                    'text' => '{lang_sec_edit_profile}',
                    'app' => $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app']. 'my_info',
                    'icon' => 'fas fa-user',
                    'icon_check' => 'S',
                    'id' => 'item_user_1',
                    'hint' => '',
                    'link_target' => 'self',
                    'itree' => array(
                        'a' => array(
                            'attributes' => array(),
                        ),
                        'icon' => '',
                        'li' => array(
                            'attributes' => array(),
                        ),
                    ),

                );
                $menu_CS_navmenu['user_items'][] = array(
                    'text' => '{lang_change_pswd}',
                    'app' => $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'].'change_pswd',
                    'icon' => 'fas fa-key',
                    'icon_check' => 'S',
                    'id' => 'item_user_3',
                    'hint' => '',
                    'link_target' => 'self',
                    'itree' => array(
                        'a' => array(
                            'attributes' => array(),
                        ),
                        'icon' => '',
                        'li' => array(
                            'attributes' => array(),
                        ),
                    ),
                );
                $menu_CS_navmenu['user_items'][] = array(
                    'text' => '{lang_exit}',
                    'app' => $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'].'Login',
                    'icon' => 'fas fa-sign-out-alt',
                    'icon_check' => 'S',
                    'id' => 'item_user_2',
                    'hint' => '',
                    'link_target' => 'parente',
                    'itree' => array(
                        'a' => array(
                            'attributes' => array(),
                        ),
                        'icon' => '',
                        'li' => array(
                            'attributes' => array(),
                        ),
                    ),
                );

                $obj_menu2->attr2->SetTag('navmenu_itens', json_encode($menu_CS_navmenu));
                $obj_menu2->saveAttrN(array(2=>""));
            }
            else{

                $arr_data_menu = $obj_app->GetData('comandoselect');
                if (!empty($arr_data_menu)) {
                    $menu_CS = unserialize($arr_data_menu);
                } else {
                    $menu_CS = unserialize('a:1:{s:10:"menu_itens";a:0:{}}');
                }

                $this->maior_id($menu_CS['menu_itens'], $item);

                $comando = unserialize($arr_sql['nmapp_menu_old']['sc_tbapl'][0]['ComandoSelect']);
                $this->correct_id($comando['menu_itens'], $item);
                $comando['menu_itens'] = $this->normalizeMenu($comando['menu_itens']);
                $comando = (is_array($comando)) ? $comando : array();
                $menu_CS = serialize(array_merge_recursive($menu_CS, $comando));
                $obj_app->SetData('ComandoSelect', $menu_CS);

            }

            $obj_evt->SetApplication($_SESSION['nm_session']['user']['cod_grp'], $app[0], $_SESSION['nm_session']['user']['cod_ver']);
            $arr_event = $obj_evt->RetrieveList('E', 'onExecute');

            $on_execute_code = <<<EOT
if({sc_script_name} == '{$_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app']}Login'){

EOT;
            //remember_me
            $on_execute_code .= <<<EOT
    if(isset(\$_COOKIE['usr_data'])){
        unset(\$_COOKIE['usr_data']);
    }
EOT;


            if ($_SESSION['nm_session']['module_security']['profile']['tabela_logged'] == 'S') {
                $obj_app->CheckAttr3(true);
                $arr_lib[] = $_SESSION['nm_session']['user']['cod_grp'] . $nm_config['delim_1'] . 'sc_logged.php';
                $obj_app->attr3->SetTag('libraries_prj', $arr_lib);
                $obj_app->SaveAttrN(3);

                $on_execute_code .= <<<EOT
    sc_logged_out([logged_user], [logged_date_login]);
EOT;

            }

            $on_execute_code .= "\r\n}\r\n";
            if (isset($arr_event['onExecute']['codigo'])) {
                $on_execute_code .= $arr_event['onExecute']['codigo'];
            }

            if (!is_array($arr_event)) {
                $arr_event = array();
                $arr_event['onExecute'] = array();
                $arr_event['onExecute']['nome'] = "onExecute";
                $arr_event['onExecute']['tipo'] = 'E';
            }
            $arr_event['onExecute']['codigo'] = $on_execute_code;

            foreach ($arr_event['onExecute'] as $key => $value) {
                $obj_evt->SetData($key, $value);
            }
            $obj_evt->SaveData();


            $obj_app->SetData('NomeConexao', $_SESSION['nm_session']['module_security']['profile']['tabela_conn']);
            $obj_app->SaveData('save');

            if($app[1] == 'menu2'){
                $obj_menu2->saveAttrN(2);
            }
            //$arr_sql['nmapp_menu'] =
            unset($arr_sql['nmapp_menu']);
        }
        if ($_SESSION['nm_session']['module_security']['profile']['tabela_logged'] != 'S') {
            unset($arr_sql['nmapp_logged']);
            unset($arr_sql['nmapp_logged_users']);
        }
        if ($_SESSION['nm_session']['module_security']['profile']['tabela_social'] != 'S') {
            unset($arr_sql['nmapp_link_social']);
        }
        if ($_SESSION['nm_session']['module_security']['profile']['config_general']['logged_show_user'] != 'S') {
            unset($arr_sql['nmapp_logged_users']);
        }

        unset($arr_sql['nmapp_menu_old']);
        $arr_protect = array('EntraDetalheOrd', 'Seq', 'Versao');
        // arr_sql[app][tabela][k] => data
        foreach ($arr_sql as $app => $datas) {
            $app_table = $datas["sc_tbapl"][0]['NomeTabela'];
            $data = $this->normalizeApplication($datas["sc_tbapl"][0]);
            $arr_apps[] = protectAjaxChar($data['Cod_Apl']) . "#@#" . $data['Tipo_Apl'] . "#@#" . protectAjaxChar($data['friendly_name'] ?? '');
            $obj_app->SetData('Cod_Prj', $data['Cod_Prj']);
            $obj_app->SetData('Versao', $data['Versao']);
            $obj_app->SetData('Cod_Apl', $data['Cod_Apl']);

            foreach ($data as $k => $d) {
                if (substr($k, 0, 4) == 'Attr') {
                    $data[$k] = serialize($d);
                }
            }

            /*if(isset($data['format_when_digit']))
                unset($data['format_when_digit']);*/

            foreach ($data as $k => $v) {
                $obj_app->SetData($k, $v);
            }
            beginTrans();
            $obj_app->InsertApp();
            commitTrans();

            if (isset($datas["sc_tbcmp"]) && is_array($datas["sc_tbcmp"])) {
                beginTrans();
                foreach ($datas["sc_tbcmp"] as $data) {
                    $data = $this->normalizeField($data, $app_table);
                    if ($data == false) {
                        continue;
                    }
                    foreach ($data as $k => $d) {
                        if (substr($k, 0, 4) == 'Attr') {
                            $data[$k] = serialize($d);
                        }
                    }
                    if (is_array($data['Def_Complemento']))
                        $data['Def_Complemento'] = serialize($data['Def_Complemento']);
                    if (is_array($data['Def_Complemento_Cons']))
                        $data['Def_Complemento_Cons'] = serialize($data['Def_Complemento_Cons']);
                    if (is_array($data['Def_Complemento_Pesq']))
                        $data['Def_Complemento_Pesq'] = serialize($data['Def_Complemento_Pesq']);
                    foreach ($data as $k => $v) {
                        if (!in_array($k, $arr_protect)) {
                            $data[$k] = $nm_db->qstr($v);
                        } else if (empty($v)) {
                            $data[$k] = "NULL";
                        }
                    }
                    $obj_fld->InsertFld($data);
                }
                commitTrans();
            }


            if (isset($datas["sc_tbevt"]) && is_array($datas["sc_tbevt"])) {
                //nm_printr($datas["sc_tbevt"]); exit;
                beginTrans();
                foreach ($datas["sc_tbevt"] as $data) {
                    $data = $this->normalizeEvent($data);
                    if ($data == false) {
                        continue;
                    }

                    $obj_evt->SetData('Cod_Apl', $data['Cod_Apl']);

                    foreach ($data as $k => $v) {
                        if (!in_array($k, $arr_protect)) {
                            $data[$k] = $nm_db->qstr($v);
                        } else if (empty($v)) {
                            $data[$k] = "NULL";
                        }
                    }
                    $obj_evt->InsertEvent($data);
                }
                commitTrans();
            }
        }
        $_SESSION['nm_session']['arr_apps'] = implode("#?#", $arr_apps);
    }

    /**
     * Retorna os sqls para o n&iacute;vel de seguran&ccedil;a.
     *
     *
     * @access  protected
     * @global  array $nm_config Array com configuracao do ScriptCase.
     */
    function load_sql($level)
    {

        global $nm_config;
        $str_file = $nm_config['path_lib'] . "security2/security_" . $level . "/arr_export.sc";
        return json_decode(file_get_contents($str_file), true);
    }

    function maior_id($arr, &$maior = 0, $menu_version = 1)
    {
        $menu_type = $menu_version == 1 ? 'menu_itens' : 'children';
        foreach ($arr as $itens) {
            $id = str_replace('item_', '', $itens['id']);
            $maior = ($maior > $id) ? $maior : $id;
            if (isset($itens[$menu_type]) && count($itens[$menu_type]) > 0) {
                $this->maior_id($itens[$menu_type], $maior, $menu_version);
            }
        }
    }

    function correct_id(&$arr, $id, $menu_version = 1)
    {
        $menu_type = $menu_version == 1 ? 'menu_itens' : 'children';
        foreach ($arr as $k => $itens) {
            $_id = str_replace('item_', '', $itens['id']);
            $arr[$k]['id'] = 'item_' . ((int)$_id + $id);
            if (isset($itens[$menu_type]) && count($itens[$menu_type]) > 0) {
                $this->correct_id($arr[$k][$menu_type], $id, $menu_version);
            }
        }
    }

    function normalizeMenu($datas, $menu_version = 1)
    {
        $menu_type = $menu_version == 1 ? 'menu_itens' : 'children';
        $link = $menu_version == 1 ? 'link' : 'app';

        global $obj_lic;
        $replace = array('nmapp_' => $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app']);
        $arr_datas = $datas;
        $arr_new = array();
        foreach ($datas as $k => $data) {
            if ($data[$link] == 'nmapp_logged_users' && ($_SESSION['nm_session']['module_security']['profile']['tabela_logged'] != 'S' || $_SESSION['nm_session']['module_security']['profile']['config_general']['logged_show_user'] != 'S')) {
                unset($arr_datas[$k]);
                continue;
            }
            if ($data[$link] == 'nmapp_link_social' && $_SESSION['nm_session']['module_security']['profile']['tabela_social'] != 'S') {
                unset($arr_datas[$k]);
                continue;
            }

            $arr_datas[$k][$link] = strtr($data[$link], $replace);
            if (isset($data[$menu_type]) && count($data[$menu_type]) > 0) {
                $arr_datas[$k][$menu_type] = $this->normalizeMenu($data[$menu_type], $menu_version);
            }
            $arr_new[] = $arr_datas[$k];
        }
        return $arr_new;
    } // PageJs

    function normalizeApplication($data)
    {
        global $nm_ini_sys, $nm_config, $obj_lic;
        $data = $this->replace('sc_tbapl', $data);

        if (!empty($data['Campos_Chave']))
            $data['Campos_Chave'] = $this->arr_to_replace['campos'][$data['NomeTabela']][$data['Campos_Chave']];

        if (isset($data['Attr4']['form_params']) && !empty($data['Attr4']['form_params'])) {
            $form_params = explode(';', $data['Attr4']['form_params']);
            foreach ($form_params as $k => $param) {
                $form_params[$k] = isset($this->arr_to_replace['campos'][$data['NomeTabela']][$param]) ? $this->arr_to_replace['campos'][$data['NomeTabela']][$param] : $param;
            }
            $data['Attr4']['form_params'] = implode(';', $form_params);
        }

        if (isset($data['Attr1']['form_sqlselect']) && !empty($data['Attr1']['form_sqlselect'])) {
            $data['Attr1']['form_sqlselect'] = strtr($data['Attr1']['form_sqlselect'], $this->arr_to_replace['others']['mixTableFields']);
        }
        if(isset($data['Attr4']['comando_select_edit']) && !empty($data['Attr4']['comando_select_edit'])){
            $data['Attr4']['comando_select_edit'] = strtr($data['Attr4']['comando_select_edit'], $this->arr_to_replace['others']['mixTableFields']);
            $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_security']['profile']['tabela_conn']);
            if(nm_db_type($arr_conn['dbms']) == 'mssql'){
                $data['Attr4']['comando_select_edit'] = strtr($data['Attr4']['comando_select_edit'], ["'[usr_login]'" => '"[usr_login]"']);
            }
        }
        if (!empty($data['Attr1']) && !empty($data['Attr1']['form_sqlwhere'])) {
            $data['Attr1']['form_sqlwhere'] = strtr($data['Attr1']['form_sqlwhere'], $this->arr_to_replace['others']['mixTableFields']);
            $data['Attr1']['form_sqlwhere'] = strtr($data['Attr1']['form_sqlwhere'], $this->arr_to_replace['tabelas']);
            $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_security']['profile']['tabela_conn']);
            if(nm_db_type($arr_conn['dbms']) == 'mssql'){
                $data['Attr1']['form_sqlwhere'] = strtr($data['Attr1']['form_sqlwhere'], ["'[usr_login]'" => '"[usr_login]"']);
            }
        }
        if (isset($data['Attr2']) && isset($data['Attr2']['botoes'])) {

            foreach ($data['Attr2']['botoes'] as $k => $v) {
                $data['Attr2']['botoes'][$k]['js'] = strtr($data['Attr2']['botoes'][$k]['js'], $this->arr_to_replace['others']['protected_fields']);
                $data['Attr2']['botoes'][$k]['js'] = strtr($data['Attr2']['botoes'][$k]['js'], $this->arr_to_replace['others']['protected_var']);
            }

        }

        $data['Attr1']['security_url_redirect'] = $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . "Login";
        $data['Attr1']['doc_path'] = substr($nm_config['path_root'], 0, -1) . $nm_ini_sys->GetTag('path_doc');
        $data['Attr1']['use_sweetalert'] = $_SESSION['nm_session']['module_security']['profile']['config_general']['sweet_alert'];

        $data['Attr4']['imagem_path'] = $nm_ini_sys->GetTag('path_img');
        if (isset($data['Attr1']['unique_key']) && !empty($data['Attr1']['unique_key'])) {
            $unique_key = explode(';', $data['Attr1']['unique_key']);
            foreach ($unique_key as $k => $uni) {
                if (isset($this->arr_to_replace['others']['mixTableFields'][$data['NomeTabela'] . "." . $uni])) {
                    $unique_key[$k] = $this->arr_to_replace['others']['mixTableFields'][$data['NomeTabela'] . "." . $uni];
                } else {
                    $unique_key[$k] = strtr($uni, $this->arr_to_replace['campos'][$data['NomeTabela']]);
                }
            }
            $data['Attr1']['unique_key'] = implode(';', $unique_key);
        }

        if (isset($data['Attr3']['dependency_new']) && is_array($data['Attr3']['dependency_new'])) {
            foreach ($data['Attr3']['dependency_new'] as $k => $arr_dep) {

                foreach ($data['Attr3']['dependency_new'][$k]['fld_pri'] as $k_fld => $fld) {
                    $data['Attr3']['dependency_new'][$k]['fld_pri'][$k_fld] = strtr($data['Attr3']['dependency_new'][$k]['fld_pri'][$k_fld], $this->arr_to_replace['campos'][$data['NomeTabela']]);
                }
                foreach ($data['Attr3']['dependency_new'][$k]['fld_dep'] as $k_fld => $fld) {
                    if(isset($this->arr_to_replace['campos'][$data['Attr3']['dependency_new'][$k]['name']])) {
                        $data['Attr3']['dependency_new'][$k]['fld_dep'][$k_fld] = strtr($data['Attr3']['dependency_new'][$k]['fld_dep'][$k_fld], $this->arr_to_replace['campos'][$data['Attr3']['dependency_new'][$k]['name']]);
                    }
                }
                $data['Attr3']['dependency_new'][$k]['name'] = $this->arr_to_replace['tabelas'][$data['Attr3']['dependency_new'][$k]['name']];
            }
        }

        if (isset($data['Attr2']['blocos']) && is_array($data['Attr2']['blocos'])) {
            foreach ($data['Attr2']['blocos'] as $k => $bloco) {
                if (!empty($data['NomeTabela']) && count($bloco['campos']) > 0) {
                    foreach ($bloco['campos'] as $seq => $field) {
                        $data['Attr2']['blocos'][$k]['campos'][$seq] = isset($this->arr_to_replace['campos'][$data['NomeTabela']][$field]) ? $this->arr_to_replace['campos'][$data['NomeTabela']][$field] : $data['Attr2']['blocos'][$k]['campos'][$seq];
                    }
                }

                $data['Attr2']['blocos'][$k]['t_nome'] = (substr($data['Attr2']['blocos'][$k]['t_nome'], 6) == 'nmapp_')
                    ? $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . substr($data['Cod_Apl'], 6) : $data['Attr2']['blocos'][$k]['t_nome'];
                $data['Attr2']['blocos'][$k]['t_texto'] = (substr($data['Attr2']['blocos'][$k]['t_texto'], 6) == 'nmapp_')
                    ? $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . substr($data['Attr2']['blocos'][$k]['t_texto'], 6) : $data['Attr2']['blocos'][$k]['t_texto'];

            }

        }
        if (isset($data['Attr2']['blocos_filter']) && is_array($data['Attr2']['blocos_filter'])) {
            foreach ($data['Attr2']['blocos_filter'] as $k => $bloco) {
                if (!empty($data['NomeTabela']) && count($bloco['campos']) > 0) {
                    foreach ($bloco['campos'] as $seq => $field) {
                        $data['Attr2']['blocos_filter'][$k]['campos'][$seq] = isset($this->arr_to_replace['campos'][$data['NomeTabela']][$field]) ? $this->arr_to_replace['campos'][$data['NomeTabela']][$field] : $data['Attr2']['blocos_filter'][$k]['campos'][$seq];
                    }
                }
                $data['Attr2']['blocos_filter'][$k]['t_nome'] = (substr($data['Attr2']['blocos_filter'][$k]['t_nome'], 6) == 'nmapp_')
                    ? $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . substr($data['Cod_Apl'], 6) : $data['Attr2']['blocos_filter'][$k]['t_nome'];

                $data['Attr2']['blocos_filter'][$k]['t_texto'] = (substr($data['Attr2']['blocos_filter'][$k]['t_texto'], 6) == 'nmapp_') ?
                    $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . substr($data['Attr2']['blocos_filter'][$k]['t_texto'], 6) : $data['Attr2']['blocos_filter'][$k]['t_texto'];

            }

        }

        if (!empty($data['NomeTabela'])) {
            $data['NomeTabela'] = $this->arr_to_replace['tabelas'][$data['NomeTabela']] ?? $data['NomeTabela'];
        }

        if (!empty($data['ComandoSelect']) && $data['Cod_Apl'] != 'nmapp_menu') {
            $data['ComandoSelect'] = strtr($data['ComandoSelect'], $this->arr_to_replace['tabelas']);
        }

        if (!empty($data['Attr2']) && $data['Cod_Apl'] == 'nmapp_menu') {
            $navmenu_itens= json_decode($data['Attr2']['navmenu_itens'], true);
            $navmenu_itens['items'] = $this->normalizeMenu($navmenu_itens['items'], 2);
            if(isset($navmenu_itens['user_items'])){
                $replace = array('nmapp_' => $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app']);
                foreach ($navmenu_itens['user_items'] as $key => $value) {
                    $navmenu_itens['user_items'][$key]['app'] = strtr($navmenu_itens['user_items'][$key]['app'], $replace);
                }
            }
            $data['Attr2']['navmenu_itens'] = json_encode($navmenu_itens);
        }

        if ($data['Cod_Apl'] == 'nmapp_Login') {
            foreach ($this->arr_to_replace['others']['nmapp_Login']['Attr1'] as $k => $v) {
                if ($k == 'JUMP_MENU') continue;

                $data['Attr1'][$k] = $v;
            }
            if($_SESSION['nm_session']['module_security']['profile']['tabela_social'] == 'S') {
                $data['Attr1']['field_start_focus'] = '';
            }

            if (
                isset($_SESSION['nm_session']['module_security']['profile']['config_login']) &&
                isset($_SESSION['nm_session']['module_security']['profile']['config_login']['use_login_template']) &&
                $_SESSION['nm_session']['module_security']['profile']['config_login']['use_login_template'] == 'S') {
                //dd($arr_sql['nmapp_Login']);
                $data['Tipo_Apl'] = NM_APP_TYPE_CONTROLUSR;
                $data['Attr4']['control_html_source'] = 'template';
                $data['Attr4']['control_html_file'] = strtr((isset($_SESSION['nm_session']['module_security']['profile']['config_login']['template_login'])?$_SESSION['nm_session']['module_security']['profile']['config_login']['template_login']:""), array("/" => '__NM__'));
            }
            if (isset($_SESSION['nm_session']['module_security']['profile']['config_general']['label_position'])) {
                $data['Attr2']['blocos'][0]['l_posicao'] = $_SESSION['nm_session']['module_security']['profile']['config_general']['label_position'];
            }


                $data['Attr1']['use_vertical_center'] = 'center';
                $data['Attr1']['margem_app_t'] = '';


        } else if ($data['Cod_Apl'] == 'nmapp_link_social' && $_SESSION['nm_session']['module_security']['profile']['tabela_social'] == 'S' && isset($this->arr_to_replace['others']['nmapp_link_social']['Attr1'])) {
            foreach ($this->arr_to_replace['others']['nmapp_link_social']['Attr1'] as $k => $v) {
                $data['Attr1'][$k] = $v;
            }
        }

        if ($data['Cod_Apl'] == 'nmapp_menu' && $_SESSION['nm_session']['module_security']['profile']['config_general']['menu'] == 'new_menu') {
            $data_nmapp_menu = json_decode($data['Attr2']['navmenu_itens'],true);
            $data_nmapp_menu['theme'] = $_SESSION['nm_session']['module_security']['profile']['config_general']['menu_theme'];
            $data_nmapp_menu['layout'] = strtoupper($_SESSION['nm_session']['module_security']['profile']['config_general']['menu_layout']);
            $data['Attr2']['navmenu_itens'] = json_encode($data_nmapp_menu);
        }


        switch ($data['Tipo_Apl']) {
            case NM_APP_TYPE_CALENDAR:
            case NM_APP_TYPE_FORM:
                $data['Attr3']["log_events"] = array_intersect(array('access', 'insert', 'update', 'delete'), $this->arr_to_replace['sc_tbapl']['Attr3']['log_events']);
                break;
            default:
                $data['Attr3']["log_events"] = array_intersect(array('access'), $this->arr_to_replace['sc_tbapl']['Attr3']['log_events']);
                break;
        }

        if (isset($data['Attr3']['ligacoes'][0]) && is_array($data['Attr3']['ligacoes'][0])) {
            $arr_mix = array();

            foreach ($this->arr_to_replace['campos'] as $arr) {
                if (!is_array($arr)) continue;
                $arr_mix = array_merge($arr_mix, $arr);
            }

            foreach ($data['Attr3']['ligacoes'] as $k => $liga) {
                $data['Attr3']['ligacoes'][$k]['liga_apl'] = $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . substr($data['Attr3']['ligacoes'][$k]['liga_apl'], 6);
                $data['Attr3']['ligacoes'][$k]['liga_id'] = "apl_" . $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . substr($data['Attr3']['ligacoes'][$k]['liga_id'], 10);
                $data['Attr3']['ligacoes'][$k]['liga_parms'] = strtr($liga['liga_parms'], $this->arr_to_replace['others']['mixTableFields']);
            }
        }

        /*if (isset($data['Attr3']['toolbars']['bottom_center'])) {
            $arr_remove_social = [];
            $__var = $_SESSION['nm_session']['module_security']['profile']['config_general'];
            if (!isset($__var['option_google']) || (isset($__var['option_google']) && $__var['option_google'] != 'google')) {
                $arr_remove_social[] = 'sys_auth_google';
            }
            if (!isset($__var['option_twitter']) || (isset($__var['option_twitter']) && $__var['option_twitter'] != 'twitter')) {
                $arr_remove_social[] = 'sys_auth_twitter';
            }
            if (!isset($__var['option_facebook']) || (isset($__var['option_facebook']) && $__var['option_facebook'] != 'facebook')) {
                $arr_remove_social[] = 'sys_auth_facebook';
            }
            $data['Attr3']['toolbars']['bottom_center'] = array_diff($data['Attr3']['toolbars']['bottom_center'], $arr_remove_social);
            if(isset($data['Attr3']['toolbars']['mobile_bottom_center'])) {
                $data['Attr3']['toolbars']['mobile_bottom_center'] = array_diff($data['Attr3']['toolbars']['mobile_bottom_center'], $arr_remove_social);
            }
        }*/

        $data['Attr4']['usa_ajax'] = ($data['Tipo_Apl'] == NM_APP_TYPE_GRID ? 'S' : 'N');

        $data['Cod_Apl'] = $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . substr($data['Cod_Apl'], 6);
        return $data;
    } // normalizeApplication

    function replace($table, $data)
    {
        foreach ($this->arr_to_replace[$table] as $str_name => $campo) {
            if (!is_array($campo)) {
                $data[$str_name] = $campo;
            } else {
                foreach ($campo as $k => $v) {
                    $data[$str_name][$k] = $v;
                }
            }
        }
        return $data;
    }

    function normalizeField($data, $app_table)
    {
        global $nm_config;
        $data = $this->replace('sc_tbcmp', $data);
        $arr_mix = array();
        foreach ($this->arr_to_replace['campos'] as $arr) {
            if (!is_array($arr)) continue;
            $arr_mix = array_merge($arr_mix, $arr);
        }
        $data['Texto_Xml'] = isset($this->arr_to_replace['others'][$data['Cod_Apl']][$data['Campo']]['Texto_Xml']) ? $this->arr_to_replace['others'][$data['Cod_Apl']][$data['Campo']]['Texto_Xml'] : $data['Texto_Xml'];
        $data['Attr4']['tam_minimo'] = isset($data['Campo']) && isset($this->arr_to_replace['others'][$data['Cod_Apl']][$data['Campo']]['Tam_Minimo']) ? $this->arr_to_replace['others'][$data['Cod_Apl']][$data['Campo']]['Tam_Minimo'] : $data['Attr4']['tam_minimo'];
        $data['Attr4']['tam_maximo'] = isset($data['Campo']) && isset($this->arr_to_replace['others'][$data['Cod_Apl']][$data['Campo']]['Tam_Maximo']) ? $this->arr_to_replace['others'][$data['Cod_Apl']][$data['Campo']]['Tam_Maximo'] : $data['Attr4']['tam_maximo'];
        if (isset($data['Attr4']['signature_guideline'])) {
            unset($data['Attr4']['signature_guideline']);
        }

        $data['Campo'] = (isset($data['Campo_Def']) && isset($this->arr_to_replace['campos'][$app_table][$data['Campo']])) ? strtr($this->arr_to_replace['campos'][$app_table][$data['Campo']], array("'" => "", '"' => "", "[" => "", "]" => "", "`" => "")) : $data['Campo'];
        $data['Def_Campo'] = (isset($data['Campo_Def']) && isset($this->arr_to_replace['campos'][$app_table][$data['Def_Campo']])) ? $this->arr_to_replace['campos'][$app_table][$data['Def_Campo']] : $data['Def_Campo'];
        $data['Campo_Def'] = (isset($data['Campo_Def']) && isset($this->arr_to_replace['campos'][$app_table][$data['Campo_Def']])) ? $this->arr_to_replace['campos'][$app_table][$data['Campo_Def']] : $data['Campo_Def'];
        $data['Def_Tabela'] = (isset($this->arr_to_replace['tabelas'][$app_table]) ? $this->arr_to_replace['tabelas'][$app_table] : $data['Def_Tabela']);
        $data['Attr4']['comando_select_edit'] = strtr($data['Attr4']['comando_select_edit'], $this->arr_to_replace['others']['mixTableFields']);
        if (isset($data['Attr1']['lookup_tab_nome']) && !empty($data['Attr1']['lookup_tab_nome'])) {
            $data['Attr1']['lookup_cmp_lista'] = strtr($data['Attr1']['lookup_cmp_lista'], $this->arr_to_replace['campos'][$data['Attr1']['lookup_tab_nome']]);


            $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_security']['profile']['tabela_conn']);
            if (nm_db_type($arr_conn['dbms']) == 'postgres') {
                $data['Attr1']['lookup_tab_nome'] = trataCampoTabela($this->arr_to_replace['tabelas'][$data['Attr1']['lookup_tab_nome']], $arr_conn['dbms']);
            } else {
                $data['Attr1']['lookup_tab_nome'] = $this->arr_to_replace['tabelas'][$data['Attr1']['lookup_tab_nome']];
            }
        }

        if (isset($data['Def_Complemento']['select']) && !empty($data['Def_Complemento']['select'])) {
            $data['Def_Complemento']['select'] = strtr($data['Def_Complemento']['select'], $this->arr_to_replace['others']['mixTableFields']);
            //$data['Def_Complemento']['select']		= strtr($data['Def_Complemento']['select'], $arr_mix);
        }

        if (isset($data['Def_Complemento_Cons']['select']) && !empty($data['Def_Complemento_Cons']['select'])) {
            $data['Def_Complemento_Cons']['select'] = strtr($data['Def_Complemento_Cons']['select'], $this->arr_to_replace['others']['mixTableFields']);
            //$data['Def_Complemento_Cons']['select']		= strtr($data['Def_Complemento_Cons']['select'], $arr_mix);
        }

        if (isset($data['Def_Complemento_Pesq']['select']) && !empty($data['Def_Complemento_Pesq']['select'])) {
            $data['Def_Complemento_Pesq']['select'] = strtr($data['Def_Complemento_Pesq']['select'], $this->arr_to_replace['others']['mixTableFields']);
            //$data['Def_Complemento_Pesq']['select']		= strtr($data['Def_Complemento_Pesq']['select'], $arr_mix);
        }
        if (strtolower($data['Campo']) == 'picture') {
            $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_security']['profile']['tabela_conn']);
            switch (nm_db_type($arr_conn['dbms'])) {
                case 'access' :
                    $tipo_sql = 'LONGBINARY';
                    break;
                case 'postgres' :
                    $tipo_sql = 'BYTEA';
                    break;
                case 'oracle' :
                    $tipo_sql = 'BLOB';
                    break;
                case 'mssql' :
                    $tipo_sql = 'BINARY';
                    break;
                default:
                    $tipo_sql = $data['Tipo_Sql'];
                    break;
            }
            $data['Tipo_Sql'] = $tipo_sql;
        }
        if ($data['Cod_Apl'] == 'nmapp_Login') {
//            if ($data['Campo'] == 'Links') {
//                $data['Attr1']['jump_menu'] = $this->arr_to_replace['others']['nmapp_Login']['Attr1']['JUMP_MENU'];
//            }
            if ($data['Campo'] == 'pswd') {
                    $data['Attr1']['usa_senha_exibir_ocultar'] = $_SESSION['nm_session']['module_security']['profile']['config_login']['usa_senha_exibir_ocultar'];
                    $data['Attr4']['html_largura'] = $_SESSION['nm_session']['module_security']['profile']['config_login']['usa_senha_exibir_ocultar'] == 'S' ? 31 : 35;

            }
            if ($data['Campo'] == 'new_user' || $data['Campo'] == 'retrieve_pswd') {
                $data['Attr1']['jump_menu'] = strtr($data['Attr1']['jump_menu'], ['nmapp_' => $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app']]);
            }
        }

        if ($data['Cod_Apl'] == 'nmapp_settings' && $data['Campo'] == 'recover_pswd') {
            if(isset($_SESSION['nm_session']['module_security']['profile']['config_general']['criptografia'])
                && !empty(isset($_SESSION['nm_session']['module_security']['profile']['config_general']['criptografia']))) {
                $arr_new = array();
                foreach($data['Def_Complemento']['conteudo'] as $__data){
                    if($__data['value_lig'] == 'send_pswd'){
                        continue;
                    }
                    $arr_new[] = $__data;
                }
                $data['Def_Complemento']['conteudo'] = $arr_new;
            }
        }
//        if ($data['Cod_Apl'] == 'nmapp_form_add_users' && $data['Campo'] == 'active') {
//            $data['Attr1']['banco_val_tipo'] = 'valor';
//            $data['Attr1']['banco_val_valor'] = isset($_SESSION['nm_session']['module_security']['profile']['config_general']['actve_by_email']) && $_SESSION['nm_session']['module_security']['profile']['config_general']['actve_by_email'] != 'S' ? 'Y' : 'N';
//        }
        if ($data['Cod_Apl'] == 'nmapp_form_edit_users' && $data['Campo'] == 'Groups') {
            $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_security']['profile']['tabela_conn']);
            if (nm_db_type($arr_conn['dbms']) == 'sybase') {
                $data['tipo_dado'] = 'UPDATE_NUMEROEDT';
            }
        }
        $data['Cod_Apl'] = $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . substr($data['Cod_Apl'], 6);

        return $data;
    }

    function normalizeEvent($data)
    {
        global $nm_config;
        $config = $_SESSION['nm_session']['module_security']['profile']['config_general'];
        $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_security']['profile']['tabela_conn']);

        $config_email = $_SESSION['nm_session']['module_security']['profile']['config_email'] ?? '';
        $data = $this->replace('sc_tbevt', $data);
        if (!isset($config['criptografia']) || empty($config['criptografia'])) {
            $data['Codigo'] = str_replace('md5(', '(', $data['Codigo']);
        } else {
            $data['Codigo'] = str_replace('md5(', 'hash("' . $config['criptografia'] . '",', $data['Codigo']);
        }


        if ($config['menu'] != 'new_menu') {
            $arr_menu = explode('#@#', $config['menu']);
            $data['Codigo'] = strtr($data['Codigo'], array('nmapp_menu' => $arr_menu[0]));
        }
        if($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'usr'){
            $data['Codigo'] = strtr($data['Codigo'], array('nmapp_grid_sec_users' => '!XXX@XXX!'));
        }

        $_arr_code = array_merge($this->arr_to_replace['others']['protected_fields'], array('nmapp_' => $config['prefix_app']));


        if (isset($config['perm_new_user']) || $config['perm_new_user'] = 'S') {
            if ($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'grp') {
                $_arr_code = array_merge($_arr_code, array("\$group_default = 2;" => ''));
            }
        }


        if ($_SESSION['nm_session']['module_security']['profile']['config_login']['pass_tam_max'] != 32) {
            $_arr_code["for(\$i=0; \$i < 32; \$i++)"] = "for(\$i=0; \$i < " . $_SESSION['nm_session']['module_security']['profile']['config_login']['pass_tam_max'] . "; \$i++)";
        }

        if ($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'ldap'
            || $_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'ldap_app') {
            $config_ldap = $_SESSION['nm_session']['module_security']['profile']['config_general'];
            $_arr = array(
                "'domain_controllers' => array(\"192.168.254.73\")," => "'domain_controllers' => array('" . $config_ldap['ldap_server'] . "'),",
                "'domain_controllers' => array('192.168.254.73')," => "'domain_controllers' => array('" . $config_ldap['ldap_server'] . "'),",
                "'base_dn' => 'DC=admartini,DC=scriptcase,DC=info'," => "'base_dn' => '" . $config_ldap['ldap_dn'] . "',",
                "'account_suffix' => '@admartini.scriptcase.info'," => "'account_suffix' => '" . $config_ldap['ldap_suffix'] . "',",
                "'ad_port' => 389" => "'ad_port' => " . $config_ldap['ldap_port'],

                "substr([usr_login],0, 32)" => "substr([usr_login],0, " . $_SESSION['nm_session']['module_security']['profile']['config_login']['usu_tam_max'] . ")",
                "substr({login},0, 32)" => "substr({login},0, " . $_SESSION['nm_session']['module_security']['profile']['config_login']['usu_tam_max'] . ")",
                "substr([_user],0, 32)" => "substr([_user],0, " . $_SESSION['nm_session']['module_security']['profile']['config_login']['usu_tam_max'] . ")",
                "substr(\$ldap_user_account, 0, 32)" => "substr(\$ldap_user_account, 0, " . $_SESSION['nm_session']['module_security']['profile']['config_login']['usu_tam_max'] . ")",

            );
            $_arr_code = array_merge($_arr_code, $_arr);
        }
        if ($_SESSION['nm_session']['module_security']['profile']['tabela_logged'] != 'S') {
            $_arr = array(
                "sc_logged_out([usr_login]);" => "",
                "if(sc_logged([usr_login])):" => "",
                "if(sc_logged([_user])):" => "",
                "endif;" => "",
                "sc_verify_logged();" => "",
                "\$date_login = (isset([logged_date_login])? [logged_date_login] : '');" => "",
                "sc_logged_out([usr_login], \$date_login);" => "",
                "sc_user_logout('logged_user', 'logout', 'nmapp_Login');" => "",
                "sc_logged_out([logged_user], [logged_date_login]);" => "",
                "sc_looged_check_logout();" => "",
                "if([sett_brute_force] == 'Y' && sc_logged_is_blocked()) { sc_error_exit(); }" => "",
                "if(sc_logged_is_blocked()) { sc_error_exit(); }" => "",
                "sc_logged_in_fail({login})" => "",
                "sc_logged_in_fail(\$user_id);" => ""
            );
            $_arr_code = array_merge($_arr_code, $_arr);
        }
        if (in_array(nm_db_type($arr_conn['dbms']), array('sybase', 'access'))) {
            $_arr_code["sc_sql_injection({group_id})"] = "{group_id}";
            $_arr_code["sc_sql_injection([group]})"] = "[group]";
            $_arr_code["sc_sql_injection({group})"] = "{group}";
            $_arr_code["sc_sql_injection( [group] )"] = "[group]";
            $_arr_code["sc_sql_injection(\$group_default)"] = "\$group_default";
        }


        if ($_SESSION['nm_session']['module_security']['profile']['config_general']['perm_new_user'] != 'S') {
            $_arr_code["link_user(\$resource, \$user_id, \$email, \$name);"] = "";
            $_arr_code["add_user_to_group({login});"] = "";
            $_arr_code["\$group_default = 2;"] = "";
            $_arr_code['sc_exec_sql("DELETE FROM sec_users_social WHERE sec_users_social.login = ". sc_sql_injection({login}));'] = "";
        }
        /*
                if ($_SESSION['nm_session']['module_security']['profile']['config_general']['logged_brute_force'] != 'S') {
                    $_arr_code["if(sc_logged_is_blocked()) { sc_error_exit(); }"] = "";
                }*/


        if ($data['Nome'] == 'active_onClick' && in_array(nm_db_type($arr_conn['dbms']), array('interbase', 'oracle'))) {
            $data['Nome'] = "ACTIVE_onClick";
        }

        $data['Codigo'] = strtr($data['Codigo'], $_arr_code);
        $data['Codigo'] = strtr($data['Codigo'], $this->arr_to_replace['others']['protected_var']);
        $data['Cod_Apl'] = $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . substr($data['Cod_Apl'], 6);

        if($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'usr'){
            $data['Codigo'] = strtr($data['Codigo'], array('!XXX@XXX!' => $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app']  .'grid_sec_users'));
        }
        /*
        if(nm_db_type($arr_conn['dbms']) == 'oracle'){
            $data['Codigo'] = strtr($data['Codigo'], array("\'RESOURCE\'" => "'RESOURCE'"));
        }*/
        return $data;
    }

    /**
     * Recupera lista de aplicacoes do tipo menu.
     *
     * @access  protected
     */
    function ActiveSecurity()
    {

        $prefix = $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'];
        nm_load_class('interface', 'Application');
        $obj_app = new nmApplication();
        $obj_app->SetApplication($_SESSION['nm_session']['user']['cod_grp'],
            $prefix . "Login",
            $_SESSION['nm_session']['user']['cod_ver']);


        $_arr = array($prefix . "Login",
            $prefix . "change_pswd",
            $prefix . "user_not_active",
            $prefix . "retrieve_pswd",
            $prefix . "control_2fa",
            $prefix . "form_add_users");

        $obj_app->UpdateSetSecurityApp($_arr, [], "N");
        if ($_SESSION['nm_session']['module_security']['profile']['config_general']['set_seg_app'] == 'N') {
            return;
        }
        $arr_apl_list = '';

        if(!isset($_SESSION['nm_session']['module_security']['profile']['pop_app']['selected_apps']) || empty($_SESSION['nm_session']['module_security']['profile']['pop_app']['selected_apps']) &&
            !isset($_SESSION['nm_session']['module_security']['profile']['pop_app']['include_apps']) || empty($_SESSION['nm_session']['module_security']['profile']['pop_app']['include_apps']))
        {
            $apl_list = $this->setAplArray(true);
            foreach($apl_list as $app){
                $_arr[] = $app[0];
            }
        }else if(isset($_SESSION['nm_session']['module_security']['profile']['pop_app']['select_include_apps']) &&
                 $_SESSION['nm_session']['module_security']['profile']['pop_app']['select_include_apps'] == 'Y')
        {
            if(isset($_SESSION['nm_session']['module_security']['profile']['pop_app']['selected_apps']) &&
               !empty($_SESSION['nm_session']['module_security']['profile']['pop_app']['selected_apps']) &&
                is_array($_SESSION['nm_session']['module_security']['profile']['pop_app']['selected_apps']))
            {
                $arr_apl_list = $_SESSION['nm_session']['module_security']['profile']['pop_app']['selected_apps'];
            }
        }

        $obj_app->UpdateSetSecurityApp($arr_apl_list, $_arr, "S");
//        $obj_app->UpdateSetSecurityApp($_arr, $arr_apl_list, "N");
    }

    function putLib()
    {
        global $nm_config;

        if ($_SESSION['nm_session']['module_security']['profile']['tabela_logged'] != 'S') {
            return;
        }

        if (!is_dir($nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . "/lib")) {
            @mkdir($nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . "/lib", 0777, true);
        }

        $str_file = file_get_contents($nm_config['path_lib'] . "security/lib/sc_logged.php");

        $arr_replace_file = array_merge(array('nmapp_' => $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'],
            'sec_logged.sec_logged' => $this->arr_to_replace['tabelas']['sec_logged']),
            $this->arr_to_replace['others']['protected_fields']
        );
//
//        $arr_replace_file["\$minutes_ago = strtotime(\"-10 minutes\");"] = "\$minutes_ago = strtotime(\"-" . $_SESSION['nm_session']['module_security']['profile']['config_general']['logged_brute_force_time'] . " minutes\");";
//        $arr_replace_file["if({rs_logged} !== FALSE && {rs_logged[0][0]} == 10)"] = "if({rs_logged} !== FALSE && {rs_logged[0][0]} == " . $_SESSION['nm_session']['module_security']['profile']['config_general']['logged_brute_force_attempts'] . ")";
//        $arr_replace_file["\$message = sprintf(\$message, 10);"] = "\$message = sprintf(\$message, " . $_SESSION['nm_session']['module_security']['profile']['config_general']['logged_brute_force_time'] . ");";

        $str_file = strtr($str_file, $arr_replace_file);
        file_put_contents($nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . "/lib/sc_logged.php", $str_file);

        nm_load_class('interface', 'Application');
        $obj_app = new nmApplication();
        $obj_app->SetApplication($_SESSION['nm_session']['user']['cod_grp'],
            $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . 'Login',
            $_SESSION['nm_session']['user']['cod_ver']);
        $obj_app->CheckAttr3();
        $arr_lib = array($_SESSION['nm_session']['user']['cod_grp'] . $nm_config['delim_1'] . 'sc_logged.php');
        $obj_app->attr3->SetTag('libraries_prj', $arr_lib);
        $obj_app->SaveAttrN(3);
        if ($_SESSION['nm_session']['module_security']['profile']['config_general']['menu'] == 'new_menu') {
            $obj_app = new nmApplication();
            $obj_app->SetApplication($_SESSION['nm_session']['user']['cod_grp'],
                $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . 'menu',
                $_SESSION['nm_session']['user']['cod_ver']);
            $obj_app->CheckAttr3();
            $arr_lib = array($_SESSION['nm_session']['user']['cod_grp'] . $nm_config['delim_1'] . 'sc_logged.php');
            $obj_app->attr3->SetTag('libraries_prj', $arr_lib);
            $obj_app->SaveAttrN(3);
        }

        $obj_app = new nmApplication();
        $obj_app->SetApplication($_SESSION['nm_session']['user']['cod_grp'],
            $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . 'logged',
            $_SESSION['nm_session']['user']['cod_ver']);
        $obj_app->CheckAttr3();
        $arr_lib = array($_SESSION['nm_session']['user']['cod_grp'] . $nm_config['delim_1'] . 'sc_logged.php');
        $obj_app->attr3->SetTag('libraries_prj', $arr_lib);
        $obj_app->SaveAttrN(3);

//        if (isset($_SESSION['nm_session']['module_security']['profile']['2fa']) &&
//            isset($_SESSION['nm_session']['module_security']['profile']['2fa']['option'] ) ) {
            $obj_app = new nmApplication();
            $obj_app->SetApplication($_SESSION['nm_session']['user']['cod_grp'],
                $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . 'control_2fa',
                $_SESSION['nm_session']['user']['cod_ver']);
            $obj_app->CheckAttr3();
            $arr_lib = array($_SESSION['nm_session']['user']['cod_grp'] . $nm_config['delim_1'] . 'sc_logged.php');
            $obj_app->attr3->SetTag('libraries_prj', $arr_lib);
            $obj_app->SaveAttrN(3);

            $obj_app = new nmApplication();
            $obj_app->SetApplication($_SESSION['nm_session']['user']['cod_grp'],
                $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . 'add_2fa',
                $_SESSION['nm_session']['user']['cod_ver']);
            $obj_app->CheckAttr3();
            $arr_lib = array($_SESSION['nm_session']['user']['cod_grp'] . $nm_config['delim_1'] . 'sc_logged.php');
            $obj_app->attr3->SetTag('libraries_prj', $arr_lib);
            $obj_app->SaveAttrN(3);
//        }


    }

    function normalizeFolders()
    {
        nm_load_class('interface', 'Group');
        $obj_grp = new nmGroup($_SESSION['nm_session']['user']['cod_grp']);

        $_arr = $obj_grp->GetData('Folders');
        $_arr['root'][$_SESSION['nm_session']['module_security']['profile']['config_general']['folder_security']] = array();

        $obj_grp->SetData('Folders', $_arr);
        $obj_grp->AtuData($_SESSION['nm_session']['user']['cod_grp']);

        $_SESSION['nm_session']['user']['folder'] = $this->arr_to_replace['sc_tbapl']['Folder'];
    }

    function populate($nm_db_usu)
    {
        global $nm_config;
        $previous_error = set_error_handler("nm_faz_nada");
        $arr_session = $_SESSION['nm_session']['module_security']['profile'];
        if (isset($arr_session['pop_app']['include_apps']) || isset($arr_session['pop_app']['select_include_apps'])){
            if($arr_session['pop_app']['include_apps'] == 'Y'){
                $apl_list = '';
            }else if($arr_session['pop_app']['select_include_apps'] == 'Y'){
                $apl_list = (is_array($arr_session['pop_app']['selected_apps']) ? $arr_session['pop_app']['selected_apps'] : '');
            }
            beginTrans();
            $this->addApplications($nm_db_usu,$apl_list);
            commitTrans();
        }
        //banco

        $arr_sql = $this->{"populate" . ucwords($arr_session['tipo_nivel'])}($nm_db_usu);
        $error = '';
        $charset = $this->getCharset();
        if (count($arr_sql) > 0) {
            foreach ($arr_sql as $str_sql) {
                //if(empty($str_sql)) continue;
                $sql = nm_decode_utf8_charset($str_sql, $charset);
                $nm_db_usu->Execute($sql);
                $_SESSION['nm_session']['module_security']['profile']['sql_security_commands'] .= $sql . ";\n";

                //echo $str_sql . "<br/>" . $nm_db_usu->ErrorMsg() . "<hr/>";
            }
            if($nm_config['em_desenv']){
                file_put_contents($nm_config['path_tmp'] . "debug_sql_module_security_" . md5(date('YmdHis')) . ".sql", implode(";\n\n\n", $arr_sql), FILE_APPEND);
            }
        }
        //$nm_db_usu->Close();
        /*if(!empty($error))
        {
            return $error;
        }*/
        set_error_handler($previous_error);
        return TRUE;
    }//GetFields

    function addApplications($nm_db_usu,$apl_list='')
    {
        global $nm_config;


        //$conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_security']['profile']['tabela_conn']);
        //$nm_db_usu = nm_db_connect($conn, __FILE__, __LINE__);

        $charset = $this->getCharset();

        $data = getAplList();
        if(!empty($apl_list)){
            foreach($data as $key => $v){
                if(!in_array($v[0], $apl_list)){
                    unset($data[$key]);
                }
            }
        }
        $fields = $_SESSION['nm_session']['module_security']['profile']['app']['app_name'] . ", "
            . $_SESSION['nm_session']['module_security']['profile']['app']['app_type'] . ", "
            . $_SESSION['nm_session']['module_security']['profile']['app']['description'];

        $prefix = $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'];
        switch ($_SESSION['nm_session']['module_security']['profile']['tipo_nivel']) {
            case 'grp':
                $data[] = array(0 => $prefix . "change_pswd", 5 => 'contr', 3 => 'Change password');
                $data[] = array(0 => $prefix . "form_add_users", 5 => 'form', 3 => 'Add users');
                $data[] = array(0 => $prefix . "form_edit_users", 5 => 'form', 3 => 'Edit users');
                $data[] = array(0 => $prefix . "my_info", 5 => 'form', 3 => 'Edit Profile');
                $data[] = array(0 => $prefix . "form_sec_apps", 5 => 'form', 3 => 'Add apps');
                $data[] = array(0 => $prefix . "form_sec_groups", 5 => 'form', 3 => 'Show groups');
                $data[] = array(0 => $prefix . "form_sec_groups_apps", 5 => 'form', 3 => 'Groups/Apps');
                $data[] = array(0 => $prefix . "grid_sec_users_groups", 5 => 'form', 3 => 'Show users by groups');
                $data[] = array(0 => $prefix . "grid_sec_apps", 5 => 'cons', 3 => 'Show apps');
                $data[] = array(0 => $prefix . "grid_sec_groups", 5 => 'cons', 3 => 'Show groups');
                $data[] = array(0 => $prefix . "grid_sec_users", 5 => 'cons', 3 => 'Show users');
                $data[] = array(0 => $prefix . "Login", 5 => 'contr', 3 => 'Login - Initial Application');


                if ($_SESSION['nm_session']['module_security']['profile']['config_general']['menu'] == 'new_menu')
                    $data[] = array(0 => $prefix . "menu", 5 => 'menu', 3 => 'Menu');
                if ($_SESSION['nm_session']['module_security']['profile']['tabela_logged'] == 'S') {
                    $data[] = array(0 => $prefix . "logged", 5 => 'contr', 3 => 'Logged application');
                    $data[] = array(0 => $prefix . "logged_users", 5 => 'cons', 3 => 'List logged users');
                }
                if ($_SESSION['nm_session']['module_security']['profile']['tabela_social'] == 'S') {
                    $data[] = array(0 => $prefix . "link_social", 5 => 'contr', 3 => 'Link Social account');
                }
                $data[] = array(0 => $prefix . "retrieve_pswd", 5 => 'contr', 3 => 'Retrieve Password');
                $data[] = array(0 => $prefix . "search_sec_groups", 5 => 'filter', 3 => 'Search Groups');
                $data[] = array(0 => $prefix . "sync_apps", 5 => 'contr', 3 => 'Resync Applications');

                break;

            case 'ldap':
                    $data[] = array(0 => $prefix . "Login", 5 => 'contr', 3 => 'Login - Initial Application');
                    if ($_SESSION['nm_session']['module_security']['profile']['config_general']['menu'] == 'new_menu')
                        $data[] = array(0 => $prefix . "menu", 5 => 'menu', 3 => 'Menu');
                    if ($_SESSION['nm_session']['module_security']['profile']['tabela_logged'] == 'S') {
                        $data[] = array(0 => $prefix . "logged", 5 => 'contr', 3 => 'Logged application');
                        $data[] = array(0 => $prefix . "logged_users", 5 => 'cons', 3 => 'List logged users');
                    }
                    break;
            case 'ldap_app':
                $data[] = array(0 => $prefix . "sync_users", 5 => 'contr', 3 => 'Resync users with ldap');
                $data[] = array(0 => $prefix . "user_not_active", 5 => 'contr', 3 => 'Validade user not active in system');
                $data[] = array(0 => $prefix . "form_edit_users", 5 => 'form', 3 => 'Edit Users');
                $data[] = array(0 => $prefix . "form_sec_apps", 5 => 'form', 3 => 'Add apps');
                $data[] = array(0 => $prefix . "form_sec_users_apps", 5 => 'form', 3 => 'Users/Apps');
                $data[] = array(0 => $prefix . "grid_sec_apps", 5 => 'cons', 3 => 'Show apps');
                $data[] = array(0 => $prefix . "grid_sec_users", 5 => 'cons', 3 => 'Show users');
                $data[] = array(0 => $prefix . "grid_sec_users_apps", 5 => 'cons', 3 => 'Users/Apps');
                $data[] = array(0 => $prefix . "search_sec_users", 5 => 'contr', 3 => 'Search users');
                $data[] = array(0 => $prefix . "Login", 5 => 'contr', 3 => 'Login - Initial Application');
                if ($_SESSION['nm_session']['module_security']['profile']['config_general']['menu'] == 'new_menu')
                    $data[] = array(0 => $prefix . "menu", 5 => 'menu', 3 => 'Menu');
                if ($_SESSION['nm_session']['module_security']['profile']['tabela_logged'] == 'S') {
                    $data[] = array(0 => $prefix . "logged", 5 => 'contr', 3 => 'Logged application');
                    $data[] = array(0 => $prefix . "logged_users", 5 => 'cons', 3 => 'List logged users');
                }
                $data[] = array(0 => $prefix . "sync_apps", 5 => 'contr', 3 => 'Resync Applications');
                break;
            case 'app':
                $data[] = array(0 => $prefix . "change_pswd", 5 => 'contr', 3 => 'Change Password');
                $data[] = array(0 => $prefix . "form_add_users", 5 => 'form', 3 => 'Add Users');
                $data[] = array(0 => $prefix . "form_edit_users", 5 => 'form', 3 => 'Edit Users');
                $data[] = array(0 => $prefix . "my_info", 5 => 'form', 3 => 'Edit Profile');
                $data[] = array(0 => $prefix . "form_sec_apps", 5 => 'form', 3 => 'Add apps');
                $data[] = array(0 => $prefix . "form_sec_users_apps", 5 => 'form', 3 => 'Users/Apps');
                $data[] = array(0 => $prefix . "grid_sec_apps", 5 => 'cons', 3 => 'Show apps');
                $data[] = array(0 => $prefix . "grid_sec_users", 5 => 'cons', 3 => 'Show users');
                $data[] = array(0 => $prefix . "grid_sec_users_apps", 5 => 'cons', 3 => 'Users/Apps');
                $data[] = array(0 => $prefix . "search_sec_users", 5 => 'contr', 3 => 'Search users');
                $data[] = array(0 => $prefix . "Login", 5 => 'contr', 3 => 'Login - Initial Application');
                if ($_SESSION['nm_session']['module_security']['profile']['config_general']['menu'] == 'new_menu')
                    $data[] = array(0 => $prefix . "menu", 5 => 'menu', 3 => 'Menu');
                if ($_SESSION['nm_session']['module_security']['profile']['tabela_logged'] == 'S') {
                    $data[] = array(0 => $prefix . "logged", 5 => 'contr', 3 => 'Logged application');
                    $data[] = array(0 => $prefix . "logged_users", 5 => 'cons', 3 => 'List logged users');
                }
                if ($_SESSION['nm_session']['module_security']['profile']['tabela_social'] == 'S') {
                    $data[] = array(0 => $prefix . "link_social", 5 => 'contr', 3 => 'Link Social account');
                }
                $data[] = array(0 => $prefix . "retrieve_pswd", 5 => 'contr', 3 => 'Retrieve Password');
                $data[] = array(0 => $prefix . "sync_apps", 5 => 'contr', 3 => 'Resync Applications');
                break;

            case 'usr':
                $data[] = array(0 => $prefix . "change_pswd", 5 => 'contr', 3 => 'Change Password');
                $data[] = array(0 => $prefix . "form_add_users", 5 => 'form', 3 => 'Add Users');
                $data[] = array(0 => $prefix . "form_edit_users", 5 => 'form', 3 => 'Edit Users');
                $data[] = array(0 => $prefix . "my_info", 5 => 'form', 3 => 'Edit Profile');
                $data[] = array(0 => $prefix . "grid_sec_users", 5 => 'cons', 3 => 'Show users');
                $data[] = array(0 => $prefix . "grid_sec_users_apps", 5 => 'cons', 3 => 'Users/Apps');
                $data[] = array(0 => $prefix . "Login", 5 => 'contr', 3 => 'Login - Initial Application');
                if ($_SESSION['nm_session']['module_security']['profile']['config_general']['menu'] == 'new_menu')
                    $data[] = array(0 => $prefix . "menu", 5 => 'menu', 3 => 'Menu');
                if ($_SESSION['nm_session']['module_security']['profile']['tabela_logged'] == 'S') {
                    $data[] = array(0 => $prefix . "logged", 5 => 'contr', 3 => 'Logged application');
                    $data[] = array(0 => $prefix . "logged_users", 5 => 'cons', 3 => 'List logged users');
                }
                if ($_SESSION['nm_session']['module_security']['profile']['tabela_social'] == 'S') {
                    $data[] = array(0 => $prefix . "link_social", 5 => 'contr', 3 => 'Link Social account');
                }
                $data[] = array(0 => $prefix . "retrieve_pswd", 5 => 'contr', 3 => 'Retrieve Password');
                break;
        }
            $data[] = array(0 => $prefix . "add_2fa", 5 => 'contr', 3 => 'Add 2FA to user');
            $data[] = array(0 => $prefix . "control_2fa", 5 => 'cons', 3 => 'Control 2FA');
            $data[] = array(0 => $prefix . "settings", 5 => 'contr', 3 => 'Settings');
        if(!in_array($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'], ['usr', 'ldap'])) {
            foreach ($data as $v) {
                $sql = nm_decode_utf8_charset("INSERT INTO " . $_SESSION['nm_session']['module_security']['profile']['app']['table']
                    . "(" . $fields . ")
								 VALUES (" . $nm_db_usu->qstr($v[0]) . ", " . $nm_db_usu->qstr($v[5]) . ", " . $nm_db_usu->qstr($v[3]) . ")", $charset);
                $nm_db_usu->Execute($sql);
                $_SESSION['nm_session']['module_security']['profile']['sql_security_commands'] .= $sql . "\n";
            }
        }
        $this->addSettings($nm_db_usu);

        //$nm_db_usu->Close();
    }

    public function addSettings($nm_db_usu)
    {
        global $nm_config;
        $arr_session = $_SESSION['nm_session']['module_security']['profile'];
        $charset = $this->getCharset();
            $sql = "INSERT INTO " . $arr_session['settings']['table']
                . "(" .
                $arr_session['settings']['set_name'] . ", " .
                $arr_session['settings']['set_value'] . ")
								 VALUES (";
            $o2fa = empty($arr_session['2fa']['option']) || $arr_session['2fa']['option'] == 0 ? 'N' : 'Y';

        $config_reset_email = $arr_session['config_ret_pass']['reset_pass'] ?? 'email_com_link_senha';
        $config_reset_email = [
            'email_com_link_senha' => 'send_link',
            'email_com_senha' => 'send_pswd',
            'email_com_nova_senha' => 'reset_send'][ strtolower($config_reset_email) ];

            $arr_values = [
                'session_expire' => $arr_session['config_general']['session'],
                'remember_me' => $arr_session['config_general']['remember_me'] == 'S' ? 'Y' : 'N',
                'cookie_expiration_time' => $arr_session['config_general']['remember_me_expiry_cookie'] ?? 30,
                'retrieve_password' => 'Y',
                'new_users' => $arr_session['config_general']['perm_new_user'] == 'S' ? 'Y' : 'N',
                'brute_force' => $arr_session['tabela_logged'] == 'S' && $arr_session['config_general']['logged_brute_force'] == 'S' ? 'Y' : 'N',
                'brute_force_time_block' => $arr_session['config_general']['logged_brute_force_time'] ?? 10,
                'brute_force_attempts' => $arr_session['config_general']['logged_brute_force_attempts'] ?? 10,
                'enable_2fa' => $o2fa,
                'enable_2fa_expiration_time' => $arr_session['2fa']['2fa_expiry_time'] ?? 300,
                'enable_2fa_mode' => $arr_session['2fa']['mode'] ?? 'individual',
                'enable_2fa_api' => $arr_session['2fa']['api'] ?? '',
                'enable_2fa_api_type' => $arr_session['2fa']['option'] ?? '',
                'captcha' => $arr_session['config_general']['use_captcha'] == 'N' ? 'N' : 'Y',
                'theme' => $arr_session['config_general']['theme'] ?? '',
                'language' => $arr_session['config_login']['show_language'] == 'S' ? 'Y' : 'N',
                'req_email_act' => $arr_session['config_general']['actve_by_email'] == 'S' ? 'Y' : 'N',
                'send_email_adm' => $arr_session['config_general']['send_mail_to_admin'] == 'S' ? 'Y' : 'N',
                'smtp_api' => $arr_session['config_general']['smtp_api'] ?? '',
                'smtp_server' => $arr_session['config_email']['smtp_server'] ?? '',
                'smtp_port' => $arr_session['config_email']['smtp_port'] ?? '',
                'smtp_security' => $arr_session['config_email']['smtp_security'] ?? '',
                'smtp_user' => $arr_session['config_email']['smtp_user'] ?? '',
                'smtp_pass' => $arr_session['config_email']['smtp_pass'] ?? '',
                'smtp_from_email' => $arr_session['config_email']['smtp_email'] ?? '',
                'smtp_from_name' => $arr_session['config_email']['smtp_name'] ?? '',
                'recover_pswd' => $config_reset_email,
                'login_mode' => $arr_session['config_general']['login_mode'] ?? '',
                'group_default' => $_SESSION['nm_session']['module_security']['id_group_default'] ?? '2',
                'group_administrator' => $_SESSION['nm_session']['module_security']['id_group_administrator'] ?? '1',
                'pswd_last_updated' => $arr_session['config_general']['pswd_last_updated'] ?? '60',
                'mfa_last_updated' => $arr_session['config_general']['mfa_last_updated'] ?? NULL,
                'password_strength' => !empty($arr_session['config_general']['password_strength']) ? implode(';', $arr_session['config_general']['password_strength']) : '' ,
                'password_min' => $arr_session['config_login']['pass_tam_min'] ,
                'auth_sn_position' => $arr_session['config_login']['login_buttons_orientation'] ,
                'auth_sn_fb' => 'N',
                'auth_sn_fb_app_id' => '',
                'auth_sn_fb_secret' => '',
                'auth_sn_x' => 'N',
                'auth_sn_x_key' => '',
                'auth_sn_x_secret' => '',
                'auth_sn_google' => 'N',
                'auth_sn_google_client_id' => '',
                'auth_sn_google_secret' => '',
            ];

        if ($arr_session['tabela_social'] == 'S') {
            
            if (isset($arr_session['config_general']['option_facebook'])) {
                $arr_values['auth_sn_fb'] = 'Y';
                $arr_values['auth_sn_fb_app_id'] = $arr_session['config_general']['facebook_app_id'];
                $arr_values['auth_sn_fb_secret'] = $arr_session['config_general']['facebook_secret'];
            }
            if (isset($arr_session['config_general']['option_twitter'])) {
                $arr_values['auth_sn_x'] = 'Y';
                $arr_values['auth_sn_x_key'] = $arr_session['config_general']['twitter_key'];
                $arr_values['auth_sn_x_secret'] = $arr_session['config_general']['twitter_secret'];
            }
            if (isset($arr_session['config_general']['option_google']) && $nm_config['flag_versao']['google_auth']['has']) {
                $arr_values['auth_sn_google'] = 'Y';
                $arr_values['auth_sn_google_client_id'] = $arr_session['config_general']['google_oauth2_client_id'];
                $arr_values['auth_sn_google_secret'] = $arr_session['config_general']['google_oauth2_secret'];
            }
        }
            foreach ($arr_values as $k => $v) {
                $__sql = nm_decode_utf8_charset($sql . $nm_db_usu->qstr($k) . ", " . $nm_db_usu->qstr($v) . ")", $charset);
                $nm_db_usu->Execute($__sql);
                $_SESSION['nm_session']['module_security']['profile']['sql_security_commands'] .= $__sql . ";\n";
            }


    }

    function ldapTest($arr)
    {
        global $nm_config, $nm_ini_sys;
        $previous_error = set_error_handler("nm_faz_nada");

        $arr_session = $_SESSION['nm_session']['module_security']['profile']['config_general'];
        if (strpos($arr['ldap_dn'], '.') !== false) {
            $base_dn         = str_replace('.', ',dc=', $arr['ldap_dn']);
            $arr['ldap_dn']  = 'dc=' . $base_dn;
        }
        if($nm_ini_sys->GetTag('sys_ldap_lib') == 'LdapRecord' && $nm_config['flag_versao']['ldap_record']['has']){
            try{
                if(!empty($arr['ldap_suffix']) && strpos($arr['ldap_login'],$arr['ldap_suffix']) === FALSE){
                    $arr['ldap_login'] = $arr['ldap_login'].$arr['ldap_suffix'];
                }
                $arr_ldap_cfg = array(
                    'hosts'             => [$arr['ldap_server']],
                    'base_dn'           => $arr['ldap_dn'],
                    'username'          => $arr['ldap_login'],
                    'password'          => $arr['ldap_pswd'],
                    'port'              => $arr['ldap_port'],
                );
                $ldap_version = (version_compare(phpversion(), '8.1', '>=')) ? "v3" : "v2";
                require_once $nm_config['path_prod_third']."ldapRecord/$ldap_version/vendor/autoload.php";
                $ad = new \LdapRecord\Connection($arr_ldap_cfg);
                $ad->connect();
                $result = 'ok';
            }catch (\LdapRecord\Auth\BindException $e) {
                $result = nm_get_text_lang("['ldap_error_bind']");
            }catch (\LdapRecord\ConnectionException $e) {
                $result = nm_get_text_lang("['ldap_error_bind']");
            }catch (\Exception $e) {
                $result = nm_get_text_lang("['ldap_error_bind']");
            }
        }else{
            $config = array(
                'domain_controllers' => array($arr['ldap_server']),
                'base_dn' => $arr['ldap_dn'],
                'account_suffix' => $arr['ldap_suffix'],
                'admin_username' => $arr['ldap_login'],
                'admin_password' => $arr['ldap_pswd'],
                'ad_port' => $arr['ldap_port'],
            );
            include_once($nm_config['path_prod_third'] . 'adLdap/Adldap.php');
            include_once($nm_config['path_prod_third'] . 'adLdap/autoload.php');
            $adldap = new adLDAP\adLDAP($config);
            $result = ($adldap->getLastError() !== 'Success' ? nm_get_text_lang("['ldap_error_bind']") : 'ok');
        }
        echo $result;
        //@ldap_bind($ldapConn, $user_name, $password) or die(nm_get_text_lang("['ldap_error_bind']") );
        set_error_handler($previous_error);
        //echo 'ok';
    }

    /**
     * Exibe o conteudo.
     *
     * Exibe o conteudo da tela inicial do ScriptCase.
     *
     * @access  protected
     */
    function DisplayContent()
    {
        global $nm_template, $nm_config, $nm_db, $nm_ini_sys;
        //$this->load_variable_replace();
        //nm_printr($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] ?? '');
        $this->showPageDesenv('module_security');
        $nm_template->SetVar('noButton',['carregar']);
        if (isset($_POST['action'])) {
            $this->do_action($_POST);
            $this->ChangeDisplay($_POST);
        } else {
            unset($_SESSION['nm_session']['module_security']['profile']);

            $profiles = $this->LoadOptionProfile(true);

            if (count($profiles) == 0) {
                $i = 1;
                $nm_template->SetVar('block_image_help', $this->GetImgManual('module_security2_tipo_', NM_HELP_MENU_CONFIG));
                $nm_template->SetVar('noButton',['carregar','tipo']);
            } else {
                $i = 0;
                $nm_template->SetVar('block_image_help', $this->GetImgManual('module_security2_carregar_', NM_HELP_MENU_CONFIG));
                $nm_template->SetVar('option_profile', $profiles);
            }

            $this->step_now = $this->arr_steps[$i];
            $nm_template->SetVar('step_before', (isset($this->arr_steps[$i - 1]) ? $this->arr_steps[$i - 1] : 0));
            $nm_template->SetVar('step_now', $this->step_now);
            $nm_template->SetVar('step_after', $this->arr_steps[$i + 1]);
            $nm_template->SetVar('content', "body_security_module_step_" . $this->step_now);
            $nm_template->Display("body_security_module", 'security_module2');
        }
    }

    /**
     * Realiza uma ação de acordo com o passo.
     *
     * @param array $arr Array com POST
     *
     * @access  protected
     */
    function do_action($arr)
    {
        global $nm_config, $nm_template;
        if ($arr['action'] == 'next' || $arr['action'] == 'generate') {
            switch ($arr['step_now']) {
                case 'carregar':
                    if ($arr['profile'] == 'use') {
                        //$arr['option_profile'];
                        $arr_tmp_list_change = explode('#@NM@#', $arr['option_profile']);
                        list($level, $file_xml) = $arr_tmp_list_change;
                        switch ($level) {
                            case 'scriptcase':
                                $str_path = $nm_config['path_scriptcase'] . 'securitymodule/';
                                break;
                            case 'sys':
                                $str_path = $nm_config['path_sys'] . 'securitymodule/';
                                break;
                            case 'grp':
                                $str_path = $nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . '/securitymodule/';
                                break;
                            case 'usr':
                                $str_path = $nm_config['path_usr'] . $_SESSION['nm_session']['user']['login'] . '/securitymodule/';
                                break;
                        }
                        $arr = $this->source2array($str_path . $file_xml);
                        $_SESSION['nm_session']['module_security']['profile'] = $arr;
                        $nm_template->SetVar('profile_nivel_in_use',$_SESSION['nm_session']['module_security']['profile']['tipo_nivel']);
                    }
                    if (count($this->LoadOptionProfile(true)) == 0) {
                        $nm_template->SetVar('noButton',['carregar','tipo']);
                    }
                    break;
                case 'tabela':
                    if ($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'ldap') {
                        $_POST['step_after'] = 'config';
                        return;
                    }

                    if (isset($arr['tabela_seg']) && $arr['tabela_seg'] == 'create') {
                        beginTrans();
                        /* PHP 8.0 */
                        /*                        if ($arr['tabela_drop_tables'] == 'S') { */
                        if (isset($arr['tabela_drop_tables']) && $arr['tabela_drop_tables'] == 'S') {
                            /*------*/
                            $this->DropTables($arr['tabela_conn'],
                                $arr['tabela_seg_prefix'],
                                isset($arr['tabela_logged']) ? $arr['tabela_logged'] : 'N',
                                isset($arr['tabela_social']) ? $arr['tabela_social'] : 'N');
                        }
                        $arr_err = $this->CreateTables($arr['tabela_conn'],
                            $arr['tabela_seg_prefix'],
                            isset($arr['tabela_logged']) ? $arr['tabela_logged'] : 'N',
                            isset($arr['tabela_social']) ? $arr['tabela_social'] : 'N');
                        commitTrans();

                        if(!empty($arr_err)){
                            $_POST['step_after'] = 'tabela';
                            $str_error_lang = nm_get_text_lang("['app_error_title']");
                            $str_error =  implode('',$arr_err);

                            $str_html = <<<HTML
                            <div class="ui modal tiny" id="err_tabela_create">
                                <div class="header">
                                    <h4>{$str_error_lang}</h4>
                                </div>
                                <div class="scrolling content">
                            		<span id="modal-info-span-description">{$str_error}</span>
                            	</div>
                                <div class="actions">
                                    <div class="ui primary button approve">
                                    	OK
                                    </div>
                                </div>
                            </div>

HTML;
                            $str_html .=<<<JS
                            <script>
                                $("#err_tabela_create").modal('show');
                            </script>
JS;
                            echo $str_html;

                        }else{
                            $_POST['step_after'] = 'config';
                        }

                    }
                    else{
                        $sql_name = $nm_config['path_tmp'] . "sql_security_module_" . md5(date('YmdHis')) . ".sql";
                        $_SESSION['nm_session']['module_security']['profile']['sql_security_commands'] = '';
                        file_put_contents($sql_name, '');
                        $_SESSION['nm_session']['module_security']['profile']['tabela_seg_create_filename']= $sql_name;
                        $sql_name = str_replace($nm_config['path_tmp'], $nm_config['url_tmp'], $sql_name);
                        $_SESSION['nm_session']['module_security']['profile']['url_tabela_seg_create_filename']= $sql_name;
                    }
                    break;

            }
        }
        else if ($arr['action'] == 'back') {
            switch ($arr['step_now']) {
                case 'config':
                    if (
                        ($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'ldap')
                        || ($arr['step_now'] == 'config' && $_SESSION['nm_session']['module_security']['profile']['tabela_seg'] == 'create')
                    ) {
                        $_POST['step_before'] = 'tabela';
                        return;
                    }
                    break;
            }

            switch($arr['step_before']){
                case 'tipo':
                    if (count($this->LoadOptionProfile(true)) == 0) {
                        $nm_template->SetVar('noButton',['carregar','tipo']);
                    }
                    break;
            }
        }
    }

    /**
     * Lê o arquivo xml e transforma em array.
     *
     * @param string source
     *
     * @access  protected
     */
    function source2array($source)
    {
        $_content = file_get_contents($source);
        if(substr($_content, 0, 8) == "<?php /*")
        {
            $_content = substr($_content, 8, -5);
        }
        return unserialize($_content, ['allowed_classes' => false]);
    }

    /**
     * Apaga as Tabelas, caso existirem.
     *
     *
     * @access  protected
     * @global  array $nm_config Array com configuracao do ScriptCase.
     */
    function DropTables($str_db, $prefix_table = 'sec_', $logged = 'N', $social_login = 'N')
    {
        global $nm_config;

        nm_load_class('interface', 'DbInterface');
        $arr_tables = $this->returnLevelTables($logged, $social_login);
        krsort($arr_tables);

        $previous_error = set_error_handler("nm_faz_nada");

        $prefix_table = nm_decode_utf8_charset($prefix_table, $this->getCharset());

        nm_load_class('interface', 'Group');
        $obj_group = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
        $force_utf8 = ($obj_group->GetData('force_db_utf8') == 'S');

        $conn = $this->obj_con->GetConnection($str_db);
        $nm_db_usu = nm_db_connect($conn, __FILE__, __LINE__, true, "", $force_utf8);
        $str_db_type = nm_db_type($conn['dbms']);
        $arr_tables_fk = array();
        $schema = $str_db_type == 'postgres' && isset($conn['schema']) && !empty($conn['schema']) ? '"'.nm_crypt_decode($conn['schema']).'".' : '';
        if (nm_db_sc_type($str_db_type) == 'mysql' || nm_db_sc_type($str_db_type) == 'postgres' || nm_db_sc_type($str_db_type) == 'interbase') {
            if (isset($_SESSION['nm_session']['cache'][$str_db])) {
                unset($_SESSION['nm_session']['cache'][$str_db]);
            }
            $obj_db_interface = new nmDbInterface($nm_db_usu, $str_db_type, $str_db, $this->obj_con, $this->getCharset());
            $arr_tables_fk = $obj_db_interface->getForeignKeys($str_db, $conn);
        }

        foreach ($arr_tables as $table) {
            if (isset($arr_tables_fk['normal']) && count($arr_tables_fk['normal']) > 0) {
                foreach ($arr_tables_fk['normal'] as $table_fk => $data_fk) {
                    foreach ($data_fk as $fk => $data) {
                        //echo $table_fk . "::". $data[0]['target_table'] ."::" . $prefix_table. $table, "<br/>";
                        if ($data[0]['target_table'] == $prefix_table . $table) {
                            if (nm_db_sc_type($str_db_type) == 'mysql') {
                                $str_sql = "ALTER TABLE " . $table_fk . " DROP FOREIGN KEY " . $fk;
                                $nm_db_usu->Execute($str_sql);
                            } elseif (nm_db_sc_type($str_db_type) == 'postgres') {
                                $str_sql = "ALTER TABLE " . $schema.$table_fk . " DROP CONSTRAINT " . $fk;
                                $nm_db_usu->Execute($str_sql);
                            }
                        }
                    }
                }
            }
            $if_exists = "";
            if($str_db_type == 'mysql') {
                $nm_db_usu->Execute("SET FOREIGN_KEY_CHECKS=0;");
            }else if($str_db_type ==  'sqlite'){
                $if_exists = ' IF EXISTS ';
            }
            $str_sql = "DROP TABLE " . $if_exists . $schema.$prefix_table . ($str_db_type == 'interbase' ? strtoupper($table) : $table);
            $nm_db_usu->Execute($str_sql);
        }
        $nm_db_usu->Close();
        set_error_handler($previous_error);
    }

    /**
     * Cria as tabelas, com o prefixo selecionado
     *
     *
     * @access  protected
     * @global  array $nm_config Array com configuracao do ScriptCase.
     */
    function CreateTables($str_db, $prefix_table = 'sec_', $logged = 'N', $social_login = 'N')
    {
        global $nm_config;

        $arr_tables = $this->returnLevelTables($logged, $social_login);

        $conn = $this->obj_con->GetConnection($str_db);

        nm_load_class('interface', 'Group');
        $obj_group = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
        $force_utf8 = ($obj_group->GetData('force_db_utf8') == 'S');

        $nm_db_usu = nm_db_connect($conn, __FILE__, __LINE__, true, "", $force_utf8);
        $db_type = nm_db_type($conn['dbms']);
        $extra = (nm_db_sc_type($db_type) == 'mysql' && nm_crypt_decode($conn['mysql_encoding']) == 'utf8mb4') ? '_utf8mb4' : '';
        // echo $db_type . '::' . $extra;
        $str_file = $nm_config['path_lib_sql'] . "security/create_" . nm_db_sc_type($db_type) . $extra . ".sql";
        if (!is_file($str_file)) {
            $str_file = $nm_config['path_lib_sql'] . "security/create_default.sql";
        }
        $sql_file = file($str_file);
        $sql_create = array();
        $tabela_key = "nada";
        $schema     = $db_type == 'postgres' && isset($conn['schema']) && !empty($conn['schema']) ? nm_crypt_decode($conn['schema']) : '';
        foreach ($sql_file as $k => $line) {
            if (stripos($line, 'Add table ') !== FALSE) {
                $tabela_key = trim(substr($line, 13, 18));
                $tabela_key = str_replace('"', '', $tabela_key);
                $sql_create[$tabela_key] = "";
            } else {
                /* PHP 8.0 */
                /*                $sql_create[$tabela_key] .= $line; */
                if (isset($sql_create[$tabela_key])) {
                    $sql_create[$tabela_key] .= $line;
                } else {
                    $sql_create[$tabela_key] = $line;
                }
                /*------*/
            }

        }

        //Alter table
        $arr_alter = array();
        $str_file = $nm_config['path_lib_sql'] . "security/alter_" . $db_type . ".sql";
        if (is_file($str_file)) {
            $sql_file = file($str_file);
            $tabela_key = "nada";
            foreach ($sql_file as $k => $line) {
                $line = trim($line);
                if (strpos($line, 'Alter table ') !== FALSE) {
                    $tabela_key = trim(substr($line, 13, 18));
                    $tabela_key = str_replace('"', '', $tabela_key);
                    $arr_alter[$tabela_key] = [];
                } else if (!empty($line)) {
                    $arr_alter[$tabela_key][] = $line;
                }
            }
        }

        $sql_total = "";
        $ret = "";
        $previous_error = set_error_handler("nm_faz_nada");
        $charset = $this->getCharset();
        $arr_err = array();
        foreach ($arr_tables as $table) {
            $ret .= "<b>" . nm_get_text_lang("['creating_tables']") . " " . $schema .' '.$prefix_table . $table . "... </b><br/>";
            $key = ($db_type == 'interbase' ? strtoupper("sec_" . $table) : "sec_" . $table);

            $sql = $sql_create[$key];
            $sql_alter = isset($arr_alter[$key]) ? $arr_alter[$key] : "";

            $arr_replace = array(
                ";" => "",
                ($db_type == 'interbase' ? "SEC_" : "sec_") => ($db_type == 'interbase' ? strtoupper($prefix_table) : $prefix_table)
            );
            if ($db_type == 'postgres') {
                $t = strpos($sql,'sec_') !== false ? 'sec_' : $prefix_table;
                $arr_replace[$t] = "\"{$schema}\".$t";
            }

            $sql = strtr($sql, $arr_replace);

            $sql_total .= $sql;

            $nm_db_usu->Execute(nm_decode_utf8_charset(trim($sql), $charset));
            $erro = $nm_db_usu->ErrorMsg();
            switch ($db_type) {
                case 'mariadb':
                    if (strpos($erro, 'Invalid default value for') !== FALSE ) {
                        $erro = '';
                        $nm_db_usu->Execute(nm_decode_utf8_charset(trim(strtr($sql, [
                            'TIMESTAMP NULL DEFAULT NULL' => 'datetime NOT NULL DEFAULT CURRENT_TIMESTAMP',
                            'TIMESTAMP DEFAULT NULL' => 'datetime NOT NULL DEFAULT CURRENT_TIMESTAMP'])), $charset));
                    }
                    break;
                case 'mssql':
                    if (strpos($erro, ': -28') !== FALSE || trim($erro) == "The active result for the query contains no fields.") {
                        $erro = '';
                    }
                    break;
                case 'oracle':
                    if (strpos($erro, 'ORA-24344:') !== FALSE || strpos($erro, 'ORA-24374:') !== FALSE) {
                        $erro = '';
                    }
                    break;
                case 'informix':
                    if (strpos($erro, '-11031]') !== FALSE) {
                        $erro = '';
                    }
                    break;
                case 'db2':
                    if (strpos($erro, 'CLI0115E') !== FALSE) {
                        $erro = '';
                    }
                    break;
            }

            if (isset($sql_alter) && is_array($sql_alter) && count($sql_alter) > 0) {
                foreach ($sql_alter as $_sql) {
                    $_sql = strtr($_sql, $arr_replace);
                    $sql_total .= $_sql . "\n\n";
                    $nm_db_usu->Execute(nm_decode_utf8_charset(trim($_sql), $charset));
                }
            }

            $ret .= "&nbsp;&nbsp;&nbsp;";
            //mantis 0023964
            if(!empty($erro) && $db_type != 'sqlite'){
                $aux       = conv_utf8_all($erro, $charset);
                $ret      .= $aux;
                $arr_err[] = nm_get_text_lang("['creating_tables']") . " " . $schema.' '.$prefix_table . $table.'<p>'.$aux.'</p>';

            }else{
                $ret .= 'Ok';
            }
            //$ret .= (!empty($erro)) ? conv_utf8_all($erro, $charset) : "Ok";

            $ret .= "<br/><br/>";
        }

        set_error_handler($previous_error);

        $this->SetSessionWithTables($prefix_table, $db_type, $arr_tables, $str_db, $conn);
        $sql_name = $nm_config['path_tmp'] . "sql_security_module_" . md5($sql_total) . ".sql";
        $_SESSION['nm_session']['module_security']['profile']['sql_security_commands'] = $sql_total;
        file_put_contents($sql_name, $sql_total);
        $_SESSION['nm_session']['module_security']['profile']['tabela_seg_create_filename']= $sql_name;
        $sql_name = str_replace($nm_config['path_tmp'], $nm_config['url_tmp'], $sql_name);
        $_SESSION['nm_session']['module_security']['profile']['url_tabela_seg_create_filename']= $sql_name;
        $ret .= "<div id='id_sql_total' style='display:none;'>" . nl2br($sql_total) . "</div>";
        $nm_db_usu->Close();

        nm_load_class('interface', 'Connection');
        $obj_con = nmConnection::singleton($_SESSION['nm_session']['user']['cod_grp']);
        $obj_con->delCache((isset($_POST['tabela_conn']))?$_POST['tabela_conn']:"");

        return  $arr_err;
    }//CreateTables

    /**
     * Carrega a sessao com os valores default de DB.
     *
     *
     * @access  protected
     * @global  array $nm_config Array com configuracao do ScriptCase.
     */
    function SetSessionWithTables($prefix, $type_db, $arr_tables, $str_db, $conn)
    {
        $arr_sess = array();
        if (strpos($prefix, '.') === FALSE) {
            switch ($type_db) {
                case 'mssql':
                    $subtype_db = 'dbo.';
                    break;
                case 'oracle':
                    $subtype_db = (strpos($prefix, '.') === FALSE) ? nm_crypt_decode($conn['user']) . '.' : 'SYSTEM.';
                    break;
                case 'postgres':
                    $subtype_db = strpos($prefix, '.') === false && isset($conn['schema']) && !empty($conn['schema']) ? '"'.nm_crypt_decode($conn['schema']).'".' : 'public.';
                    break;
                default:
                    $subtype_db = '';
                    break;
            }
            $prefix = $subtype_db . $prefix;
        }

        if (in_array('users', $arr_tables)) {
            $arr_sess['usr']['table'] = $prefix . 'users';
            $arr_sess['usr']['login'] = 'login';
            $arr_sess['usr']['pswd'] = 'pswd';
            $arr_sess['usr']['name'] = ($type_db == 'postgres' || $type_db == 'oracle' ? '"name"' : 'name');
            $arr_sess['usr']['email'] = 'email';
            $arr_sess['usr']['active'] = ($type_db == 'interbase' ? '"active"' : 'active');
            $arr_sess['usr']['activation_code'] = 'activation_code';
            $arr_sess['usr']['priv_admin'] = 'priv_admin';
            $arr_sess['usr']['mfa'] = 'mfa';
            $arr_sess['usr']['picture'] = 'picture';
            $arr_sess['usr']['role'] = ($type_db == 'sybase' ? '"role"' : 'role');
            $arr_sess['usr']['phone'] = 'phone';
            $arr_sess['usr']['pswd_last_updated'] = 'pswd_last_updated';
            $arr_sess['usr']['mfa_last_updated'] = 'mfa_last_updated';
        }
        if (in_array('logged', $arr_tables)) {
            $arr_sess['logged']['table'] = $prefix . 'logged';
            $arr_sess['logged']['login'] = 'login';
            $arr_sess['logged']['date_login'] = 'date_login';
            $arr_sess['logged']['sc_session'] = 'sc_session';
            $arr_sess['logged']['ip'] = 'ip';
        }

        if (in_array('apps', $arr_tables)) {
            $arr_sess['app']['table'] = $prefix . 'apps';
            $arr_sess['app']['app_name'] = 'app_name';
            $arr_sess['app']['description'] = 'description';
            $arr_sess['app']['app_type'] = 'app_type';
        }

        if (in_array('groups', $arr_tables)) {
            $arr_sess['grp']['table'] = $prefix . 'groups';
            $arr_sess['grp']['group_id'] = 'group_id';
            $arr_sess['grp']['description'] = 'description';
        }

        if (in_array('users_groups', $arr_tables)) {
            $arr_sess['usr_grp']['table'] = $prefix . 'users_groups';
            $arr_sess['usr_grp']['login'] = 'login';
            $arr_sess['usr_grp']['group_id'] = 'group_id';
        }

        if (in_array('users_social', $arr_tables)) {
            $arr_sess['usr_social']['table'] = $prefix . 'users_social';
            $arr_sess['usr_social']['login'] = 'login';
            $arr_sess['usr_social']['resource'] = ($type_db == 'oracle' ? "oresource" : 'resource');
            $arr_sess['usr_social']['resource_id'] = 'resource_id';
        }

        if (in_array('users_apps', $arr_tables)) {
            $arr_sess['usr_app']['table'] = $prefix . 'users_apps';
            $arr_sess['usr_app']['login'] = 'login';
            $arr_sess['usr_app']['app_name'] = 'app_name';
            $arr_sess['usr_app']['priv_access'] = 'priv_access';
            $arr_sess['usr_app']['priv_insert'] = 'priv_insert';
            $arr_sess['usr_app']['priv_delete'] = 'priv_delete';
            $arr_sess['usr_app']['priv_update'] = 'priv_update';
            $arr_sess['usr_app']['priv_export'] = 'priv_export';
            $arr_sess['usr_app']['priv_print'] = 'priv_print';
        }

        if (in_array('groups_apps', $arr_tables)) {
            $arr_sess['grp_app']['table'] = $prefix . 'groups_apps';
            $arr_sess['grp_app']['group_id'] = 'group_id';
            $arr_sess['grp_app']['app_name'] = 'app_name';
            $arr_sess['grp_app']['priv_access'] = 'priv_access';
            $arr_sess['grp_app']['priv_insert'] = 'priv_insert';
            $arr_sess['grp_app']['priv_delete'] = 'priv_delete';
            $arr_sess['grp_app']['priv_update'] = 'priv_update';
            $arr_sess['grp_app']['priv_export'] = 'priv_export';
            $arr_sess['grp_app']['priv_print'] = 'priv_print';
        }
        if (in_array('settings', $arr_tables)) {
            $arr_sess['settings']['table'] = $prefix . 'settings';
            $arr_sess['settings']['set_name'] = 'set_name';
            $arr_sess['settings']['set_value'] = 'set_value';
        }

        if (!is_array($_SESSION['nm_session']['module_security']['profile'])) {
            $_SESSION['nm_session']['module_security']['profile'] = array();
        }

        if ($type_db == 'oracle') {
            foreach ($arr_sess as $k => $_arr) {
                foreach ($_arr as $k2 => $str) {
                    $arr_sess[$k][$k2] = strtoupper($str);
                }
            }
        }
        //cuuuurto circuuuuuito
        if (!isset($_SESSION['nm_session']['cache'])) {
            $_SESSION['nm_session']['cache'] = array();
            $_SESSION['nm_session']['cache']['tables'] = array();
            $_SESSION['nm_session']['cache']['tables_fields'] = array();
        } else if (!isset($_SESSION['nm_session']['cache']['tables'])) {
            $_SESSION['nm_session']['cache']['tables'] = array();
        }
        if (!isset($_SESSION['nm_session']['cache']['tables_fields'])) {
            $_SESSION['nm_session']['cache']['tables_fields'] = array();
        }

        foreach ($arr_sess as $key => $_arr) {
            foreach ($_arr as $k => $str) {
                $str = ($type_db == 'interbase' ? strtoupper($str) : $str);
                $arr_sess[$key][$k] = $str;
                if ($k == 'table') {
                    $_SESSION['nm_session']['cache']['tables'][$str_db][0][0][''][] = $str;
                    continue;
                }
                $bol_dont_protect = false;
                $_SESSION['nm_session']['cache']['tables_fields'][$str_db][$arr_sess[$key]['table']][$bol_dont_protect][$bol_dont_protect][] = $str;
            }
        }
        $_SESSION['nm_session']['module_security']['profile'] = array_merge($_SESSION['nm_session']['module_security']['profile'], $arr_sess);
    }

    /**
     * Com o botão pressionado, decide qual tela exibir.
     *
     * @param array $arr Variavel contendo POST
     *
     * @access  protected
     */
    function ChangeDisplay($arr)
    {

        global $nm_template, $nm_config;


        $this->GetSteps();
        switch ($arr['action']) {
            case 'back':
                $this->step_now = $this->before;
                break;
            case 'next':
                $this->PutInSession($_POST);
                $this->step_now = $this->after;
                break;
            case 'generate':
                $this->PutInSession($_POST);
                $nm_template->SetVar('arr_session', $this->session_js());
                $tipo_nivel = $_SESSION['nm_session']['module_security']['profile']['tipo_nivel'];
                $nm_template->SetVar('block_image_help', $this->GetImgManual('module_security2_generate_'.$tipo_nivel, NM_HELP_MENU_CONFIG));
                $nm_template->Display("body_security_module_step_generate", 'security_module2');
                nm_print_flush('');
                exit;
                break;
            case 'compile':
                $this->generateCompile();
                exit;
                break;

        }


        $nm_template->SetVar('arr_session', $this->session_js());
        $this->DoSteps();
        include($nm_config['path_lib'] . 'sc_manual.inc.php');

        // $id = ;
        $anchor = $this->step_now . '_' . (isset($_SESSION['nm_session']['module_security']['profile']['tipo_nivel']) ? $_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] : "");
        $anchor .= (isset($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'])
            && $_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'ldap_app'  ? '_total' : '');
        $nm_template->SetVar('block_image_help', $this->GetImgManual('module_security2_' . $anchor, NM_HELP_MENU_CONFIG));

        switch ($this->step_now) {
            case 'carregar':
                unset($_SESSION['nm_session']['module_security']['profile']);
                $nm_template->SetVar('option_profile', $this->LoadOptionProfile(true));
                break;
            case 'tabela':
                $nm_template->SetVar('arr_connections', $this->obj_con->GetAllConnections());
                $nm_template->SetVar('tipo_nivel', $_SESSION['nm_session']['module_security']['profile']['tipo_nivel']);
                $nm_template->SetVar('tipo_nivel_ldap', $_SESSION['nm_session']['module_security']['profile']['tipo_nivel_ldap'] ?? '' );
                break;
            case 'associar':
                $arr_tables = nm_db_tables($_SESSION['nm_session']['module_security']['profile']['tabela_conn'], __FILE__, __LINE__);
                $charset = $this->getCharset();
                foreach ($arr_tables as $k => $v) {
                    $arr_tables[$k] = conv_utf8_all($v, $charset);
                }
                $nm_template->SetVar('arr_tables', array_unique($arr_tables));

                break;
            case 'config' :
                nm_load_class('interface', 'Group');
                $obj_grupo = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
                $arr_schemas = explode(':', $obj_grupo->GetData('schemas'));
                $val_def = $obj_grupo->GetValPadroes($_SESSION['nm_session']['user']['cod_grp']);
                $option = '';
                foreach ($arr_schemas as $schema) {
                    $arr_tmp_list_change = explode('__NM__', $schema);
                    list($mod, $show) = $arr_tmp_list_change;
                    $option .= "<option value='" . $schema . "'";
                    $option .= ($schema == $val_def['def_template'] ? "selected='selected'" : '') . ">" . $show . "</option>";
                }
                $nm_template->SetVar('options_schemas', $option);
                $nm_template->SetVar('count_langs_prj',count(explode(':',$obj_grupo->GetData('locales'))));

                nm_load_class('interface', 'Log');
                $log = nmLog::singleton($_SESSION['nm_session']['user']['cod_grp'], $_SESSION['nm_session']['user']['cod_ver']);
                $arr_schemas = $log->ListSchemas($_SESSION['nm_session']['user']['cod_grp'], $_SESSION['nm_session']['user']['cod_ver']);

                $option = "<option value=''></option>";
                foreach ($arr_schemas as $schema) {
                    $option .= "<option value='" . $schema['Name_Schema'] . "'>" . $schema['Name_Schema'] . "</option>";
                }
                $nm_template->SetVar('options_log', $option);

                nm_load_class('interface', 'Application');
                $obj_app = new nmApplication();
                $datas = $obj_app->GetApplications($_SESSION['nm_session']['user']['cod_grp'], $_SESSION['nm_session']['user']['cod_ver'], array('Cod_Apl', 'Tipo_Apl', 'friendly_name'));
                //$option = "<option value=''></option>";
                $option = "<option value='new_menu'>-- " . nm_get_text_lang("['menu_option']") . " --</option>";
                foreach ($datas as $apl) {
                    if (in_array($apl['Tipo_Apl'], array(NM_APP_TYPE_MENU, NM_APP_TYPE_MENUTREE, NM_APP_TYPE_MENU2)))
                        $option .= "<option value='" . $apl['Cod_Apl'] . "#@#" . $apl['Tipo_Apl'] . "#@#" . $apl['friendly_name'] . "'>" . $apl['Cod_Apl'] . "</option>";
                }
                $nm_template->SetVar('options_menu', $option);


                nm_load_class('interface', 'Group');
                $obj_grp = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
                $grp_apis = $obj_grp->GetData('api');

                $arr_apis = nm_get_arr_api(true);
                $_arr = [];
                $_arr_mail = [];
                if (is_array($arr_apis) && is_array($grp_apis)) {
                    foreach ($arr_apis as $mod => $arr_api) {
                        foreach ($arr_api as $k => $api) {
                            if (!in_array($mod . "__NM__" . $k, $grp_apis) || !in_array($api['type'], ['email', 'sms', 'auth'])) continue;

                            $_arr[$mod][$k] = $api['name'] . ' - ' . $api['gateway'];
                            if ($api['type'] == 'email') {
                                $_arr_mail[$mod][$k] = $api['name'] . ' - ' . $api['gateway'];
                            }
                        }
                    }
                }

                $nm_template->SetVar('options_api', $_arr);
                $nm_template->SetVar('options_smtp_api', $_arr_mail);
                $nm_template->SetVar('str_table', $this->montaTable('Cod_Apl','ASC','checkbox'));

                $output = [];
                if(function_exists("BreakCSS")) {
                    $cssData = file_get_contents($nm_config['path_devel'] . 'generator/nmGen/navMenu/common/themes.css');
                    $arr_css_themes = BreakCSS($cssData);

                    foreach ($arr_css_themes['all'] as $k => $v) {
                        if (strpos($k, 'data-aetheme=') !== false && strpos($k, '@') === false) {
                            $out = preg_replace("/\*\[data\-aetheme\=([A-Za-z0-9\_\-]*)\]/", '$1', $k );
                            if (in_array($out, ['monochromatic-blue','monochromatic-blue-berry','monochromatic-navy','monochromatic-green','monochromatic-lemon','monochromatic-yellow','monochromatic-orange','monochromatic-dark-orange','monochromatic-red','monochromatic-guava','monochromatic-purple','monochromatic-pink','monochromatic-coral','monochromatic-beige','monochromatic-leather','monochromatic-gray','monochromatic-black','navy-energy','organic-nature','tropical','vibrant-modern','autumn-days','tech-future','luxury','midnight'])) {
                                if (!$nm_config['flag_versao']['new_menu_themes']['has']) {
                                    continue;
                                }
                            }
                            $name = ucwords(str_replace('-', ' ', $out));
                            $output[$out] = [
                                'name' => $name,
                                'scope' => 'scriptcase',
                                'p' => $v['--theme-color-primary'],
                                's' => $v['--theme-color-secondary'],
                                'a' => $v['--theme-color-accent'],
                                't' => $v['--theme-color-text'],
                                'm' => $v['--theme-color-muted'],
                                'b' => $v['--theme-box-shadow'],
                                'n' => $v['--theme-alert-color'],
                            ];
                        }
                    }
                }

                nm_load_class('interface', 'NewMenuThemes');
                $themeHandler = new nmNewMenuThemes();
                if ($nm_config['flag_versao']['new_menu_themes']['has']) {
                    $arr_push = $themeHandler->getArrayFromScope($themeHandler::PROJECT_SCOPE, true);
                    $output = array_merge($output, $arr_push);
                    $arr_push = $themeHandler->getArrayFromScope($themeHandler::PUBLIC_SCOPE, true);
                    $output = array_merge($output, $arr_push);
                }

                $nm_template->SetVar('themes_arr', $output);

                break;
            case 'popular_app_perfil':
                if ($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'usr'
                    || ($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'ldap' )) {
                    $k_now = array_search($this->step_now, $this->arr_steps);

                    $this->after = 0;
                    $this->before = 'popular';
                    $this->step_now = 'popular_app_perfil';
                    $nm_template->SetVar('step_now', $this->step_now);
                    $nm_template->SetVar('step_before', $this->before);
                    $nm_template->SetVar('step_after', $this->after);
                    $nm_template->SetVar('content', "body_security_module_step_" . $this->step_now);
                }
                break;
        }

        $nm_template->Display("body_security_module", 'security_module2');
    }//returnLevelTables

    function GetSteps()
    {
        if (!isset($this->step_now) || empty($this->step_now)) {
            $this->step_now = $_POST['step_now'];
            $this->before = $_POST['step_before'];
            $this->after = $_POST['step_after'];
        }
    }//DropTables

    function PutInSession($arr)
    {
        global $obj_lic;
        switch ($arr['step_now']) {
            case 'popular_app_perfil':
                if (!isset($arr['pop_app']['include_apps'])) {
                    $arr['pop_app']['include_apps'] = 'N';
                }
                break;
            case 'popular':
                if (!isset($arr['pop_usr']['active'])) {
                    $arr['pop_usr']['active'] = 'N';
                }
                if (!isset($arr['pop_usr']['priv_admin'])) {
                    $arr['pop_usr']['priv_admin'] = 'N';
                }
                break;
            case 'config':
                $_arr_config = array('usu_carac_letra', 'usu_carac_num', 'usu_carac_accent', 'usu_carac_cedilla', 'usu_carac_space', 'usu_carac_dot', 'usu_carac_comma',
                    'pass_carac_letra', 'pass_carac_num', 'pass_carac_accent', 'pass_carac_cedilla', 'pass_carac_space', 'pass_carac_dot', 'pass_carac_comma');
                foreach ($_arr_config as $chave) {
                    if (!isset($arr['config_login'][$chave])) {
                        $arr['config_login'][$chave] = 'N';
                    }
                }
                if (!isset($arr['config_general']['perm_new_user'])) {
                    $arr['config_general']['perm_new_user'] = 'N';
                }
                if (!isset($arr['pop_app']['include_apps'])) {
                    $arr['pop_app']['include_apps'] = 'N';
                }
                if (!isset($arr['pop_usr']['active'])) {
                    $arr['pop_usr']['active'] = 'N';
                }
                if (!isset($arr['pop_usr']['priv_admin'])) {
                    $arr['pop_usr']['priv_admin'] = 'N';
                }
                break;
            case 'tabela':
                if (!isset($arr['tabela_logged'])) {
                    $arr['tabela_logged'] = 'N';
                }
                if (!isset($arr['tabela_social'])) {
                    $arr['tabela_social'] = 'N';
                }
                break;
        }

        foreach ($arr as $k => $data) {
            if (!in_array($k, array('action', 'step_now', 'step_before', 'step_after', 'option_profile'))) {
                $_SESSION['nm_session']['module_security']['profile'][$k] = $data;
            }
        }
    }//CreateTables

    /**
     * Retorna a sessao para escrever em javascript.
     *
     *
     * @access  protected
     * @global  array $nm_config Array com configuracao do ScriptCase.
     */
    function session_js()
    {
        $session_js = "	var arr_session = new Array();\n";

        if (isset($_SESSION['nm_session']['module_security']['profile']) && is_array($_SESSION['nm_session']['module_security']['profile'])) {
            foreach ($_SESSION['nm_session']['module_security']['profile'] as $k => $arr_data) {
                if($k == 'sql_security_commands') {
                    continue;
                }
                if (!is_array($arr_data)) {
                    $session_js .= "\t arr_session['" . $k . "'] = '" . $arr_data . "';\n";
                } else {
                    foreach ($arr_data as $k2 => $data) {
                        if(!is_array($data)){
                            $session_js .= "\t arr_session['" . $k . "[" . $k2 . "]'] = '" . addslashes($data) . "';\n";
                        }
                    }
                }
            }
        }
        return $session_js;
    }

    function generateCompile()
    {
        echo "<script>var no_change = true;</script>";
        global $nm_config;
        $str_apl_initial = $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . "Login";
        $str_apl_initial_type = NM_APP_TYPE_CONTROL;
        $str_apl_initial_cod_grp = $_SESSION['nm_session']['user']['cod_grp'];
        $str_apl_initial_versao = $_SESSION['nm_session']['user']['cod_ver'];
        $nm_list_app_compile = $_SESSION['nm_session']['arr_apps'];

        include_once($nm_config['path_iface'] . "generate_code.php");
    }//load_variable_replace

    function DoSteps()
    {
        global $nm_template;
        $this->GetSteps();

        $k_now = array_search($this->step_now, $this->arr_steps);

        $this->after = ($k_now + 1);
        $this->before = ($k_now - 1);

        $this->after = (array_key_exists($this->after, $this->arr_steps)) ? $this->arr_steps[$this->after] : 0;
        $this->before = (array_key_exists($this->before, $this->arr_steps)) ? $this->arr_steps[$this->before] : 0;

        $nm_template->SetVar('step_now', $this->step_now);
        $nm_template->SetVar('step_before', $this->before);
        $nm_template->SetVar('step_after', $this->after);
        if($this->step_now == 'config'){
            $arr_config_tam                 = [];
            $arr_config_tam['usu_tam_min']  = (isset($_SESSION['nm_session']['module_security']['profile']['config_login']['usu_tam_min']) ? $_SESSION['nm_session']['module_security']['profile']['config_login']['usu_tam_min'] : 5);
            $arr_config_tam['usu_tam_max']  = (isset($_SESSION['nm_session']['module_security']['profile']['config_login']['usu_tam_max']) ? $_SESSION['nm_session']['module_security']['profile']['config_login']['usu_tam_max'] : 255);
            $arr_config_tam['pass_tam_min'] = (isset($_SESSION['nm_session']['module_security']['profile']['config_login']['pass_tam_min']) ? $_SESSION['nm_session']['module_security']['profile']['config_login']['pass_tam_min'] : 5);
            $arr_config_tam['pass_tam_max'] = (isset($_SESSION['nm_session']['module_security']['profile']['config_login']['pass_tam_max']) ? $_SESSION['nm_session']['module_security']['profile']['config_login']['pass_tam_max'] : 255);
            $nm_template->SetVar('config_tam',$arr_config_tam);
            $nm_template->SetVar('content_config_initial_data', "body_security_module_step_popular");
            $nm_template->SetVar('content_config_add_apss', "body_security_module_step_popular_app_perfil");
            $nm_template->SetVar('content_config_save_profile', "body_security_module_step_save_profile");
        }
        $nm_template->SetVar('content', "body_security_module_step_" . $this->step_now);

    }

    function LoadOptionProfile($arr = false)
    {
        global $nm_config;
        $arr_paths = array('scriptcase' => $nm_config['path_scriptcase'] . 'securitymodule/',
            'sys' => $nm_config['path_sys'] . 'securitymodule/',
            'grp' => $nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . '/securitymodule/',
            'usr' => $nm_config['path_usr'] . $_SESSION['nm_session']['user']['login'] . '/securitymodule/'
        );
        $html_select_option = "";
        $arr_non_files = array('.', '..', 'index.html');
        $arr_return = array();
        foreach ($arr_paths as $k => $path) {

            if (!is_dir($path)) continue;
            $files = array_diff(scandir($path), $arr_non_files);
            if (count($files) == 0) continue;
            if(!isset($arr_return[$k])) {
                $arr_return[$k] = array();
            }
            $html_select_option .= "<optgroup label='" . nm_get_text_lang("['mod_" . $k . "']") . "'>";
            foreach ($files as $file) {
                $_content = file_get_contents($path . '/'.$file);
                if(substr($_content, 0, 8) == "<?php /*")
                {
                    $_content = substr($_content, 8, -5);
                }
                $data = unserialize($_content, ['allowed_classes' => false]);
                if(!is_array($data)) continue;
                $arr_return[$k][$file] = ['profile' => $data['perfil_save_name'], 'tipo_nivel' => $data['tipo_nivel'] ?? '', 'tipo_nivel_ldap' => $data['tipo_nivel_ldap'] ?? ''];
                $html_select_option .= "<option value='" . $k . "#@NM@#" . $file . "'>" . substr($file, 0, -3) . "</option>";
            }
            $html_select_option .= "</optgroup>";
        }
        return $arr ? $arr_return : $html_select_option;
    }//maior_id

    /**
     * Define funcoes Javascript da pagina.
     *
     * Define a lista de funcoes Javascript especificos da pagina atual.
     *
     * @access  protected
     */
    function PageJavascript()
    {
        global $nm_config, $obj_lic;

        $lang1 = nm_get_text_lang("['prefix_incorrect']");
        $lang2 = nm_get_text_lang("['folder_incorrect']");
        $lang3 = nm_get_text_lang("['profile_incorrect']");
        $lang4 = nm_get_text_lang("['recaptcha_secret_key']['empty']");
        $lang5 = nm_get_text_lang("['recaptcha_site_key']['empty']");
        $lang6 = nm_get_text_lang("['pop_usr_length']['error']");
        $lang7 = nm_get_text_lang("['pop_pswd_length']['error']");
        $url_img = $nm_config['url_scriptcase_img'];
        $pop_message = nm_get_text_lang("['pop']['message']");
        $ldap_title = nm_get_text_lang("['ldap']['title']");
        $grp_title = nm_get_text_lang("['grp']['title']");
        $app_title = nm_get_text_lang("['app']['title']");
        $usr_title = nm_get_text_lang("['usr']['title']");
        $str_msg_ldap = nm_get_text_lang("['ldap_message_ok']");
        $str_lang_min_max = nm_get_text_lang("['tam_min_max']");
        $str_js = "var nm_select_conn = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_select_conn']"))) . "'; \n";
        $str_js .= "var nm_app_exist = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_app_exist']"))) . "'; \n";
        $str_js .= "var nm_field_unselected = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_field_unselected']"))) . "'; \n";
        $str_js .= "var nm_table_exist = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_tables_exist']"))) . "'; \n";
        $str_js .= "var nm_empty_perfil = '" . (html_entity_decode(nm_get_text_lang("['js_empty_perfil']"))) . "'; \n";
        $str_js .= "var nm_confirm_no_clicked = '" . addslashes(html_entity_decode(nm_get_text_lang("['aba_no_clicked']"))) . "'; \n";
        $str_js .= "var nm_prefix_error = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_prefix_table']"))) . "'; \n";
        $str_js .= "var nm_lang_2fa_empty = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_2fa_required']"))) . "'; \n";
        $str_js .= "var nm_lang_smtp_api_empty = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_smtp_api_required']"))) . "'; \n";
        $str_js .= "var nm_lang_social_link_empty = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_social_link_required']"))) . "'; \n";
        $str_js .= "var nm_lang_social_empty = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_social_empty']"))) . "'; \n";
        $arr_manual_links = [
            'usr' => $this->GetManual('module_security_tipo_usr', NM_HELP_MENU_CONFIG),
            'app' => $this->GetManual('module_security_tipo_app', NM_HELP_MENU_CONFIG),
            'grp' => $this->GetManual('module_security_tipo_grp', NM_HELP_MENU_CONFIG),
            'ldap' => $this->GetManual('module_security_tipo_ldap', NM_HELP_MENU_CONFIG),
            'ldap_app' => $this->GetManual('module_security_tipo_ldap_total', NM_HELP_MENU_CONFIG),
        ];
        $str_js .= "var arr_help_links =". json_encode($arr_manual_links)."; \n";
        $tipo_nivel = isset($_SESSION['nm_session']['module_security']['profile']['tipo_nivel']) ? $_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] : '';

        $arr_manual_links_tabs_config = [
            'general_'.$tipo_nivel               => $this->GetManual('module_security2_config_general_'.$tipo_nivel,NM_HELP_MENU_CONFIG),
            'login_'.$tipo_nivel                 => $this->GetManual('module_security2_config_login_'.$tipo_nivel,NM_HELP_MENU_CONFIG),
            'config_email_'.$tipo_nivel          => $this->GetManual('module_security2_config_email_'.$tipo_nivel,NM_HELP_MENU_CONFIG),
            'users_'.$tipo_nivel                 => $this->GetManual('module_security2_config_users_'.$tipo_nivel,NM_HELP_MENU_CONFIG),
            'config_2fa_'.$tipo_nivel            => $this->GetManual('module_security2_config_2fa_'.$tipo_nivel,NM_HELP_MENU_CONFIG),
            'config_social_'.$tipo_nivel         => $this->GetManual('module_security2_config_social_'.$tipo_nivel,NM_HELP_MENU_CONFIG),
            'config_logged_user_'.$tipo_nivel    => $this->GetManual('module_security2_config_logged_user_'.$tipo_nivel,NM_HELP_MENU_CONFIG),
            'config_initial_data_'.$tipo_nivel   => $this->GetManual('module_security2_config_initial_data_'.$tipo_nivel,NM_HELP_MENU_CONFIG),
            'config_add_apps_'.$tipo_nivel       => $this->GetManual('module_security2_config_add_apps_'.$tipo_nivel,NM_HELP_MENU_CONFIG),
            'config_ldap_'.$tipo_nivel           => $this->GetManual('module_security2_config_ldap_'.$tipo_nivel,NM_HELP_MENU_CONFIG),
        ];
        $str_js .= "var arr_help_links_config_tabs = ".json_encode($arr_manual_links_tabs_config)."; \n";
        $str_js .= "var nm_message_apps_need_save_to_close = '".nm_get_text_lang("['warning_apps_need_save_to_close']")."'; \n";
        $str_js .= "var nm_message_apps_opened = '".nm_get_text_lang("['warning_apps_opened']")."' \n";
        $str_js .= "var nm_btn_label_no = '".nm_get_text_lang("['option_no']")."'; \n";
        $str_js .= "var nm_btn_label_close = '".nm_get_text_lang("['btn_close']")."'; \n";

        $str_js .= <<<JS

            function nm_reload_apis(type, dest, with_custom = 0)
                {

                    if(dest == null){
                        return;
                    }
                    if(type == null || type == ''){
                        document.getElementById(dest).innerHTML = '';
                        return;
                    }
                    $.ajax({
                            type: 'POST',
                            async: true,
                            url: nm_url_iface + 'security_module2.php',
                            data: 'nm_ajax=1&nm_option=reload_api&type='+type + '&with_custom=' + with_custom,
                            success: function(html_retorno)
                            {
                                    var valor_default = $('#'+dest).val();
                                    document.getElementById(dest).innerHTML = html_retorno;
                                    $('#'+ dest).val( valor_default );
                            }
                        });
            }

            function nm_change_captcha(valor)
            {
                if(valor == 'recaptchav3' && '{$nm_config['flag_versao']['ssh_connection']['has']}' != '1'){
                    nmFrmScaseRunFunc('noPermission');
                    $('#id_fld_use_captcha').dropdown('set selected', 'N');
                    return;
                }
                if(valor == 'recaptcha' || valor == 'recaptchav3')
                {
                    $('#id_recaptcha_site_key').removeClass('disabled');
                    $('#id_recaptcha_secret_key').removeClass('disabled');
                    $("input[name='config_general[recaptcha_site_key]']").attr('required','required');
                    $("input[name='config_general[recaptcha_secret_key]']").attr('required','required');
                    if($("input[name='config_general[recaptcha_site_key]']").val() == ''){
                        $("#nm_hidden_error_rec_site_key").removeClass('nm_help_hidden');
                    }else{
                        $("#nm_hidden_error_rec_site_key").addClass('nm_help_hidden');
                    }
                    if($("input[name='config_general[recaptcha_secret_key]']").val() == ''){
                        $("#nm_hidden_error_rec_sec_key").removeClass('nm_help_hidden');
                    }else{
                        $("#nm_hidden_error_rec_sec_key").addClass('nm_help_hidden');
                    }
                }
                else
                {
                    $('#id_recaptcha_site_key').addClass('disabled');
                    $('#id_recaptcha_secret_key').addClass('disabled');
                    $("input[name='config_general[recaptcha_site_key]']").removeAttr('required');
                    $("input[name='config_general[recaptcha_secret_key]']").removeAttr('required');
                    $("#nm_hidden_error_rec_sec_key").addClass('nm_help_hidden');
                    $("#nm_hidden_error_rec_site_key").addClass('nm_help_hidden');
                }
            }
            
            function reload_libs()
            {
                $.ajax({
						type: 'POST',
						url:  nm_url_iface+ 'security_module2.php',
						data: 'nm_ajax=1&nm_option=getLibs',
						success: function(retorno)
						{
						    $('#id_config_login_template').html(retorno);
						}
					   });
            }

			function ajaxGetFields(table, content)
			{
                regex = /(.*)\[(.*)\]/
				$.ajax({
						type: 'POST',
						url:  nm_url_iface+ 'security_module2.php',
						data: 'nm_ajax=1&nm_option=getfields&nm_table_usu='+table,
						success: function(retorno)
						{
							$("[data-tab="+ content +"] .select_fields option").remove();
							$("[data-tab="+ content +"] .select_fields").dropdown('clear');
                            $("[data-tab="+ content +"] .select_fields select").append(retorno).each(function()
							{
								var str_name = $(this).attr('name');

								if(arr_session)
								{
									if(arr_session[str_name] != undefined)
									{
										$(this).val(arr_session[str_name]);
									}else{
                                        setTimeout(function(){
                                            str_field = regex.exec(str_name);
                                            $('select[name="' + str_name + '"]').dropdown('refresh')
                                            .dropdown('set selected',
                                                $('select[name="' + str_name + '"] > option:contains('+ str_field[2] +')').val() ??
                                                $('select[name="' + str_name + '"] > option:contains('+ str_field[2] +')').val()
                                            );
                                        },500);
									}
								}
							});
                            
						}
				});
			}



		function call_in_associar(){
			$('#abas >li > a').click(function(){
				$('#usr').hide();
				$('#app').hide();
				$('#grp').hide();
				$('#usr_app').hide();
				$('#grp_app').hide();
				$('#usr_grp').hide();
				$('#logged').hide();
				$('#social').hide();
				$('#usr_social').hide();
				$('#settings').hide();
				$($(this).attr('href')).show();
				$('#abas > li').each(function(){
					$(this).removeClass('aba_selected');
				});

				$($(this).attr('href') + '_aba ').addClass('aba_selected');
				return false;
			});
			$('#abas >li').click(function(){
				$('#'+ $(this).attr('id') + ' > a').click();
			});
			switch('{$tipo_nivel}')
			{
		/* usr, app, grp, usr_grp, usr_app, grp_app*/
				case 'usr':
					$('#grp_aba').remove();
					$('#app_aba').remove();
					$('#usr_grp_aba').remove();
					$('#usr_app_aba').remove();
					$('#grp_app_aba').remove();
					$('#grp').remove();
					$('#app').remove();
					$('#usr_grp').remove();
					$('#usr_app').remove();
					$('#grp_app').remove();
				break;
				case 'grp':
					$('#usr_app_aba').remove();
					$('#usr_app').remove();
				break;
				case 'ldap':
				case 'app':
					$('#grp_app_aba').remove();
					$('#usr_grp_aba').remove();
					$('#grp_aba').remove();
					$('#grp').remove();
					$('#usr_grp').remove();
					$('#grp_app').remove();
				break;
			}
		}

		function disable_fields()
		{
			$('.select_fields').attr('disabled', 'disabled');
			$('.select_tables').attr('disabled', 'disabled');
		}

		function disable_button(but)
		{
			// $('#id_button_'+but).addClass('nmButtonDisabled');
			$('#id_button_'+but).attr('disabled', 'disabled');
		}

		function enable_button(but)
		{
			// $('#id_button_'+but).removeClass('nmButtonDisabled');
			$('#id_button_'+but).removeAttr('disabled').removeClass('disabled').removeClass('hidden').show();
		}

        function nm_display_menu(content)
		{
            $("input[name='pop_usr[login]']").removeAttr('required');
            $("input[name='pop_usr[login]']").removeAttr('pattern');
            $("input[name='pop_usr[login]']").removeAttr('minlength');
            $("input[name='pop_usr[login]']").removeAttr('maxlength');
            $("input[name='pop_usr[pswd]']").removeAttr('required');
            $("input[name='pop_usr[pswd]']").removeAttr('pattern');
            $("input[name='pop_usr[pswd]']").removeAttr('minlength');
            $("input[name='pop_usr[pswd]']").removeAttr('maxlength');
            $("input[name='config_general[recaptcha_secret_key]']").removeAttr('required');
            $("input[name='config_general[recaptcha_site_key]']").removeAttr('required');
            $("input[name='step_before']").val(content);
            $("input[name='step_now']").val(content);
			$('#id_button_back').attr('disabled', false);
			$("#id_button_back").click();
		}

        function nm_display_alert(str_lang,str_tipo,lang_ok,lang_cancel){
            if(typeof(str_tipo) == 'undefined'){
                $('#modal-info-message .ui.cancel.button').hide();
            }
            if(typeof(lang_ok) != 'undefined'){
                $('#modal-info-message .ui.primary.button').html(lang_ok);
            }
            if(typeof(lang_cancel) != 'undefined'){
               $('#modal-info-message .ui.cancel.button').html(lang_cancel);
            }
            $('#modal-info-span-description').html(str_lang);
            $('#modal-info-message .ui.primary.button').on('click',function(){
                $('#modal-info-message').modal('hide');
            });
            $('#modal-info-message').modal('show');
        }
        function nm_config_min_max_pattern(){
            var usu_tam_min_js  = parseInt($("#id_login_usu_tam_min").val());
            var usu_tam_max_js  = parseInt($("#id_login_usu_tam_max").val());
            var pass_tam_min_js = parseInt($("#id_login_pass_tam_min").val());
            var pass_tam_max_js = parseInt($("#id_login_pass_tam_max").val());

            if(usu_tam_min_js <= usu_tam_max_js ){
                $("input[name='pop_usr[login]']").attr('minlength',usu_tam_min_js);
            }
            if(usu_tam_max_js >= usu_tam_min_js){
                $("input[name='pop_usr[login]']").attr('maxlength',usu_tam_max_js);
            }

            if(usu_tam_max_js >= usu_tam_min_js && usu_tam_min_js <= usu_tam_max_js){
                $("input[name='pop_usr[login]']").attr('pattern','.{'+usu_tam_min_js+','+usu_tam_max_js+'}');
            }

            if(pass_tam_min_js <= pass_tam_max_js ){
                $("input[name='pop_usr[pswd]']").attr('minlength',pass_tam_min_js);
            }
            if(pass_tam_max_js >= pass_tam_min_js){
                $("input[name='pop_usr[pswd]']").attr('maxlength',pass_tam_max_js);
            }

            if(pass_tam_max_js >= pass_tam_min_js && pass_tam_min_js <= pass_tam_max_js){
                $("input[name='pop_usr[pswd]']").attr('pattern','.{'+pass_tam_min_js+','+pass_tam_max_js+'}');
            }
        }

        function nm_check_length_pop_data(obj,str_name){
            var min     = parseInt($(obj).attr('minlength'));
            var max     = parseInt($(obj).attr('maxlength'));
            var field   = parseInt($(obj).val().length);
            if(field < min){
                $("#"+str_name).removeClass('nm_help_hidden');
            }else if(field > max){
                $("#"+str_name).removeClass('nm_help_hidden');
            }else{
                $("#"+str_name).addClass('nm_help_hidden');
            }
        }

        function nm_check_name_perfil(){
            var response = 'ok';
            var param = {
                'p'        : $("select[name='perfil_data_mod']").val(),
                'n'        : $("input[name='perfil_save_name']").val(),
                'nm_ajax'  : 1,
                'nm_option': 'verify_profile_name'
            };
            $.ajax({
            	type: 'POST',
            	url:  nm_url_iface + 'security_module2.php',
            	data: param,
            	async: false,
            	cache: false,
            	success: function(retorno)
            	{
                    if(retorno != 'ok'){
                        $("#nm_help_error_perfil_name").html(retorno);
                        $("#nm_help_error_perfil_name").removeClass('nm_help_hidden');
                        response = 'error';
                    }else{
                        $("#nm_help_error_perfil_name").addClass('nm_help_hidden');
                        response =  'ok';
                    }
            	}
            });

            return response;
        }

        function nm_check_save_perfil(){
                var input_perfil_name = $("input[name='perfil_save_name']");
                if($('#id_perfil_save_perfil').is(':checked')){
                    $(input_perfil_name).removeAttr('disabled');
                    if($(input_perfil_name).val() == ''){
                        $(".ui.fluid.dropdown.perfil").addClass('disabled');
                        $("#nm_help_error_perfil_name").html(nm_empty_perfil);
                        $("#nm_help_error_perfil_name").removeClass('nm_help_hidden');
                        $("#modal-save-perfil .ui.primary.approve.button").addClass('disabled');
                        $("#modal-save-perfil .ui.primary.approve.button").attr('disabled','disabled');
                    }else{
                        $(".ui.fluid.dropdown.perfil").removeClass('disabled');
                        $("#nm_help_error_perfil_name").addClass('nm_help_hidden');
                        $("#modal-save-perfil .ui.primary.approve.button").removeClass('disabled');
                        $("#modal-save-perfil .ui.primary.approve.button").removeAttr('disabled');
                    }
                }else{
                   $(".ui.fluid.dropdown.perfil").addClass('disabled');
                   $(input_perfil_name).attr('disabled','disabled');
                   $("#modal-save-perfil .ui.primary.approve.button").removeClass('disabled');
                   $("#modal-save-perfil .ui.primary.approve.button").removeAttr('disabled'); 
                }
                $('#id_perfil_save_perfil').on('click',function(){
                        var input_perfil_name = $("input[name='perfil_save_name']");
                        if($(this).is(':checked')){
                            $(input_perfil_name).removeAttr('disabled');
                            if($(input_perfil_name).val() == ''){
                                $(".ui.fluid.dropdown.perfil").addClass('disabled');
                                $("#nm_help_error_perfil_name").html(nm_empty_perfil);
                                $("#nm_help_error_perfil_name").removeClass('nm_help_hidden');
                                $("#modal-save-perfil .ui.primary.approve.button").addClass('disabled');
                                $("#modal-save-perfil .ui.primary.approve.button").attr('disabled','disabled');
                            }else{
                                $(".ui.fluid.dropdown.perfil").removeClass('disabled');
                                $("#nm_help_error_perfil_name").addClass('nm_help_hidden');
                                $("#modal-save-perfil .ui.primary.approve.button").removeClass('disabled');
                                $("#modal-save-perfil .ui.primary.approve.button").removeAttr('disabled');
                            }
                        }else{
                            $(".ui.fluid.dropdown.perfil.selection.disabled").addClass('disabled');
                            $("#nm_help_error_perfil_name").addClass('nm_help_hidden');
                            $(input_perfil_name).attr('disabled','disabled');
                            $("#modal-save-perfil .ui.primary.approve.button").removeClass('disabled');
                            $("#modal-save-perfil .ui.primary.approve.button").removeAttr('disabled');
                        }
                    });
                $(input_perfil_name).on('input',function(){
                    if($(this).val() == '' || !correct_prefix($(this).val()) && $('#id_perfil_save_perfil').is(':checked')){
                        $(".ui.fluid.dropdown.perfil").addClass('disabled');
                        $("#nm_help_error_perfil_name").html('{$lang3}');
                        $("#nm_help_error_perfil_name").removeClass('nm_help_hidden');
                        $("#modal-save-perfil .ui.primary.approve.button").addClass('disabled');
                        $("#modal-save-perfil .ui.primary.approve.button").attr('disabled','disabled');
                    }else{
                        $(".ui.fluid.dropdown.perfil").removeClass('disabled');
                        $("#nm_help_error_perfil_name").addClass('nm_help_hidden');
                        $("#modal-save-perfil .ui.primary.approve.button").removeClass('disabled');
                        $("#modal-save-perfil .ui.primary.approve.button").removeAttr('disabled');
                    }
                });
        }
        function nm_open_warning_apps_opened(){
            var param = {
                'nm_ajax'     : 1,
                'nm_option'   : 'get_app_tabs'
            };
            $.ajax({
                type: 'POST',
                url:  nm_url_iface + 'security_module2.php',
                data: param,
                async: false,
                cache: false,
                success: function(response)
                {
                    arrResponse = JSON.parse(response);
                    if(arrResponse.length === 0){
                        nm_open_save_perfil();
                    }else{
                        $('#modal-warning-apps-opened').modal({
                            onShow: function () {
                                let isChanged = false;
                                for (let i = arrResponse.length - 1; i >= 0; i--) {
                                    let objMainFrame = parent.document.querySelector('iframe[name="nmFrmBot'+arrResponse[i]+'"]');
                                    if(objMainFrame){
                                        let objInnerFrame = objMainFrame.contentWindow.document.querySelector('iframe[name="nmFrmRight_'+arrResponse[i]+'"]');
                                        if(objInnerFrame){
                                            let inputTarget = objInnerFrame.contentWindow.document.querySelector('input[name="form_modified"]');
                                            if(inputTarget){
                                                if(inputTarget.value == 'Y'){
                                                    $('#modal-warning-apps-opened #btn-approve').hide();
                                                    $('#modal-warning-apps-opened #btn-cancel').html(nm_btn_label_close);
                                                    $('#modal-warning-apps-opened #modal-warning-apps-opened-span-description').html(nm_message_apps_need_save_to_close);
                                                    isChanged = true;
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                }
                                if(!isChanged){
                                    $('#modal-warning-apps-opened #btn-approve').show();
                                    $('#modal-warning-apps-opened #btn-cancel').html(nm_btn_label_no);
                                    $('#modal-warning-apps-opened #modal-warning-apps-opened-span-description').html(nm_message_apps_opened);
                                }
                            },
                            onApprove : function(){
                                for (let i = arrResponse.length - 1; i >= 0; i--) {
                                    if($(parent.document.getElementById('sys_aba_page_'+arrResponse[i])).is(':visible')){
                                        parent.ajax_get_close_app(arrResponse[i], false);
                                    }
                                }
                                nm_open_save_perfil();
                            }
                        });
                        $("#modal-warning-apps-opened").modal('show');
                    }
                }
            });
        }
        function nm_open_save_perfil(){
            $('#modal-save-perfil').modal({
                onVisible : function(){
                    nm_check_save_perfil();
                },
            	onApprove : function(){
                    if($("#2fa_option").val() == '0' || $("#2fa_option").val() == 0){
                        $("#2fa_option").val('');
                    }

                    if($("#id_pop_usr_include_apps").is(':checked')){
                        $("#id_pop_usr_select_include_apps").val('N');
                        if($("input[name='pop_app[selected_apps][]']")){
                        	$("input[name='pop_app[selected_apps][]']").remove();
                        }
                    }else if($("#id_pop_usr_select_include_apps").is(':checked')){
                        $("#id_pop_usr_include_apps").val('N');
                    }else{
                        $("#id_pop_usr_select_include_apps").val('N');
                        $("#id_pop_usr_include_apps").val('N');
                        if($("input[name='pop_app[selected_apps][]']")){
                        	$("input[name='pop_app[selected_apps][]']").remove();
                        }
                    }
                    if($('#id_perfil_save_perfil').is(':checked')){
                            if($('input[name=perfil_save_name]').val() == ''){
                                $("#nm_help_error_perfil_name").html(nm_empty_perfil);
                                $("#nm_help_error_perfil_name").removeClass('nm_help_hidden');
                        		$('input[name=perfil_save_name]').focus();
                                return false;
                            }else if(!correct_prefix($('input[name=perfil_save_name]').val())){
                                $("#nm_help_error_perfil_name").html('{$lang3}');
                                $("#nm_help_error_perfil_name").removeClass('nm_help_hidden');
                        		$('input[name=perfil_save_name]').focus();
                                return false;
                            }else{
                                if(nm_check_name_perfil() == 'error'){
                                    return false;
                                }
                            }
                        var html_salva_perfil = '<input type="hidden" value="'+$("input[name='perfil_save_perfil']").val()+'" name="perfil_save_perfil" >';
                        html_salva_perfil    += '<input type="hidden" value="'+$("input[name='perfil_save_name']").val()+'" name="perfil_save_name" >';
                        html_salva_perfil    += '<input type="hidden" value="'+$("select[name='perfil_data_mod']").val()+'" name="perfil_data_mod">';
                        $("#form_security").append(html_salva_perfil);
                    }
                    $('#id_action_form').val('generate');
                    $('#form_security').submit();
            	}
            });
            $("#modal-save-perfil").modal('show');
        }
        function nm_show_include_apps(){
            $('#modal_show_inlude_app').modal({
                closable: true,
                blurring: true,
                onApprove: function(){
                    if($("input[name='pop_app[selected_apps][]']")){
                        $("input[name='pop_app[selected_apps][]']").remove();
                    }
                    var html_salva_perfil = '';
                    var arr_options = [];
                    var i = 0;
                    $("input[name='field_app']").each(function(){
                        if($(this).is(':checked')){
                            arr_options[i] = $(this).val();
                            html_salva_perfil = html_salva_perfil + '<input type="hidden" value="'+arr_options[i]+'" name="pop_app[selected_apps][]" >';
                            i++;
                        }
                    });
                    if(arr_options.length > 0){
                        nm_add_app_session(arr_options,html_salva_perfil);
                        nm_show_selected_apps(arr_options);
                    }else{
                        $("#table_selected_apps").hide();
                    }
                },
            }).modal('show');
        }
        function nm_add_app_session(str_param,str_html){
            var param = {
                'data'        : str_param,
                'nm_ajax'     : 1,
                'nm_option'   : 'add_app_session'
            };
            $.ajax({
                type: 'POST',
                url:  nm_url_iface + 'security_module2.php',
                data: param,
                async: false,
                cache: false,
                success: function(retorno)
                {
                    if(retorno != 'ok'){
                        nm_display_alert(retorno);
                    }else{
                        $("#form_security").append(str_html);
                    }
                }
            });
        }

        function nm_show_selected_apps(str_param){
            var param = {
                'data'        : str_param,
                'nm_ajax'     : 1,
                'nm_option'   : 'get_selected_apps'
            };
            $.ajax({
                type: 'POST',
                url:  nm_url_iface + 'security_module2.php',
                data: param,
                async: false,
                cache: false,
                success: function(retorno)
                {
                    if(retorno != ''){
                         $("#table_selected_apps").html(retorno);
                         $("#table_selected_apps").show();
                    }else{
                         $("#table_selected_apps").hide();
                    }
                }
            });
        }

        function nm_navigate_back(str_tipo){
            if(typeof(str_tipo) == 'undefined'){
                str_tipo = 'back';
            }
            if($("select[name='tabela_conn']").length){
                $("select[name='tabela_conn']").removeAttr('required');
            }
            nm_open_load();
            $('#id_action_form').val(str_tipo);
        }

        function nm_check_login_template(str_obj){
            if(str_obj.is(':checked')){
                securityLib('enable');
                $("#id_config_login_template").removeAttr('disabled');
                $("#id_config_login_template").removeClass('disabled');
                $("#id_config_login_template_div div").eq(0).removeClass('disabled');
                $("#id_config_login_template_div a div").removeClass('disabled');
                $("#id_config_login_template_div a").eq(0).attr('href','javascript:reload_libs()');
                $("#id_config_login_template_div a").eq(1).attr('href',"javascript:parent.nm_exec_menu('libraries')");
            }else{
                securityLib('disable');
                $("#id_config_login_template").attr('disabled','disabled');
                $("#id_config_login_template_div div").eq(0).addClass('disabled');
                $("#id_config_login_template").addClass('disabled');
                $("#id_config_login_template_div a div").addClass('disabled');
                $("#id_config_login_template_div a").removeAttr('href');
            }
        }

        function securityLib(str_opt){
            $.ajax({
				type: 'POST',
				url:  nm_url_iface+ 'security_module2.php',
				data: 'nm_ajax=1&nm_option=seclib&option='+str_opt,
				success: function(retorno)
				{
                    reload_libs();
				}
		   });
        }

		$(document).ready(function()
		{
            if(arr_session){
                if(typeof(arr_session['tabela_seg']) != 'undefined'){
                    if(arr_session['tabela_seg'] == 'create'){
                        $("#menu_item_associar").removeAttr('onclick');
                        $("#menu_item_associar").attr('disabled', 'disabled');
                        $("#menu_item_associar").addClass('disabled');
                    }
                }
            }
            if($("input[name=step_now]").val() == 'tipo' || $("input[name=step_now]").val() == 'popular_app_perfil'){
                $("#id_button_next").hide();
            }
            $("#2fa_option").change(function(){
                nm_reload_apis($(this).val(), '2fa_api');
            });

            $('.ui.radio.checkbox').checkbox();
            $('.dropdown').dropdown();
            $('.menu .item').tab();
		    

			var after_menu = 0;
			$(".span_menu").each(function()
			{
				if(after_menu == 1)
				{
					$(this).css('color', '#DEDEDE');
					$('#td_'+ $(this).attr('id')).attr('onclick', '');
					$('#td_'+ $(this).attr('id')).css('cursor', 'auto');
				}
				if($('input[name=step_now]').val() == $(this).attr('id') )
				{
					after_menu = 1;
				}
			});

			$("#img_"+$('input[name=step_now]').val()).show();

			function nm_display(content)
			{
				$("input[name=step_after]").val(content);
                $("input[name=step_before]").val($("#menu_item_"+content).prev('a').attr('id').replace(/menu_item_/g, ""));
				$('#id_button_next').attr('disabled', false);
				$("#id_button_next").click();
			}


			/*
			if(typeof(no_change) == 'undefined' && $('input[name=step_now]').val() != 'associar')
			{
				change_of_session();
			}
			*/
			switch($('input[name=step_now]').val())
			{
				case 'associar':
					call_in_associar();
					change_of_session();
					if(!one_empty && $('#tabela_seg').val() == 'create')
					{
						disable_fields();
					}
					else
					{
						$('.select_fields').attr('disabled', false);
						$('.select_tables').attr('disabled', false);
					}

					$('#id_button_next').click(function(){
					var retorno = true;
					var campo = '';
						$('select').each(function(k,v){
							if($(v).val() == '')
							{
								retorno = false;
								campo = $(v);
								return false;
							}
						});
						if(retorno == false)
						{
							nm_display_alert(nm_field_unselected);
							return false;
						}
						nm_open_load();
					});
					setTimeout(function(){

						if($("select[name='usr[active]']").val() == '')
						{
							$('.select_fields').attr('disabled', false);
							$('.select_tables').attr('disabled', false);
						}
					}, 1000);
				break;

				case 'carregar':
					disable_button('back');
					$('#id_button_next').click(function(){
						nm_open_load();
					});
				break;

				case 'tipo':
					$('#id_button_next').click(function(){
						nm_open_load();
					});
					$('input[name=tipo_nivel]').click(function()
					{
						nm_change_description(this.value);
                       
                        var tmp_link_manual = '';
                        if( $(this).val() == 'ldap' || $(this).val() == 'ldap_app')
                        {
                            $("#id_table_ldap_childs").show();
                           eval("tmp_link_manual = arr_help_links."+ $('input[name=tipo_nivel_ldap]').val());
                        }
                        else{
                            $("#id_table_ldap_childs").hide();
                            eval("tmp_link_manual = arr_help_links."+ $(this).val());
                        }
                        $('.help-image-link').attr('onclick', "javascript:nm_window_manual('"+tmp_link_manual+"');return false; ")
                        
					});
                    
                    $('input[name=tipo_nivel_ldap]').click(function()
					{
                        var tmp_link_manual = '';
                        eval("tmp_link_manual = arr_help_links."+ $(this).val());
                        $('.help-image-link').attr('onclick', "javascript:nm_window_manual('"+tmp_link_manual+"');return false; ")
                        
					});
				break;
				case 'config':
                    $(".ui.top.attached.tabular.menu a").click(function(){
                        var data_tab_val = $(this).attr('data-tab');
                        if(data_tab_val == '2fa'){
                            data_tab_val = 'config_'+data_tab_val+'_{$tipo_nivel}';
                        }else{
                            data_tab_val = data_tab_val+'_{$tipo_nivel}';
                        }
                        var tmp_link_help = '';
                        eval("tmp_link_help = arr_help_links_config_tabs."+data_tab_val);
                        $('.help-image-link').attr('onclick', "javascript:nm_window_manual('"+tmp_link_help+"');return false; ");
                    });
                    nm_check_login_template($("input[name='config_login[use_login_template]']"));
                    if($("#id_pop_usr_include_apps").is(':checked')){
                        $("#table_selected_apps").hide();
                        $("#id_pop_usr_select_include_apps").prop('checked',false);
                        $("#id_btn_select_include_apps").addClass('disabled');
                    }else if($("#id_pop_usr_select_include_apps").is(':checked')){
                        $("#id_pop_usr_include_apps").prop('checked',false);
                        $("#id_btn_select_include_apps").removeClass('disabled');
                        $("#table_selected_apps").show();
                    }
                    $("#id_pop_usr_include_apps").click(function(){
                        $("#id_pop_usr_select_include_apps").prop('checked',false);
                        $("#id_btn_select_include_apps").addClass('disabled');
                        $("#table_selected_apps").hide();
                    });
                    $("#id_pop_usr_select_include_apps").click(function(){
                        if($(this).is(':checked')){
                            $("#id_btn_select_include_apps").removeClass('disabled');
                            $("#table_selected_apps").show();
                        }else{
                            $("#id_btn_select_include_apps").addClass('disabled');
                            $("#table_selected_apps").hide();
                        }
                        $("#id_pop_usr_include_apps").prop('checked',false);
                    });

                    $("#id_button_next").hide();
                    $("#id_button_back").hide();
					$('.img_help').click(function(e){
						nm_show_help(this,e);
						setTimeout(nm_close_help, 1500);
					});
					$('.img_help').mouseover(function(e){
						nm_show_help(this, e);
					});
					$('.img_help').mouseout(function(){nm_close_help();});

                    if('{$tipo_nivel}' != 'ldap' && '{$tipo_nivel}' != 'ldap_app')
                    {
                        $('#config_ldap').remove();
                        $('#config_ldap_aba').remove();
                    }
                    
					$('#id_folder_security').change(function(){
						if(!correct_prefix($(this).val()))
						{
							nm_display_alert('{$lang2}');
							$(this).focus();
							return false;
						}
					});
                    $('input[name="config_general[smtp_api_custom]"]').on('click', function(){
                        if($(this).is(':checked')){
                            $('.table_custom_smtp').removeClass('disabled');
                            $('#id_combobox_smtp_api').addClass('disabled');
                        }else{
                            $('.table_custom_smtp').addClass('disabled');
                            $('#id_combobox_smtp_api').removeClass('disabled');
                        }
                    });
                    $('#smtp_api').on('change', (function(){
                        $('.table_custom_smtp').addClass('disabled');

						if($(this).val() == 'custom'){
                            $('.table_custom_smtp').removeClass('disabled');
                        }
                        i_control = true;
					}));
					$('#id_prefix_app').change(function(){
						if(!correct_prefix($(this).val()))
						{
                            $("a[data-tab=general]").click(); 
							nm_display_alert('{$lang1}');
                            $('#id_prefix_app').focus();
							return false;
						}
					});

                    $("input[name='config_general[recaptcha_secret_key]']").on('input',function(){
                        if($("#id_fld_use_captcha").val() == 'recaptcha' || $("#id_fld_use_captcha").val() == 'recaptchav3'){
                            if($(this).val() == ''){
                                $("#nm_hidden_error_rec_sec_key").removeClass('nm_help_hidden');
                            }else{
                                $("#nm_hidden_error_rec_sec_key").addClass('nm_help_hidden');
                            }
                        }else{
                            $("#nm_hidden_error_rec_sec_key").addClass('nm_help_hidden');
                        }
                    });
                    
                    $("input[name='config_general[recaptcha_site_key]']").on('input',function(){
                        if($("#id_fld_use_captcha").val() == 'recaptcha' || $("#id_fld_use_captcha").val() == 'recaptchav3'){
                            if($(this).val() == ''){
                                $("#nm_hidden_error_rec_site_key").removeClass('nm_help_hidden');
                            }else{
                                $("#nm_hidden_error_rec_site_key").addClass('nm_help_hidden');
                            }
                        }else{
                            $("#nm_hidden_error_rec_site_key").addClass('nm_help_hidden');
                        }
                    });
					$('#id_button_gen').click(function(){
						if(!correct_prefix($('#id_prefix_app').val()))
						{
                            $("a[data-tab=general]").click(); 
							nm_display_alert('{$lang1}');
                            $('#id_prefix_app').focus();
							return false;
						}
						if(!correct_prefix($('#id_folder_security').val()))
						{
                            $("a[data-tab=general]").click(); 
                            nm_display_alert('{$lang2}');
							$('#id_folder_security').focus();
							return false;
						}
						if(!min_max_usu())
						{
						    return false;
						}
						if(!min_max_pass())
						{
						    return false;
						}
						verify_apps($('#id_prefix_app').val());
						if($('#id_hid_has_app').val() == 'tem')
						{
                            $("a[data-tab=general]").click();
                            nm_display_alert(nm_app_exist);
						 	$('#id_prefix_app').focus();
						 	return false;
						 }

                        if($("a[data-tab=config_email]").length != 0 && ($('#smtp_api').val() == '' || $('#smtp_api').val() == null)){
                            nm_display_alert(nm_lang_smtp_api_empty);
                            $('#config_email_aba').trigger('click');
                            $('#smtp_api').focus();
                            return false;
                        }
                        if($("a[data-tab=config_email]").length != 0 && $('#smtp_api').val() == 'custom'){
                            var valid = true ;
                            $('.config_email_custom').each(function(i,t){
                                if(valid 
                                   && ( $(t).attr('name') != 'config_email[smtp_security]' 
                                   && $(t).attr('name')   != 'config_email[smtp_name]' 
                                   && $(t).attr('name')   != 'config_email[smtp_user]' 
                                   && $(t).attr('name')   != 'config_email[smtp_pass]' ) 
                                ){
                                    valid = $(t).val() != '';
                                    if(valid == false){
                                        $('#config_email_aba').trigger('click');
                                        $(t).focus();
                                    }
                                }
                            });
                            if(!valid){
                                $("a[data-tab=config_email]").click();
                                nm_display_alert(nm_lang_smtp_api_empty);
                                return false;
                            }
                        }
                        if($("a[data-tab=config_social]").length  != 0 ){
                            if(($('.socialSelect:checked').length == 0 || $('.socialSelect:checked').val() == null )){
                                nm_display_alert(nm_lang_social_link_empty);
                                $("a[data-tab=config_social]").click();
                                return false;
                            }
                            if($('#id_social_facebook').is(':checked') && ($("#id_fld_facebook_app_id").val() == '' || $("#id_fld_facebook_app_id").val() == '')){
                                nm_display_alert(nm_lang_social_empty);
                                $("a[data-tab=config_social]").click();
                                return false;
                            }
                            if($('#id_social_google').is(':checked') && ($("#id_fld_google_client_id").val() == '' || $("#id_fld_google_secret").val() == '')){
                                nm_display_alert(nm_lang_social_empty);
                                $("a[data-tab=config_social]").click();
                                return false;
                            }
                            if($('#id_social_twitter').is(':checked') && ($("#id_fld_twitter_key").val() == '' || $("#id_fld_twitter_secret").val() == '')){
                                nm_display_alert(nm_lang_social_empty);
                                $("a[data-tab=config_social]").click();
                                return false;
                            }
                        }

                        if($("[data-tab='2fa']").length != 0 && ($('#2fa_option').val() != '' && $('#2fa_option').val() != '0') && ($('#2fa_api').val() == '' || $('#2fa_api').val() == null)){
                            nm_display_alert(nm_lang_2fa_empty);
                            $("a[data-tab=2fa]").click();
                            $('#2fa_api').focus();
                            return false;
                        }

                        if($("#id_fld_use_captcha").val() == 'recaptcha' || $("#id_fld_use_captcha").val() == 'recaptchav3'){
                            if($("input[name='config_general[recaptcha_secret_key]']").val() == ''){
                                if($("input[name='config_general[recaptcha_site_key]']").val() == ''){
                                    $("#nm_hidden_error_rec_site_key").removeClass('nm_help_hidden');
                                }else{
                                    $("#nm_hidden_error_rec_site_key").addClass('nm_help_hidden');
                                }
                                $("#nm_hidden_error_rec_sec_key").removeClass('nm_help_hidden');
                                nm_display_alert('{$lang4}');
                                $("a[data-tab=login]").click();
                                return false;
                            } else if($("input[name='config_general[recaptcha_site_key]']").val() == ''){
                                if($("input[name='config_general[recaptcha_secret_key]']").val() == ''){
                                    $("#nm_hidden_error_rec_sec_key").removeClass('nm_help_hidden');
                                }else{
                                    $("#nm_hidden_error_rec_sec_key").addClass('nm_help_hidden');
                                }
                                $("#nm_hidden_error_rec_site_key").removeClass('nm_help_hidden');
                                nm_display_alert('{$lang5}');
                                $("a[data-tab=login]").click();
                                return false;
                            }
                            
                        }
                        if( $("input[name='pop_usr[login]']").val().length < $("input[name='pop_usr[login]']").attr('minlength') || 
                            $("input[name='pop_usr[login]']").val().length > $("input[name='pop_usr[login]']").attr('maxlength')){
                            $("#nm_hidden_error_pop_usr_login").removeClass('nm_help_hidden');
                            nm_display_alert('{$lang6}');
                            $("a[data-tab=config_initial_data]").click();
                            return false;
                        }else{
                            $("#nm_hidden_error_pop_usr_login").addClass('nm_help_hidden');
                        }
                        if( $("input[name='pop_usr[pswd]']").val().length < $("input[name='pop_usr[pswd]']").attr('minlength') || 
                            $("input[name='pop_usr[pswd]']").val().length > $("input[name='pop_usr[pswd]']").attr('maxlength')){
                            $("#nm_hidden_error_pop_usr_pswd").removeClass('nm_help_hidden');
                            nm_display_alert('{$lang7}');
                            $("a[data-tab=config_initial_data]").click();
                            return false;
                        }else{
                            $("#nm_hidden_error_pop_usr_pswd").addClass('nm_help_hidden');
                        }

						var no_clicked = false;
						var aba_no_clicked;
						$(".ui.top.attached.tabular.menu a").each(function(k,v)
						{
							if(!no_clicked && !$(v).hasClass('aba_clicked'))
							{
								no_clicked = true;
								aba_no_clicked = $(v);
							}
						});
                        var tipo_nivel = '{$tipo_nivel}';
                        if( $('#id_action_form').val() == 'next' && ( tipo_nivel == 'ldap' || tipo_nivel == 'ldap_app' ) && false == nm_ldap_test())
					    {
					         e.preventDefault();
					         return false;
					    }
						if(no_clicked)
						{
                            $("#modal-all-tabs-click-span-description").text(nm_confirm_no_clicked);
                            $('#modal-all-tabs-click').modal({
                                onCancel : function(){
                                    aba_no_clicked.click();
                                    return false;
                                },
                                onApprove: function (){
                                    nm_open_warning_apps_opened();
                                }
                            });
							$('#modal-all-tabs-click').modal('show');
						}else{
                            nm_open_warning_apps_opened();
                        }
					});

                    var tipo_nivel = '{$tipo_nivel}';
					switch(tipo_nivel)
					{
						case 'usr':
							$('#id_tr_grp').remove();
							$('#id_tr_app').remove();
						break;
						case 'app':
							$('#id_tr_grp').remove();
						break;
                        case 'ldap_app':
                            $('#id_tr_ldap_test').show();
		                    $('#id_btn_ldap_test').click(function()
		                    {
                                nm_open_load();
                                setTimeout(() => {
    		                        if(nm_ldap_test())
    		                        {
                                        if( $("input[name='config_general[ldap_server]']").val() == '' || 
                                            $("input[name='config_general[ldap_dn]']").val()     == '' ||
                                            $("input[name='config_general[ldap_port]']").val()   == '' )
                                        {
                                            $("a[data-tab=config_ldap]").click(); 
                                        }else{
                                           $("a[data-tab=config_initial_data]").click();  
                                        }
    		                            nm_display_alert("{$str_msg_ldap}");
    		                        }
                                    $.unblockUI();
                                 }, "1000");
		                    });
                        break;
						case 'ldap':
						    $('#id_tr_grp').remove();
		                    $('#id_tr_ldap_test').show();
		                    $('#id_btn_ldap_test').click(function()
		                    {
                                nm_open_load();
                                setTimeout(() => {
    		                        if(nm_ldap_test())
    		                        {
                                        if( $("input[name='config_general[ldap_server]']").val() == '' || 
                                            $("input[name='config_general[ldap_dn]']").val()     == '' ||
                                            $("input[name='config_general[ldap_port]']").val()   == '' )
                                        {
                                            $("a[data-tab=config_ldap]").click(); 
                                        }else{
                                           $("a[data-tab=config_initial_data]").click();  
                                        }
    		                            nm_display_alert("{$str_msg_ldap}");
    		                        }
                                    $.unblockUI();
                                }, "1000");
		                    });
						break;
					}
                    $("form").submit(function(e){
					    if( $('#id_action_form').val() == 'next' && ( tipo_nivel == 'ldap' || tipo_nivel == 'ldap_app' ) && false == nm_ldap_test())
					    {
					         e.preventDefault();
					         return false;
					    }
                        if($('#modal-save-perfil').is(':hidden')){
                            nm_open_load();
                        }
					});
                    if(arr_session['pop_app[include_apps]'] == 'N')
					{
						$("#id_pop_usr_include_apps").removeAttr('checked');
					}else{
                        $("#id_pop_usr_select_include_apps").prop('checked',false);
                        $("#id_btn_select_include_apps").addClass('disabled');
                    }
                    $('input[name=perfil_save_name]').on('input',function()
					{
						if(!correct_prefix($(this).val()))
						{
                            $("#nm_help_error_perfil_name").html('{$lang3}');
							$("#nm_help_error_perfil_name").removeClass('nm_help_hidden');
							$(this).focus();
							return false;
						}else{
                            $("#nm_help_error_perfil_name").addClass('nm_help_hidden');
                        }
					});
                    if($('#id_perfil_save_perfil').is(':checked'))
					{
						show_save_perfil();
					}
                    nm_config_min_max_pattern();
                    $('.ui.top.attached.tabular.menu .item').click(function(){
                        var config_data_tab_attr = $(this).attr('data-tab');
                        $(this).addClass('aba_clicked');
                        if( config_data_tab_attr == 'config_initial_data'){
                            nm_config_min_max_pattern();
                            nm_check_length_pop_data($("input[name='pop_usr[login]']"),'nm_hidden_error_pop_usr_login');
                            nm_check_length_pop_data($("input[name='pop_usr[pswd]']"),'nm_hidden_error_pop_usr_pswd');
                            $("input[name='pop_usr[login]']").on('input',function(){
                                nm_check_length_pop_data($(this),'nm_hidden_error_pop_usr_login');
                            });
                            $("input[name='pop_usr[pswd]']").on('input',function(){
                                nm_check_length_pop_data($(this),'nm_hidden_error_pop_usr_pswd');
                            });
                        }else if(config_data_tab_attr == 'login'){
                            $("#id_login_usu_tam_min").on('input', function() {
                                nm_config_min_max_pattern();
                            });
                            $("#id_login_usu_tam_max").on('input', function() {
                                nm_config_min_max_pattern();
                            });
                            $("#id_login_pass_tam_min").on('input', function() {
                                nm_config_min_max_pattern();
                            });
                            $("#id_login_pass_tam_max").on('input', function() {
                                nm_config_min_max_pattern();
                            });
                        }
                    });
                    enable_button('gen');
					disable_button('next');
				break;
				case 'tabela':
                    disable_button('next');
                    if($("select[name='tabela_conn']").val() == ''){
                        $("#tabela_conn_refresh").removeAttr('href');
                        $("#tabela_conn_refresh").attr('disabled','disabled');
                        $("#tabela_conn_refresh div").addClass('disabled');
                    }else{
                        $("#tabela_conn_refresh").attr('href','javascript: refreshTables();');
                        $("#tabela_conn_refresh").removeAttr('disabled');
                        $("#tabela_conn_refresh div").removeClass('disabled');
                    }
					$('#id_button_next').on('click', function(){

                        if(!correct_prefix( $("input[name='tabela_seg_prefix']").val() )){
                            nm_display_alert(nm_prefix_error);
                            return false;
                        }

						if($('#id_select_conn option:selected').val() == '')
						{
							nm_display_alert(nm_select_conn);
							return false;
						}

						bol_verify = verify_tables($('#id_select_conn option:selected').val(), $('#id_tabela_seg_prefix').val());
						if( nm_ldap_auth == 'falso'
							&& $('#id_tabela_seg_create').is(':checked')
							&& !$('input[name=tabela_drop_tables]').is(':checked')
							&& bol_verify
							&& !confirm(nm_table_exist)
						  )
						{
							$('input[name=tabela_drop_tables]').focus();
							return false;
						}
						nm_open_load();
					});
                    
				break;
				case 'popular':
				    var tipo_nivel = '{$tipo_nivel}';
					switch(tipo_nivel)
					{
						case 'usr':
							$('#id_tr_grp').remove();
							$('#id_tr_app').remove();
						break;
						case 'app':
							$('#id_tr_grp').remove();
						break;
                        case 'ldap_app':
                            $('#id_tr_grp').remove();
		                    $('#id_tr_ldap_test').show();
		                    $('#id_btn_ldap_test').click(function()
		                    {
		                        if(nm_ldap_test())
		                        {
                                    if( $("input[name='config_general[ldap_server]']").val() == '' || 
                                        $("input[name='config_general[ldap_dn]']").val()     == '' ||
                                        $("input[name='config_general[ldap_port]']").val()   == '' )
                                    {
                                        $("a[data-tab=config_ldap]").click(); 
                                    }else{
                                       $("a[data-tab=config_initial_data]").click();  
                                    }
		                            nm_display_alert("{$str_msg_ldap}");
		                        }
		                    });
						break;
						case 'ldap':
						    $('#id_tr_grp').remove();
		                    $('#id_tr_ldap_test').show();
		                    $('#id_btn_ldap_test').click(function()
		                    {
		                        if(nm_ldap_test())
		                        {
                                    if( $("input[name='config_general[ldap_server]']").val() == '' || 
                                        $("input[name='config_general[ldap_dn]']").val()     == '' ||
                                        $("input[name='config_general[ldap_port]']").val()   == '' )
                                    {
                                        $("a[data-tab=config_ldap]").click(); 
                                    }else{
                                       $("a[data-tab=config_initial_data]").click();  
                                    }
		                            nm_display_alert("{$str_msg_ldap}");
		                        }
		                    });
						break;
					}
                    $("form").submit(function(e){
					    if( $('#id_action_form').val() == 'next' && ( tipo_nivel == 'ldap' || tipo_nivel == 'ldap_app' ) && false == nm_ldap_test())
					    {
					         e.preventDefault();
					         return false;
					    }
						nm_open_load();
					});
				break;
				case 'popular_app_perfil':
					// $('#id_button_next').click(function(){
					// 	nm_open_load();
					// });
					if(arr_session['pop_app[include_apps]'] == 'N')
					{
						$("#id_pop_usr_include_apps").removeAttr('checked');
					}else{
                        $("#id_pop_usr_select_include_apps").prop('checked',false);
                        $("#id_btn_select_include_apps").addClass('disabled');
                    }
                    
                    enable_button('gen');
					disable_button('next');
					$('input[name=perfil_save_name]').change(function()
					{
						if(!correct_prefix($(this).val()))
						{
                            $("#nm_help_error_perfil_name").html('{$lang3}');
                            $("#nm_help_error_perfil_name").removeClass('nm_help_hidden');
							$(this).focus();
							return false;
						}else{
                            $("#nm_help_error_perfil_name").addClass('nm_help_hidden');
                        }
					});

					if($('#id_perfil_save_perfil').is(':checked'))
					{
						show_save_perfil();
					}
				break;
				default:
				break;
			}
            change_of_session();
            
            const togglePassword1 = document.querySelector('#togglePassword');
            const password1 = document.querySelector('#id_config_email_smtp_pass');
            try{
                togglePassword1.addEventListener('click', function (e) {
                    const type = password1.getAttribute('type') === 'password' ? 'text' : 'password';
                    password1.setAttribute('type', type);
                    this.classList.toggle('fa-eye-slash');
                });
            }catch(e){}
		});

        function nm_ldap_test()
        {
            var param = {
                        'ldap_server' : $("input[name='config_general[ldap_server]']").val(),
                        'ldap_dn'	  : $("input[name='config_general[ldap_dn]']").val(),
                        'ldap_suffix' : $("input[name='config_general[ldap_suffix]']").val(),
                        'ldap_login'  : $("input[name='pop_usr[login]']").val(),
                        'ldap_pswd'   : $("input[name='pop_usr[pswd]']").val(),
                        'ldap_port'   : $("input[name='config_general[ldap_port]']").val(),
                        'nm_ajax'     : 1,
                        'nm_option'   : 'ldap_test'
                        };
            var retornoFora = false;
            $.ajax({
					type: 'POST',
					url:  nm_url_iface + 'security_module2.php',
					data: param,
					async: false,
					cache: false,
					success: function(retorno)
					{
					    if(retorno != 'ok')
					    {
                            if( $("input[name='config_general[ldap_server]']").val() == '' || 
                                $("input[name='config_general[ldap_dn]']").val()     == '' ||
                                $("input[name='config_general[ldap_port]']").val()   == '' )
                            {
                                $("a[data-tab=config_ldap]").click(); 
                            }else{
                               $("a[data-tab=config_initial_data]").click();  
                            }
					        nm_display_alert(retorno);
					        retornoFora = false;
					    }
					    else
					    {
					       retornoFora = true;
					    }

					}
				});

    			return retornoFora;
            }
		
			var one_empty = false;
			function change_of_session(){
			$("input").each(function()
			{
				switch($(this).attr('type'))
				{
					case 'radio':
						var str_name = $(this).attr('name');
						if(arr_session)
						{
							if(arr_session[str_name] != undefined)
							{
								if($(this).val() == arr_session[str_name])
								{
									$(this).attr('checked', true);
									$(this).click()
									$(this).trigger('click');
                                    $(this).trigger('change');
                                    if(str_name == 'tipo_nivel' && ( $(this).val() == 'ldap' || $(this).val() == 'ldap_app' ) )
                                    {
                                        $("#id_table_ldap_childs"). show();
                                    }
                                    else if(str_name == 'tipo_nivel')
                                    {
                                        $("#id_table_ldap_childs"). hide();
                                    }
								}
							}
						}
					break;
					case 'checkbox':
						var str_name = $(this).attr('name');
						if(arr_session)
						{
							if(arr_session[str_name] != undefined )
							{

								if( arr_session[str_name] == $(this).val())
								{
								    if($(this).val() != 'facebook' && $(this).val() != 'google' && $(this).val() != 'twitter')
								    {
									    $(this).click();
									}
									$(this).click();
									$(this).prop('checked','checked');

								}
								else
								{
									$(this).removeAttr('checked');
								}
							}
						}
					break;
					default:
						var str_name = $(this).attr('name');
						if(arr_session)
						{
							if(arr_session[str_name] != undefined)
							{
								$(this).val(arr_session[str_name]);
								$(this).change();
								$(this).trigger('change');;
							}
						}
					break;
				}
				if(!one_empty && $(this).val() == '')
				{
						one_empty = true;
				}
			});

		 $("select").each(function()
			{
				var str_name = $(this).attr('name');
				if(arr_session)
				{
					if(arr_session[str_name] != undefined)
					{
						$(this).val(arr_session[str_name]);
						if( $(this).val() == '' || $("select[name='"+ str_name +"']").val() == '')
						{
							one_empty = true;
						}
					}
				}
					$(this).trigger('change');;
			});
		}


		function nm_change_description(tipo)
		{
			$("#id_td_description > div").hide();
			$("#id_div_"+tipo).show();
		}

		function nm_show_hide_tr(id)
		{
			if($('#'+id).is(':hidden'))
			{
				$('#'+id).show();
				$('#img_'+id).attr('src', "{$url_img}img_contract.png");
			}
			else
			{
				$('#'+id).hide();
				$('#img_'+id).attr('src',"{$url_img}img_expand.png");
			}
		}

		function show_profiles(valor)
		{
			if(valor == 'use')
			{
				$("select[name=option_profile]").show();
				return;
			}
			$("select[name=option_profile]").hide();
		}


		function nm_config_help()
		{
			$('.img_help').click(function(e){
				nm_show_help(this,e);
				setTimeout(nm_close_help, 1500);
			});
			$('.img_help').mouseover(function(e){
				nm_show_help(this, e);
			});
			$('.img_help').mouseout(function(){nm_close_help();});
		}


			function nm_show_help(t,e)
			{
				var id = $(t).attr('id');
				id = id.replace('img', 'desc');

				xcurs = e.pageX + 30;
				ycurs = e.pageY - 10;
				$('#id_description_help').css('top', ycurs+'px');
				$('#id_description_help').css('left', xcurs+'px');
				$('#id_description_help > span').html( $('#'+id).html());
				$('#id_description_help').show();
			}


		function nm_close_help()
		{
			$('#id_description_help').hide();
		}


		function see_sql_local(id)
		{
			if($('#'+id).is(':visible'))
			{
				$('#'+id).hide();
				return;
			}
			$('#'+id).show(1000);
		}


			function show_sql()
			{
				if($('#id_sql_total').is(':visible'))
				{
					$('#id_sql_total').hide();
				}
				else
				{
					$('#id_sql_total').show();
				}
			}


			function nm_select_crypt(valor)
			{
				if(valor != '')
				{
					$('#id_ret_pass_send_mail').attr('disabled', 'disabled');
					$('#id_ret_pass_send_mail_desc').css('color', '#CECECE');
					$('#id_criptografia_chave').removeAttr('disabled');
					if( $('#id_ret_pass_send_mail').is(':checked'))
					{
						$('#id_ret_pass_send_mail_reset').attr('checked', true);
					}
					return;
				}

				$('#id_criptografia_chave').attr('disabled', 'disabled');
				$('#id_ret_pass_send_mail_desc').css('color', '#000');
				$('#id_ret_pass_send_mail').attr('disabled', false);

			}


		function nm_save_ajax()
		{
			var param = 'nm_ajax=1&nm_option=populate';
			$('input[name^=pop_]').each(function(k,v)
			{
				switch($(v).attr('type'))
				{
					case 'checkbox':
						if( $(v).is(':checked'))
							param += '&'+$(v).attr('name') +'='+ $(v).val();
					break;
					default:
						param += '&'+$(v).attr('name') +'='+ $(v).val();
					break;
				}
			});
			$('select[name^=pop_]').each(function(k,v)
			{
				$('option',v).each(function(k1,v1){
						param += '&'+$(v).attr('name') + '='+$(v1).val();
					});
		//		param += '&'+$(v).attr('name') + '='+$('option',v).val();
			});

			$.ajax({
					type: 'POST',
					url:  nm_url_iface + 'security_module2.php',
					data: param,
					success: function(retorno)

					{
						if(retorno == 'ok')
						{
							showMsg('{$pop_message}');
							$('input[name^=pop_'+type+']').each(function(k,v)
							{
								switch($(v).attr('type'))
								{
									case 'checkbox':
										$(v).attr('checked', false);
									break;
									default:
										$(v).val('');
									break;
								}
							});
							$('select[name^=pop_'+type+']').each(function(k,v)
							{
								$(v).val($('option:first',v).val());
							});
						}
						else
						{
							showMsg(retorno);
						}


					} //fim do success
			});
		}


	function showMsg(msg)
	{
		$('#id_msg_div_content').html(msg);
		$('#id_msg_div').show();
	}

	function compile_applications(cod_grp, versao, ver_dve)
	{
		parent.$('.nmProjectInfo').hide();
		parent.nm_app_data(cod_grp, '', '', '', '', '', '', '', '', versao, ver_dve);
		parent.nm_close_all_abas_app();

		parent.form_wiz.field_group.value = cod_grp;
		parent.form_wiz.field_ver.value = versao;
		parent.form_wiz.field_dve.value = ver_dve;

		parent.form_wiz.execute_apl_initial_cod_grp.value = cod_grp;
		parent.form_wiz.execute_apl_initial_versao.value = versao;
		parent.form_wiz.submit();
		parent.show_prj_bar();
	}

		function verify_tables(conn, prefix)
		{
			var ret = false;
			$.ajax({
				type: 'POST',
				url:  '{$nm_config['url_iface']}security_module2.php',
				async: false,
				data: 'nm_ajax=1&nm_option=verify_tables&conn='+conn + '&prefix='+prefix,
				success: function(retorno)
				{
					if(retorno == 'tem')
						ret = true;
					else
						ret = false;
				}
			});
			return ret;
		}

			function verify_apps(prefix)
			{
				$.ajax({
					type: 'POST',
					async: false,
					url:  '{$nm_config['url_iface']}security_module2.php',
					data: 'nm_ajax=1&nm_option=verify_apps&prefix='+prefix,
					success: function(retorno)
					{
						$('#id_hid_has_app').val(retorno);
					}
				});

			}

			function nm_open_load()
			{
				//$('#id_loading').toggleClass('loading-visible');
				$.blockUI({
					message: $('#id_loading').html(),
					css: {
						top: '90px',
						position:'fixed'
						}
				});
			}

			function show_save_perfil()
			{
				if($('#id_perfil_save_perfil').is(':checked'))
				{
					$(".perfil").removeAttr('disabled');
				}
				else
					$(".perfil").attr('disabled', 'disabled');
			}

			function generate_step(step)
			{
				$.ajax({
					type: 'POST',
					url:  '{$nm_config['url_iface']}security_module2.php',
					cache: false,
					data: 'nm_ajax=1&nm_option=generate&step='+step,
					success: function(retorno)
					{
						if(retorno == '')
						{
							$("#id_msgs_step"+step).show();
							$("#id_msgs_step"+(step+1)).show();
							$("#id_msgs_step"+step+"_img").attr("src", "{$nm_config['url_img']}ok.png");
							step = (step + 1);
							if(step == 4)
							{
								steps = true;
							}
							else
								generate_step((step));
						}
						else
							$('body').html(retorno);
					}
				});

			}

			function nm_verify_steps()
			{
				if(step4 && steps)
				{
					$("#id_msgs_step4_img").attr("src", "{$nm_config['url_img']}ok.png");
					$("#id_btns_ok").show();
				}
				else
					setTimeout(nm_verify_steps, 500);
			}

		function nm_check_connection(valor)
		{
            $('#tabela_conn').addClass('loading');
            if(valor == ''){ return;}
            disable_button('next');
            $("#tabela_conn_refresh").removeAttr('href');
            $("#tabela_conn_refresh").attr('disabled','disabled');
            $("#tabela_conn_refresh div").addClass('disabled');
            $('#img_loading_conn').show();
			$.ajax({
					type: 'POST',
					url:  '{$nm_config['url_iface']}admin_sys_allconections_test.php',
					cache: false,
					data: 'nm_ajax=1&nm_option=checkConnection&str_conn='+valor,
					success: function(retorno)
					{
                        $('#img_loading_conn').hide();
						if(retorno != '')
						{
							$('#tab_conn_erro').show();
							$('#id_select_conn').val('');
                            disable_button('next');
                            $("#tabela_conn_refresh").removeAttr('href');
                            $("#tabela_conn_refresh").attr('disabled','disabled');
                            $("#tabela_conn_refresh div").addClass('disabled');
							//$('#id_select_conn').change();
						}
						else{
							$('#tab_conn_erro').hide();
                            enable_button('next');
                            $("#tabela_conn_refresh").attr('href','javascript: refreshTables();');
                            $("#tabela_conn_refresh").removeAttr('disabled');
                            $("#tabela_conn_refresh div").removeClass('disabled');
                        }
					}
				});
		}

		function correct_prefix(prefix)
		{
            if(typeof(prefix) !== 'undefined'){
    			if('' != prefix.replace(/[a-z0-9_]+/i, "") || /^[0-9]/i.test(prefix))
    			{
    				return false;
    			}
            }
    		return true;
		}


		function nm_can_disable(valor)
		{
		    if(valor == '')
		    {
		        $('.can_disabled').hide();
		    }
		    else if(nm_ldap_auth == 'falso' )
		    {
		        $('.can_disabled').show();
		    }
		}

		function min_max_usu()
		{
		    if(parseInt($('#id_login_usu_tam_min').val()) > parseInt($('#id_login_usu_tam_max').val()))
		    {
		        nm_display_alert("{$str_lang_min_max}");
		        $('#login_aba').click();
		        $('#id_login_usu_tam_min').focus();
		        return false;
		    }
		    return true;
		}
		function min_max_pass()
		{
		    if(parseInt($('#id_login_pass_tam_min').val()) > parseInt($('#id_login_pass_tam_max').val()))
		    {
		        nm_display_alert("{$str_lang_min_max}");
		        $('#login_aba').click();
		        $('#id_login_pass_tam_min').focus();
		        return false;
		    }
		    return true;
		}

        function socialConfig(t)
        {
            if($(t).is(':checked'))
            {
                $("input[name^='config_general[" + $(t).val() + "'").removeAttr('disabled');
            }
            else
            {
                $("input[name^='config_general[" + $(t).val() + "'").attr('disabled', 'disabled');
            }
        }
JS;
        $this->AddJavascript($str_js);


        $str_js  = " var arr_order_apl  = 'ASC';\n";
        $str_js .= " var arr_order_fol  = 'DESC';\n";
        $str_js .= " var arr_order_dt   = 'DESC';\n";
        $str_js .= " var arr_order_desc = 'DESC';\n";
        $str_js .= "function setOrderBy(str_campo)\n";
        $str_js .= "{\n";
        $str_js .= "    str_ordenacao = '';\n";
        $str_js .= "    if(str_campo=='Cod_Apl')\n";
        $str_js .= "    {\n";
        $str_js .= "      if(arr_order_apl == 'ASC')\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_apl = 'DESC';\n";
        $str_js .= "      }else\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_apl = 'ASC';\n";
        $str_js .= "      }\n";
        $str_js .= "      str_ordenacao = arr_order_apl;\n";
        $str_js .= "    }\n";
        $str_js .= "    if(str_campo=='Folder')\n";
        $str_js .= "    {\n";
        $str_js .= "      if(arr_order_fol == 'ASC')\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_fol = 'DESC';\n";
        $str_js .= "      }else\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_fol = 'ASC';\n";
        $str_js .= "      }\n";
        $str_js .= "      str_ordenacao = arr_order_fol;\n";
        $str_js .= "    }\n";
        $str_js .= "    if(str_campo=='Data_Inc')\n";
        $str_js .= "    {\n";
        $str_js .= "      if(arr_order_dt == 'ASC')\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_dt = 'DESC';\n";
        $str_js .= "      }else\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_dt = 'ASC';\n";
        $str_js .= "      }\n";
        $str_js .= "      str_ordenacao = arr_order_dt;\n";
        $str_js .= "    }\n";
        $str_js .= "    if(str_campo=='Descricao')\n";
        $str_js .= "    {\n";
        $str_js .= "      if(arr_order_desc == 'ASC')\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_desc = 'DESC';\n";
        $str_js .= "      }else\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_desc = 'ASC';\n";
        $str_js .= "      }\n";
        $str_js .= "      str_ordenacao = arr_order_desc;\n";
        $str_js .= "    }\n";
        $str_js .= "    ajax_get_arr_apl(str_campo, str_ordenacao);\n";
        $str_js .= "}\n";
        $this->AddJavascript($str_js);
        $str_js = <<<JS
        function ajax_get_arr_apl(str_campo, str_ordenacao)
        {
            var param = {
                    'nm_ajax': 1,
                    'nm_option': 'setorderby',
                    'campo': str_campo,
                    'str_param': str_ordenacao,
                    'option': 'checkbox'
            };
            $.ajax({
                type: 'POST',
                url:  nm_url_iface + 'security_module2.php',
                data: param,
                async: false,
                cache: false,
                success: function(retorno){
                    if(retorno != ''){
                        ajax_set_arr_apl(retorno);
                    }
                }
            });            
        }
        function ajax_set_arr_apl(str_retorno)
        {
          if(str_retorno!='')
          {
            document.getElementById('id_arr_apls').innerHTML = str_retorno;
          }
        }
JS;
        $str_js  = "function nm_check_all(b_checked)\n";
        $str_js .= "{\n";
        $str_js .= "  $('#id_arr_apls tbody tr:visible').find('input').prop('checked', b_checked); \n";
        $str_js .= "}\n";
        $this->AddJavascript($str_js);

        $str_js = <<<JS
        function nm_show_password(obj){
            input = obj.parent().find('input');
            if(input.prop('type') == 'text'){
                input.prop('type', 'password');
                obj.removeClass('slash');
            }else if(input.prop('type') == 'password'){
                input.prop('type', 'text');
                obj.addClass('slash');
            }
        }
JS;
        $this->AddJavascript($str_js);

        $str_js  = "   var str_conn_cache = '';\n";
        $str_js .= "   function refreshTables()\n";
        $str_js .= "   {\n";
        $str_js .= "     str_conn = ''; \n";
        $str_js .= "     if(str_conn_cache != '') \n";
        $str_js .= "     { \n";
        $str_js .= "         str_conn = str_conn_cache;\n";
        $str_js .= "     } \n";
        $str_js .= "     else if($(\"select[name='tabela_conn']\").val() != '') \n";
        $str_js .= "     { \n";
        $str_js .= "         str_conn = $(\"select[name='tabela_conn']\").val();\n";
        $str_js .= "     } \n";
        $str_js .= "     $.ajax({ \n";
        $str_js .= "         url:  '" . $nm_config['url_iface'] . "wizard.php', \n";
        $str_js .= "         type: 'POST', \n";
        $str_js .= "         data: 'ajax=nm&ajax_reset_cache=true&force=1&conn=' + str_conn, \n";
        $str_js .= "         beforeSend: function() \n";
        $str_js .= "         { \n";
        $str_js .= "            nm_open_load(); \n";
        $str_js .= "         }, \n";
        $str_js .= "         success:function(msg) \n";
        $str_js .= "         { \n";
        $str_js .= "             $.unblockUI(); \n";
        $str_js .= "             str_conn_cache = '';\n";
        $str_js .= "         } \n";
        $str_js .= "     });\n";
        $str_js .= "   }\n";
        $this->AddJavascript($str_js);

        $str_js =<<<JS
        function nm_set_timeout(str_obj,str_field,str_type){
            setTimeout(() => {
                $("a[data-tab='"+str_obj+"']").attr('onclick','');
                $("a[data-tab='"+str_obj+"']").click();
                $(str_type+"[name='"+str_field+"']").focus();
                $("a[data-tab='"+str_obj+"']").attr('onclick','nm_verify_deps($(this).attr("data-tab"));');
            },'0050');
        }
        function nm_verify_deps(str_opt){
            if(str_opt != 'general'){
                verify_apps($('#id_prefix_app').val());
            }
            if($('#smtp_api').val() == 'custom' && $("a[data-tab=config_email]").hasClass('active') == true){
                var valid = 'yes';
                var field = '';
                $('.config_email_custom').each(function(i,t){
                	if(valid == 'yes'
                       && ( $(t).attr('name') != 'config_email[smtp_security]' 
                       && $(t).attr('name')   != 'config_email[smtp_name]' 
                       && $(t).attr('name')   != 'config_email[smtp_user]' 
                       && $(t).attr('name')   != 'config_email[smtp_pass]' ) 
                    ){
                		if($(t).val() == ''){
                            valid = 'no';
                            field = $(t).attr('name');
                        }
                	}
                });
            }

            if($('#id_hid_has_app').val() == 'tem'){
                nm_display_alert(nm_app_exist);
                nm_set_timeout('general','config_general[prefix_app]','input');
            }else if(($("#id_fld_use_captcha").val() == 'recaptcha' || $("#id_fld_use_captcha").val() == 'recaptchav3') && ( $("input[name='config_general[recaptcha_secret_key]']").val() == '' || $("input[name='config_general[recaptcha_secret_key]']").val() == '') ){
                if($("input[name='config_general[recaptcha_secret_key]']").val() == ''){
                    $("#nm_hidden_error_rec_sec_key").removeClass('nm_help_hidden');
                }
                if($("input[name='config_general[recaptcha_site_key]']").val() == ''){
                    $("#nm_hidden_error_rec_site_key").removeClass('nm_help_hidden');
                }
                if($("input[name='config_general[recaptcha_secret_key]']").val() == ''){
                    nm_display_alert('{$lang4}');
                    nm_set_timeout('login','config_general[recaptcha_secret_key]','input');
                }else if($("input[name='config_general[recaptcha_site_key]']").val() == ''){
                    nm_display_alert('{$lang5}');
                    nm_set_timeout('login','config_general[recaptcha_site_key]','input');
                }
            }else if(valid == 'no' && $('#smtp_api').val() == 'custom' && $("a[data-tab=config_email]").hasClass('active') == true){
                nm_display_alert(nm_lang_smtp_api_empty);
                nm_set_timeout('config_email',field,'input');
            }else if($("[data-tab='2fa']").length != 0 && ($('#2fa_option').val() != '' && $('#2fa_option').val() != '0') && ($('#2fa_api').val() == '' || $('#2fa_api').val() == null)){
                nm_display_alert(nm_lang_2fa_empty);
                nm_set_timeout('2fa','2fa[api]','select');
            }
        }
JS;
        $this->AddJavascript($str_js);
    }

    /**
     * Define arquivos JS da pagina.
     *
     * Define a lista de arquivos JS especificos da pagina atual.
     *
     * @access  protected
     */
    function PageJs()
    {
        $this->AddJs('third', 'jquery_plugin/malsup-blockui/jquery.blockUI.js');
        $this->AddJs('devel', 'window.js');
//        $this->AddJs('third', 'bootstrap/js/bootstrap.min.js');
        $this->AddJs('third', 'semantic-ui/semantic.min.js');
        $this->AddJs('devel', 'menuEditor2.js');

    }//doReplace


    /**
     * Define folhas de estilo da pagina.
     *
     * Define a lista de folhas de estilo especificas da pagina atual.
     *
     * @access  protected
     */
    function PageStyleCss()
    {
//        $this->AddStyleCssAfterScCss('third', 'bootstrap/css/bootstrap.min.css');
        $this->AddStyleCssAfterScCss('third', 'semantic-ui/semantic.min.css');
        $this->AddStyleCss('third', 'font-awesome/6/css/all.min.css');
    } // PageStyleCss


    /**
     * Define folhas de estilo da pagina.
     *
     * Define a lista de folhas de estilo especificas da pagina atual.
     *
     * @access  protected
     */
    function PageStyle()
    {
        global $nm_config, $nm_browser;

        $this->AddStyle("#abas li { text-decoration:none; list-style: none; cursor:pointer; padding:4px; color:#FFF;}"); //border:1px #BFDAF2 solid; padding: 3px 0px 0;
        $this->AddStyle("#id_table_ldap_childs { display:none;}"); //border:1px #BFDAF2 solid; padding: 3px 0px 0;
        $this->AddStyle(" a { text-decoration:none; font-weight: normal; text-transform: none; color:#336994; font-size:14px;}");//white-space:nowrap; padding: 0 10px;
        $this->AddStyle(".aba_selected , .aba_selected li { color:#000; font-weight:bold; background-color:#CECECE; padding:4px;}");
        $this->AddStyle(".aba_selected a { color:#000;}");
        $this->AddStyle(".aba_no_selected{ color:#000; background-color:#fffbac; }");
        $this->AddStyle("#id_img_module{ position:relative; top: -35px; left: -37px; padding: 37px 95px; background:url(" . $nm_config['url_img'] . "security_module_1.png) no-repeat; font-size:15px;}");
//        $this->AddStyle(".description, #id_description_help{	display:none;	position: absolute;	margin: 0px;	padding: 0px;	line-height: normal;	width: 160px;	color: rgb(59, 82, 118);	font-family: Verdana, Geneva, sans-serif;	font-size: 8pt;	text-align: left;	border:1px solid #BFDAF2;	background-color:#FAFACA;	white-space:normal;}");
        $this->AddStyle("#title_help{	background-color:#BFDAF2;}");
        $this->AddStyle(".img_help{	padding:0 8px;	cursor:pointer;}");
        $this->AddStyle("div.loading-invisible{display:none;}");
        $this->AddStyle("div.loading-visible{display:block; position:absolute; top:200px; left:0; width:100%; text-align:center; background:#fff; filter: alpha(opacity=80); -khtml-opacity: 0.80; -moz-opacity: 0.80; opacity: 0.80; border-top:1px solid #ddd; border-bottom:1px solid #ddd; }");
        $this->AddStyle("#id_tr_ldap_test{display:none;}");
        $this->AddStyle(".nmButton{cursor:pointer;}");
        $this->AddStyle(".can_disabled{display:none}");
        $this->AddStyle(".nm-radio-button{vertical-align: text-bottom;}");
        $this->AddStyle(".table_custom_smtp{display:none;}");
        $this->AddStyle(".nm_help_red{ color: red!important; } .nm_help_green{ color: green!important; }");
        $this->AddStyle(".nm_help_visible{ display: block!important; } .nm_help_hidden{ display: none!important; } .nm_padding_top{ padding-top: 10px; }");
    }

    function populateGrp($nm_db_usu)
    {

        $arr_sql = array_merge(array(), $this->populateUsr($nm_db_usu));
        $grp_app = $_SESSION['nm_session']['module_security']['profile']['grp_app'];
        $values = "";
        $data = $_SESSION['nm_session']['module_security']['profile']['pop_grp'];
        $charset = $this->getCharset();
        $_SESSION['nm_session']['module_security']['id_group_administrator'] = false;

        //=================================
        $table = $_SESSION['nm_session']['module_security']['profile']['grp']['table'];
        $fields = $_SESSION['nm_session']['module_security']['profile']['grp']['group_id'];
        $rs = $nm_db_usu->Execute(nm_decode_utf8_charset("SELECT " . $fields . ',' . $_SESSION['nm_session']['module_security']['profile']['grp']['description'] . " FROM " . $table . " ORDER BY " . $fields . " DESC", $charset));
        $fields .= ", ";
        $reg = isset($rs->fields[0]) ? ((int)$rs->fields[0] + 1) : 1;

        $rs_count = $nm_db_usu->Execute(nm_decode_utf8_charset("SELECT count(*) FROM " . $table . " WHERE description = " . $nm_db_usu->qstr($data['description']), $charset));
        if ($rs_count->fields[0] == 1) {
            while (!$rs->EOF) {
                if ($rs->fields[1] == $data['description']) {
                    $reg = $rs->fields[0];
                    break;
                }
                $rs->MoveNext();
            }
            $rs->Close();
        } else {

            $values .= $reg . ", ";

            foreach ($data as $k => $v) {
                $fields .= $_SESSION['nm_session']['module_security']['profile']['grp'][$k] . ", ";
                $values .= $nm_db_usu->qstr($v) . ", ";
            }
            $fields = substr($fields, 0, -2);
            $values = substr($values, 0, -2);
            $sql = nm_decode_utf8_charset("INSERT INTO " . $table . "(" . $fields . ") VALUES (" . $values . ")", $charset);
            $_SESSION['nm_session']['module_security']['profile']['sql_security_commands'] .= $sql . ";\n";
            $nm_db_usu->Execute($sql);
        }
        $_SESSION['nm_session']['module_security']['id_group_default'] = false;
        if (
            isset($_SESSION['nm_session']['module_security']['profile']['config_general']['perm_new_user'])
            && $_SESSION['nm_session']['module_security']['profile']['config_general']['perm_new_user'] == 'S'
        ) {

            $reg_group_default = $reg + 1;


            $group_default = $_SESSION['nm_session']['module_security']['profile']['config_general']['default_group'];
            $group_default = empty($group_default) ? "Group Default" : $group_default;

            $sql = nm_decode_utf8_charset("INSERT INTO "
                . $_SESSION['nm_session']['module_security']['profile']['grp']['table']
                . "(" . $_SESSION['nm_session']['module_security']['profile']['grp']['group_id'] . ", "
                . $_SESSION['nm_session']['module_security']['profile']['grp']['description']
                . ") VALUES (" . $reg_group_default . ", " . $nm_db_usu->qstr($group_default) . ")",$charset);
            $nm_db_usu->Execute($sql);
            $_SESSION['nm_session']['module_security']['profile']['sql_security_commands'] .= $sql . ";\n";
            $_SESSION['nm_session']['module_security']['id_group_default'] = $reg_group_default;
        }

        // ================================

        //$rs = $nm_db_usu->Execute(nm_decode_utf8_charset("SELECT ". $grp['group_id'] . " FROM ". $grp['table'] . " WHERE ". $grp['description'] . " = " . $nm_db_usu->qstr($data['description']), $charset) );
        $grupo = $reg;
        $_SESSION['nm_session']['module_security']['id_group_administrator'] = $grupo;
        //$rs->Close();

        $y = $nm_db_usu->qstr("Y");
        $n = $nm_db_usu->qstr("N");
        $values = array();
        $values[NM_APP_TYPE_GRID] = $y . ", " . $n . ", " . $n . ", " . $n . ", " . $y . ", " . $y;
        $values[NM_APP_TYPE_FORM] = $y . ", " . $y . ", " . $y . ", " . $y . ", " . $n . ", " . $n;
        $values[NM_APP_TYPE_FILTER] = $y . ", " . $n . ", " . $n . ", " . $n . ", " . $n . ", " . $n;
        $values[NM_APP_TYPE_CONTROL] = $values[NM_APP_TYPE_FILTER];
        $values[NM_APP_TYPE_TABBED] = $values[NM_APP_TYPE_FILTER];
        $values[NM_APP_TYPE_CHART] = $values[NM_APP_TYPE_GRID];
        $values[NM_APP_TYPE_PROC] = $values[NM_APP_TYPE_GRID];
        $values[NM_APP_TYPE_MENU] = $values[NM_APP_TYPE_FILTER];
        $values[NM_APP_TYPE_MENUTREE] = $values[NM_APP_TYPE_FILTER];
        $values[NM_APP_TYPE_CALENDAR] = $values[NM_APP_TYPE_FORM];
        $values[NM_APP_TYPE_REPORTPDF] = $values[NM_APP_TYPE_FILTER];
        $values[NM_APP_TYPE_RPDFPROC] = $values[NM_APP_TYPE_FILTER];
        $values[NM_APP_TYPE_CONTAINER] = $values[NM_APP_TYPE_FILTER];
        $values[NM_APP_TYPE_BLANK] = $values[NM_APP_TYPE_FILTER];
        $values['default'] = $y . ", " . $y . ", " . $y . ", " . $y . ", " . $y;


        $insert_apps = "INSERT INTO " . $grp_app['table'] .
            "(" .
            $grp_app['group_id'] . ", " .
            $grp_app['app_name'] . ", " .
            $grp_app['priv_access'] . ", " .
            $grp_app['priv_insert'] . ", " .
            $grp_app['priv_delete'] . ", " .
            $grp_app['priv_update'] . ", " .
            $grp_app['priv_export'] . ", " .
            $grp_app['priv_print'] . ") VALUES (";

        $permissions_group_default = $n . ", " . $n . ", " . $n . ", " . $n . ", " . $n . ", " . $n;
        $prefix_app = $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'];


        $rs = $nm_db_usu->Execute(nm_decode_utf8_charset("SELECT " . $_SESSION['nm_session']['module_security']['profile']['app']['app_name'] . ", " . $_SESSION['nm_session']['module_security']['profile']['app']['app_type'] . " FROM " . $_SESSION['nm_session']['module_security']['profile']['app']['table'], $charset));
        $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_security']['profile']['tabela_conn']);
        $db_type = nm_db_type($arr_conn['dbms']);
        if ($rs !== false) {
            while (!$rs->EOF) {


                $arr_sql[] = $insert_apps .
                    ($db_type == 'sybase' ? $grupo : $nm_db_usu->qstr($grupo)) . ", " .
                    $nm_db_usu->qstr($rs->fields[0]) . ", " .
                    ($values[$rs->fields[1]] ?: $values['default']) .
                    ")";
                if ($_SESSION['nm_session']['module_security']['id_group_default'] != false) {
                    $permissions = in_array($rs->fields[0], array($prefix_app . 'Login', $prefix_app . 'change_pswd', $prefix_app . 'control_2fa', $prefix_app . 'add_2fa')) ? $values[NM_APP_TYPE_CONTROL] : $permissions_group_default;
                    $permissions = in_array($rs->fields[0], array( $prefix_app . 'my_info')) ? $values[NM_APP_TYPE_FORM] : $permissions;

                    $arr_sql[] = $insert_apps .
                        $nm_db_usu->qstr($_SESSION['nm_session']['module_security']['id_group_default']) . ", " .
                        $nm_db_usu->qstr($rs->fields[0]) . ", " .
                        $permissions .
                        ")";
                }

                $rs->MoveNext();
            }
            $rs->Close();
        }
        if ($_SESSION['nm_session']['module_security']['id_group_default'] != false) {
            $app = $_SESSION['nm_session']['module_security']['profile']['config_general']['prefix_app'] . "menu";
            if ($_SESSION['nm_session']['module_security']['profile']['config_general']['menu'] != 'new_menu') {
                $app = explode("#@#", $_SESSION['nm_session']['module_security']['profile']['config_general']['menu']);
                $app = $app[0];
            }

            $arr_sql[] = "UPDATE " . $grp_app['table'] . " SET " . $grp_app['priv_access'] . " = " . $nm_db_usu->qstr("Y")
                . " WHERE " . $grp_app['app_name'] . " = " . $nm_db_usu->qstr($app) . " AND " . $grp_app['group_id'] . " = " . $nm_db_usu->qstr($_SESSION['nm_session']['module_security']['id_group_default']);
        }


        //=================================
        $table = $_SESSION['nm_session']['module_security']['profile']['usr_grp']['table'];


        $arr_sql[] = "INSERT INTO " . $table
            . "(" . $_SESSION['nm_session']['module_security']['profile']['usr_grp']['login'] . ", "
            . $_SESSION['nm_session']['module_security']['profile']['usr_grp']['group_id']
            . ") VALUES (" .
            $nm_db_usu->qstr($_SESSION['nm_session']['module_security']['profile']['pop_usr']['login'], $charset) . ", " . $nm_db_usu->qstr($grupo, $charset) . ")";
        //=================================

        return $arr_sql;
    }

    function populateUsr($nm_db_usu)
    {
        global $nm_config;
        $table = $_SESSION['nm_session']['module_security']['profile']['usr']['table'];
        $fields = "";
        $values = "";
        $arr_sql = array();
        $data = $_SESSION['nm_session']['module_security']['profile']['pop_usr'];
        $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_security']['profile']['tabela_conn']);

        foreach ($data as $k => $v) {
            if ($k == 'pswd' && $_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'ldap') {
                $v = ' ';
            }

            $fields .= $_SESSION['nm_session']['module_security']['profile']['usr'][$k] . ", ";
            if (strtolower($k) == 'pswd' && $_SESSION['nm_session']['module_security']['profile']['config_general']['criptografia'] != '') {
                $values .= $nm_db_usu->qstr(hash($_SESSION['nm_session']['module_security']['profile']['config_general']['criptografia'], $v)) . ", ";
            } elseif((strtolower($k) == 'pswd_last_updated' || strtolower($k) == 'mfa_last_updated') && nm_db_type($arr_conn['dbms']) == 'oracle'){
                if(!is_null($v)){
                    $values .= " TO_DATE(".$nm_db_usu->qstr($v) . ", 'yyyy-mm-dd hh24:mi:ss'), ";
                }else{
                    $values .= $nm_db_usu->qstr($v) . ", ";
                }
            } else {
                $values .= $nm_db_usu->qstr($v) . ", ";
            }
        }
        $fields = substr($fields, 0, -2);
        $values = substr($values, 0, -2);
        $arr_sql[] = 'INSERT INTO ' . $table . '(' . $fields . ') VALUES (' . $values . ')';
        $this->addSettings($nm_db_usu);
        return $arr_sql;
    }

    function populateLdap($nm_db_usu)
    {
        return array();
    }

    function populateLdap_app($nm_db_usu){
        return $this->populateApp($nm_db_usu);
    }

    function populateApp($nm_db_usu)
    {
        $arr_sql = array();
        $charset = $this->getCharset();
        $values = "";
        $arr_sql = array_merge($arr_sql, $this->populateUsr($nm_db_usu));
        $data = $_SESSION['nm_session']['module_security']['profile']['pop_usr'];

        $table = $_SESSION['nm_session']['module_security']['profile']['usr_app']['table'];

        $y = $nm_db_usu->qstr("Y");
        $n = $nm_db_usu->qstr("N");
        $values = array();
        $values[NM_APP_TYPE_GRID] = $y . ", " . $n . ", " . $n . ", " . $n . ", " . $y . ", " . $y;
        $values[NM_APP_TYPE_FORM] = $y . ", " . $y . ", " . $y . ", " . $y . ", " . $y . ", " . $y;
        $values[NM_APP_TYPE_FILTER] = $y . ", " . $n . ", " . $n . ", " . $n . ", " . $n . ", " . $n;
        $values[NM_APP_TYPE_CONTROL] = $values[NM_APP_TYPE_FILTER];
        $values[NM_APP_TYPE_CONTROLUSR] = $values[NM_APP_TYPE_FILTER];
        $values[NM_APP_TYPE_TABBED] = $values[NM_APP_TYPE_FILTER];
        $values[NM_APP_TYPE_CHART] = $values[NM_APP_TYPE_GRID];
        $values[NM_APP_TYPE_PROC] = $values[NM_APP_TYPE_GRID];
        $values[NM_APP_TYPE_MENU] = $values[NM_APP_TYPE_FILTER];
        $values[NM_APP_TYPE_MENUTREE] = $values[NM_APP_TYPE_FILTER];
        $values[NM_APP_TYPE_CALENDAR] = $values[NM_APP_TYPE_FORM];
        $values[NM_APP_TYPE_REPORTPDF] = $values[NM_APP_TYPE_FILTER];
        $values[NM_APP_TYPE_RPDFPROC] = $values[NM_APP_TYPE_FILTER];
        $values[NM_APP_TYPE_CONTAINER] = $values[NM_APP_TYPE_FILTER];
        $values[NM_APP_TYPE_BLANK] = $values[NM_APP_TYPE_FILTER];
        $values['default'] = $y . ", " . $y . ", " . $y . ", " . $y . ", " . $y;

        $insert_apps = "INSERT INTO " . $table . "(" .
            $_SESSION['nm_session']['module_security']['profile']['usr_app']['login'] . ", " .
            $_SESSION['nm_session']['module_security']['profile']['usr_app']['app_name'] . ", " .
            $_SESSION['nm_session']['module_security']['profile']['usr_app']['priv_access'] . ", " .
            $_SESSION['nm_session']['module_security']['profile']['usr_app']['priv_insert'] . ", " .
            $_SESSION['nm_session']['module_security']['profile']['usr_app']['priv_delete'] . ", " .
            $_SESSION['nm_session']['module_security']['profile']['usr_app']['priv_update'] . ", " .
            $_SESSION['nm_session']['module_security']['profile']['usr_app']['priv_export'] . ", " .
            $_SESSION['nm_session']['module_security']['profile']['usr_app']['priv_print'] . ") VALUES (";

        $str_sql = nm_decode_utf8_charset("SELECT " . $_SESSION['nm_session']['module_security']['profile']['app']['app_name'] . ", " . $_SESSION['nm_session']['module_security']['profile']['app']['app_type'] . " FROM " . $_SESSION['nm_session']['module_security']['profile']['app']['table'], $charset);
        $rs = $nm_db_usu->Execute($str_sql);

        while (!$rs->EOF) {
            $arr_sql[] = $insert_apps . $nm_db_usu->qstr($data['login']) . ", " . $nm_db_usu->qstr($rs->fields[0]) . ", " .
                ($values[$rs->fields[1]] ?: $values['default']) . ")";
            $rs->MoveNext();
        }
        $rs->Close();
        return $arr_sql;
    }

    function _debug_file($value)
    {
        $str_content = "\n\n=================================================\n";
        if (is_array($value)) {
            $str_content .= var_export($value, true);
        } else {
            $str_content .= $value;
        }
        file_put_contents("/var/www/debug_security.txt", $str_content, FILE_APPEND);
    }

    function replace_campos($sql, $arr_tables)
    {
        foreach ($arr_tables as $tabela) {
            $tabela = 'sec_' . $tabela;
            if (is_array($this->arr_to_replace['campos'][$tabela])) {
                if (strpos($this->arr_to_replace['tabelas'][$tabela], ".") !== FALSE)
                    $arr_replace = substr($this->arr_to_replace['tabelas'][$tabela], strpos($this->arr_to_replace['tabelas'][$tabela], ".") + 1);
                else
                    $arr_replace = $this->arr_to_replace['tabelas'][$tabela];

                $sql = str_replace($tabela, $arr_replace, $sql);
                $arr_replace = $this->arr_to_replace['campos'][$tabela];

                if (isset($arr_replace['table']))
                    unset($arr_replace['table']);

                $sql = strtr($sql, $arr_replace);
            }

        }
        return $sql;
    }
}

?>