
const menubar = document.querySelector('.ae-menubar.menubar');
const menubarHeight = menubar ? menubar.offsetHeight : 0;
function cleanDropdownStyle(dropdown) {
    const styleAttr = dropdown.getAttribute('style');
    const pattern = /right:\s*calc\(100%\s*-\s*0\.5em\);?/;

    if (styleAttr && styleAttr.match(pattern)) {
        const cleanedStyle = styleAttr.replace(pattern, '').trim();
        dropdown.setAttribute('style', cleanedStyle);
    }
}
function handleMenuItem(megamenu_link) {
    const dropdownId = megamenu_link.getAttribute('aria-controls');
    const dropdown = document.getElementById(dropdownId);
    const sectionTitles = dropdown.querySelectorAll('.section_title>p');
    const megamenu_linkRect = megamenu_link.getBoundingClientRect();
    const dropdownRect = dropdown.getBoundingClientRect();
    const axis = megamenu_link.getAttribute('data-axis');

    // Remove a classe 'show' de todos os dropdowns
    document.querySelectorAll('.dropdown').forEach(function (dropdown) {
        dropdown.classList.remove('show');
        const controlItem = document.querySelector(`[aria-controls="${dropdown.id}"]`);
        if (controlItem) {
            controlItem.setAttribute('aria-expanded', 'false');
        }
    });

    // Adiciona a classe 'show' para o dropdown atual
    dropdown.classList.add('show');
    megamenu_link.setAttribute('aria-expanded', 'true');

    let top, left;

    if (axis === 'horizontal') {
        // Alinha horizontalmente
        top = menubarHeight - 10;
        left = megamenu_linkRect.left - dropdownRect.width/2 + megamenu_linkRect.width/2;

        // Verifica se o dropdown se encaixa na viewport horizontalmente
        if (left + dropdownRect.width > window.innerWidth) {
            left = megamenu_linkRect.right - dropdownRect.width;
        }


    } else {
        // Alinha verticalmente (default)
        top = megamenu_linkRect.bottom;
        left = megamenu_linkRect.left;

        // Verifica se o dropdown se encaixa na viewport verticalmente
        if (top + dropdownRect.height > window.innerHeight) {
            top = 0;
        }

        // Verifica se o dropdown se encaixa na viewport horizontalmente
        if (left + dropdownRect.width > window.innerWidth) {
            left = window.innerWidth - dropdownRect.width;
        }

    }


    // Garante que o dropdown não saia do limite esquerdo
    if (left < 0) {
        left = 0;
    }
    if (
        top < 10 && (
            (document.querySelector('.expand-button') && document.querySelector('.expand-button').checkVisibility())
            ||
            (document.querySelector('.menu-mobile-control') && document.querySelector('.menu-mobile-control').checkVisibility())
        )
    ) {
        dropdown.classList.add('fullscreen');

        left = 0;
    } else {
        dropdown.classList.remove('fullscreen');
    }


    // Garante que o dropdown seja visível em telas menores
    if (dropdownRect.height > window.innerHeight) {
        dropdown.style.maxHeight = `100vh`;
        dropdown.style.overflowY = 'auto';
    }

    left = Math.trunc(left);
    top = Math.trunc(top);
    dropdown.style.top = `${top}px`;
    dropdown.style.left = `${left}px`;
    dropdown.style["max-height"] = `calc(100vh - ${top}px)`;
    dropdown.style["overflow-y"] = `auto`;
    dropdown.style["overflow-x"] = `hidden`;

    setTimeout(() => {
        cleanDropdownStyle(dropdown);
    }, 150);

    var title_height = 0;
    sectionTitles.forEach(function (title) {
        if (title.offsetHeight > title_height) {
            title_height = title.offsetHeight;
        }
    });
    sectionTitles.forEach(function (title) {
        title.style.height = title_height + 'px';
    });

    // Adiciona ouvinte de eventos ao megamenu_link para manipular mouseleave
    megamenu_link.addEventListener('mouseleave', function (ev) {
        ev.stopPropagation();
        setTimeout(() => {
            if (!dropdown.matches(':hover') && !megamenu_link.matches(':hover')) {
                dropdown.classList.remove('show');
                megamenu_link.setAttribute('aria-expanded', 'false');
            }
        }, 100);
    }, {once: true});

    // Adiciona ouvinte de eventos ao dropdown para manipular mouseleave
    dropdown.addEventListener('mouseleave', function (ev) {
        ev.stopPropagation();
        setTimeout(() => {
            if (!dropdown.matches(':hover') && !megamenu_link.matches(':hover')) {
                dropdown.classList.remove('show');
                megamenu_link.setAttribute('aria-expanded', 'false');
            }
        }, 100);
    }, {once: true});

    // Adiciona ouvintes de eventos ao dropdown para manipular mouseenter
    dropdown.addEventListener('mouseenter', function (ev) {
        ev.stopPropagation();
        dropdown.classList.add('show');
        megamenu_link.setAttribute('aria-expanded', 'true');
    }, {once: true});
}
function loadMegamenus() {

    document.querySelectorAll('[data-megamenu="link"]').forEach(function (megamenu_link) {
        const axis = megamenu_link.getAttribute('data-axis');
        megamenu_link.setAttribute('aria-expanded', 'false');
        if (axis === 'horizontal') {
            megamenu_link.addEventListener('mouseenter', () => handleMenuItem(megamenu_link));
        } else {
            megamenu_link.addEventListener('click', () => handleMenuItem(megamenu_link));
        }
    }, {once: true});

    window.addEventListener('resize', function () {
        document.querySelectorAll('.dropdown').forEach(function (dropdown) {
            dropdown.classList.remove('show');
            const controlItem = document.querySelector(`[aria-controls="${dropdown.id}"]`);
            if (controlItem) {
                controlItem.setAttribute('aria-expanded', 'false');
            }
        });
    }, {once: true});
};
