
{{google_font_css}}
  <style type="text/css">
    html,
    body {
      width: 100%;
      height: 100%;
    }

    body{
      background-color: #dee3eb;
    }
    
    .sample-image {
      width: auto;
    }

    .sample-image-third {
      width: calc(33.33% - .5rem);
    }

    .frame-container {
      flex-flow: column nowrap;
      row-gap: .5rem;
      display: flex;
      height: auto;
      justify-content: stretch;
      align-items: stretch;
    }

    .frame-container > div ,
    .frame-container > iframe {
      flex-grow: 1;
    }

    .frame-container > div > iframe{
      height: 100%;
      width: 100%;
    }

    .sample-row{      
      flex-flow: row nowrap;
      justify-content: center;
      align-items: center;
      column-gap: .65rem;
      display: flex;
    }
    .ae-menubar .main-navigation [role=menuitem] .submenu[role=menu] {
      z-index: 10;
    }
    .menu__layer {
        height: 100vh;
        display: flex;
        flex-direction: column;
        justify-content: flex-start;
        align-items: stretch;
    }
    .ae-menubar.tabsbar {
        margin: 0 !important;
        border-radius: 0 !important;
    }
    .ae-menubar.breadcrumbs {
        margin: 0.25rem !important;
    }
  </style>
  <section class="ae-menubar menubar split" role="toolbar" aria-orientation="horizontal" tabindex="0" data-aetheme="{{menu_theme}}">
    <div class="container-row">
      <div class="wrapper">
        <div class="logo"><a id="sc-menu-link-home" href="./"><span class="only-sr">Scriptcase menubar home </span><img
              class="d-none xl:d-block" src="{{logo}}"
              aria-hidden="true" /><img class="d-block xl:d-none"
              src="{{logo_compact}}" aria-hidden="true" /></a></div>

          {{header_string_h_placement}}
      </div>
      <div class="wrapper">
        <div class="toolbar" role="toolbar" aria-orientation="horizontal" aria-label="barra de ações">
            <div class="group actions" role="group">
                <?php
                if(isset($menu_data['tb_items']) && !empty($menu_data['tb_items'])) {
                    foreach ($menu_data['tb_items'] as $_tb_item) {
                        if (isset($_tb_item['display']) && $_tb_item['display']=='S' && isset($_tb_item['app']) && $_tb_item['app'] == 'search') {
                            ?>
                            <button class="button action-button" id="search-button"
                                    aria-label="pesquisar" aria-expanded="false" value="search" aria-controls="search-panel"
                                    aria-owns="search-panel"><i class="mb_icon lni lni-search-alt"
                                                                aria-hidden="true"></i></button>
                            <?php
                        }
                        elseif (isset($_tb_item['display']) && $_tb_item['display']=='S' && isset($_tb_item['app']) && $_tb_item['app'] == 'languages') {
                            ?>
                            <button class="button action-button" id="translate-button"
                                    aria-label="idiomas" aria-expanded="false" value="translate" aria-controls="translate-panel"
                                    aria-owns="translate-panel"><i class="mb_icon lni lni-world" aria-hidden="true"></i></button>
                            <?php
                        }
                        elseif (isset($_tb_item['display']) && $_tb_item['display']=='S' && isset($_tb_item['app']) && $_tb_item['app'] == 'themes') {
                            ?>
                            <button class="button action-button"
                                    id="themes-button" aria-label="temas" aria-expanded="false" value="themes" aria-controls="themes-panel"
                                    aria-owns="themes-panel"><i class="mb_icon lni lni-paint-roller" aria-hidden="true"></i></button>
                            <?php
                        }
                        elseif (isset($_tb_item['display']) && $_tb_item['display']=='S' && isset($_tb_item['app']) && $_tb_item['app'] == 'shortcuts') {
                            ?>
                            <button
                                    class="button action-button" id="shortcuts-button" aria-label="ações rápidas" aria-expanded="false"
                                    value="shortcuts" aria-controls="shortcuts-panel" aria-owns="shortcuts-panel"><i
                                        class="mb_icon lni lni-grid-alt" aria-hidden="true"></i></button>
                            <?php
                        }
                        elseif (isset($_tb_item['display']) && $_tb_item['display']=='S' && isset($_tb_item['app']) && $_tb_item['app'] == 'notification') {
                            ?>
                            <button
                                    class="button action-button" id="notification-button" aria-label="notificações" aria-expanded="false"
                                    value="notification" aria-controls="notification-panel" aria-owns="notification-panel">
                                <i class="mb_icon lni lni-alarm" aria-hidden="true">
                                    <span class="bg-red-500 d-inline-block" id="notification-dot"></span>
                                </i>
                            </button>
                            <?php
                        }
                    }
                }
                ?>
            </div>
        </div>
          <?php
          if ($menu_data['usercheck'] == 'S') {
          ?>
        <div class="user action-button" role="button" id="user-button" aria-label="ações do usuário"
          aria-expanded="false" aria-controls="user-panel" aria-owns="user-panel">

          <img src="{{userimage}}" class="user_image" />
        </div>
          <?php
          }
          ?>
      </div>
    </div>
    <div class="divider divider-y divider-solid"></div>
    <div class="container-row">
      <div class="wrapper">
        <div class="menu-mobile-control" role="button" aria-pressed="false" aria-label="abrir menu"
          aria-controls="main-navigation-mobile"><i class="mb_icon-custom hamburger-menu" aria-hidden="true"><label
              for="hamburger-icon-control"><input type="checkbox"
                id="hamburger-icon-control" /><span></span><span></span><span></span></label></i></div>
        <div class="main-navigation" id="main-navigation" aria-label="navegação principal">
          <ul role="menubar" aria-label="navegação principal" id="nav_list">

          </ul>
        </div>
      </div>
    </div>
    <div class="ae-menu-mobile" id="main-navigation-mobile" data-show="false" aria-hidden="true">
      <div class="main-navigation-mobile ae-menubar-accordion" aria-label="navegação principal">
        <ul role="menubar" aria-label="navegação principal" id="nav_mobile">

        </ul>
      </div>
    </div>
      <?php
      if ($menu_data['usercheck'] == 'S') {
      ?>
    <div class="panel" id="user-panel" role="dialog" aria-label="menu de contexto com ações relativas ao usuário"
      aria-hidden="true">
      <div class="section user-info mx-3">
          <div class="user" id="user-avatar" aria-hidden="true">
              <img src="{{userimage}}" class="user_image" />
          </div>
          <div>
              <p class="user-name">{{username}}</p>
              <p class="user-profile">{{userdesc}}</p>
          </div>
      </div>
      <hr class="divider-y divider-solid divider-theme-color" />
      <div class="section actions ae-menubar-accordion">
        <ul role="menubar" aria-label="ações do menu do usuário" id="user_menu_list">
        </ul>
      </div>
      <hr class="divider-y divider-solid divider-theme-color" />
    </div>
      <?php
      }
      ?>

      {{themes-panel}}
      {{languages-panel}}
      {{fav-panel}}
      {{search-panel}}
      {{notification}}
      {{megamenu}}
  </section>
  <section class="ae-menubar tabsbar" data-aetheme="{{menu_theme}}" style="" aria-orientation="horizontal">
      {{tabs_placement}}
  </section>
  {{breadcrumbs_placement}}
  <div class="frame-container" id="app-frames" data-aetheme="{{menu_theme}}">
    <iframe class="nm_frame_app" name="nm_frame_app" src="" frameborder="0"></iframe>
      <div class="loader-placeholder"><div class="lds-dual-ring"></div></div>
  </div>