<?php

/**
 * Cria os metodos do grafico
 */
function createChartMethods($file, $groupByName)
{
    // metodos para tratamento de informacoes da quebra
    fnChart_info_initializeChart($file);
    fnChart_info_initializeInfo($file);
    fnChart_info_initializeData($file);
    fnChart_info_loadMd5Info($file);
    fnChart_info_loadSessionInfo($file);
    fnChart_info_setSeriesMode($file);
    fnChart_info_setChartItemsLimit($file);
    fnChart_info_createFusionChartsData($file);
    fnChart_info_createFusionChartsData_javascript($file);
    fnChart_info_createFusionChartsData_json($file);
    fnChart_info_createFusionChartsData_json_chart($file);
    fnChart_info_createFusionChartsData_json_chart_export($file);
    fnChart_info_createFusionChartsData_json_chart_format($file);
    fnChart_info_createFusionChartsData_json_chart_subtitle($file);
    fnChart_info_createFusionChartsData_json_chart_theme($file);
    fnChart_info_createFusionChartsData_json_type_area($file);
    fnChart_info_createFusionChartsData_json_type_chord($file);
    fnChart_info_createFusionChartsData_json_type_combination($file);
    fnChart_info_createFusionChartsData_json_type_bar($file);
    fnChart_info_createFusionChartsData_json_type_funnel($file);
    fnChart_info_createFusionChartsData_json_type_gauge($file);
    fnChart_info_createFusionChartsData_json_type_heatmap($file);
    fnChart_info_createFusionChartsData_json_type_line($file);
    fnChart_info_createFusionChartsData_json_type_pie($file);
    fnChart_info_createFusionChartsData_json_type_pyramid($file);
    fnChart_info_createFusionChartsData_json_type_radar($file);
    fnChart_info_createFusionChartsData_json_type_sankey($file);
    fnChart_info_createFusionChartsData_json_type_sunburst($file);
    fnChart_info_createFusionChartsData_json_type_treemap($file);
    fnChart_info_createFusionChartsData_json_data_series($file);
    fnChart_info_createFusionChartsData_json_data_singleSeries($file);
    fnChart_info_createFusionChartsData_json_data_multiSeries($file);
    fnChart_info_createFusionChartsData_json_data_comparisonSeries($file);
    fnChart_info_createFusionChartsData_json_data_singleSerieCategorySeries($file);
    fnChart_info_createFusionChartsData_json_data_combinationSeries($file);
    fnChart_info_createFusionChartsData_json_data_heatMapSeries($file);
    fnChart_info_createFusionChartsData_json_data_treeMapSeries($file);
    fnChart_info_createFusionChartsData_json_data_chordSeries($file);
    fnChart_info_createFusionChartsData_json_data_sankeySeries($file);
    fnChart_info_createFusionChartsData_json_data_sunburstSeries($file);
    fnChart_info_createFusionChartsData_json_data_gaugeSeries($file);
    fnChart_info_createFusionChartsData_json_data_scatterSeries($file);
    fnChart_info_createFusionChartsData_json_data_bubbleSeries($file);
    fnChart_info_createFusionChartsData_json_data_order($file);
    fnChart_info_createFusionChartsData_json_data_trendline($file);
    fnChart_info_saveFusionChartsJson($file);

    // metodos para exibicao de grafico
    fnChart_display_chartApp_inline_startUp($file);
    fnChart_display_chartApp_type($file);
    fnChart_display_summaryChart_inline_startUp($file);
    fnChart_display_summaryChart_inline_initialAjaxCall($file);
    fnChart_display_summaryChart_inline_initialAjaxResponse($file);
    fnChart_display_summaryChart_inline_updateAjaxResponse($file);
    fnChart_display_summaryChart_data($file);
    fnChart_display_summaryChart_newPage($file);
    fnChart_display_summaryChart_phantom($file);
    fnChart_display_summaryChart_phantom_md5($file);
    fnChart_display_chart_summaryBody($file);
    fnChart_display_chart_chartBody($file);
    fnChart_display_chart_htmlHeader($file);
    fnChart_display_chart_htmlHeader_styleCss($file);
    fnChart_display_chart_htmlHeader_linkCss($file);
    fnChart_display_chart_htmlHeader_javascript($file);
    fnChart_display_chart_htmlFooter($file);
    fnChart_display_chart_htmlFusionChartsLibrary($file);
    fnChart_display_chart_htmlFusionChartsConfigDiv($file);
    fnChart_display_chart_htmlFusionChartsDiv_inline($file);
    fnChart_display_chart_htmlFusionChartsDiv_newPage($file);
    fnChart_display_chart_htmlFusionChartsDiv_breadcrumb($file);
    fnChart_display_chart_htmlFusionChartsJavascript_function($file);
    fnChart_display_chart_htmlFusionChartsJavascript_phantom($file);
    fnChart_display_chart_htmlFusionChartsJavascript_onReady($file);
    fnChart_display_chart_htmlFusionChartsJavascript_chartApp($file);
    fnChart_display_chart_htmlFusionChartsJavascript_drilldown($file);
    fnChart_display_chart_htmlFusionChartsJavascript_setInlineChartMd5($file);
    fnChart_display_chart_htmlSamePageBackButton($file);

    // metodos auxiliares
    fnChart_aux_addTrendline_average($file);
    fnChart_aux_addTrendline_fixed($file);
    fnChart_aux_addTrendline_linear($file);
    fnChart_aux_addTrendline_standardDeviation($file);
    fnChart_aux_addTrendline_variance($file);
    fnChart_aux_addTrendline_zone($file);
    fnChart_aux_createSummaryCss($file);
    fnChart_aux_filterChartItems($file);
    fnChart_aux_format_functions($file, $groupByName);
    fnChart_aux_formatFinalize($file);
    fnChart_aux_getChartErrorMessage($file);
    fnChart_aux_getChartInfoType($file);
    fnChart_aux_getChartLink($file);
    fnChart_aux_getChartLinkInfo($file);
    fnChart_aux_getChartLinkMd5($file);
    fnChart_aux_getFusionChartsRenderer($file);
    fnChart_aux_getFusionChartsComparisonRenderer($file);
    fnChart_aux_getMetricField($file);
    fnChart_aux_getMetricLabel($file);
    fnChart_aux_isJsonChartCreated($file);
    fnChart_aux_isMobile($file);
    fnChart_aux_isMultiSeries($file);
    fnChart_aux_isPdf($file);
    fnChart_aux_isResponsive($file);
    fnChart_aux_isUtf8($file);
    fnChart_aux_orderChartMultipleSeries($file);
    fnChart_aux_orderChartSingleSerie($file);
    fnChart_aux_orderSerie($file);
    fnChart_aux_protectText($file);
    fnChart_aux_rearrangeOrderIndexes($file);
    fnChart_aux_rearrangeOrderMultiIndexes($file);
    fnChart_aux_setChartType($file);
    fnChart_aux_setFusionchartsFix($file);
}

/**
 * Inicializa as estruturas internas do grafico
 */
function fnChart_info_initializeChart($file)
{
    $phpCode = <<<EOT
    function info_initializeChart(\$chartMd5, \$isExport = false)
    {
        \$this->info_initializeInfo(\$chartMd5);

        \$this->info_loadMd5Info(\$chartMd5);
        \$this->info_loadSessionInfo(\$chartMd5);
        \$this->info_setSeriesMode();
        \$this->info_setChartItemsLimit();
        \$this->info_createFusionChartsData(\$isExport);

        \$this->info_saveFusionChartsJson();
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_initializeChart

/**
 * Inicializa o array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo($file)
{
    global $summaryInfo;

    $charset = str_replace(array('<?php echo ', ' ?>'), array('{', '}'), $_SESSION['nm_session'] ['charset']);

    $phpCode = <<<EOT
    function info_initializeInfo(\$chartMd5)
    {
        \$charset = <<<SCEOT
$charset
SCEOT;

        \$summaryCss = '';
        if (isset(\$_POST['summary_css']) && '' != \$_POST['summary_css']) {
            \$summaryCss = \$_POST['summary_css'];
        } else {
            \$summaryCss = \$this->aux_createSummaryCss();
        }

        \$this->SC_APP_info = [

EOT;
    $phpCode .= fnChart_info_initializeInfo_chart();
    $phpCode .= fnChart_info_initializeInfo_types();
    $phpCode .= fnChart_info_initializeInfo_options();
    $phpCode .= fnChart_info_initializeInfo_css();
    $phpCode .= <<<EOT
        ];
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_initializeInfo

/**
 * Inicializa a secao chart do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_chart()
{
    global $summaryInfo;

    $availableTypes = [];
    foreach ($summaryInfo['chart'] ['available_types'] as $chartType) {
        $availableTypes[] = "'$chartType'";
    }
    $availableTypes = implode(', ', $availableTypes);

    $availableComparisonTypes = [];
    foreach ($summaryInfo['chart'] ['available_comparison_types'] as $chartType) {
        $availableComparisonTypes[] = "'$chartType'";
    }
    $availableComparisonTypes = implode(', ', $availableComparisonTypes);

    $availableModes = [];
    foreach ($summaryInfo['chart'] ['available_modes'] as $chartMode) {
        $availableModes[] = "'$chartMode'";
    }
    $availableModes = implode(', ', $availableModes);

    $fillEmptyCaptionOption = $summaryInfo['chart'] ['fill_empty_caption'] ? 'true' : 'false';
    $hideLabelEmptyValuesOption = $summaryInfo['chart'] ['hide_label_empty_values'] ? 'true' : 'false';

    $phpCode = <<<EOT
            'chart' => [
                'page_title' => '',
                'chart_title' => "{$summaryInfo['chart'] ['chart_title']}",
                'fill_empty_caption' => $fillEmptyCaptionOption,
                'hide_label_empty_values' => $hideLabelEmptyValuesOption,
                'available_types' => [$availableTypes],
                'available_comparison_types' => [$availableComparisonTypes],
                'default_type' => '{$summaryInfo['chart'] ['default_type']}',
                'available_modes' => [$availableModes],
                'default_mode' => '{$summaryInfo['chart'] ['default_mode']}',
                'json_filename' => "sc_fc_{$summaryInfo['general'] ['app_name_file']}_{\$chartMd5}.json",
                'json_base_dir' => \$this->Ini->root . \$this->Ini->path_imag_temp . '/',
                'json_base_url' => \$this->Ini->path_imag_temp . '/',
                'fusioncharts_fix' => '',
            ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_chart

/**
 * Inicializa a secao types do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_types()
{
    global $summaryInfo;

    $phpCode = <<<EOT
            'types' => [

EOT;
    $availableTypes = array_unique(array_merge($summaryInfo['chart'] ['available_types'], $summaryInfo['chart'] ['available_comparison_types']));
    foreach ($availableTypes as $chartType) {
        switch ($chartType) {
            case 'Area':
                $phpCode .= fnChart_info_initializeInfo_types_area();
                break;
            case 'Bar':
                $phpCode .= fnChart_info_initializeInfo_types_bar();
                break;
            case 'Chord':
                $phpCode .= fnChart_info_initializeInfo_types_chord();
                break;
            case 'Combination':
                $phpCode .= fnChart_info_initializeInfo_types_combination();
                break;
            case 'Funnel':
                $phpCode .= fnChart_info_initializeInfo_types_funnel();
                break;
            case 'Gauge':
                $phpCode .= fnChart_info_initializeInfo_types_gauge();
                break;
            case 'Heatmap':
                $phpCode .= fnChart_info_initializeInfo_types_heatmap();
                break;
            case 'Line':
                $phpCode .= fnChart_info_initializeInfo_types_line();
                break;
            case 'Pie':
                $phpCode .= fnChart_info_initializeInfo_types_pie();
                break;
            case 'Pyramid':
                $phpCode .= fnChart_info_initializeInfo_types_pyramid();
                break;
            case 'Radar':
                $phpCode .= fnChart_info_initializeInfo_types_radar();
                break;
            case 'Sankey':
                $phpCode .= fnChart_info_initializeInfo_types_sankey();
                break;
            case 'Sunburst':
                $phpCode .= fnChart_info_initializeInfo_types_sunburst();
                break;
            case 'Treemap':
                $phpCode .= fnChart_info_initializeInfo_types_treemap();
                break;
        }
    }
    $phpCode .= <<<EOT
            ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_types

/**
 * Inicializa a secao area dos tipos de graficos do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_types_area()
{
    global $summaryInfo;

    $stackingOption = $summaryInfo['chart'] ['types'] ['area'] ['stacking'] ? 'true' : 'false';

    $phpCode = <<<EOT
                'area' => [
                    'format' => '{$summaryInfo['chart'] ['types'] ['area'] ['format']}',
                    'stacking' => $stackingOption,
                    'isScroll' => '{$summaryInfo['chart'] ['types'] ['area'] ['isScroll']}',
                ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_types_area

/**
 * Inicializa a secao bar dos tipos de graficos do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_types_bar()
{
    global $summaryInfo;

    $stackingOption = $summaryInfo['chart'] ['types'] ['bar'] ['stacking'] ? 'true' : 'false';

    $phpCode = <<<EOT
                'bar' => [
                    'orientation' => '{$summaryInfo['chart'] ['types'] ['bar'] ['orientation']}',
                    'dimension' => '{$summaryInfo['chart'] ['types'] ['bar'] ['dimension']}',
                    'plotSpacePercent' => '{$summaryInfo['chart'] ['types'] ['bar'] ['plotSpacePercent']}',
                    'rotateValues' => '{$summaryInfo['chart'] ['types'] ['bar'] ['rotateValues']}',
                    'placeValuesInside' => '{$summaryInfo['chart'] ['types'] ['bar'] ['placeValuesInside']}',
                    'stacking' => $stackingOption,
                    'stack100Percent' => '{$summaryInfo['chart'] ['types'] ['bar'] ['stack100Percent']}',
                    'seriesMode' => '{$summaryInfo['chart'] ['types'] ['bar'] ['seriesMode']}',
                    'isScroll' => '{$summaryInfo['chart'] ['types'] ['bar'] ['isScroll']}',
                    'isOverlapped' => '{$summaryInfo['chart'] ['types'] ['bar'] ['isOverlapped']}',
                ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_types_bar

/**
 * Inicializa a secao chord dos tipos de graficos do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_types_chord()
{
    $phpCode = <<<EOT
                'chord' => [
                ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_types_chord

/**
 * Inicializa a secao combination dos tipos de graficos do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_types_combination()
{
    global $summaryInfo;

    $phpCode = <<<EOT
                'combination' => [
                ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_types_combination

/**
 * Inicializa a secao funnel dos tipos de graficos do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_types_funnel()
{
    global $summaryInfo;

    $displayValuesExceptionOption = in_array('funnel', $summaryInfo['chart'] ['display_values_exception']) ? 'true' : 'false';

    $phpCode = <<<EOT
                'funnel' => [
                    'dimension' => '{$summaryInfo['chart'] ['types'] ['funnel'] ['dimension']}',
                    'streamlinedData' => '{$summaryInfo['chart'] ['types'] ['funnel'] ['streamlinedData']}',
                    'displayValuesException' => $displayValuesExceptionOption,
                ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_types_funnel

/**
 * Inicializa a secao gauge dos tipos de graficos do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_types_gauge()
{
    global $summaryInfo;

    $showTicks = $summaryInfo['chart'] ['gauge_show_ticks'] ? 'true' : 'false';
    $useInterval = $summaryInfo['chart'] ['use_gauge_interval'] ? 'true' : 'false';

    $phpCode = <<<EOT
                'gauge' => [
                    'format' => '{$summaryInfo['chart'] ['types'] ['gauge'] ['format']}',
                    'show_ticks' => $showTicks,
                    'use_interval' => $useInterval,
                    'interval_colors' => [

EOT;
    if ($summaryInfo['chart'] ['use_gauge_interval']) {
        foreach ($summaryInfo['chart'] ['gauge_interval_colors'] as $intervalColorInfo) {
            $phpCode .= <<<EOT
                        [
                            'minValue' => '{$intervalColorInfo['low']}',
                            'maxValue' => '{$intervalColorInfo['high']}',
                            'code' => '{$intervalColorInfo['color']}',
                        ],

EOT;
        }
    }
    $phpCode .= <<<EOT
                    ],
                ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_types_gauge

/**
 * Inicializa a secao heatmap dos tipos de graficos do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_types_heatmap()
{
    $phpCode = <<<EOT
                'heatmap' => [
                ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_types_heatmap

/**
 * Inicializa a secao line dos tipos de graficos do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_types_line()
{
    global $summaryInfo;

    $phpCode = <<<EOT
                'line' => [
                    'format' => '{$summaryInfo['chart'] ['types'] ['line'] ['format']}',
                    'seriesMode' => '{$summaryInfo['chart'] ['types'] ['line'] ['seriesMode']}',
                    'isScroll' => '{$summaryInfo['chart'] ['types'] ['line'] ['isScroll']}',
                    'isZoom' => '{$summaryInfo['chart'] ['types'] ['line'] ['isZoom']}',
                ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_types_line

/**
 * Inicializa a secao pie dos tipos de graficos do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_types_pie()
{
    global $summaryInfo;

    $orderOption = strtolower($summaryInfo['chart'] ['types'] ['pie'] ['order']);
    $showPercentValuesOption = $summaryInfo['chart'] ['types'] ['pie'] ['showPercentValues'] ? 'true' : 'false';
    $displayValuesExceptionOption = in_array('pie', $summaryInfo['chart'] ['display_values_exception']) ? 'true' : 'false';

    $phpCode = <<<EOT
                'pie' => [
                    'format' => '{$summaryInfo['chart'] ['types'] ['pie'] ['format']}',
                    'dimension' => '{$summaryInfo['chart'] ['types'] ['pie'] ['dimension']}',
                    'order' => '{$orderOption}',
                    'showPercentValues' => $showPercentValuesOption,
                    'displayValuesException' => $displayValuesExceptionOption,
                ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_types_pie

/**
 * Inicializa a secao pyramid dos tipos de graficos do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_types_pyramid()
{
    global $summaryInfo;

    $showPercentValuesOption = $summaryInfo['chart'] ['types'] ['pyramid'] ['showPercentValues'] ? 'true' : 'false';
    $isSlicedOption = $summaryInfo['chart'] ['types'] ['pyramid'] ['isSliced'] ? 'true' : 'false';
    $displayValuesExceptionOption = in_array('pyramid', $summaryInfo['chart'] ['display_values_exception']) ? 'true' : 'false';

    $phpCode = <<<EOT
                'pyramid' => [
                    'dimension' => '{$summaryInfo['chart'] ['types'] ['pyramid'] ['dimension']}',
                    'isSliced' => $isSlicedOption,
                    'displayValuesException' => $displayValuesExceptionOption,
                ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_types_pyramid

/**
 * Inicializa a secao radar dos tipos de graficos do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_types_radar()
{
    $phpCode = <<<EOT
                'radar' => [
                ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_types_radar

/**
 * Inicializa a secao sankey dos tipos de graficos do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_types_sankey()
{
    $phpCode = <<<EOT
                'sankey' => [
                ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_types_sankey

/**
 * Inicializa a secao sunburst dos tipos de graficos do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_types_sunburst()
{
    $phpCode = <<<EOT
                'sunburst' => [
                ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_types_sunburst

/**
 * Inicializa a secao treemap dos tipos de graficos do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_types_treemap()
{
    $phpCode = <<<EOT
                'treemap' => [
                ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_types_treemap

/**
 * Inicializa a secao options do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_options()
{
    global $summaryInfo;

    $useFontawesomeOption = $summaryInfo['options'] ['use_fontawesome'] ? 'true' : 'false';
    $chartSamePageOption = $summaryInfo['options'] ['chart_same_page'] ? 'true' : 'false';
    $tooltipExpanderOption = $summaryInfo['chart'] ['tooltip_expanded'] ? 'true' : 'false';
    $formatNumberScaleOption = $summaryInfo['chart'] ['formatNumberScale'] ? 'true' : 'false';
    $setAdaptiveYMinOption = $summaryInfo['chart'] ['setAdaptiveYMin'] ? 'true' : 'false';
    $showValuesOption = $summaryInfo['chart'] ['display_values'] ? 'true' : 'false';
    $hasTrendlineOption = $summaryInfo['chart'] ['has_trendline'] ? 'true' : 'false';
    $trendlineIsZoneOption = $summaryInfo['chart'] ['trendline_is_zone'] ? 'true' : 'false';

    $phpCode = <<<EOT
            'options' => [
                'md5' => \$chartMd5,
                'charset' => \$charset,
                'favicon' => '{$summaryInfo['options'] ['favicon']}',
                'summary_css' => \$summaryCss,
                'use_fontawesome' => $useFontawesomeOption,
                'chart_same_page' => $chartSamePageOption,
                'tooltip_expanded' => $tooltipExpanderOption,
                'formatNumberScale' => $formatNumberScaleOption,
                'legendPosition' => '{$summaryInfo['chart'] ['legendPosition']}',
                'setAdaptiveYMin' => $setAdaptiveYMinOption,
                'showValues' => $showValuesOption,
                'hasTrendline' => $hasTrendlineOption,
                'trendlineIsZone' => $trendlineIsZoneOption,
                'trendlineType' => '{$summaryInfo['chart'] ['trendline_type']}',
                'trendlineStart' => {$summaryInfo['chart'] ['trendline_start']},
                'trendlineEnd' => {$summaryInfo['chart'] ['trendline_end']},
            ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_options

/**
 * Inicializa a secao css do array de informacoes a ser usado na geracao do grafico
 */
function fnChart_info_initializeInfo_css()
{
    $phpCode = <<<EOT
            'css' => [
                'chart_page' => 'scGridPage',
            ],

EOT;

    return $phpCode;
} // fnChart_info_initializeInfo_css

/**
 * Inicializa o array de dados calculados para geracao do grafico
 */
function fnChart_info_initializeData($file)
{
    global $summaryInfo;

    if ($summaryInfo['options'] ['display_inline_chart']) {
        $chartWidth = $summaryInfo['chart'] ['inline_width'];
        $chartHeight = $summaryInfo['chart'] ['inline_height'];
    } else {
        $chartWidth = $summaryInfo['chart'] ['width'];
        $chartHeight = $summaryInfo['chart'] ['height'];
    }

    $phpCode = <<<EOT
    function info_initializeData()
    {
        \$this->SC_APP_data = [
            'type' => '',
            'order' => '',
            'width' => '{$chartWidth}',
            'height' => '{$chartHeight}',
            'phantom_width' => '{$summaryInfo['chart'] ['width']}',
            'phantom_height' => '{$summaryInfo['chart'] ['height']}',
            'data_mode' => '',
            'series_mode' => '',
            'md5_data' => [],
            'chart_id' => 'id_chart_' . mt_rand(1, 1000),
            'chart_div' => 'id_div_' . mt_rand(1, 1000),
            'chart_dataFormat' => 'jsonurl',
            'limit_chart_items' => '',
            'filtered_chart_items' => [],
            'fusioncharts_license' => [],
            'fusioncharts_javascript' => [],
            'fusioncharts_json' => [],
        ];

        if (\$this->aux_isResponsive()) {
            \$this->SC_APP_data['width'] = '100%';
            \$this->SC_APP_data['height'] = '85%';
        } elseif (\$this->aux_isMobile()) {
            \$this->SC_APP_data['width'] = '100%';
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_initializeData

/**
 * Carrega informacoes do grafico a ser gerado
 */
function fnChart_info_loadMd5Info($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function info_loadMd5Info(\$chartMd5)
    {
        \$chartInfo = \$this->aux_getChartInfoType();

        \$this->SC_APP_data['md5_data'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] [\$chartInfo] [\$chartMd5];

        \$pageTitle = \$this->aux_isUtf8() ? \$this->aux_getMetricLabel(\$this->SC_APP_data['md5_data'] ['metric']) : sc_convert_encoding(\$this->aux_getMetricLabel(\$this->SC_APP_data['md5_data'] ['metric']), \$_SESSION['scriptcase'] ['charset'], 'UTF-8');

        \$this->SC_APP_info['chart'] ['page_title'] = \$pageTitle;
        \$this->SC_APP_data['type'] = \$this->SC_APP_info['chart'] ['default_type'];
        \$this->SC_APP_data['data_mode'] = \$this->SC_APP_info['chart'] ['default_mode'];
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_loadMd5Info

/**
 * Carrega configuracoes do grafico a ser gerado
 */
function fnChart_info_loadSessionInfo($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function info_loadSessionInfo(\$chartMd5)
    {
        \$this->SC_APP_data['type'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'];
        \$this->SC_APP_data['data_mode'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['graf_opc_atual'];

        \$this->SC_APP_data['width'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_larg'];
        \$this->SC_APP_data['height'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_alt'];

        \$this->SC_APP_data['order'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['graf_order'];

        \$this->SC_APP_info['types'] ['area'] ['format'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_area_forma'];
        \$this->SC_APP_info['types'] ['area'] ['stacking'] = 'Off' != \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_area_empil'];
        \$this->SC_APP_info['types'] ['area'] ['isScroll'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_area_is_scroll'];

        \$this->SC_APP_info['types'] ['bar'] ['orientation'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_orien'];
        \$this->SC_APP_info['types'] ['bar'] ['dimension'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_dimen'];
        \$this->SC_APP_info['types'] ['bar'] ['stacking'] = 'Off' != \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_empil'];
        \$this->SC_APP_info['types'] ['bar'] ['stack100Percent'] = 'Percent' == \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_empil'] ? '1' : '0';
        \$this->SC_APP_info['types'] ['bar'] ['seriesMode'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_agrup'];
        \$this->SC_APP_info['types'] ['bar'] ['isScroll'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_scroll'];
        \$this->SC_APP_info['types'] ['bar'] ['isOverlapped'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_overlapped'];

        \$this->SC_APP_info['types'] ['funnel'] ['dimension'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_funil_dimen'];

        \$this->SC_APP_info['types'] ['gauge'] ['format'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_gauge_forma'];

        \$this->SC_APP_info['types'] ['line'] ['format'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_forma'];
        \$this->SC_APP_info['types'] ['line'] ['seriesMode'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_agrup'];
        \$this->SC_APP_info['types'] ['line'] ['isScroll'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_is_scroll'];
        \$this->SC_APP_info['types'] ['line'] ['isZoom'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_is_zoom'];

        \$this->SC_APP_info['types'] ['pie'] ['format'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pizza_forma'];
        \$this->SC_APP_info['types'] ['pie'] ['dimension'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pizza_dimen'];
        \$this->SC_APP_info['types'] ['pie'] ['order'] = strtolower(\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pizza_orden']);
        \$this->SC_APP_info['types'] ['pie'] ['showPercentValues'] = 'Percent' == \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pizza_valor'];

        \$this->SC_APP_info['types'] ['pyramid'] ['dimension'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pyram_dimen'];
        \$this->SC_APP_info['types'] ['pyramid'] ['showPercentValues'] = 'Percent' == \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pyram_valor'];
        \$this->SC_APP_info['types'] ['pyramid'] ['isSliced'] = 'S' == \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pyram_forma'];

        \$this->SC_APP_info['types'] ['combination'] ['dimension'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_combi_dimen'];

EOT;
    if (!$summaryInfo['general'] ['app_type_chart'] && $summaryInfo['chart'] ['grid_chart_enable_scroll']) {
        $phpCode .= <<<EOT

        if (\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['chart_has_enable_scroll']) {
            \$this->SC_APP_info['types'] ['area'] ['isScroll'] = 'S' == \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['chart_enable_scroll'];
            \$this->SC_APP_info['types'] ['bar'] ['isScroll'] = 'S' == \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['chart_enable_scroll'];
            \$this->SC_APP_info['types'] ['line'] ['isScroll'] = 'S' == \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['chart_enable_scroll'];
        } else {
            \$this->SC_APP_info['types'] ['area'] ['isScroll'] = false;
            \$this->SC_APP_info['types'] ['bar'] ['isScroll'] = false;
            \$this->SC_APP_info['types'] ['line'] ['isScroll'] = false;
        }

EOT;
    }
    $phpCode .= <<<EOT
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_loadSessionInfo

/**
 * Define o modo de exibicao das series em graficos multi series
 */
function fnChart_info_setSeriesMode($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function info_setSeriesMode()
    {
        switch (\$this->SC_APP_data['type']) {
            case 'Area':
            case 'Bar':
            case 'Line':

EOT;
    if ($summaryInfo['general'] ['app_type_chart']) {
        $phpCode .= <<<EOT
                \$chatAppDisplaySerie = (!isset(\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['summarizing_drill_down']) || !\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['summarizing_drill_down']) && 1 == count(\$this->SC_APP_data['md5_data'] ['metric']);

EOT;
    } else {
        $phpCode .= <<<EOT
                \$chatAppDisplaySerie = false;

EOT;

    }
    $phpCode .= <<<EOT

                if (\$chatAppDisplaySerie) {
                    \$this->SC_APP_data['data_mode'] = self::CHART_MODE_ANALYTIC;
                    \$this->SC_APP_data['series_mode'] = 'set';
                } elseif ('Series' == \$this->SC_APP_info['types'] ['bar'] ['seriesMode']) {
                    \$this->SC_APP_data['series_mode'] = 'serie';
                } else {
                    \$this->SC_APP_data['series_mode'] = 'set';
                }
                break;

            default:
                \$this->SC_APP_data['series_mode'] = 'set';
                break;
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_setSeriesMode

/**
 * Define o limite de itens para exibicao no grafico
 */
function fnChart_info_setChartItemsLimit($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function info_setChartItemsLimit()
    {
        if (\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['has_limit_chart_items']) {
            if ('' != \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['limit_chart_items'] && '0' != \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['limit_chart_items']) {
                \$this->SC_APP_data['limit_chart_items'] = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['limit_chart_items'];
            } elseif (isset(\$this->SC_APP_data['md5_data'] ['options'] ['limit_chart_items']) && '' != \$this->SC_APP_data['md5_data'] ['options'] ['limit_chart_items']) {
                \$this->SC_APP_data['limit_chart_items'] = \$this->SC_APP_data['md5_data'] ['options'] ['limit_chart_items'];
            }
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_setChartItemsLimit

/**
 * Cria as informacoes para geracao de um grafico do FusionCharts
 */
function fnChart_info_createFusionChartsData($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData(\$isExport)
    {
        if (\$this->SC_APP_data['md5_data'] ['options'] ['is_grand_total']) {
            \$this->SC_APP_info['options'] ['tooltip_expanded'] = false;
        }

        \$this->info_createFusionChartsData_json(\$isExport);
        \$this->info_createFusionChartsData_javascript();
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData

/**
 * Cria as informacoes do codigo javascript do FusionCharts
 */
function fnChart_info_createFusionChartsData_javascript($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_javascript()
    {
        \$this->SC_APP_data['fusioncharts_javascript'] ['type'] = \$this->aux_getFusionChartsRenderer();
        \$this->SC_APP_data['fusioncharts_javascript'] ['width'] = \$this->SC_APP_data['width'];
        \$this->SC_APP_data['fusioncharts_javascript'] ['height'] = \$this->SC_APP_data['height'];
        \$this->SC_APP_data['fusioncharts_javascript'] ['dataFormat'] = 'jsonurl';
        \$this->SC_APP_data['fusioncharts_javascript'] ['dataSource'] = \$this->SC_APP_info['chart'] ['json_base_url'] . \$this->SC_APP_info['chart'] ['json_filename'];

        if (\$this->aux_isResponsive()) {
            \$this->SC_APP_data['fusioncharts_javascript'] ['width'] = '100%';
            \$this->SC_APP_data['fusioncharts_javascript'] ['height'] = '85%';
        } elseif (\$this->aux_isMobile()) {
            \$this->SC_APP_data['fusioncharts_javascript'] ['width'] = '100%';
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_javascript

/**
 * Cria as informacoes de configuracao json do FusionCharts
 *
 * ['subCaption'] = ''; => colocado para inibir a dupla exibicao da informacao contida agora no breadcrumb
 */
function fnChart_info_createFusionChartsData_json($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json(\$isExport)
    {
        \$this->info_createFusionChartsData_json_chart(\$isExport);

        switch (\$this->SC_APP_data['type']) {
            case 'Area':
                \$this->info_createFusionChartsData_json_type_area();
                break;
            case 'Bar':
                \$this->info_createFusionChartsData_json_type_bar();
                break;
            case 'Chord':
                \$this->info_createFusionChartsData_json_type_chord();
                break;
            case 'Combination':
                \$this->info_createFusionChartsData_json_type_combination();
                break;
            case 'Funnel':
                \$this->info_createFusionChartsData_json_type_funnel();
                break;
            case 'Gauge':
                \$this->info_createFusionChartsData_json_type_gauge();
                break;
            case 'Heatmap':
                \$this->info_createFusionChartsData_json_type_heatmap();
                break;
            case 'Line':
                \$this->info_createFusionChartsData_json_type_line();
                break;
            case 'Pie':
                \$this->info_createFusionChartsData_json_type_pie();
                break;
            case 'Pyramid':
                \$this->info_createFusionChartsData_json_type_pyramid();
                break;
            case 'Radar':
                \$this->info_createFusionChartsData_json_type_radar();
                break;
            case 'Sankey':
                \$this->info_createFusionChartsData_json_type_sankey();
                break;
            case 'Sunburst':
                \$this->info_createFusionChartsData_json_type_sunburst();
                break;
            case 'Treemap':
                \$this->info_createFusionChartsData_json_type_treemap();
                break;
        }

        \$this->info_createFusionChartsData_json_data_series();

        \$this->info_createFusionChartsData_json_data_order();
        \$this->info_createFusionChartsData_json_data_trendline();

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['subCaption'] = '';
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json

/**
 * Cria as informacoes de configuracao gerais json do FusionCharts
 */
function fnChart_info_createFusionChartsData_json_chart($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_chart(\$isExport)
    {
        \$this->SC_APP_data['fusioncharts_json'] ['sc'] ['chart_md5'] = \$this->SC_APP_info['options'] ['md5'];
        \$this->SC_APP_data['fusioncharts_json'] ['sc'] ['chart_title'] = \$this->aux_getMetricLabel(\$this->SC_APP_data['md5_data'] ['metric']);

        \$chartCaption = '';
        if ('' != \$this->SC_APP_info['chart'] ['chart_title']) {
            \$chartCaption = \$this->SC_APP_info['chart'] ['chart_title'];
        } elseif (\$this->SC_APP_info['chart'] ['fill_empty_caption']) {
            \$chartCaption = \$this->aux_getMetricLabel(\$this->SC_APP_data['md5_data'] ['metric']);
        }

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] = [
            'caption' => \$chartCaption,
            'subCaption' => \$this->info_createFusionChartsData_json_chart_subtitle(),
            'xAxisName' => \$this->SC_APP_data['md5_data'] ['dimension'] ['label'],
            'yAxisName' => \$this->aux_getMetricLabel(\$this->SC_APP_data['md5_data'] ['metric']),
            'chartLeftMargin' => '10',
            'chartTopMargin' => '10',
            'chartRightMargin' => '10',
            'plotHighlightEffect' => 'fadeout',
            'showValues' => \$this->SC_APP_info['options'] ['showValues'] ? '1' : '0',
        ];

        if (\$this->SC_APP_info['options'] ['formatNumberScale']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['formatNumberScale'] = '1';
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['numberScaleValue'] = '1000,1000,1000,1000';
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['numberScaleUnit']  = 'K,M,G,T';
        } else {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['formatNumberScale'] = '0';
        }

        if (\$this->SC_APP_info['options'] ['setAdaptiveYMin']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['setAdaptiveYMin'] = '1';
        }

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showLegend'] = '1';

        \$this->info_createFusionChartsData_json_chart_format();
        \$this->info_createFusionChartsData_json_chart_theme();
        \$this->info_createFusionChartsData_json_chart_export(\$isExport);

        if ('below' == \$this->SC_APP_info['options'] ['legendPosition']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['legendPosition'] = 'bottom';
        } elseif ('right' == \$this->SC_APP_info['options'] ['legendPosition']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['legendPosition'] = 'right';
        } elseif ('hide' == \$this->SC_APP_info['options'] ['legendPosition']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showLegend'] = '0';
        }

        if (\$isExport) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['animation'] = '0';
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_chart

/**
 * Define as configuracoes para exportar grafico pelo Fusioncharts
 */
function fnChart_info_createFusionChartsData_json_chart_export($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function info_createFusionChartsData_json_chart_export(\$isExport)
    {
        if (\$isExport) {
            return;
        }

EOT;
    if ($summaryInfo['chart'] ['export_chart_button']) {
        $phpCode .= <<<EOT

        \$exportFormats = [
            'png' => 'PNG=' . \$this->Ini->Nm_lang['fusioncharts_export_png'],
            'jpg' => 'JPG=' . \$this->Ini->Nm_lang['fusioncharts_export_jpg'],
            'pdf' => 'PDF=' . \$this->Ini->Nm_lang['fusioncharts_export_pdf'],
            'svg' => 'SVG=' . \$this->Ini->Nm_lang['fusioncharts_export_svg'],
            'csv' => 'CSV=' . \$this->Ini->Nm_lang['fusioncharts_export_csv'],
            'xlsx' => 'XLSX=' . \$this->Ini->Nm_lang['fusioncharts_export_xlsx'],
        ];

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['exportEnabled'] = '1';
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['exportMode'] = 'client';
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['exportFileName'] = "{$summaryInfo['general'] ['app_name_export_chart']}";
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['exportFormats'] = implode('|', \$exportFormats);

EOT;
    }
    $phpCode .= <<<EOT
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_chart_export

/**
 * Define as regras de formatacao para valores do grafico
 */
function fnChart_info_createFusionChartsData_json_chart_format($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_chart_format()
    {
        \$formatFunction = \$this->SC_APP_data['md5_data'] ['metric'] [0] ['format'];

        if (!\$formatFunction) {
            return;
        }

        \$formatRules = \$this->\$formatFunction();
        foreach (\$formatRules as \$formatIndex => \$formatValue) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] [\$formatIndex] = \$formatValue;
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_chart_format

/**
 * Cria o subtitulo do grafico
 */
function fnChart_info_createFusionChartsData_json_chart_subtitle($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_chart_subtitle()
    {
        \$parameters = [];
        \$lastParameter = '';

        foreach (\$this->SC_APP_data['md5_data'] ['parameters'] as \$parameterInfo) {
            \$lastParameter = "{\$parameterInfo['field_label']} = {\$parameterInfo['label']}";
            \$parameters[] = \$lastParameter;
        }

        \$this->SC_APP_data['fusioncharts_json'] ['sc'] ['chart_subtitle'] = \$lastParameter;

        return implode(' :: ', \$parameters);
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_chart_subtitle

/**
 * Cria a configuracao visual do grafico
 */
function fnChart_info_createFusionChartsData_json_chart_theme($file)
{
    global $summaryInfo;

    $gradientColorList = [];
    foreach ($summaryInfo['chart'] ['tree_heat_map_color_list'] as $gradientColor) {
        if ('#' == substr($gradientColor, 0, 1)) {
            $gradientColor = substr($gradientColor, 1);
        }
        $gradientColorList[] = "'$gradientColor'";
    }
    $gradientColorList = implode(', ', $gradientColorList);

    $phpCode = <<<EOT
    function info_createFusionChartsData_json_chart_theme()
    {
        \$this->chartTheme = \$this->load_chart_theme();
        \$this->chartGradient = [$gradientColorList];

        foreach (\$this->chartTheme as \$property => \$value) {
            if ('' != \$value) {
                if ('gradientColors' == \$property) {
                    if ('' != \$value) {
                        \$gradientColors = explode(',', \$value);
                        \$this->chartGradient = [];
                        foreach (\$gradientColors as \$thisGradientColor) {
                            if ('#' == substr(\$thisGradientColor, 0, 1)) {
                                \$thisGradientColor = substr(\$thisGradientColor, 1);
                            }
                            \$this->chartGradient[] = \$thisGradientColor;
                        }
                    }
                } else {
                    \$this->SC_APP_data['fusioncharts_json'] ['chart'] [\$property] = \$value;
                }
            }
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_chart_theme

/**
 * Cria as informacoes de configuracao json do FusionCharts para graficos do tipo area
 */
function fnChart_info_createFusionChartsData_json_type_area($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_type_area()
    {
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_type_area

/**
 * Cria as informacoes de configuracao json do FusionCharts para graficos do tipo bar
 */
function fnChart_info_createFusionChartsData_json_type_bar($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_type_bar()
    {
        if ('' != \$this->SC_APP_info['types'] ['bar'] ['plotSpacePercent']) {
            if (20 > \$this->SC_APP_info['types'] ['bar'] ['plotSpacePercent']) {
                \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['plotSpacePercent'] = '20';
            } elseif (80 < \$this->SC_APP_info['types'] ['bar'] ['plotSpacePercent']) {
                \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['plotSpacePercent'] = '80';
            } else {
                \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['plotSpacePercent'] = \$this->SC_APP_info['types'] ['bar'] ['plotSpacePercent'];
            }
        }
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['rotateValues'] = \$this->SC_APP_info['types'] ['bar'] ['rotateValues'];
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['placeValuesInside'] = \$this->SC_APP_info['types'] ['bar'] ['placeValuesInside'];
        if (1 == \$this->SC_APP_info['types'] ['bar'] ['stack100Percent'] && \$this->aux_isMultiSeries()) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['stack100Percent'] = '1';
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showPercentValues'] = '0';
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_type_bar

/**
 * Cria as informacoes de configuracao json do FusionCharts para graficos do tipo chord
 */
function fnChart_info_createFusionChartsData_json_type_chord($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_type_chord()
    {
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['nodeLabelPosition'] = 'outside';
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_type_chord

/**
 * Cria as informacoes de configuracao json do FusionCharts para graficos do tipo combination
 */
function fnChart_info_createFusionChartsData_json_type_combination($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_type_combination()
    {
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['rotateValues'] = \$this->SC_APP_info['types'] ['bar'] ['rotateValues'];
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['placeValuesInside'] = \$this->SC_APP_info['types'] ['bar'] ['placeValuesInside'];
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_type_combination

/**
 * Cria as informacoes de configuracao json do FusionCharts para graficos do tipo funnel
 */
function fnChart_info_createFusionChartsData_json_type_funnel($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_type_funnel()
    {
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['useSameSlantAngle'] = '1';
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['isHollow'] = '0';
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showLabels'] = '0';

        if (\$this->SC_APP_info['types'] ['funnel'] ['displayValuesException']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showValues'] = '0';
        }

        if ('2d' == \$this->SC_APP_info['types'] ['funnel'] ['dimension']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['is2D'] = '1';
        }

        if ('0' == \$this->SC_APP_info['types'] ['funnel'] ['streamlinedData']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['streamlinedData'] = '0';
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_type_funnel

/**
 * Cria as informacoes de configuracao json do FusionCharts para graficos do tipo gauge
 */
function fnChart_info_createFusionChartsData_json_type_gauge($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_type_gauge()
    {
        if ('Circular' == \$this->SC_APP_info['types'] ['gauge'] ['format']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['gaugeStartAngle'] = '180';
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['gaugeEndAngle'] = '-180';
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['lowerLimitDisplay'] = ' ';
        }

        if (\$this->SC_APP_info['types'] ['gauge'] ['show_ticks']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['majorTMNumber'] = '9';
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['majorTMHeight'] = '15';
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['majorTMThickness'] = '2';

            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['minorTMNumber'] = '4';
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['minorTMHeight'] = '10';
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['minorTMThickness'] = '1';
        }

        if (\$this->SC_APP_info['types'] ['gauge'] ['use_interval']) {
            \$this->SC_APP_data['fusioncharts_json'] ['colorRange'] = [
                'color' => \$this->SC_APP_info['types'] ['gauge'] ['interval_colors']
            ];
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_type_gauge

/**
 * Cria as informacoes de configuracao json do FusionCharts para graficos do tipo heatmap
 */
function fnChart_info_createFusionChartsData_json_type_heatmap($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_type_heatmap()
    {
        \$this->SC_APP_data['fusioncharts_json'] ['colorrange'] ['gradient'] = '1';
        \$this->SC_APP_data['fusioncharts_json'] ['colorrange'] ['startlabel'] = '';
        \$this->SC_APP_data['fusioncharts_json'] ['colorrange'] ['endlabel'] = '';

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showplotborder'] = '1';
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_type_heatmap

/**
 * Cria as informacoes de configuracao json do FusionCharts para graficos do tipo line
 */
function fnChart_info_createFusionChartsData_json_type_line($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_type_line()
    {
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_type_line

/**
 * Cria as informacoes de configuracao json do FusionCharts para graficos do tipo pie
 */
function fnChart_info_createFusionChartsData_json_type_pie($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_type_pie()
    {
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['use3DLighting'] = '0';

        if (\$this->SC_APP_info['types'] ['pie'] ['displayValuesException']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showValues'] = '0';
        }

        if (\$this->SC_APP_info['types'] ['pie'] ['showPercentValues']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showPercentValues'] = '1';
        } else {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showPercentValues'] = '0';
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_type_pie

/**
 * Cria as informacoes de configuracao json do FusionCharts para graficos do tipo pyramid
 */
function fnChart_info_createFusionChartsData_json_type_pyramid($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_type_pyramid()
    {
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showLabels'] = '0';

        if (\$this->SC_APP_info['types'] ['pyramid'] ['displayValuesException']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showValues'] = '0';
        }

        if ('2d' == \$this->SC_APP_info['types'] ['pyramid'] ['dimension']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['is2D'] = '1';
        }

        if (\$this->SC_APP_info['types'] ['pyramid'] ['showPercentValues']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showPercentValues'] = '1';
        } else {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showPercentValues'] = '0';
        }

        if (\$this->SC_APP_info['types'] ['pyramid'] ['isSliced']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['isSliced'] = '1';
        } else {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['isSliced'] = '0';
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_type_pyramid

/**
 * Cria as informacoes de configuracao json do FusionCharts para graficos do tipo radar
 */
function fnChart_info_createFusionChartsData_json_type_radar($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_type_radar()
    {
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_type_radar

/**
 * Cria as informacoes de configuracao json do FusionCharts para graficos do tipo sankey
 */
function fnChart_info_createFusionChartsData_json_type_sankey($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_type_sankey()
    {
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['linkColor'] = 'blend';
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_type_sankey

/**
 * Cria as informacoes de configuracao json do FusionCharts para graficos do tipo sunburst
 */
function fnChart_info_createFusionChartsData_json_type_sunburst($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_type_sunburst()
    {
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_type_sunburst

/**
 * Cria as informacoes de configuracao json do FusionCharts para graficos do tipo treemap
 */
function fnChart_info_createFusionChartsData_json_type_treemap($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_type_treemap()
    {
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['algorithm'] = 'squarified';

        if (isset(\$this->SC_APP_data['fusioncharts_json'] ['chart'] ['labelFontSize']) && '' != \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['labelFontSize']) {
            \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['parentLabelLineHeight'] = 4 + \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['labelFontSize'];
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_type_treemap

/**
 * Cria as informacoes de configuracao json das series de dados
 */
function fnChart_info_createFusionChartsData_json_data_series($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_series()
    {
        if (0 < \$this->SC_APP_data['limit_chart_items']) {
            \$this->aux_filterChartItems();
        }

        \$this->aux_setFusionchartsFix();

        if (\$this->SC_APP_data['md5_data'] ['options'] ['is_comparison']) {
            \$this->info_createFusionChartsData_json_data_comparisonSeries();
        } elseif ('Line' == \$this->SC_APP_data['type'] && 'Step' == \$this->SC_APP_info['types'] ['line'] ['format'] && !\$this->aux_isMultiSeries()) {
            \$this->info_createFusionChartsData_json_data_singleSerieCategorySeries();
        } elseif ('Bar' == \$this->SC_APP_data['type'] && \$this->SC_APP_info['types'] ['bar'] ['isScroll'] && !\$this->aux_isMultiSeries()) {
            \$this->info_createFusionChartsData_json_data_singleSerieCategorySeries();
        } elseif ('Line' == \$this->SC_APP_data['type'] && \$this->SC_APP_info['types'] ['line'] ['isScroll'] && !\$this->aux_isMultiSeries()) {
            \$this->info_createFusionChartsData_json_data_singleSerieCategorySeries();
        } elseif ('Line' == \$this->SC_APP_data['type'] && \$this->SC_APP_info['types'] ['line'] ['isZoom'] && !\$this->aux_isMultiSeries()) {
            \$this->info_createFusionChartsData_json_data_singleSerieCategorySeries();
        } elseif ('Area' == \$this->SC_APP_data['type'] && \$this->SC_APP_info['types'] ['area'] ['isScroll'] && !\$this->aux_isMultiSeries()) {
            \$this->info_createFusionChartsData_json_data_singleSerieCategorySeries();
        } elseif ('Heatmap' == \$this->SC_APP_data['type']) {
            \$this->info_createFusionChartsData_json_data_heatMapSeries();
        } elseif ('Treemap' == \$this->SC_APP_data['type']) {
            \$this->info_createFusionChartsData_json_data_treeMapSeries();
        } elseif ('Chord' == \$this->SC_APP_data['type']) {
            \$this->info_createFusionChartsData_json_data_chordSeries();
        } elseif ('Sankey' == \$this->SC_APP_data['type']) {
            \$this->info_createFusionChartsData_json_data_sankeySeries();
        } elseif ('Sunburst' == \$this->SC_APP_data['type']) {
            \$this->info_createFusionChartsData_json_data_sunburstSeries();
        } elseif ('Gauge' == \$this->SC_APP_data['type']) {
            \$this->info_createFusionChartsData_json_data_gaugeSeries();
        } elseif ('Scatter' == \$this->SC_APP_data['type']) {
            \$this->info_createFusionChartsData_json_data_scatterSeries();
        } elseif ('Bubble' == \$this->SC_APP_data['type']) {
            \$this->info_createFusionChartsData_json_data_bubbleSeries();
        } elseif ('Combination' == \$this->SC_APP_data['type']) {
            \$this->info_createFusionChartsData_json_data_combinationSeries();
        } elseif ('Radar' == \$this->SC_APP_data['type']) {
            if (self::CHART_MODE_SYNTHETIC == \$this->SC_APP_data['data_mode']) {
                \$this->info_createFusionChartsData_json_data_singleSerieCategorySeries();
            } else {
                \$this->info_createFusionChartsData_json_data_multiSeries();
            }
        } elseif (\$this->aux_isMultiSeries()) {
            \$this->info_createFusionChartsData_json_data_multiSeries();
        } else {
            \$this->info_createFusionChartsData_json_data_singleSeries();
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_series

/**
 * Cria as informacoes de configuracao json das series de dados para series simples
 */
function fnChart_info_createFusionChartsData_json_data_singleSeries($file)
{
    global $summaryInfo;

    $chartLinkFuncion = '';
    if ('drilldown' == $summaryInfo['chart'] ['chart_link']) {
        $chartLinkFuncion = 'chartDrillDown';
    } elseif ('grid' == $summaryInfo['chart'] ['chart_link']) {
        $chartLinkFuncion = 'chartLinkToGrid';
    }

    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_singleSeries()
    {
        \$this->SC_APP_data['fusioncharts_json'] ['data'] = [];

        \$displayValues = [];
        foreach (\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['chart_display_values'] as \$thisDisplayValue) {
            \$displayValues[] = \$thisDisplayValue;
        }
        if (isset(\$displayValues[0])) {
            if (false === \$displayValues[0]) {
                \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showValues'] = '0';
            } elseif (\$displayValues[0]) {
                \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showValues'] = '1';
            }
        }

        \$dimensionIndex = 0;
        foreach (\$this->SC_APP_data['md5_data'] ['dimension_list'] as \$thisDimensionIndex => \$thisDimensionName) {
            if (\$thisDimensionName == \$this->SC_APP_data['md5_data'] ['dimension'] ['field']) {
                \$dimensionIndex = \$thisDimensionIndex;
            }
        }

        foreach (\$this->SC_APP_data['md5_data'] ['data_synthetic'] [self::GROUPBY_ORIGINAL] as \$plotInfo) {
            \$addItem = true;

            if (!empty(\$this->SC_APP_data['filtered_chart_items']) && !in_array(\$plotInfo['label'], \$this->SC_APP_data['filtered_chart_items'])) {
                \$addItem = false;
            }

            if (\$addItem) {
                \$thisData = [
                    'label' => \$this->SC_APP_info['chart'] ['fusioncharts_fix'] . \$plotInfo['label'],
                    'value' => \$plotInfo['value'],
                ];

                if (\$this->SC_APP_info['chart'] ['hide_label_empty_values'] && 0 == \$plotInfo['value']) {
                    \$thisData['showValue'] = false;
                }

                if ('date' == \$this->SC_APP_data['md5_data'] ['dimension_type_list'] [\$dimensionIndex]) {
                    \$thisData['label_sort_value'] = \$plotInfo['dimension_value'];
                } else {
                    \$thisData['label_sort_value'] = \$plotInfo['label'];
                }

                if ('none' != \$this->SC_APP_data['md5_data'] ['options'] ['chart_link'] && '' != \$this->SC_APP_data['md5_data'] ['dimension'] ['next']) {
                    \$thisData['link'] = 'j-{$chartLinkFuncion}-' . \$this->aux_getChartLink(\$this->SC_APP_data['md5_data'] ['dimension_list'], \$this->SC_APP_data['md5_data'] ['metric'], \$this->SC_APP_data['md5_data'] ['parameters'], \$plotInfo['dimension_value']);
                }

                if (\$this->SC_APP_info['options'] ['tooltip_expanded']) {
                    \$metricLabel = \$this->aux_getMetricLabel(\$this->SC_APP_data['md5_data'] ['metric']);

                    \$displayValue = '\$dataValue';
                    if ('Pie' == \$this->SC_APP_data['type'] && \$this->SC_APP_info['types'] ['pie'] ['showPercentValues']) {
                        \$displayValue = '\$percentValue';
                    } elseif ('Pyramid' == \$this->SC_APP_data['type'] && \$this->SC_APP_info['types'] ['pyramid'] ['showPercentValues']) {
                        \$displayValue = '\$percentValue';
                    } elseif ('Pyramid' == \$this->SC_APP_data['type'] && !\$this->SC_APP_info['types'] ['pyramid'] ['showPercentValues']) {
                        \$displayValue = '\$value';
                    } elseif ('Funnel' == \$this->SC_APP_data['type']) {
                        \$displayValue = '\$value';
                    }

                    \$thisData['tooltext'] = "<b>{\$this->SC_APP_data['md5_data'] ['dimension'] ['label']}</b>: {\$plotInfo['label']}";
                    \$thisData['tooltext'] .= "<br>";
                    \$thisData['tooltext'] .= "<b>{\$metricLabel}</b>: " . \$displayValue;
                }

                \$this->SC_APP_data['fusioncharts_json'] ['data'] [] = \$thisData;
            }
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_singleSeries

/**
 * Cria as informacoes de configuracao json das series de dados para series multiplas
 */
function fnChart_info_createFusionChartsData_json_data_multiSeries($file)
{
    global $summaryInfo;

    $chartLinkFuncion = '';
    if ('drilldown' == $summaryInfo['chart'] ['chart_link']) {
        $chartLinkFuncion = 'chartDrillDown';
    } elseif ('grid' == $summaryInfo['chart'] ['chart_link']) {
        $chartLinkFuncion = 'chartLinkToGrid';
    }

    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_multiSeries()
    {
        \$this->SC_APP_data['fusioncharts_json'] ['categories'] = [];
        \$this->SC_APP_data['fusioncharts_json'] ['dataset'] = [];

        \$category = [];
        foreach (\$this->SC_APP_data['md5_data'] ['data_analytic'] [ \$this->SC_APP_data['series_mode'] ] ['categories'] as \$categoryLabel) {
            \$addItem = true;

            if ('set' == \$this->SC_APP_data['series_mode'] && !empty(\$this->SC_APP_data['filtered_chart_items']) && !in_array(\$categoryLabel, \$this->SC_APP_data['filtered_chart_items'])) {
                \$addItem = false;
            }

            if (\$addItem) {
                \$category[] = [
                    'label' => \$this->SC_APP_info['chart'] ['fusioncharts_fix'] . \$categoryLabel,
                ];
            }
        }
        \$this->SC_APP_data['fusioncharts_json'] ['categories'] [] = [
            'category' => \$category,
        ];

        \$displayValues = [];
        foreach (\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['chart_display_values'] as \$thisDisplayValue) {
            \$displayValues[] = \$thisDisplayValue;
        }

        if ('set' == \$this->SC_APP_data['series_mode']) {
            \$seriesCount = 0;

            foreach (\$this->SC_APP_data['md5_data'] ['data_analytic'] [ \$this->SC_APP_data['series_mode'] ] ['dataset'] as \$seriesValue => \$seriesInfo) {
                \$data = [];

                foreach (\$this->SC_APP_data['md5_data'] ['data_analytic'] [ \$this->SC_APP_data['series_mode'] ] ['categories'] as \$categoryIndex => \$categoryLabel) {
                    \$plotValue = \$categoryIndex;
                    if (isset(\$seriesInfo['data'] [\$categoryIndex])) {
                        \$plotInfo = \$seriesInfo['data'] [\$categoryIndex];
                    } else {
                        \$plotInfo = [
                            'label' => \$categoryLabel,
                            'dimension_value' => \$categoryIndex,
                            'value' => 0,
                        ];
                    }

                    \$addItem = true;

                    if (!empty(\$this->SC_APP_data['filtered_chart_items']) && !in_array(\$plotInfo['label'], \$this->SC_APP_data['filtered_chart_items'])) {
                        \$addItem = false;
                    }

                    if (\$addItem) {
                        \$thisData = [
                            'value' => \$plotInfo['value'],
                        ];

                        if (\$this->SC_APP_info['chart'] ['hide_label_empty_values'] && 0 == \$plotInfo['value']) {
                            \$thisData['showValue'] = false;
                        }

                        if ('none' != \$this->SC_APP_data['md5_data'] ['options'] ['chart_link'] && '' != \$this->SC_APP_data['md5_data'] ['dimension'] ['next']) {
                            \$thisData['link'] = 'j-{$chartLinkFuncion}-' . \$this->aux_getChartLink(\$this->SC_APP_data['md5_data'] ['dimension_list'], \$this->SC_APP_data['md5_data'] ['metric'], \$this->SC_APP_data['md5_data'] ['parameters'], \$plotInfo['dimension_value']);
                        }

                        if (\$this->SC_APP_info['options'] ['tooltip_expanded']) {
                            if (\$this->SC_APP_data['md5_data'] ['options'] ['is_multimetric']) {
                                \$thisData['tooltext'] = "<br><b>{\$this->SC_APP_data['md5_data'] ['data_analytic'] [ \$this->SC_APP_data['series_mode'] ] ['field_name'] ['x_axys']}</b>: {\$plotValue}";
                                \$thisData['tooltext'] .= "<br>";
                                \$thisData['tooltext'] .= "<b>{\$seriesInfo['label']}</b>: \\\$dataValue<br>";
                            } else {
                                \$metricLabel = \$this->aux_getMetricLabel(\$this->SC_APP_data['md5_data'] ['metric']);

                                \$thisData['tooltext'] = "<br><b>{\$this->SC_APP_data['md5_data'] ['data_analytic'] [ \$this->SC_APP_data['series_mode'] ] ['field_name'] ['x_axys']}</b>";
                                \$thisData['tooltext'] .= "<br>";
                                \$thisData['tooltext'] .= "<b>{\$plotInfo['label']}</b>";
                                \$thisData['tooltext'] .= "<br>";
                                \$thisData['tooltext'] .= "<b>{\$this->SC_APP_data['md5_data'] ['data_analytic'] [ \$this->SC_APP_data['series_mode'] ] ['field_name'] ['legend']}</b>: {\$seriesInfo['label']}";
                                \$thisData['tooltext'] .= "<br>";
                                \$thisData['tooltext'] .= "<b>{\$metricLabel}</b>: {\$plotInfo['value']}<br>";
                            }
                        }

                        \$data[] = \$thisData;
                    }
                }

                \$dataSet = [
                    'seriesName' => \$seriesInfo['label'],
                    'data' => \$data,
                ];

                if (isset(\$displayValues[\$seriesCount])) {
                    if (false === \$displayValues[\$seriesCount]) {
                        \$dataSet['showValues'] = '0';
                    } elseif (\$displayValues[\$seriesCount]) {
                        \$dataSet['showValues'] = '1';
                    }
                }

                \$this->SC_APP_data['fusioncharts_json'] ['dataset'] [] = \$dataSet;

                \$seriesCount++;
            }
        } else {
            foreach (\$this->SC_APP_data['md5_data'] ['data_analytic'] [ \$this->SC_APP_data['series_mode'] ] ['dataset'] as \$seriesValue => \$seriesInfo) {
                \$data = [];

                foreach (\$seriesInfo['data'] as \$plotValue => \$plotInfo) {
                    \$addItem = true;

                    if ('serie' == \$this->SC_APP_data['series_mode'] && !empty(\$this->SC_APP_data['filtered_chart_items']) && !in_array(\$seriesInfo['label'], \$this->SC_APP_data['filtered_chart_items'])) {
                        \$addItem = false;
                    }

                    if (\$addItem) {
                        \$thisData = [
                            'value' => \$plotInfo['value'],
                        ];

                        if (\$this->SC_APP_info['chart'] ['hide_label_empty_values'] && 0 == \$plotInfo['value']) {
                            \$thisData['showValue'] = false;
                        }

                        if ('none' != \$this->SC_APP_data['md5_data'] ['options'] ['chart_link'] && '' != \$this->SC_APP_data['md5_data'] ['dimension'] ['next']) {
                            \$thisData['link'] = 'j-{$chartLinkFuncion}-' . \$this->aux_getChartLink(\$this->SC_APP_data['md5_data'] ['dimension_list'], \$this->SC_APP_data['md5_data'] ['metric'], \$this->SC_APP_data['md5_data'] ['parameters'], \$plotInfo['dimension_value']);
                        }

                        if (\$this->SC_APP_info['options'] ['tooltip_expanded']) {
                            if (\$this->SC_APP_data['md5_data'] ['options'] ['is_multimetric']) {
                                \$thisData['tooltext'] = "<b>{\$this->SC_APP_data['md5_data'] ['data_analytic'] [ \$this->SC_APP_data['series_mode'] ] ['field_name'] ['x_axys']}</b>: {\$plotValue}";
                                \$thisData['tooltext'] .= "<br>";
                                \$thisData['tooltext'] .= "<b>{\$seriesInfo['label']}</b>: \\\$dataValue";
                            } else {
                                \$metricLabel = \$this->aux_getMetricLabel(\$this->SC_APP_data['md5_data'] ['metric']);

                                \$thisData['tooltext'] = "<b>{\$this->SC_APP_data['md5_data'] ['data_analytic'] [ \$this->SC_APP_data['series_mode'] ] ['field_name'] ['x_axys']}</b>";
                                \$thisData['tooltext'] .= "<br>";
                                \$thisData['tooltext'] .= "<b>{\$plotInfo['label']}</b>";
                                \$thisData['tooltext'] .= "<br><br>";
                                \$thisData['tooltext'] .= "<b>{\$this->SC_APP_data['md5_data'] ['data_analytic'] [ \$this->SC_APP_data['series_mode'] ] ['field_name'] ['legend']}</b>: {\$seriesInfo['label']}";
                                \$thisData['tooltext'] .= "<br>";
                                \$thisData['tooltext'] .= "<b>{\$metricLabel}</b>: {\$plotInfo['value']}";
                            }
                        }

                        \$data[] = \$thisData;
                    }
                }

                \$addItem = true;

                if (!empty(\$this->SC_APP_data['filtered_chart_items']) && !in_array(\$seriesInfo['label'], \$this->SC_APP_data['filtered_chart_items'])) {
                    \$addItem = false;
                }

                if (\$addItem) {
                    \$this->SC_APP_data['fusioncharts_json'] ['dataset'] [] = [
                        'seriesName' => \$seriesInfo['label'],
                        'data' => \$data,
                    ];
                }
            }
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_multiSeries

/**
 * Cria as informacoes de configuracao json das series de dados para series de comparacao
 */
function fnChart_info_createFusionChartsData_json_data_comparisonSeries($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_comparisonSeries()
    {
        \$this->SC_APP_data['fusioncharts_json'] ['categories'] = [];
        \$this->SC_APP_data['fusioncharts_json'] ['dataset'] = [];

        \$category = [];
        foreach (\$this->SC_APP_data['md5_data'] ['data_synthetic'] [self::GROUPBY_ORIGINAL] as \$plotInfo) {
            \$addItem = true;

            if (!empty(\$this->SC_APP_data['filtered_chart_items']) && !in_array(\$plotInfo['label'], \$this->SC_APP_data['filtered_chart_items'])) {
                \$addItem = false;
            }

            if (\$addItem) {
                \$category[] = [
                    'label' => \$plotInfo['label'],
                ];
            }
        }
        \$this->SC_APP_data['fusioncharts_json'] ['categories'] [] = [
            'category' => \$category,
        ];

        foreach (\$this->SC_APP_data['md5_data'] ['data_synthetic'] as \$seriesIndex => \$seriesInfo) {
            \$data = [];

            foreach (\$seriesInfo as \$plotInfo) {
                \$addItem = true;

                if (!empty(\$this->SC_APP_data['filtered_chart_items']) && !in_array(\$plotInfo['label'], \$this->SC_APP_data['filtered_chart_items'])) {
                    \$addItem = false;
                }

                if (\$addItem) {
                    \$thisData = [
                        'value' => \$plotInfo['value'],
                    ];

                    if (\$this->SC_APP_info['chart'] ['hide_label_empty_values'] && 0 == \$plotInfo['value']) {
                        \$thisData['showValue'] = false;
                    }

                    if (\$this->SC_APP_info['options'] ['tooltip_expanded']) {
                        \$metricLabel = \$this->aux_getMetricLabel(\$this->SC_APP_data['md5_data'] ['metric']);

                        \$thisData['tooltext'] = "<b>{\$this->SC_APP_data['md5_data'] ['dimension'] ['label']}</b>";
                        \$thisData['tooltext'] .= "<br>";
                        \$thisData['tooltext'] .= "<b>{\$plotInfo['label']}</b>";
                        \$thisData['tooltext'] .= "<br><br>";
                        \$thisData['tooltext'] .= "<b>{\$this->SC_APP_data['md5_data'] ['options'] ['comparison_field_label']}</b>: {\$this->SC_APP_data['md5_data'] ['options'] ['series_name'] [\$seriesIndex]}";
                        \$thisData['tooltext'] .= "<br>";
                        \$thisData['tooltext'] .= "<b>{\$metricLabel}</b>: {\$plotInfo['value']}";
                    }

                    \$data[] = \$thisData;
                }
            }

            \$this->SC_APP_data['fusioncharts_json'] ['dataset'] [] = [
                'seriesName' => \$this->SC_APP_data['md5_data'] ['options'] ['series_name'] [\$seriesIndex],
                'data' => \$data,
            ];
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_comparisonSeries

/**
 * Cria as informacoes de configuracao json das series de dados para series de graficos com categorias mas com apenas uma serie
 */
function fnChart_info_createFusionChartsData_json_data_singleSerieCategorySeries($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_singleSerieCategorySeries()
    {
        \$this->SC_APP_data['fusioncharts_json'] ['categories'] = [];
        \$this->SC_APP_data['fusioncharts_json'] ['dataset'] = [];

        \$category = [];
        foreach (\$this->SC_APP_data['md5_data'] ['data_synthetic'] [self::GROUPBY_ORIGINAL] as \$plotInfo) {
            \$addItem = true;

            if (!empty(\$this->SC_APP_data['filtered_chart_items']) && !in_array(\$plotInfo['label'], \$this->SC_APP_data['filtered_chart_items'])) {
                \$addItem = false;
            }

            if (\$addItem) {
                \$category[] = [
                    'label' => \$this->SC_APP_info['chart'] ['fusioncharts_fix'] . \$plotInfo['label'],
                ];
            }
        }
        \$this->SC_APP_data['fusioncharts_json'] ['categories'] [] = [
            'category' => \$category,
        ];

        \$displayValues = [];
        foreach (\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['chart_display_values'] as \$thisDisplayValue) {
            \$displayValues[] = \$thisDisplayValue;
        }
        if (isset(\$displayValues[0])) {
            if (false === \$displayValues[0]) {
                \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showValues'] = '0';
            } elseif (\$displayValues[0]) {
                \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showValues'] = '1';
            }
        }

        \$data = [];
        foreach (\$this->SC_APP_data['md5_data'] ['data_synthetic'] [self::GROUPBY_ORIGINAL] as \$plotInfo) {
            \$addItem = true;

            if (!empty(\$this->SC_APP_data['filtered_chart_items']) && !in_array(\$plotInfo['label'], \$this->SC_APP_data['filtered_chart_items'])) {
                \$addItem = false;
            }

            if (\$addItem) {
                \$thisData = [
                    'value' => \$plotInfo['value'],
                ];

                if (\$this->SC_APP_info['chart'] ['hide_label_empty_values'] && 0 == \$plotInfo['value']) {
                    \$thisData['showValue'] = false;
                }

                if (\$this->SC_APP_info['options'] ['tooltip_expanded']) {
                    \$thisData['tooltext'] = "<b>{\$this->SC_APP_data['md5_data'] ['dimension'] ['label']}</b>: {\$plotInfo['label']}";
                    \$thisData['tooltext'] .= "<br>";
                    \$thisData['tooltext'] .= "<b>{\$this->SC_APP_data['md5_data'] ['metric'] [0] ['label']}</b>: {\$plotInfo['value']}";
                }

                \$data[] = \$thisData;
            }
        }
        \$this->SC_APP_data['fusioncharts_json'] ['dataset'] [] = [
            'seriesName' => \$this->SC_APP_data['md5_data'] ['metric'] [0] ['label'],
            'data' => \$data,
        ];

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['showLegend'] = '0';
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_singleSerieCategorySeries

/**
 * Cria as informacoes de configuracao json das series de dados para series de graficos combination
 */
function fnChart_info_createFusionChartsData_json_data_combinationSeries($file)
{
    global $summaryInfo;

    $chartLinkFuncion = '';
    if ('drilldown' == $summaryInfo['chart'] ['chart_link']) {
        $chartLinkFuncion = 'chartDrillDown';
    } elseif ('grid' == $summaryInfo['chart'] ['chart_link']) {
        $chartLinkFuncion = 'chartLinkToGrid';
    }

    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_combinationSeries()
    {
        if (2 > count(\$this->SC_APP_data['md5_data'] ['metric'])) {
            return;
        }

        \$this->SC_APP_data['fusioncharts_json'] ['categories'] = [];
        \$this->SC_APP_data['fusioncharts_json'] ['dataset'] = [];

        \$category = [];
        foreach (\$this->SC_APP_data['md5_data'] ['data_analytic'] ['set'] ['categories'] as \$categoryLabel) {
            \$addItem = true;

            if (!empty(\$this->SC_APP_data['filtered_chart_items']) && !in_array(\$categoryLabel, \$this->SC_APP_data['filtered_chart_items'])) {
                \$addItem = false;
            }

            if (\$addItem) {
                \$category[] = [
                    'label' => \$this->SC_APP_info['chart'] ['fusioncharts_fix'] . \$categoryLabel,
                ];
            }
        }
        \$this->SC_APP_data['fusioncharts_json'] ['categories'] [] = [
            'category' => \$category,
        ];

        \$renderAs = [];
        \$displayValues = [];
        foreach (\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['comb_field_display_type'] as \$thisRenderAs) {
            \$renderAs[] = \$thisRenderAs;
        }
        foreach (\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['chart_display_values'] as \$thisDisplayValue) {
            \$displayValues[] = \$thisDisplayValue;
        }

        \$primaryAxysName = [];
        \$secondaryAxysName = '';

        \$axysCount = 0;
        foreach (\$this->SC_APP_data['md5_data'] ['data_analytic'] ['set'] ['dataset'] as \$serieName => \$serieInfo) {
            \$data = [];

            if (0 == \$axysCount) {
                \$secondaryAxysName = \$serieInfo['label'];
            } else {
                \$primaryAxysName[] = \$serieInfo['label'];
            }

            foreach (\$serieInfo ['data'] as \$plotValue => \$plotInfo) {
                \$addItem = true;

                if (!empty(\$this->SC_APP_data['filtered_chart_items']) && !in_array(\$plotInfo['label'], \$this->SC_APP_data['filtered_chart_items'])) {
                    \$addItem = false;
                }

                if (\$addItem) {
                    \$thisData = [
                        'value' => \$plotInfo['value'],
                    ];

                    if (\$this->SC_APP_info['chart'] ['hide_label_empty_values'] && 0 == \$plotInfo['value']) {
                        \$thisData['showValue'] = false;
                    }

                    if ('none' != \$this->SC_APP_data['md5_data'] ['options'] ['chart_link'] && '' != \$this->SC_APP_data['md5_data'] ['dimension'] ['next']) {
                        \$thisData['link'] = 'j-{$chartLinkFuncion}-' . \$this->aux_getChartLink(\$this->SC_APP_data['md5_data'] ['dimension_list'], \$this->SC_APP_data['md5_data'] ['metric'], \$this->SC_APP_data['md5_data'] ['parameters'], \$plotInfo['dimension_value']);
                    }

                    if (\$this->SC_APP_info['options'] ['tooltip_expanded']) {
                        \$thisData['tooltext'] = "<b>{\$this->SC_APP_data['md5_data'] ['data_analytic'] ['set'] ['field_name'] ['x_axys']}</b>: {\$plotValue}";
                        \$thisData['tooltext'] .= "<br>";
                        \$thisData['tooltext'] .= "<b>{\$serieName}</b>: {\$plotInfo['value']}";
                    }

                    \$data[] = \$thisData;
                }
            }

            \$datasetInfo = [
                'seriesName' => \$serieInfo['label'],
                'data' => \$data,
            ];
            if (0 == \$axysCount) {
                \$datasetInfo['parentYAxis'] = 'S';
            }
            if (isset(\$renderAs[\$axysCount]) && '' != \$renderAs[\$axysCount]) {
                \$datasetInfo['renderAs'] = \$renderAs[\$axysCount];
            }
            if (isset(\$displayValues[\$axysCount])) {
                if (false === \$displayValues[\$axysCount]) {
                    \$datasetInfo['showValues'] = '0';
                } elseif (\$displayValues[\$axysCount]) {
                    \$datasetInfo['showValues'] = '1';
                }
            }

            \$this->SC_APP_data['fusioncharts_json'] ['dataset'] [] = \$datasetInfo;

            \$axysCount++;
        }

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['pYAxisName'] = implode(', ', \$primaryAxysName);
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['sYAxisName'] = \$secondaryAxysName;

        \$this->formatThemeSecondary(\$this->SC_APP_data['fusioncharts_json'] ['chart']);
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_combinationSeries

/**
 * Cria as informacoes de configuracao json das series de dados para series de graficos heatmap
 */
function fnChart_info_createFusionChartsData_json_data_heatMapSeries($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_heatMapSeries()
    {
        \$divideBy = count(\$this->chartGradient) - 1;
        \$firstColor = \$this->chartGradient[0];

        \$this->SC_APP_data['fusioncharts_json'] ['dataset'] [] = [
            'data' => \$this->SC_APP_data['md5_data'] ['data_heatmap'] ['dataset']
        ];

        \$this->SC_APP_data['fusioncharts_json'] ['columns'] = [
            'column' => \$this->SC_APP_data['md5_data'] ['data_heatmap'] ['columns']
        ];

        \$this->SC_APP_data['fusioncharts_json'] ['rows'] = [
            'row' => \$this->SC_APP_data['md5_data'] ['data_heatmap'] ['rows']
        ];

        if ('' != \$this->SC_APP_info['chart'] ['fusioncharts_fix']) {
            foreach (\$this->SC_APP_data['fusioncharts_json'] ['columns'] ['column'] as \$columnIndex => \$columnInfo) {
                \$this->SC_APP_data['fusioncharts_json'] ['columns'] ['column'] [\$columnIndex] ['label'] = \$this->SC_APP_info['chart'] ['fusioncharts_fix'] . \$columnInfo['label'];
            }
        }

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['yAxisName'] = \$this->SC_APP_data['md5_data'] ['data_heatmap'] ['yDimensionName'];

        \$stepValue = (\$this->SC_APP_data['md5_data'] ['data_heatmap'] ['maxValue'] - \$this->SC_APP_data['md5_data'] ['data_heatmap'] ['minValue']) / \$divideBy;
        \$minValue = (float)\$this->SC_APP_data['md5_data'] ['data_heatmap'] ['minValue'];

        \$colors = [];

        for (\$i = 1; \$i < count(\$this->chartGradient); \$i++) {
            \$minMultiplier = \$i - 1;
            \$colors[] = [
                'code' => \$this->chartGradient[\$i],
                'label' => '',
                'minvalue' => \$minValue + (\$stepValue * \$minMultiplier),
                'maxvalue' => \$minValue + (\$stepValue * \$i),
            ];
        }

        \$this->SC_APP_data['fusioncharts_json'] ['colorrange'] ['minvalue'] = \$this->SC_APP_data['md5_data'] ['data_heatmap'] ['minValue'];
        \$this->SC_APP_data['fusioncharts_json'] ['colorrange'] ['code'] = \$firstColor;
        \$this->SC_APP_data['fusioncharts_json'] ['colorrange'] ['color'] = \$colors;

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['plotToolText'] = "<div><b>{\$this->SC_APP_data['md5_data'] ['dimension_label'] [1]}: </b>\\\$rowLabel<br/><b>{\$this->SC_APP_data['md5_data'] ['dimension_label'] [0]}: </b>\\\$columnLabel<br/><b>{\$this->SC_APP_data['md5_data'] ['metric'] [0] ['label']}: </b>\\\$value</div>";
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_heatMapSeries

/**
 * Cria as informacoes de configuracao json das series de dados para series de graficos treemap
 */
function fnChart_info_createFusionChartsData_json_data_treeMapSeries($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_treeMapSeries()
    {
        \$divideBy = count(\$this->chartGradient) - 1;
        \$firstColor = \$this->chartGradient[0];

        \$this->SC_APP_data['fusioncharts_json'] ['data'] [] = \$this->SC_APP_data['md5_data'] ['data_treemap'] ['data'];

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['yAxisName'] = \$this->SC_APP_data['md5_data'] ['data_treemap'] ['yDimensionName'];

        \$stepValue = (\$this->SC_APP_data['md5_data'] ['data_treemap'] ['maxValue'] - \$this->SC_APP_data['md5_data'] ['data_treemap'] ['minValue']) / \$divideBy;
        \$minValue = (float)\$this->SC_APP_data['md5_data'] ['data_treemap'] ['minValue'];

        \$colors = [];

        for (\$i = 1; \$i < count(\$this->chartGradient); \$i++) {
            \$colors[] = [
                'code' => \$this->chartGradient[\$i],
                'label' => '',
                'maxvalue' => \$minValue + (\$stepValue * \$i),
            ];
        }

        \$this->SC_APP_data['fusioncharts_json'] ['colorrange'] ['gradient'] = '1';
        \$this->SC_APP_data['fusioncharts_json'] ['colorrange'] ['minvalue'] = \$this->SC_APP_data['md5_data'] ['data_treemap'] ['minValue'];
        \$this->SC_APP_data['fusioncharts_json'] ['colorrange'] ['code'] = \$firstColor;
        \$this->SC_APP_data['fusioncharts_json'] ['colorrange'] ['color'] = \$colors;


EOT;
    if ('' != $summaryInfo['chart'] ['treemap_label_total']) {
        $phpCode .= <<<EOT
        \$this->SC_APP_data['fusioncharts_json'] ['data'] [0] ['label'] = "{$summaryInfo['chart'] ['treemap_label_total']}";

EOT;
    }
    $phpCode .= <<<EOT
        \$this->SC_APP_data['fusioncharts_json'] ['data'] [0] ['labelFontBold'] = '0';
        \$this->SC_APP_data['fusioncharts_json'] ['data'] [0] ['fillcolor'] = 'c0c0c0';

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['plotToolText'] = "<div><b>\\\$label</b><br/> <b>{\$this->SC_APP_data['md5_data'] ['metric'] [0] ['label']}: </b>\\\$value<br/><b>{\$this->SC_APP_data['md5_data'] ['metric'] [1] ['label']}: </b>\\\$svalue</div>";
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_treeMapSeries

/**
 * Cria as informacoes de configuracao json das series de dados para series de graficos chord
 */
function fnChart_info_createFusionChartsData_json_data_chordSeries($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_chordSeries()
    {
        \$chartCaption = '';
        if ('' != \$this->SC_APP_info['chart'] ['chart_title']) {
            \$chartCaption = \$this->SC_APP_info['chart'] ['chart_title'];
        } elseif (\$this->SC_APP_info['chart'] ['fill_empty_caption']) {
            \$chartCaption = \$this->SC_APP_data['md5_data'] ['metric'] [0] ['label'];
        }

        \$this->SC_APP_data['fusioncharts_json'] ['links'] = \$this->SC_APP_data['md5_data'] ['data_chord'] ['links'];

        \$this->SC_APP_data['fusioncharts_json'] ['nodes'] = \$this->SC_APP_data['md5_data'] ['data_chord'] ['nodes'];

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['caption'] = \$chartCaption;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_chordSeries

/**
 * Cria as informacoes de configuracao json das series de dados para series de graficos sankey
 */
function fnChart_info_createFusionChartsData_json_data_sankeySeries($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_sankeySeries()
    {
        \$chartCaption = '';
        if ('' != \$this->SC_APP_info['chart'] ['chart_title']) {
            \$chartCaption = \$this->SC_APP_info['chart'] ['chart_title'];
        } elseif (\$this->SC_APP_info['chart'] ['fill_empty_caption']) {
            \$chartCaption = \$this->SC_APP_data['md5_data'] ['metric'] [0] ['label'];
        }

        \$this->SC_APP_data['fusioncharts_json'] ['links'] = \$this->SC_APP_data['md5_data'] ['data_sankey'] ['links'];

        \$this->SC_APP_data['fusioncharts_json'] ['nodes'] = \$this->SC_APP_data['md5_data'] ['data_sankey'] ['nodes'];

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['caption'] = \$chartCaption;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_sankeySeries

/**
 * Cria as informacoes de configuracao json das series de dados para series de graficos sunburst
 */
function fnChart_info_createFusionChartsData_json_data_sunburstSeries($file)
{
    global $summaryInfo;

    $divideBy = count($summaryInfo['chart'] ['tree_heat_map_color_list']) - 1;
    $firstColor = $summaryInfo['chart'] ['tree_heat_map_color_list'] [0];

    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_sunburstSeries()
    {
        \$this->SC_APP_data['fusioncharts_json'] ['data'] = \$this->SC_APP_data['md5_data'] ['data_sunburst'] ['data'];
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_sunburstSeries

/**
 * Cria as informacoes de configuracao json das series de dados para series de graficos gauge
 */
function fnChart_info_createFusionChartsData_json_data_gaugeSeries($file)
{
    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_gaugeSeries()
    {
        \$valueMarker = 'LinearGauge' == \$this->SC_APP_info['types'] ['gauge'] ['format'] ? 'pointer' : 'dial';

        \$this->SC_APP_data['fusioncharts_json'] [\$valueMarker . 's'] = [];

        \$gaugeMin = 0;
        \$gaugeMax = 0;

        \$dial = [];
        foreach (\$this->SC_APP_data['md5_data'] ['data_synthetic'] [self::GROUPBY_ORIGINAL] as \$plotInfo) {
            \$addItem = true;

            if (!empty(\$this->SC_APP_data['filtered_chart_items']) && !in_array(\$plotInfo['label'], \$this->SC_APP_data['filtered_chart_items'])) {
                \$addItem = false;
            }

            if (\$addItem) {
                \$gaugeMin = min(\$gaugeMin, \$plotInfo['value']);
                \$gaugeMax = max(\$gaugeMax, \$plotInfo['value']);

                \$dial[] = [
                    'value' => \$plotInfo['value'],
                    'tooltext' => "{\$plotInfo['label']}: {\$plotInfo['value']}",
                ];
            }
        }
        \$this->SC_APP_data['fusioncharts_json'] [\$valueMarker . 's'] = [
            \$valueMarker => \$dial,
        ];

        if (10 > \$gaugeMax) {
            \$gaugeMax = 10;
        }
        \$gaugeMax = ceil(\$gaugeMax * 1.1);

        if (!\$this->SC_APP_info['types'] ['gauge'] ['use_interval']) {
            if (isset(\$this->chart_theme['css_chart_background_pallete_color']) && '' != \$this->chart_theme['css_chart_background_pallete_color']) {
                \$chartPallete = explode(',', \$this->chart_theme['css_chart_background_pallete_color']);

                \$this->SC_APP_data['fusioncharts_json'] ['colorRange'] = [
                    'color' => [[
                        'minValue' => '0',
                        'maxValue' => \$gaugeMax,
                        'code' => str_replace('#', '', \$chartPallete[0])
                    ]]
                ];
            } else {
                \$this->SC_APP_data['fusioncharts_json'] ['colorRange'] = [
                    'color' => [[
                        'minValue' => '0',
                        'maxValue' => \$gaugeMax,
                        'code' => '9bc8f2'
                    ]]
                ];
            }
        }

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['lowerLimit'] = \$gaugeMin;
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['upperLimit'] = \$gaugeMax;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_gaugeSeries

/**
 * Cria as informacoes de configuracao json das series de dados para series de graficos scatter
 */
function fnChart_info_createFusionChartsData_json_data_scatterSeries($file)
{
    global $summaryInfo;

    $chartLinkFuncion = '';
    if ('drilldown' == $summaryInfo['chart'] ['chart_link']) {
        $chartLinkFuncion = 'chartDrillDown';
    } elseif ('grid' == $summaryInfo['chart'] ['chart_link']) {
        $chartLinkFuncion = 'chartLinkToGrid';
    }

    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_scatterSeries()
    {
        if (2 != count(\$this->SC_APP_data['md5_data'] ['metric'])) {
            return;
        }

        \$this->SC_APP_data['fusioncharts_json'] ['categories'] = [];
        \$this->SC_APP_data['fusioncharts_json'] ['dataset'] = [];

        \$seriesXName = \$this->SC_APP_data['md5_data'] ['metric'] [0] ['field'];
        \$seriesYName = \$this->SC_APP_data['md5_data'] ['metric'] [1] ['field'];

        \$seriesXLabel = \$this->SC_APP_data['md5_data'] ['metric'] [0] ['label'];
        \$seriesYLabel = \$this->SC_APP_data['md5_data'] ['metric'] [1] ['label'];

        \$category = [];
        \$data = [];

        foreach (\$this->SC_APP_data['md5_data'] ['data_analytic'] ['set'] ['dataset'] [\$seriesXName] ['data'] as \$plotValue => \$plotInfo) {
            \$addItem = true;

            if (!empty(\$this->SC_APP_data['filtered_chart_items']) && !in_array(\$plotInfo['label'], \$this->SC_APP_data['filtered_chart_items'])) {
                \$addItem = false;
            }

            if (\$addItem) {
                \$category[] = [
                    'x' => \$plotInfo['value'],
                    'showverticalline' => '1',
                ];

                \$plotYValue = \$this->SC_APP_data['md5_data'] ['data_analytic'] ['set'] ['dataset'] [\$seriesYName] ['data'] [\$plotValue] ['value'];

                \$thisData = [
                    'x' => \$plotInfo['value'],
                    'y' => \$plotYValue,
                ];

                if ('none' != \$this->SC_APP_data['md5_data'] ['options'] ['chart_link'] && '' != \$this->SC_APP_data['md5_data'] ['dimension'] ['next']) {
                    \$thisData['link'] = 'j-{$chartLinkFuncion}-' . \$this->aux_getChartLink(\$this->SC_APP_data['md5_data'] ['dimension_list'], \$this->SC_APP_data['md5_data'] ['metric'], \$this->SC_APP_data['md5_data'] ['parameters'], \$plotInfo['dimension_value']);
                }

                if (\$this->SC_APP_info['options'] ['tooltip_expanded']) {
                    \$thisData['tooltext'] = "<b>{\$this->SC_APP_data['md5_data'] ['data_analytic'] [ \$this->SC_APP_data['series_mode'] ] ['field_name'] ['x_axys']}</b>: {\$plotValue}";
                    \$thisData['tooltext'] .= "<br>";
                    \$thisData['tooltext'] .= "<b>{\$seriesXLabel}</b>: {\$plotInfo['value']}";
                    \$thisData['tooltext'] .= "<br>";
                    \$thisData['tooltext'] .= "<b>{\$seriesYLabel}</b>: {\$plotYValue}";
                }

                \$data[] = \$thisData;
            }
        }

        \$this->SC_APP_data['fusioncharts_json'] ['categories'] [] = [
            'category' => \$category,
        ];
        \$this->SC_APP_data['fusioncharts_json'] ['dataset'] [] = [
            'seriesName' => \$this->SC_APP_data['md5_data'] ['data_analytic'] ['set'] ['field_name'] ['x_axys'],
            'showregressionline' => 1,
            'data' => \$data,
        ];

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['xaxisname'] = \$seriesXLabel;
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['yaxisname'] = \$seriesYLabel;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_scatterSeries

/**
 * Cria as informacoes de configuracao json das series de dados para series de graficos bubble
 */
function fnChart_info_createFusionChartsData_json_data_bubbleSeries($file)
{
    global $summaryInfo;

    $chartLinkFuncion = '';
    if ('drilldown' == $summaryInfo['chart'] ['chart_link']) {
        $chartLinkFuncion = 'chartDrillDown';
    } elseif ('grid' == $summaryInfo['chart'] ['chart_link']) {
        $chartLinkFuncion = 'chartLinkToGrid';
    }

    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_bubbleSeries()
    {
        if (3 != count(\$this->SC_APP_data['md5_data'] ['metric'])) {
            return;
        }

        \$this->SC_APP_data['fusioncharts_json'] ['categories'] = [];
        \$this->SC_APP_data['fusioncharts_json'] ['dataset'] = [];

        \$seriesXName = \$this->SC_APP_data['md5_data'] ['metric'] [0] ['field'];
        \$seriesYName = \$this->SC_APP_data['md5_data'] ['metric'] [1] ['field'];
        \$seriesZName = \$this->SC_APP_data['md5_data'] ['metric'] [2] ['field'];

        \$seriesXLabel = \$this->SC_APP_data['md5_data'] ['metric'] [0] ['label'];
        \$seriesYLabel = \$this->SC_APP_data['md5_data'] ['metric'] [1] ['label'];
        \$seriesZLabel = \$this->SC_APP_data['md5_data'] ['metric'] [2] ['label'];

        \$category = [];
        \$data = [];

        foreach (\$this->SC_APP_data['md5_data'] ['data_analytic'] ['set'] ['dataset'] [\$seriesXName] ['data'] as \$plotValue => \$plotInfo) {
            \$addItem = true;

            if (!empty(\$this->SC_APP_data['filtered_chart_items']) && !in_array(\$plotInfo['label'], \$this->SC_APP_data['filtered_chart_items'])) {
                \$addItem = false;
            }

            if (\$addItem) {
                \$category[] = [
                    'x' => \$plotInfo['value'],
                    'showverticalline' => '1',
                ];

                \$plotYValue = \$this->SC_APP_data['md5_data'] ['data_analytic'] ['set'] ['dataset'] [\$seriesYName] ['data'] [\$plotValue] ['value'];
                \$plotZValue = \$this->SC_APP_data['md5_data'] ['data_analytic'] ['set'] ['dataset'] [\$seriesZName] ['data'] [\$plotValue] ['value'];

                \$thisData = [
                    'x' => \$plotInfo['value'],
                    'y' => \$plotYValue,
                    'z' => \$plotZValue,
                ];

                if ('none' != \$this->SC_APP_data['md5_data'] ['options'] ['chart_link'] && '' != \$this->SC_APP_data['md5_data'] ['dimension'] ['next']) {
                    \$thisData['link'] = 'j-{$chartLinkFuncion}-' . \$this->aux_getChartLink(\$this->SC_APP_data['md5_data'] ['dimension_list'], \$this->SC_APP_data['md5_data'] ['metric'], \$this->SC_APP_data['md5_data'] ['parameters'], \$plotInfo['dimension_value']);
                }

                if (\$this->SC_APP_info['options'] ['tooltip_expanded']) {
                    \$thisData['tooltext'] = "<b>{\$this->SC_APP_data['md5_data'] ['data_analytic'] [ \$this->SC_APP_data['series_mode'] ] ['field_name'] ['x_axys']}</b>: {\$plotValue}";
                    \$thisData['tooltext'] .= "<br>";
                    \$thisData['tooltext'] .= "<b>{\$seriesXLabel}</b>: {\$plotInfo['value']}";
                    \$thisData['tooltext'] .= "<br>";
                    \$thisData['tooltext'] .= "<b>{\$seriesYLabel}</b>: {\$plotYValue}";
                }

                \$data[] = \$thisData;
            }
        }

        \$this->SC_APP_data['fusioncharts_json'] ['categories'] [] = [
            'category' => \$category,
        ];
        \$this->SC_APP_data['fusioncharts_json'] ['dataset'] [] = [
            'seriesName' => \$this->SC_APP_data['md5_data'] ['data_analytic'] ['set'] ['field_name'] ['x_axys'],
            'showregressionline' => 1,
            'data' => \$data,
        ];

        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['xaxisname'] = \$seriesXLabel;
        \$this->SC_APP_data['fusioncharts_json'] ['chart'] ['yaxisname'] = \$seriesYLabel;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_bubbleSeries

/**
 * Ordena as series do grafico
 */
function fnChart_info_createFusionChartsData_json_data_order($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_order()
    {

EOT;
    if ($summaryInfo['general'] ['app_type_chart']) {
        $phpCode .= <<<EOT
        if (isset(\$this->SC_APP_data['fusioncharts_json'] ['data'])) {
            \$this->aux_orderChartSingleSerie();
        } elseif (isset(\$this->SC_APP_data['fusioncharts_json'] ['categories']) && isset(\$this->SC_APP_data['fusioncharts_json'] ['dataset'])) {
            \$this->aux_orderChartMultipleSeries();
        }

EOT;
    } else {
        $phpCode .= <<<EOT
        if ('Pie' == \$this->SC_APP_data['type'] && 'off' != \$this->SC_APP_info['types'] ['pie'] ['order']) {
            \$this->aux_orderSerie(\$this->SC_APP_data['fusioncharts_json'] ['data'], \$this->SC_APP_info['types'] ['pie'] ['order']);
            \$this->aux_rearrangeOrderIndexes(\$this->SC_APP_data['fusioncharts_json'] ['data']);
        } elseif ('Line' == \$this->SC_APP_data['type'] && 'Step' == \$this->SC_APP_info['types'] ['line'] ['format'] && !\$this->aux_isMultiSeries()) {
            \$this->aux_orderSerie(\$this->SC_APP_data['fusioncharts_json'] ['dataset'] [0] ['data'], \$this->SC_APP_data['order']);
            \$this->aux_rearrangeOrderMultiIndexes(\$this->SC_APP_data['fusioncharts_json'] ['dataset'] [0] ['data'], \$this->SC_APP_data['fusioncharts_json'] ['categories'] [0] ['category']);
        } elseif ('Radar' == \$this->SC_APP_data['type'] && self::CHART_MODE_SYNTHETIC == \$this->SC_APP_data['data_mode']) {
            \$this->aux_orderSerie(\$this->SC_APP_data['fusioncharts_json'] ['dataset'] [0] ['data'], \$this->SC_APP_data['order']);
            \$this->aux_rearrangeOrderMultiIndexes(\$this->SC_APP_data['fusioncharts_json'] ['dataset'] [0] ['data'], \$this->SC_APP_data['fusioncharts_json'] ['categories'] [0] ['category']);
        } elseif ('Bar' == \$this->SC_APP_data['type'] && \$this->SC_APP_info['types'] ['bar'] ['isScroll'] && !\$this->aux_isMultiSeries()) {
            \$this->aux_orderSerie(\$this->SC_APP_data['fusioncharts_json'] ['dataset'] [0] ['data'], \$this->SC_APP_data['order']);
            \$this->aux_rearrangeOrderMultiIndexes(\$this->SC_APP_data['fusioncharts_json'] ['dataset'] [0] ['data'], \$this->SC_APP_data['fusioncharts_json'] ['categories'] [0] ['category']);
        } elseif ('Line' == \$this->SC_APP_data['type'] && \$this->SC_APP_info['types'] ['line'] ['isScroll'] && !\$this->aux_isMultiSeries()) {
            \$this->aux_orderSerie(\$this->SC_APP_data['fusioncharts_json'] ['dataset'] [0] ['data'], \$this->SC_APP_data['order']);
            \$this->aux_rearrangeOrderMultiIndexes(\$this->SC_APP_data['fusioncharts_json'] ['dataset'] [0] ['data'], \$this->SC_APP_data['fusioncharts_json'] ['categories'] [0] ['category']);
        } elseif ('Area' == \$this->SC_APP_data['type'] && \$this->SC_APP_info['types'] ['area'] ['isScroll'] && !\$this->aux_isMultiSeries()) {
            \$this->aux_orderSerie(\$this->SC_APP_data['fusioncharts_json'] ['dataset'] [0] ['data'], \$this->SC_APP_data['order']);
            \$this->aux_rearrangeOrderMultiIndexes(\$this->SC_APP_data['fusioncharts_json'] ['dataset'] [0] ['data'], \$this->SC_APP_data['fusioncharts_json'] ['categories'] [0] ['category']);
        } elseif (!\$this->aux_isMultiSeries() && !\$this->SC_APP_data['md5_data'] ['options'] ['is_comparison'] && '' != \$this->SC_APP_data['order'] && !in_array(\$this->SC_APP_data['type'], ['Gauge', 'Radar'])) {
            \$this->aux_orderSerie(\$this->SC_APP_data['fusioncharts_json'] ['data'], \$this->SC_APP_data['order']);
            \$this->aux_rearrangeOrderIndexes(\$this->SC_APP_data['fusioncharts_json'] ['data']);
        }

EOT;
    }
    $phpCode .= <<<EOT
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_order

/**
 * Cria as linhas de tendencia das series do grafico
 */
function fnChart_info_createFusionChartsData_json_data_trendline($file)
{
    global $summaryInfo;

    scCopy($summaryInfo['general'] ['dir_scriptcase_root'] . 'devel/lib/third/polynomial_regression/PolynomialRegression.php', $summaryInfo['general'] ['dir_app_lib'] . '/PolynomialRegression.php');

    $phpCode = <<<EOT
    function info_createFusionChartsData_json_data_trendline()
    {
        if (!\$this->SC_APP_info['options'] ['hasTrendline']) {
            return;
        }

        \$this->SC_APP_data['fusioncharts_json'] ['trendlines'] = [];

        if (\$this->SC_APP_info['options'] ['trendlineIsZone']) {
            \$this->aux_addTrendline_zone();
        } elseif ('fixed' == \$this->SC_APP_info['options'] ['trendlineType']) {
            \$this->aux_addTrendline_fixed();
        } else {
            \$series = [];

            if (isset(\$this->SC_APP_data['fusioncharts_json'] ['data'])) {
                \$thisSerie = [];
                foreach (\$this->SC_APP_data['fusioncharts_json'] ['data'] as \$plotInfo) {
                    \$thisSerie[] = \$plotInfo['value'];
                }
                \$series[] = \$thisSerie;
            } elseif (isset(\$this->SC_APP_data['fusioncharts_json'] ['categories']) && isset(\$this->SC_APP_data['fusioncharts_json'] ['dataset'])) {
                foreach (\$this->SC_APP_data['fusioncharts_json'] ['dataset'] as \$serieInfo) {
                    \$thisSerie = [];
                    foreach (\$serieInfo['data'] as \$plotInfo) {
                        \$thisSerie[] = \$plotInfo['value'];
                    }
                    \$series[] = \$thisSerie;
                }
            }

            if (!empty(\$series)) {
                if ('linear' == \$this->SC_APP_info['options'] ['trendlineType']) {
                    require_once(\$this->Ini->path_lib_php . 'PolynomialRegression.php');
                }

                foreach (\$series as \$thisSerie) {
                    switch (\$this->SC_APP_info['options'] ['trendlineType']) {
                        case 'avg';
                                \$this->aux_addTrendline_average(\$thisSerie);
                            break;
                        case 'linear';
                                \$this->aux_addTrendline_linear(\$thisSerie);
                            break;
                        case 'std_deviation';
                                \$this->aux_addTrendline_standardDeviation(\$thisSerie);
                            break;
                        case 'variance';
                                \$this->aux_addTrendline_variance(\$thisSerie);
                            break;
                    }
                }
            }
        }

        if (empty(\$this->SC_APP_data['fusioncharts_json'] ['trendlines'])) {
            unset(\$this->SC_APP_data['fusioncharts_json'] ['trendlines']);
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_createFusionChartsData_json_data_trendline

/**
 * Salva a configuracao json do grafico FusionCharts
 */
function fnChart_info_saveFusionChartsJson($file)
{
    $phpCode = <<<EOT
    function info_saveFusionChartsJson()
    {
        @file_put_contents(
            \$this->SC_APP_info['chart'] ['json_base_dir'] . \$this->SC_APP_info['chart'] ['json_filename'],
            json_encode(\$this->SC_APP_data['fusioncharts_json'])
        );
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_info_saveFusionChartsJson

/**
 * Exibe a inicializacao da estrutura onde sera exibido o grafico da aplicacao de grafico
 */
function fnChart_display_chartApp_inline_startUp($file)
{
    $phpCode = <<<EOT
    function display_chartApp_inline_startUp()
    {
        \$htmlCode = \$this->display_chart_htmlFusionChartsLibrary();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsDiv_breadcrumb();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsDiv_newPage();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsJavascript_function();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsJavascript_drilldown();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsJavascript_chartApp();

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chartApp_inline_startUp

/**
 * Exibe as informacoes para troca de tipo de grafico na aplicacao de grafico
 */
function fnChart_display_chartApp_type($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function display_chartApp_type(\$chartMd5, \$chartType, \$chartTitle)
    {
        \$this->aux_setChartType(\$chartType);

        \$this->info_initializeData();
        \$this->info_initializeChart(\$chartMd5);

        \$ajaxResponse = [
            'status' => 'ok',
            'chartType' => \$this->SC_APP_data['fusioncharts_javascript'] ['type'],
            'chartUrl' => "{\$this->SC_APP_info['chart'] ['json_base_url']}sc_fc_{$summaryInfo['general'] ['app_name_file']}_{\$chartMd5}.json",
            'chartMd5' => \$chartMd5,
            'chartTitle' => \$chartTitle,
            'errorMessage' => \$this->aux_getChartErrorMessage(),
        ];

        echo json_encode(\$ajaxResponse);
        exit;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chartApp_type

/**
 * Exibe a inicializacao da estrutura onde sera exibido o grafico junto ao resumo
 */
function fnChart_display_summaryChart_inline_startUp($file)
{
    $phpCode = <<<EOT
    function display_summaryChart_inline_startUp()
    {
        \$htmlCode = \$this->display_chart_htmlFusionChartsLibrary();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsDiv_breadcrumb();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsDiv_inline();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsJavascript_function();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsJavascript_drilldown();
        \$htmlCode .= <<<SCEOT
    <span id="sc-summary-fusioncharts-placeholder">
    </span>

SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_summaryChart_inline_startUp

/**
 * Exibe a inicializacao do grafico via ajax
 */
function fnChart_display_summaryChart_inline_initialAjaxCall($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function display_summaryChart_inline_initialAjaxCall(\$chartMd5)
    {
        \$this->info_initializeData();
        \$this->info_initializeChart(\$chartMd5);

        \$scPage = NM_encode_input(\$this->Ini->sc_page);
        \$ajaxUrl = "{\$this->Ini->path_link}{$summaryInfo['general'] ['app_dir']}/{$summaryInfo['general'] ['app_link_base_file']}";

        \$htmlCode = <<<SCEOT
    <script type="text/javascript">
        drillDownBreadcrumb = [{
            label: "{\$this->SC_APP_data['fusioncharts_json'] ['sc'] ['chart_title']}",
            md5: "{\$this->SC_APP_data['fusioncharts_json'] ['sc'] ['chart_md5']}"
        }];
        \$.ajax({
            type: "POST",
            url: "{\$ajaxUrl}",
            dataType: "json",
            data: {
                nmgp_opcao: "grafico",
                script_case_init: "{\$scPage}",
                chart_inline_create: "Y",
                chart_md5: "{\$chartMd5}",
            }
        }).done(function(data) {
            \$("#sc-summary-fusioncharts-placeholder").html(data.chartHtml);

EOT;
    if (!$summaryInfo['general'] ['app_type_chart']) {
        $phpCode .= <<<EOT
            if ('' != data.chartType && '' != data.chartUrl) {
                scFusionCharts_create(data.chartType, data.chartUrl, data.chartWidth, data.chartHeight, data.errorMessage);
            }

EOT;
    }
    $phpCode .= <<<EOT
        });
    </script>

SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_summaryChart_inline_initialAjaxCall

/**
 * Exibe a resposta para inicializacao do grafico via ajax
 */
function fnChart_display_summaryChart_inline_initialAjaxResponse($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function display_summaryChart_inline_initialAjaxResponse(\$chartMd5)
    {
        \$this->info_initializeData();
        \$this->info_initializeChart(\$chartMd5);

        \$ajaxResponse = [
            'status' => 'ok',
            'chartHtml' => '',
            'chartType' => '',
            'chartUrl' => '',
            'chartMd5' => \$chartMd5,
            'chartWidth' => \$this->SC_APP_data['width'],
            'chartHeight' => \$this->SC_APP_data['height'],
            'errorMessage' => \$this->aux_getChartErrorMessage(),
        ];

        if ('' != \$chartMd5 && isset(\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['chart_info'] [\$chartMd5])) {
            \$ajaxResponse['chartHtml'] .= \$this->display_chart_htmlFusionChartsJavascript_setInlineChartMd5(\$chartMd5);
            \$ajaxResponse['chartType'] = \$this->SC_APP_data['fusioncharts_javascript'] ['type'];
            \$ajaxResponse['chartUrl'] = \$this->SC_APP_data['fusioncharts_javascript'] ['dataSource'];
        }


EOT;
    if ($summaryInfo['general'] ['app_type_chart']) {
        $phpCode .= <<<EOT
        \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['opcao'] = 'resumo';


EOT;
    }
    $phpCode .= <<<EOT
        echo json_encode(\$ajaxResponse);
        exit;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_summaryChart_inline_initialAjaxResponse

/**
 * Exibe a resposta para atualizacao do grafico via ajax
 */
function fnChart_display_summaryChart_inline_updateAjaxResponse($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function display_summaryChart_inline_updateAjaxResponse(\$chartMd5)
    {
        \$this->info_initializeData();
        \$this->info_initializeChart(\$chartMd5);

        \$ajaxResponse = [
            'status' => 'ok',
            'chartType' => \$this->SC_APP_data['fusioncharts_javascript'] ['type'],
            'chartUrl' => \$this->SC_APP_data['fusioncharts_javascript'] ['dataSource'],
            'chartMd5' => \$chartMd5,
            'chartWidth' => \$this->SC_APP_data['width'],
            'chartHeight' => \$this->SC_APP_data['height'],
            'errorMessage' => \$this->aux_getChartErrorMessage(),
        ];


EOT;
    if ($summaryInfo['general'] ['app_type_chart']) {
        $phpCode .= <<<EOT
        \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['opcao'] = 'resumo';


EOT;
    }
    $phpCode .= <<<EOT
        echo json_encode(\$ajaxResponse);
        exit;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_summaryChart_inline_updateAjaxResponse

/**
 * Exibe os dados do FusionCharts de um grafico
 */
function fnChart_display_summaryChart_data($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function display_summaryChart_data(\$chartMd5)
    {
        \$this->info_initializeChart(\$chartMd5);


EOT;
    if ($summaryInfo['general'] ['app_type_chart']) {
        $phpCode .= <<<EOT
        \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['opcao'] = 'resumo';


EOT;
    }
    $phpCode .= <<<EOT
        \$chartFile = "{\$this->SC_APP_info['chart'] ['json_base_dir']}sc_fc_{$summaryInfo['general'] ['app_name_file']}_{\$chartMd5}.json";

        echo @file_get_contents(\$chartFile);
        exit;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_summaryChart_data

/**
 * Exibe o grafico do resumo em uma nova pagina
 */
function fnChart_display_summaryChart_newPage($file)
{
    $phpCode = <<<EOT
    function display_summaryChart_newPage(\$chartMd5)
    {
        global \$nm_saida;

        \$this->info_initializeData();
        \$this->info_initializeChart(\$chartMd5);

        \$htmlCode = \$this->display_chart_htmlHeader();
        \$htmlCode .= \$this->display_chart_summaryBody();
        \$htmlCode .= \$this->display_chart_htmlFooter();

        \$nm_saida->saida(\$htmlCode);
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_summaryChart_newPage

/**
 * Exibe o grafico do resumo para uso pelo Phantom
 */
function fnChart_display_summaryChart_phantom($file)
{
    $phpCode = <<<EOT
    function display_summaryChart_phantom()
    {
        \$htmlCode = \$this->display_chart_htmlFusionChartsDiv_newPage();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsJavascript_phantom();

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_summaryChart_phantom

/**
 * Recupera as informacoes adicionais para criacao do MD5 para nomeacao da imagem do grafico
 */
function fnChart_display_summaryChart_phantom_md5($file)
{
    $phpCode = <<<EOT
    function display_summaryChart_phantom_md5()
    {
        return '__' . implode('X', [
            (\$this->SC_APP_data['md5_data'] ['options'] ['is_comparison'] ? 'comparison' : 'standard'),
            \$this->SC_APP_data['fusioncharts_javascript'] ['type'],
            \$this->SC_APP_data['fusioncharts_javascript'] ['width'],
            \$this->SC_APP_data['fusioncharts_javascript'] ['height'],
        ]);
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_summaryChart_phantom_md5

/**
 * Exibe o corpo html do grafico do resumo
 */
function fnChart_display_chart_summaryBody($file)
{
    $phpCode = <<<EOT
    function display_chart_summaryBody()
    {
        \$htmlCode = <<<SCEOT
<body class="{\$this->SC_APP_info['css'] ['chart_page']}">

SCEOT;
        \$htmlCode .= \$this->display_chart_htmlFusionChartsConfigDiv();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsDiv_breadcrumb();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsDiv_newPage();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsJavascript_function();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsJavascript_onReady();
        \$htmlCode .= \$this->display_chart_htmlSamePageBackButton();
        \$htmlCode .= <<<SCEOT
</body>


SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_summaryBody

/**
 * Exibe o corpo html do grafico da aplicacao de grafico
 */
function fnChart_display_chart_chartBody($file)
{
    $phpCode = <<<EOT
    function display_chart_chartBody()
    {
        \$htmlCode = \$this->display_chart_htmlFusionChartsDiv_breadcrumb();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsJavascript_function();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsJavascript_onReady();

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_chartBody

/**
 * Exibe o cabecalho html
 */
function fnChart_display_chart_htmlHeader($file)
{
    $phpCode = <<<EOT
    function display_chart_htmlHeader()
    {
        \$htmlCode = <<<SCEOT
<html>

<head>
    {\$this->SC_APP_info['options'] ['charset']}

SCEOT;
        if ('' != \$this->SC_APP_info['options'] ['favicon']) {
            \$htmlCode .= <<<SCEOT
    <link rel="shortcut icon" href="../_lib/img/{\$this->SC_APP_info['options'] ['favicon']}" />

SCEOT;
        }
        if (\$this->aux_isMobile()) {
            \$htmlCode .= <<<SCEOT
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />

SCEOT;
        }
        \$htmlCode .= \$this->display_chart_htmlHeader_styleCss();
        \$htmlCode .= \$this->display_chart_htmlHeader_linkCss();
        \$htmlCode .= \$this->display_chart_htmlHeader_javascript();
        \$htmlCode .= \$this->display_chart_htmlFusionChartsJavascript_drilldown();
        \$htmlCode .= <<<SCEOT
    <title>{\$this->SC_APP_info['chart'] ['page_title']}</title>
</head>


SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlHeader

/**
 * Exibe a inclusao de estilos css do cabecalho html com a tag style
 */
function fnChart_display_chart_htmlHeader_styleCss($file)
{
    $phpCode = <<<EOT
    function display_chart_htmlHeader_styleCss()
    {
        \$htmlCode = <<<SCEOT
    <style>
        #sc-id-chart-blockui {
            display: none;
            position: fixed;
            top: 0px;
            left: 0px;
            width: 100%;
            height: 100%;
            background-color: rgb(255, 255, 255);
            z-index: 99900;
            opacity: 0.7;
        }
        #sc-id-div-config {
            position: absolute;
            top: 50%;
            left: 50%;
            padding: 1.5rem;
            z-index: 99990;
            width: 700px;
            border: 1px solid #c2c2c2;
            display: none;
            flex-flow: column nowrap;
            row-gap: 2rem;
            justify-content: center;
            align-items: flex-start;
            box-sizing: border-box;
            transform: translate(-50%, -50%);
            box-shadow: 0 8px 16px rgba(0,0,0,.25);
        }
        #sc-id-div-config-input {
            width: 100%;
            display: flex;
            flex-flow: row wrap;
            row-gap: .875rem;
            column-gap: .875rem;
            justify-content: space-between;
            align-items: center;
        }
        #sc-id-div-config-button {
            width: 100%;
            display: flex;
            flex-flow: row nowrap;
            justify-content: end;
            column-gap: .75rem;
        }
        .input-group {
            flex-flow: column nowrap;
            justify-content: flex-start;
            align-items: flex-start;
            row-gap: .5rem;
            display: flex;
        }
        .input-group > label {
            font-weight: 700;
        }
        #sc-id-drilldown-breadcrumb {
            padding: 10px 0;
        }
    </style>

SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlHeader_styleCss

/**
 * Exibe a inclusao de estilos css do cabecalho html com a tag link
 */
function fnChart_display_chart_htmlHeader_linkCss($file)
{
    $phpCode = <<<EOT
    function display_chart_htmlHeader_linkCss()
    {
        \$htmlCode = '';

        if (\$this->SC_APP_info['options'] ['use_fontawesome']) {
            \$htmlCode .= <<<SCEOT
    <link rel="stylesheet" href="{\$this->Ini->path_prod}/third/font-awesome/6/css/all.min.css" type="text/css" media="screen,print" />

SCEOT;
        }

        if ('' != \$this->SC_APP_info['options'] ['summary_css']) {
            \$summaryCss = NM_encode_input(\$this->SC_APP_info['options'] ['summary_css']);

            \$htmlCode .= <<<SCEOT
    <link rel="stylesheet" href="{\$summaryCss}" type="text/css" media="screen,print" />

SCEOT;
        }

        \$htmlCode .= <<<SCEOT
    <link rel="stylesheet" href="../_lib/buttons/{\$this->Ini->Str_btn_css}" type="text/css" media="screen,print" />

SCEOT;

        if (isset(\$this->Ini->str_google_fonts) && !empty(\$this->Ini->str_google_fonts)) {
            \$htmlCode .= <<<SCEOT
    <link rel="stylesheet" href="{\$this->Ini->str_google_fonts}" type="text/css" media="screen,print" />

SCEOT;
        }

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlHeader_linkCss

/**
 * Exibe a inclusao de codigo javascript do cabecalho html
 */
function fnChart_display_chart_htmlHeader_javascript($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function display_chart_htmlHeader_javascript()
    {
        \$scPage = NM_encode_input(\$this->Ini->sc_page);
        \$ajaxUrl = "{\$this->Ini->path_link}{$summaryInfo['general'] ['app_dir']}/{$summaryInfo['general'] ['app_name_file']}_config_graf_flash.php?nome_apl={$summaryInfo['general'] ['app_name_var']}&campo_apl=nm_resumo_graf&sc_page=" . NM_encode_input(\$this->Ini->sc_page) . "&language={$summaryInfo['general'] ['app_language']}";
        \$ajaxUrlDrillDown = "{\$this->Ini->path_link}{$summaryInfo['general'] ['app_dir']}/{$summaryInfo['general'] ['app_link_base_file']}";

        \$htmlCode = <<<SCEOT
    <script type="text/javascript" src="{\$this->Ini->path_prod}/third/jquery/js/jquery.js"></script>
    <script type="text/javascript">
        function showChartConfig()
        {
            $("#sc-id-div-config").css("display", "flex").show();
            $("#sc-id-chart-blockui").show();
        }
        function hideChartConfig()
        {
            $("#sc-id-div-config").hide();
            $("#sc-id-chart-blockui").hide();
        }
        $(function() {
            $("#sc-id-button-submit").on("click", function() {
                $.ajax({
                    type: "POST",
                    url: "{\$ajaxUrl}",
                    data: {
                        bok_graf: "OK",
                        ajax: "OK",
                        nome_apl: "{$summaryInfo['general'] ['app_name_var']}",
                        campo_apl: "nm_resumo_graf",
                        sc_page: "{\$scPage}",
                        tipo: $("#sc-id-chart-type").val(),
                        opc_atual: $("#sc-id-chart-mode").val(),
                        largura: $("#sc-id-chart-width").val(),
                        altura: $("#sc-id-chart-height").val(),
                        order: $("#sc-id-chart-order").val()
                    }
                }).done(function(data, textStatus, jqXHR) {
                    document.refresh_chart.submit();
                });
            });
            $("#sc-id-button-cancel").on("click", function() {
                hideChartConfig();
            });
        });
    </script>

SCEOT;
        \$htmlCode .= \$this->display_chart_htmlFusionChartsLibrary();

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlHeader_javascript

/**
 * Exibe o rodape html
 */
function fnChart_display_chart_htmlFooter($file)
{
    $phpCode = <<<EOT
    function display_chart_htmlFooter()
    {
        \$htmlCode = <<<SCEOT
</html>

SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlFooter

/**
 * Exibe o codigo html para inclusao dos arquivos da bilbioteca FusionCharts
 */
function fnChart_display_chart_htmlFusionChartsLibrary($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function display_chart_htmlFusionChartsLibrary(\$useServer = '')
    {
        \$jsServer = '';
        if ('pdf' == \$useServer || 'phantom' == \$useServer) {
            \$jsServer = \$this->Ini->server_pdf;
        }

        \$htmlCode = <<<SCEOT
    <script type="text/javascript" src="{\$jsServer}{\$this->Ini->path_prod}/third/{$summaryInfo['chart'] ['fusioncharts_lib']}"></script>

SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlFusionChartsLibrary

/**
 * Exibe o codigo html para criacao da div de configuracao do grafico
 */
function fnChart_display_chart_htmlFusionChartsConfigDiv($file)
{
    global $summaryInfo, $tbapl_toolbars_res;

    $configButtonParameters = [
        'id' => 'Rgraf',
        'click' => 'showChartConfig()',
        'align' => 'absmiddle',
        'value' => isset($tbapl_toolbars_res['labels'] ['sys_format_gra']) ? $tbapl_toolbars_res['labels'] ['sys_format_gra'] : '',
        'hint' => isset($tbapl_toolbars_res['hints'] ['sys_format_gra']) ? $tbapl_toolbars_res['hints'] ['sys_format_gra'] : '',
        'border' => "0",
    ];
    $configButtonCode = trim(new_gera_cod_botoes('bconf_graf', $configButtonParameters));
    if (';' == substr($configButtonCode, -1)) {
        $configButtonCode = substr($configButtonCode, 0, -1);
    }

    $okButtonParameters = [
        'id' => 'sc-id-button-submit',
        'click' => '',
        'align' => 'absmiddle',
        'border' => '0',
    ];
    $okButtonCode = trim(new_gera_cod_botoes('bok', $okButtonParameters));
    if (';' == substr($okButtonCode, -1)) {
        $okButtonCode = substr($okButtonCode, 0, -1);
    }

    $cancelButtonParameters = [
        'id' => 'sc-id-button-cancel',
        'click' => '',
        'align' => 'absmiddle',
        'border' => '0',
    ];
    $cancelButtonCode = trim(new_gera_cod_botoes('bcancelar', $cancelButtonParameters));
    if (';' == substr($cancelButtonCode, -1)) {
        $cancelButtonCode = substr($cancelButtonCode, 0, -1);
    }

    $phpCode = <<<EOT
    function display_chart_htmlFusionChartsConfigDiv()
    {
        \$translate = [];
        \$language = '{$summaryInfo['general'] ['app_language']}';
        if (isset(\$_SESSION['scriptcase'] ['sc_idioma_graf_flash'])) {
            \$translate = \$_SESSION['scriptcase'] ['sc_idioma_graf_flash'];
        }
        if (!isset(\$translate[\$language])) {
            foreach (\$translate as \$language => \$rest) {
                break;
            }
        }

        \$modeSyntheticSelected = self::CHART_MODE_SYNTHETIC == \$this->SC_APP_data['data_mode'] ? ' selected="selected"' : '';
        \$modeAnalyticSelected = self::CHART_MODE_ANALYTIC == \$this->SC_APP_data['data_mode'] ? ' selected="selected"' : '';
        \$modeSyntheticValue = self::CHART_MODE_SYNTHETIC;
        \$modeAnalyticValue = self::CHART_MODE_ANALYTIC;

        \$orderNoneSelected = '' == \$this->SC_APP_data['order'] ? ' selected="selected"' : '';
        \$orderAscSelected = 'asc' == \$this->SC_APP_data['order'] ? ' selected="selected"' : '';
        \$orderDescSelected = 'desc' == \$this->SC_APP_data['order'] ? ' selected="selected"' : '';

        \$configButtonCode = trim({$configButtonCode});
        \$okButtonCode = trim({$okButtonCode});
        \$cancelButtonCode = trim({$cancelButtonCode});

        \$htmlCode = <<<SCEOT
    {\$configButtonCode}
    <div id="sc-id-chart-blockui"></div>
    <div id="sc-id-div-config" class="scGridToolbar">
        <div id="sc-id-div-config-input" class="group">
            <div class="input-group">
                <label>{\$translate[\$language] ['tipo_g']}</label>
                <select id="sc-id-chart-type" class="css_toolbar_obj">

SCEOT;
        foreach (\$this->SC_APP_info['chart'] ['available_types'] as \$chartType) {
            \$typeSelected = \$chartType == \$this->SC_APP_data['type'] ? ' selected="selected"' : '';
             switch (\$chartType) {
                case 'Area':
                   \$chartTitle = 'tp_area';
                   break;
                case 'Bar':
                   \$chartTitle = 'tp_barra';
                   break;
                case 'Funnel':
                   \$chartTitle = 'tp_funil';
                   break;
                case 'Gauge':
                   \$chartTitle = 'tp_gauge';
                   break;
                case 'Line':
                   \$chartTitle = 'tp_linha';
                   break;
                case 'Mark':
                   \$chartTitle = 'tp_marcador';
                   break;
                case 'Pie':
                   \$chartTitle = 'tp_pizza';
                   break;
                case 'Pyramid':
                   \$chartTitle = 'tp_pyramid';
                   break;
                case 'Polar':
                   \$chartTitle = 'tp_polar';
                   break;
                case 'Radar':
                   \$chartTitle = 'tp_radar';
                   break;
             }

            \$htmlCode .= <<<SCEOT
                    <option value="{\$chartType}"{\$typeSelected}>{\$translate[\$language] [\$chartTitle]}</option>

SCEOT;
        }
        \$htmlCode .= <<<SCEOT
                </select>
            </div>
            <div class="input-group">
                <label>{\$translate[\$language] ['modo_gera']}</label>
                <select id="sc-id-chart-mode" class="css_toolbar_obj">
                    <option value="{\$modeSyntheticValue}"{\$modeSyntheticSelected}>{\$translate[\$language] ['sintetico']}</option>
                    <option value="{\$modeAnalyticValue}"{\$modeAnalyticSelected}>{\$translate[\$language] ['analitico']}</option>
                </select>
            </div>
            <div class="input-group">
                <label>{\$translate[\$language] ['largura']}</label>
                <input id="sc-id-chart-width" type="text" size="5" value="{\$this->SC_APP_data['width']}" class="css_toolbar_obj" style="text-align: right" />
            </div>
            <div class="input-group">
                <label>{\$translate[\$language] ['altura']}</label>
                <input id="sc-id-chart-height" type="text" size="5" value="{\$this->SC_APP_data['height']}" class="css_toolbar_obj" style="text-align: right" />
            </div>
            <div class="input-group">
                <label>{\$translate[\$language] ['order']}</label>
                <select id="sc-id-chart-order" class="css_toolbar_obj">
                    <option value=""{\$orderNoneSelected}>{\$translate[\$language] ['order_none']}</option>
                    <option value="asc"{\$orderAscSelected}>{\$translate[\$language] ['order_asc']}</option>
                    <option value="desc"{\$orderDescSelected}>{\$translate[\$language] ['order_desc']}</option>
                </select>
            </div>
        </div>
        <div id="sc-id-div-config-button" class="input-group">
            {\$okButtonCode}
            {\$cancelButtonCode}
        </div>
    </div>
    <form name="refresh_chart" action="./" method="POST">

SCEOT;
        foreach (\$_POST as \$postItem => \$postValue) {
            \$htmlCode .= <<<SCEOT
        <input type="hidden" name="{\$postItem}" value="{\$postValue}" />

SCEOT;
        }
        \$htmlCode .= <<<SCEOT
    </form>

SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlFusionChartsConfigDiv

/**
 * Exibe o codigo html para criacao da div onde sera renderizado o grafico FusionCharts em graficos inline
 */
function fnChart_display_chart_htmlFusionChartsDiv_inline($file)
{
    $phpCode = <<<EOT
    function display_chart_htmlFusionChartsDiv_inline()
    {
        \$htmlCode = <<<SCEOT
    <div id="{\$this->SC_APP_data['chart_div']}" style="display: inline-block; position: sticky; left: 0"></div>


SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlFusionChartsDiv_inline

/**
 * Exibe o codigo html para criacao da div onde sera renderizado o grafico FusionCharts em graficos em nova pagina
 */
function fnChart_display_chart_htmlFusionChartsDiv_newPage($file)
{
    $phpCode = <<<EOT
    function display_chart_htmlFusionChartsDiv_newPage()
    {
        \$backgroundColor = '#FFFFFF';
        \$fontColor = '#000000';

        \$chartTheme = \$this->load_chart_theme();
        if (isset(\$chartTheme['bgColor']) && '' != \$chartTheme['bgColor']) {
            \$backgroundColor = \$chartTheme['bgColor'];
            \$fontColor = \$chartTheme['captionFontColor'];
        }

        \$htmlCode = <<<SCEOT
    <div style="position: relative;">
        <div id="{\$this->SC_APP_data['chart_div']}" style="width: 100%"></div>
        <div id="sc-id-fusioncharts-error" style="position: absolute; display: none; background-color: {\$backgroundColor}; color: {\$fontColor}">
            <div style="display: flex; height: 100%; justify-content: center; align-items: center;" id="sc-id-fusioncharts-error-message"></div>
        </div>
    </div>
    <script type="text/javascript">var scCombChartId = "{\$this->SC_APP_data['chart_div']}";</script>

SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlFusionChartsDiv_newPage

/**
 * Exibe o codigo html para criacao da div onde sera exibido o breadcrumb de graficos drilldown
 */
function fnChart_display_chart_htmlFusionChartsDiv_breadcrumb($file)
{
    $phpCode = <<<EOT
    function display_chart_htmlFusionChartsDiv_breadcrumb()
    {
        \$htmlCode = <<<SCEOT
    <div id="sc-id-drilldown-breadcrumb" style="display: none"></div>

SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlFusionChartsDiv_breadcrumb

/**
 * Exibe o codigo html com funcao para instanciacao e renderizacao do grafico FusionCharts
 *
 * codigo obfuscado de uso da chave do fusioncharts tambem presente em nmFontePHPContainer para uso de graficos nos
 * indices do dashboard
 */
function fnChart_display_chart_htmlFusionChartsJavascript_function($file)
{
    $phpCode = <<<EOT
    function display_chart_htmlFusionChartsJavascript_function()
    {
        \$jsServer = '';
        if ('pdf' == \$useServer) {
            \$jsServer = \$this->Ini->server_pdf;
        }

        \$htmlCode = <<<SCEOT
    <script type="text/javascript">
        let scFusionCharts;
        let scFusionChartsType = "{\$this->SC_APP_data['fusioncharts_javascript'] ['type']}";
        let scFusionChartsDataSource = "{\$jsServer}{\$this->SC_APP_data['fusioncharts_javascript'] ['dataSource']}";
        let scFusionChartsWidth = "{\$this->SC_APP_data['width']}";
        let scFusionChartsHeight = "{\$this->SC_APP_data['height']}";
        function scFusionCharts_create(chartType, chartDataSource, chartWidth, chartHeight, errorMessage) {
            var _0x2a9c6f=_0x1dca;function _0x1dca(_0xe4377e,_0x1b81e2){var _0x5b52f4=_0x5b52();return _0x1dca=function(_0x1dca71,_0x2a923f){_0x1dca71=_0x1dca71-0x1c7;var _0x141613=_0x5b52f4[_0x1dca71];return _0x141613;},_0x1dca(_0xe4377e,_0x1b81e2);}function _0x5b52(){var _0x2f555f=['667805zEUTHi','2537110AnXgKT','9908390zHctCU','8968kYpBKO','4xIkojs','3cNIlPu','license','159962VsDImE','5018772jBJBQw','7rNiKXc','1067788GrVIGD','2700mLIdJZ'];_0x5b52=function(){return _0x2f555f;};return _0x5b52();}(function(_0x4cefc0,_0x430fb3){var _0x10ab7a=_0x1dca,_0x50734d=_0x4cefc0();while(!![]){try{var _0x9fcd02=-parseInt(_0x10ab7a(0x1ce))/0x1+parseInt(_0x10ab7a(0x1cc))/0x2*(parseInt(_0x10ab7a(0x1c7))/0x3)+parseInt(_0x10ab7a(0x1d2))/0x4*(parseInt(_0x10ab7a(0x1cf))/0x5)+-parseInt(_0x10ab7a(0x1ca))/0x6*(parseInt(_0x10ab7a(0x1cb))/0x7)+parseInt(_0x10ab7a(0x1d1))/0x8*(parseInt(_0x10ab7a(0x1cd))/0x9)+parseInt(_0x10ab7a(0x1d0))/0xa+parseInt(_0x10ab7a(0x1c9))/0xb;if(_0x9fcd02===_0x430fb3)break;else _0x50734d['push'](_0x50734d['shift']());}catch(_0x5b5696){_0x50734d['push'](_0x50734d['shift']());}}}(_0x5b52,0xd688a),FusionCharts['options'][_0x2a9c6f(0x1c8)]({'key':'YcC1orx'+'B1D8B1D3F3'+'C2D2F1C2B4A7B6'+'C4C-9ni1C2C5i'+'qC-13avH2I2es'+'lE2D6E2C3E3'+'G3I3B7A4E2'+'F4B2E3D4F3H3B'+'-22ffF4E2'+'D3nD2G'+'1B6cfqB2'+'E3C1C-7yhB1E'+'4B1suwA33A8B'+'14C5D7'+'A2D5G2H4B3B2'+'hbbA3C4IA2'+'rveA4D4E2'+'C-11oF1I'+'1F2C2'+'eevE6E1G4F2A1'+'C3B1'+'E6E2A2C5F1'+'D1F2l==','creditLabel':![]}));
            FusionCharts.ready(function() {
                scFusionCharts = new FusionCharts({
                    "renderAt": "{\$this->SC_APP_data['chart_div']}",
                    "id": "{\$this->SC_APP_data['chart_id']}",
                    "type": chartType,
                    "width": chartWidth,
                    "height": chartHeight,
                    "dataFormat": "{\$this->SC_APP_data['chart_dataFormat']}",
                    "dataSource": chartDataSource,
                    "loadMessage": "{\$this->Ini->Nm_lang['lang_msg_chart_load']}",
                    "dataEmptyMessage": "{\$this->Ini->Nm_lang['lang_msg_chart_empty']}",
                }).render();
                if ("" !== errorMessage) {
                    scFusionCharts_showErrorMessage(errorMessage);
                }
            });
        }
        function scFusionCharts_showErrorMessage(errorMessage)
        {
            let chartContainer = $("#{\$this->SC_APP_data['chart_div']}");
            $("#sc-id-fusioncharts-error-message").html(errorMessage);
            $("#sc-id-fusioncharts-error")
                .offset({top: 0, left: 0})
                .width(chartContainer.width())
                .height(chartContainer.height())
                .show();
        }
        function scFusionCharts_hideErrorMessage()
        {
            $("#sc-id-fusioncharts-error").hide();
        }
    </script>

SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlFusionChartsJavascript_function

/**
 * Exibe o codigo html com funcao para instanciacao e renderizacao do grafico FusionCharts
 */
function fnChart_display_chart_htmlFusionChartsJavascript_phantom($file)
{
    $phpCode = <<<EOT
    function display_chart_htmlFusionChartsJavascript_phantom()
    {
        \$htmlCode = <<<SCEOT
    <script type="text/javascript">
        FusionCharts.options.license({
            key: "YcC1orxB1D8B1D3F3C2D2F1C2B4A7B6C4C-9ni1C2C5iqC-13avH2I2eslE2D6E2C3E3G3I3B7A4E2F4B2E3D4F3H3B-22ffF4E2D3nD2G1B6cfqB2E3C1C-7yhB1E4B1suwA33A8B14C5D7A2D5G2H4B3B2hbbA3C4IA2rveA4D4E2C-11oF1I1F2C2eevE6E1G4F2A1C3B1E6E2A2C5F1D1F2l==",
            creditLabel: false,
        });
        FusionCharts.ready(function() {
            var scFusionCharts = new FusionCharts({
                "creditLabel": false,
                "renderAt": "{\$this->SC_APP_data['chart_div']}",
                "id": "{\$this->SC_APP_data['chart_id']}",
                "type": "{\$this->SC_APP_data['fusioncharts_javascript'] ['type']}",
                "width": "{\$this->SC_APP_data['phantom_width']}",
                "height": "{\$this->SC_APP_data['phantom_height']}",
                "dataFormat": "{\$this->SC_APP_data['chart_dataFormat']}",
                "dataSource": "{\$this->Ini->server_pdf}{\$this->SC_APP_data['fusioncharts_javascript'] ['dataSource']}",
            }).render();
        });
    </script>

SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlFusionChartsJavascript_phantom

/**
 * Exibe o codigo html com chamada da funcao para instanciacao e renderizacao do grafico FusionCharts no evento onReady
 */
function fnChart_display_chart_htmlFusionChartsJavascript_onReady($file)
{
    $phpCode = <<<EOT
    function display_chart_htmlFusionChartsJavascript_onReady()
    {
        \$htmlCode = <<<SCEOT
    <script type="text/javascript">
        \$(function() {
            scFusionCharts_create(scFusionChartsType, scFusionChartsDataSource, scFusionChartsWidth, scFusionChartsHeight, '');
        });
    </script>

SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlFusionChartsJavascript_onReady

/**
 * Exibe o codigo html com as funcoes para controle de aplicacao de grafico
 */
function fnChart_display_chart_htmlFusionChartsJavascript_chartApp($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function display_chart_htmlFusionChartsJavascript_chartApp()
    {
        \$scPage = NM_encode_input(\$this->Ini->sc_page);
        \$ajaxUrl = "{\$this->Ini->path_link}{$summaryInfo['general'] ['app_dir']}/{$summaryInfo['general'] ['app_link_base_file']}";

        \$htmlCode = <<<SCEOT
    <script type="text/javascript">
        function changeChartType(newType, chartAction)
        {
            if ("" == newType) {
                newType = fc_chart_type;
            }
            $.ajax({
                type: "POST",
                url: "{\$ajaxUrl}",
                dataType: "json",
                data: {
                    chartapp_action: "Y",
                    chartapp_chart_type: "Y",
                    script_case_init: "{\$scPage}",
                    chart_md5: scChartInlineMd5,
                    chart_type: newType,
                    chart_action: chartAction,
                }
            }).done(function(data) {
                scFusionCharts_hideErrorMessage();
                if ("" === data.errorMessage) {
                    scFusionCharts.chartType(data.chartType, {
                        dataSource: data.chartUrl,
                        dataFormat: "jsonUrl"
                    });
                } else {
                    scFusionCharts_showErrorMessage(data.errorMessage);
                }
                if ("scSaveChartChanges" == chartAction) {
                    scChartInlineMd5 = data.chartMd5;
                    drillDownBreadcrumb = [{
                        label: data.chartTitle,
                        md5: data.chartMd5
                    }];
                    chartDrillDown_content();
                }
                if ("scChangeChartType" == chartAction || "scSaveChartSorting" == chartAction) {
                    scChartInlineMd5 = data.chartMd5;
                    chartDrillDown_clearBreadcrumb();
                }
            });
        }
    </script>

SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlFusionChartsJavascript_chartApp

/**
 * Exibe o codigo html com as funcoes para realizacao do drill down
 */
function fnChart_display_chart_htmlFusionChartsJavascript_drilldown($file)
{
    global $summaryInfo;

    $chartLinkFuncion = '';
    if ('drilldown' == $summaryInfo['chart'] ['chart_link']) {
        $chartLinkFuncion = 'chartDrillDown';
    } elseif ('grid' == $summaryInfo['chart'] ['chart_link']) {
        $chartLinkFuncion = 'chartLinkToGrid';
    }

    $phpCode = <<<EOT
    function display_chart_htmlFusionChartsJavascript_drilldown()
    {
        \$scPage = NM_encode_input(\$this->Ini->sc_page);
        \$ajaxUrl = "{\$this->Ini->path_link}{$summaryInfo['general'] ['app_dir']}/{$summaryInfo['general'] ['app_link_base_file']}";

        \$htmlCode = <<<SCEOT
    <script type="text/javascript">
        let drillDownBreadcrumb = [{
            label: "{\$this->SC_APP_data['fusioncharts_json'] ['sc'] ['chart_title']}",
            md5: "{\$this->SC_APP_data['fusioncharts_json'] ['sc'] ['chart_md5']}"
        }];
        function chartLink(chartMd5)
        {

EOT;
    if ('none' != $summaryInfo['chart'] ['chart_link']) {
        $phpCode .= <<<EOT
            {$chartLinkFuncion}(chartMd5);

EOT;
    }
    $phpCode .= <<<EOT
        }
        function chartDrillDown(chartMd5)
        {
            $.ajax({
                type: "POST",
                url: "{\$ajaxUrl}",
                dataType: "json",
                data: {
                    nmgp_opcao: "grafico",
                    summary_chart_data: "Y",
                    script_case_init: "{\$scPage}",
                    chart_md5: chartMd5,
                }
            }).done(function(data) {
                drillDownBreadcrumb.push({
                    label: data.sc.chart_subtitle,
                    md5: data.sc.chart_md5
                });
                scFusionCharts.setChartData(data);
                chartDrillDown_content();
            });
        }
        function chartDrillDown_back(chartIndex)
        {
            $.ajax({
                type: "POST",
                url: "{\$ajaxUrl}",
                dataType: "json",
                data: {
                    nmgp_opcao: "grafico",
                    summary_chart_data: "Y",
                    script_case_init: "{\$scPage}",
                    chart_md5: drillDownBreadcrumb[chartIndex].md5,
                }
            }).done(function(data) {
                let removeCount = drillDownBreadcrumb.length - chartIndex - 1;
                while (removeCount > 0) {
                    drillDownBreadcrumb.pop();
                    removeCount--;
                }
                scFusionCharts.setChartData(data);
                chartDrillDown_content();
            });
        }
        function chartDrillDown_content()
        {
            if (1 == drillDownBreadcrumb.length) {
                $("#sc-id-drilldown-breadcrumb").html("").slideUp("slow");
            } else {
                let chartTitles = [], i, thisChartTitle;
                for (i = 0; i < drillDownBreadcrumb.length; i++) {
                    thisChartTitle = drillDownBreadcrumb[i].label;
                    if (i < drillDownBreadcrumb.length - 1) {
                        thisChartTitle = "<a href='javascript: chartDrillDown_back(" + i + ")'>" + thisChartTitle + "</a>";
                    }
                    chartTitles.push(thisChartTitle);
                }
                $("#sc-id-drilldown-breadcrumb").html(chartTitles.join(' <i class="fa-solid fa-angle-right"></i> '));
                if (2 == drillDownBreadcrumb.length) {
                    $("#sc-id-drilldown-breadcrumb").slideDown("slow")
                }
            }
        }
        function chartDrillDown_clearBreadcrumb()
        {
            while (1 < drillDownBreadcrumb.length) {
                drillDownBreadcrumb.pop();
            }
            chartDrillDown_content();
        }
        function chartLinkToGrid(chartInfo)
        {

EOT;
    if ($summaryInfo['options'] ['display_inline_chart']) {
        $phpCode .= <<<EOT
            nm_link_cons(chartInfo);

EOT;
    } else {
        $phpCode .= <<<EOT
            opener.nm_link_cons(chartInfo);
            window.close();

EOT;
    }
    $phpCode .= <<<EOT
        }
    </script>

SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlFusionChartsJavascript_drilldown

/**
 * Exibe o codigo html com chamada da funcao para atribuicao da chave MD5 inicial do grafico junto ao resumo
 */
function fnChart_display_chart_htmlFusionChartsJavascript_setInlineChartMd5($file)
{
    $phpCode = <<<EOT
    function display_chart_htmlFusionChartsJavascript_setInlineChartMd5(\$chartMd5)
    {
        \$htmlCode = <<<SCEOT
    <script type="text/javascript">
        \$(function() {
            scChartInlineMd5 = "{\$chartMd5}";
        });
    </script>

SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlFusionChartsJavascript_setInlineChartMd5

/**
 * Exibe o codigo html com o link de volta ao resumo em graficos que sao abertos em uma nova pagina
 */
function fnChart_display_chart_htmlSamePageBackButton($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function display_chart_htmlSamePageBackButton()
    {
        global \$nm_retorno_graf;

        if (!\$this->SC_APP_info['options'] ['chart_same_page']) {
            return;
        }

EOT;

        if (scSecurity_use_sc_session()) {
$phpCode .= <<<EOT
        \$security = '&script_case_session=' . session_id();
EOT;

        }
        else {
$phpCode .= <<<EOT
        \$security = '';

EOT;

        }
$phpCode .= <<<EOT
        \$scInit = NM_encode_input(\$this->Ini->sc_page);

        if (empty(\$nm_retorno_graf)) {
            \$nm_retorno_graf = 'resumo';
        }

        \$htmlCode = <<<SCEOT
<br /><br />
<a class="scGridPageLink" href="{$summaryInfo['general'] ['app_link_base_file']}?script_case_init={\$scInit}{\$security}&nmgp_opcao={\$nm_retorno_graf}">{\$this->Ini->Nm_lang['lang_btns_rtrn_hint']}</a>

SCEOT;

        return \$htmlCode;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_display_chart_htmlSamePageBackButton

/**
 * Adiciona trendline da media da serie
 */
function fnChart_aux_addTrendline_average($file)
{
    $phpCode = <<<EOT
    function aux_addTrendline_average(\$serie)
    {
        \$mean = \$this->calculateMean(\$serie);

        \$lines = ['line' => []];
        \$lines['line'] [] = [
            'startvalue' => \$mean,
            'tooltext' => '\$startDataValue',
            'dashed' => '1',
            'dashLen' => '5',
            'dashGap' => '2',
        ];

        \$this->SC_APP_data['fusioncharts_json'] ['trendlines'] [] = \$lines;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_addTrendline_average

/**
 * Adiciona trendline fixo
 */
function fnChart_aux_addTrendline_fixed($file)
{
    $phpCode = <<<EOT
    function aux_addTrendline_fixed()
    {
        \$lines = ['line' => []];
        \$lines['line'] [] = [
            'startvalue' => \$this->SC_APP_info['options'] ['trendlineStart'],
            'tooltext' => '\$startDataValue',
            'dashed' => '1',
            'dashLen' => '5',
            'dashGap' => '2',
        ];

        \$this->SC_APP_data['fusioncharts_json'] ['trendlines'] [] = \$lines;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_addTrendline_fixed

/**
 * Adiciona trendline linear da serie
 */
function fnChart_aux_addTrendline_linear($file)
{
    $phpCode = <<<EOT
    function aux_addTrendline_linear(\$serie)
    {
        if (function_exists('bcscale')) {
            bcscale(10);
            \$polynomialRegression = new PolynomialRegression(2);
            foreach (\$serie as \$i => \$dataPoint) {
                \$polynomialRegression->addData(\$i, \$dataPoint);
            }
            \$coefficients = \$polynomialRegression->getCoefficients();

            \$lines = ['line' => []];
            \$lines['line'] [] = [
                'startvalue' => \$coefficients[0],
                'endvalue' => (\$coefficients[1] * \$i) + \$coefficients[0],
                'tooltext' => '\$startDataValue',
                'dashed' => '1',
                'dashLen' => '5',
                'dashGap' => '2',
            ];

            \$this->SC_APP_data['fusioncharts_json'] ['trendlines'] [] = \$lines;
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_addTrendline_linear

/**
 * Adiciona trendline do desvio padrao da serie
 */
function fnChart_aux_addTrendline_standardDeviation($file)
{
    $phpCode = <<<EOT
    function aux_addTrendline_standardDeviation(\$serie)
    {
        \$mean = \$this->calculateMean(\$serie);
        \$variance = \$this->calculateVariance(\$serie, \$mean);
        \$stdDeviation = \$this->calculateStandardDeviation(\$variance);

        \$lines = ['line' => []];
        \$lines['line'] [] = [
            'startvalue' => \$stdDeviation,
            'tooltext' => '\$startDataValue',
            'dashed' => '1',
            'dashLen' => '5',
            'dashGap' => '2',
        ];

        \$this->SC_APP_data['fusioncharts_json'] ['trendlines'] [] = \$lines;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_addTrendline_standardDeviation

/**
 * Adiciona trendline da variancia da serie
 */
function fnChart_aux_addTrendline_variance($file)
{
    $phpCode = <<<EOT
    function aux_addTrendline_variance(\$serie)
    {
        \$mean = \$this->calculateMean(\$serie);
        \$variance = \$this->calculateVariance(\$serie, \$mean);

        \$lines = ['line' => []];
        \$lines['line'] [] = [
            'startvalue' => \$variance,
            'tooltext' => '\$startDataValue',
            'dashed' => '1',
            'dashLen' => '5',
            'dashGap' => '2',
        ];

        \$this->SC_APP_data['fusioncharts_json'] ['trendlines'] [] = \$lines;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_addTrendline_variance

/**
 * Adiciona trendline de zona
 */
function fnChart_aux_addTrendline_zone($file)
{
    $phpCode = <<<EOT
    function aux_addTrendline_zone()
    {
        \$lines = ['line' => []];
        \$lines['line'] [] = [
            'isTrendZone' => 1,
            'startvalue' => \$this->SC_APP_info['options'] ['trendlineStart'],
            'endvalue' => \$this->SC_APP_info['options'] ['trendlineEnd'],
            'tooltext' => '\$startDataValue - \$endDataValue',
            'displayvalue' => ' ',
        ];

        \$this->SC_APP_data['fusioncharts_json'] ['trendlines'] [] = \$lines;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_addTrendline_zone

/**
 * Cria a folha de estilo summary_css
 */
function fnChart_aux_createSummaryCss($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function aux_createSummaryCss()
    {
        if (isset(\$_POST['nmgp_cor_print'])) {
            \$nmgp_cor_print = \$_POST['nmgp_cor_print'];
        } elseif (isset(\$_GET['nmgp_cor_print'])) {
            \$nmgp_cor_print = \$_GET['nmgp_cor_print'];
        } else {
            \$nmgp_cor_print = '';
        }
        if (isset(\$_POST['nmgp_tipo_pdf'])) {
            \$nmgp_tipo_pdf = \$_POST['nmgp_tipo_pdf'];
        } elseif (isset(\$_GET['nmgp_cor_print'])) {
            \$nmgp_tipo_pdf = \$_GET['nmgp_tipo_pdf'];
        } else {
            \$nmgp_tipo_pdf = '';
        }

        \$cssFileName = \$this->Ini->path_imag_temp . '/sc_css_{$summaryInfo['general'] ['app_name_file']}_sum_' . \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['num_css'] . '.css'; 
        \$cssFilePointer = @fopen(\$this->Ini->root . \$cssFileName, 'w');

        if ((\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['opcao'] == "print" && strtoupper(\$nmgp_cor_print) == "PB") || \$nmgp_tipo_pdf == "pb") {
            \$gridCssFile = \$this->Ini->str_schema_all . "_grid_bw.css";
            \$gridCssDirection = \$this->Ini->str_schema_all . "_grid_bw" . \$_SESSION['scriptcase'] ['reg_conf'] ['css_dir'] . ".css";
        } else {
            \$gridCssFile = \$this->Ini->str_schema_all . "_grid.css";
            \$gridCssDirection = \$this->Ini->str_schema_all . "_grid" . \$_SESSION['scriptcase'] ['reg_conf'] ['css_dir'] . ".css";
        }

        if (is_file(\$this->Ini->path_css . \$gridCssFile)) {
            \$cssFileContents = file(\$this->Ini->path_css . \$gridCssFile);
            foreach (\$cssFileContents as \$cssLine) {
                \$cssLine = str_replace("../../img", \$this->Ini->path_imag_cab, \$cssLine);
                @fwrite(\$cssFilePointer, "    " .  \$cssLine . "\\r\\n");
            }
        }

        if (is_file(\$this->Ini->path_css . \$gridCssDirection)) {
            \$cssFileContents = file(\$this->Ini->path_css . \$gridCssDirection);
            foreach (\$cssFileContents as \$cssLine) {
                \$cssLine = str_replace("../../img", \$this->Ini->path_imag_cab, \$cssLine);
                @fwrite(\$cssFilePointer, "    " .  \$cssLine . "\\r\\n");
            }
        }

        @fclose(\$cssFilePointer);

        return \$cssFileName;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_createSummaryCss

/**
 * Filtra items do grafico para satisfazer limite de items de exibicao
 */
function fnChart_aux_filterChartItems($file)
{
    $phpCode = <<<EOT
    function aux_filterChartItems()
    {
        \$itemCount = 0;
        \$itemValues = [];

        foreach (\$this->SC_APP_data['md5_data'] ['data_synthetic'] [self::GROUPBY_ORIGINAL] as \$dimensionValue => \$dimensionInfo) {
            \$itemValues[ \$dimensionInfo['label'] ] = \$dimensionInfo['value'];
        }

        arsort(\$itemValues);

        foreach (\$itemValues as \$dimensionLabel => \$dimensionValue) {
            \$this->SC_APP_data['filtered_chart_items'] [] = \$dimensionLabel;

            \$itemCount++;
            if (\$itemCount == \$this->SC_APP_data['limit_chart_items']) {
                break;
            }
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_filterChartItems

/**
 * Funcoes de formatacao dos valores do grafico de acordo com a metrica.
 */
function fnChart_aux_format_functions($file, $groupByName)
{
    global $summaryInfo;

    $phpCode = '';

    foreach ($summaryInfo['group_by'] [$groupByName] ['metric'] as $metricInfo) {
        $phpCode .= <<<EOT
    function {$metricInfo['format_function']}()
    {
        \$chartFormat = [

EOT;
        foreach ($metricInfo['chart_format'] as $chartFormatRule => $chartFormatValue) {
            $phpCode .= <<<EOT
            '$chartFormatRule' => "$chartFormatValue",

EOT;
        }
        $phpCode .= <<<EOT
        ];

        return \$this->aux_formatFinalize(\$chartFormat);
    }


EOT;
    }

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_format_functions

/**
 * Finaliza formatacao de valores do grafico
 */
function fnChart_aux_formatFinalize($file)
{
    $phpCode = <<<EOT
    function aux_formatFinalize(\$formatConfig)
    {
        \$monetaryIni = '';
        \$monetaryEnd = '';

        if ('' != \$formatConfig['monetarySymbol']) {
            if ('' == \$formatConfig['monetaryPosition'] || 'left' == \$formatConfig['monetaryPosition']) {
                \$monetaryIni = \$this->aux_protectText(\$formatConfig['monetarySymbol']) . \$formatConfig['monetarySpace'];
                \$monetaryEnd = '';
            } else {
                \$monetaryIni = '';
                \$monetaryEnd = \$formatConfig['monetarySpace'] . \$this->aux_protectText(\$formatConfig['monetarySymbol']);
            }
            \$formatConfig['decimalSeparator'] = \$formatConfig['monetaryDecimal'];
            \$formatConfig['thousandSeparator'] = \$formatConfig['monetaryThousands'];
        }
        if ('' == \$formatConfig['decimals']) {
            \$formatConfig['decimals'] = 0;
            unset(\$formatConfig['trailingZeros']);
        } elseif (1 != \$formatConfig['forceDecimals']) {
            \$formatConfig['forceDecimals'] = 0;
        } else {
            \$formatConfig['forceDecimals'] = 1;
        }
        if ('' == \$formatConfig['trailingZeros']) {
            unset(\$formatConfig['trailingZeros']);
        }
        if ('' != \$monetaryIni) {
            \$formatConfig['numberPrefix'] = \$monetaryIni;
        }
        if ('' != \$monetaryEnd) {
            \$formatConfig['numberSuffix'] = \$monetaryEnd;
        }
        unset(\$formatConfig['monetarySymbol']);
        unset(\$formatConfig['monetaryPosition']);
        unset(\$formatConfig['monetarySpace']);
        unset(\$formatConfig['monetaryDecimal']);
        unset(\$formatConfig['monetaryThousands']);

        if (',' == \$formatConfig['decimalSeparator']) {
            unset(\$formatConfig['decimalSeparator']);
            \$formatConfig['decimalSeparator'] = ',';
        }
        if (',' == \$formatConfig['thousandSeparator']) {
            unset(\$formatConfig['thousandSeparator']);
            \$formatConfig['thousandSeparator'] = ',';
        }

        if (isset(\$formatConfig['formatNumberScale']) && '1' == \$formatConfig['formatNumberScale']) {
            unset(\$formatConfig['trailingZeros']);
            \$formatConfig['decimals'] = 0;
        }

        foreach (\$formatConfig as \$i => \$v) {
            if ('' === \$v) {
                unset(\$formatConfig[\$i]);
            }
        }

        return \$formatConfig;
    }


EOT;

    nm_imprime_2($file, $phpCode);
}

/**
 * Retorna a mensagem de erro do grafico
 */
function fnChart_aux_getChartErrorMessage($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function aux_getChartErrorMessage()
    {
        \$dimensionCount = isset(\$this->SC_APP_data['md5_data'] ['dimension_list']) && is_array(\$this->SC_APP_data['md5_data'] ['dimension_list']) ? count(\$this->SC_APP_data['md5_data'] ['dimension_list']) : 0;
        \$metricCount = isset(\$this->SC_APP_data['md5_data'] ['metric']) && is_array(\$this->SC_APP_data['md5_data'] ['metric']) ? count(\$this->SC_APP_data['md5_data'] ['metric']) : 0;
        //return \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] . ' - ' . \$dimensionCount . ' - ' . \$metricCount;

        switch (\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo']) {
            case 'Bubble':
                    if (3 != \$metricCount) {
                        return "{\$this->Ini->Nm_lang['lang_msg_chart_bubble']}";
                    }
                break;
            case 'Chord':
                    if (2 != \$dimensionCount && 1 != \$metricCount) {
                        return "{\$this->Ini->Nm_lang['lang_msg_chart_chord']}";
                    }
                break;
            case 'Combination':
                    if (2 > \$metricCount) {
                        return "{\$this->Ini->Nm_lang['lang_msg_chart_combination']}";
                    }
                break;
            case 'Heatmap':
                    if (2 != \$dimensionCount && 1 != \$metricCount) {
                        return "{\$this->Ini->Nm_lang['lang_msg_chart_heatmap']}";
                    }
                break;
            case 'Sankey':
                    if (2 != \$dimensionCount && 1 != \$metricCount) {
                        return "{\$this->Ini->Nm_lang['lang_msg_chart_sankey']}";
                    }
                break;
            case 'Scatter':
                    if (2 != \$metricCount) {
                        return "{\$this->Ini->Nm_lang['lang_msg_chart_scatter']}";
                    }
                break;
            case 'Sunburst':
                    if (1 != \$metricCount) {
                        return "{\$this->Ini->Nm_lang['lang_msg_chart_sunburst']}";
                    }
                break;
            case 'Treemap':
                    if (2 != \$dimensionCount && 2 != \$metricCount) {
                        return "{\$this->Ini->Nm_lang['lang_msg_chart_treemap']}";
                    }
                break;
            default:
                //return \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'];
                break;
        }

        return '';
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_getChartErrorMessage

/**
 * Retorna o indice de armazenamento das informacoes de graficos de acordo com o tipo de grafico sendo exibido
 */
function fnChart_aux_getChartInfoType($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function aux_getChartInfoType()
    {
        switch (\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo']) {
            case 'Chord':
                return 'chord_info';
            case 'Heatmap':
                return 'heatmap_info';
            case 'Sankey':
                return 'sankey_info';
            case 'Sunburst':
                return 'sunburst_info';
            case 'Treemap':
                return 'treemap_info';
            default:
                return 'chart_info';
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_getChartInfoType

/**
 * Retorna parametro para funcao de link do grafico
 */
function fnChart_aux_getChartLink($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function aux_getChartLink(\$dimension, \$metric, \$parameters, \$thisValue)
    {
        \$identifierParameters = [];
        foreach (\$parameters as \$parameterInfo) {
            \$identifierParameters[] = \$parameterInfo['value'];
        }
        \$identifierParameters[] = \$thisValue;

EOT;
    if ('drilldown' == $summaryInfo['chart'] ['chart_link']) {
        if ($summaryInfo['general'] ['app_type_chart']) {
            $phpCode .= <<<EOT
        if (!isset(\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['summarizing_drill_down']) || !\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['summarizing_drill_down']) {
            return '';
        } else {
            return \$this->aux_getChartLinkMd5(\$dimension, \$metric, \$identifierParameters);
        }

EOT;
        } else {
            $phpCode .= <<<EOT
        return \$this->aux_getChartLinkMd5(\$dimension, \$metric, \$identifierParameters);

EOT;
        }
    } elseif ('grid' == $summaryInfo['chart'] ['chart_link']) {
        $phpCode .= <<<EOT
        return \$this->aux_getChartLinkInfo(\$identifierParameters);

EOT;
    } else {
        $phpCode .= <<<EOT
        return '';

EOT;
    }
    $phpCode .= <<<EOT
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_getChartLink

/**
 * Retorna informacao de link para grid
 */
function fnChart_aux_getChartLinkInfo($file)
{
    $phpCode = <<<EOT
    function aux_getChartLinkInfo(\$identifierParameters)
    {
        \$linkInfo = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['grid_drilldown'] ['chart_links_to_grid'];

        while (!empty(\$identifierParameters)) {
            \$thisParameter = array_shift(\$identifierParameters);
            \$linkInfo = \$linkInfo[\$thisParameter];
        }

        return \$linkInfo['__sc_chart_link'];
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_getChartLinkInfo

/**
 * Retorna chave MD5 para identificacao do grafico
 */
function fnChart_aux_getChartLinkMd5($file)
{
    $phpCode = <<<EOT
    function aux_getChartLinkMd5(\$dimension, \$metric, \$identifierParameters)
    {
        \$dimensionLabel = [];
        foreach (\$dimension as \$dimensionInfo) {
            \$dimensionLabel[] = \$dimensionInfo;
        }

        \$metricLabel = [];
        foreach (\$metric as \$metricInfo) {
            \$metricLabel[] = \$metricInfo['label'];
        }

        \$identifier = 'Dim(' . implode('+', \$dimensionLabel) . ')_X_Met(' . implode('+', \$metricLabel) . ')_|_Par(' . implode('+', \$identifierParameters) . ')';

        return md5(\$identifier);
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_getChartLinkMd5

/**
 * Recupera o tipo de grafico para renderizacao
 */
function fnChart_aux_getFusionChartsRenderer($file)
{
    $phpCode = <<<EOT
    function aux_getFusionChartsRenderer()
    {
        if (\$this->SC_APP_data['md5_data'] ['options'] ['is_comparison']) {
            return \$this->aux_getFusionChartsComparisonRenderer();
        }

        \$multiSeriesSuffix = \$this->aux_isMultiSeries() ? 'ms' : '';

        switch (\$this->SC_APP_data['type']) {
            case 'Area':
                if (\$this->aux_isMultiSeries() && \$this->SC_APP_info['types'] ['area'] ['stacking']) {
                    return 'stackedarea2d';
                } elseif (\$this->SC_APP_info['types'] ['area'] ['isScroll']) {
                    return 'scrollarea2d';
                } elseif ('Spline' == \$this->SC_APP_info['types'] ['area'] ['format']) {
                    return \$multiSeriesSuffix . 'splinearea';
                } elseif (\$this->aux_isMultiSeries()) {
                    return 'msarea';
                } else {
                    return 'area2d';
                }
                break;

            case 'Bar';
                if (\$this->aux_isMultiSeries() && \$this->SC_APP_info['types'] ['bar'] ['stacking']) {
                    \$multiSeriesSuffix = 'stacked';
                }
                if ('Horizontal' == \$this->SC_APP_info['types'] ['bar'] ['orientation']) {
                    if (\$this->SC_APP_info['types'] ['bar'] ['isScroll']) {
                        return 'scrollbar2d';
                    } elseif (\$this->SC_APP_info['types'] ['bar'] ['isOverlapped']) {
                        return 'overlappedbar2d';
                    } elseif ('2d' == \$this->SC_APP_info['types'] ['bar'] ['dimension']) {
                        return \$multiSeriesSuffix . 'bar2d';
                    } else {
                        return \$multiSeriesSuffix . 'bar3d';
                    }
                } else {
                    if (\$this->SC_APP_info['types'] ['bar'] ['isScroll']) {
                        return 'scrollcolumn2d';
                    } elseif (\$this->SC_APP_info['types'] ['bar'] ['isOverlapped']) {
                        return 'overlappedcolumn2d';
                    } elseif ('2d' == \$this->SC_APP_info['types'] ['bar'] ['dimension']) {
                        return \$multiSeriesSuffix . 'column2d';
                    } else {
                        return \$multiSeriesSuffix . 'column3d';
                    }
                }
                break;

            case 'Bubble';
                return 'bubble';
                break;

            case 'Chord';
                return 'chord';
                break;

            case 'Combination';
                    if ('2d' == \$this->SC_APP_info['types'] ['combination'] ['dimension']) {
                        return 'mscombidy2d';
                    } else {
                        return 'mscolumn3dlinedy';
                    }
                break;

            case 'Funnel';
                return 'funnel';
                break;

            case 'Gauge';
                if ('LinearGauge' == \$this->SC_APP_info['types'] ['gauge'] ['format']) {
                    return 'hlineargauge';
                } else {
                    return 'angulargauge';
                }
                break;

            case 'Heatmap';
                return 'heatmap';
                break;

            case 'Line':
                if (\$this->SC_APP_info['types'] ['line'] ['isScroll']) {
                    return 'scrollline2d';
                } elseif (\$this->SC_APP_info['types'] ['line'] ['isZoom']) {
                    return 'zoomline';
                } elseif ('Spline' == \$this->SC_APP_info['types'] ['line'] ['format']) {
                    return 'spline';
                } elseif ('Step' == \$this->SC_APP_info['types'] ['line'] ['format']) {
                    return 'msstepline';
                } else {
                    return \$multiSeriesSuffix . 'line';
                }
                break;

            case 'Pie':
                if ('Donut' == \$this->SC_APP_info['types'] ['pie'] ['format']) {
                    if ('2d' == \$this->SC_APP_info['types'] ['pie'] ['dimension']) {
                        return 'doughnut2d';
                    } else {
                        return 'doughnut3d';
                    }
                } else {
                    if ('2d' == \$this->SC_APP_info['types'] ['pie'] ['dimension']) {
                        return 'pie2d';
                    } else {
                        return 'pie3d';
                    }
                }
                break;

            case 'Pyramid';
                return 'pyramid';
                break;

            case 'Radar';
                return 'radar';
                break;

            case 'Sankey';
                return 'sankey';
                break;

            case 'Sunburst';
                return 'sunburst';
                break;

            case 'Scatter';
                return 'scatter';
                break;

            case 'Treemap';
                return 'treemap';
                break;
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_getFusionChartsRenderer

/**
 * Recupera o tipo de grafico para renderizacao em resumos de comparacao
 */
function fnChart_aux_getFusionChartsComparisonRenderer($file)
{
    $phpCode = <<<EOT
    function aux_getFusionChartsComparisonRenderer()
    {
        \$chartType = \$this->SC_APP_data['type'];
        if (!in_array(\$chartType, ['Area', 'Bar', 'Line', 'Radar'])) {
            \$chartType = \$this->SC_APP_info['chart'] ['available_comparison_types'] [0];
        }

        switch (\$chartType) {
            case 'Area':
                if ('Spline' == \$this->SC_APP_info['types'] ['area'] ['format']) {
                    return 'mssplinearea';
                } else {
                    return 'msarea';
                }
                break;

            case 'Bar';
                if ('Horizontal' == \$this->SC_APP_info['types'] ['bar'] ['orientation']) {
                    if ('2d' == \$this->SC_APP_info['types'] ['bar'] ['dimension']) {
                        return 'msbar2d';
                    } else {
                        return 'msbar3d';
                    }
                } else {
                    if ('2d' == \$this->SC_APP_info['types'] ['bar'] ['dimension']) {
                        return 'mscolumn2d';
                    } else {
                        return 'mscolumn3d';
                    }
                }
                break;

            case 'Line':
                if ('Step' == \$this->SC_APP_info['types'] ['line'] ['format']) {
                    return 'msstepline';
                } else {
                    return 'msline';
                }
                break;

            case 'Radar';
                return 'radar';
                break;
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_getFusionChartsComparisonRenderer

/**
 * Recupera o nome do campo de metrica
 */
function fnChart_aux_getMetricField($file)
{
    $phpCode = <<<EOT
    function aux_getMetricField(\$metricInfo)
    {
        if (1 == count(\$metricInfo)) {
            return \$metricInfo[0] ['field'];
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_getMetricField

/**
 * Recupera o label de campo de metrica
 */
function fnChart_aux_getMetricLabel($file)
{
    $phpCode = <<<EOT
    function aux_getMetricLabel(\$metricInfo)
    {
        if (!is_array(\$metricInfo)) {
            return \$metricInfo;
        } elseif (1 == count(\$metricInfo)) {
            return \$metricInfo[0] ['label'];
        } else {
            \$metricLabel = [];
            foreach (\$metricInfo as \$thisMetricInfo) {
                \$metricLabel[] = \$thisMetricInfo['label'];
            }
            return implode(', ', \$metricLabel);
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_getMetricLabel

/**
 * Verifica se aconfiguracao json do grafico carregado ja foi criado
 */
function fnChart_aux_isJsonChartCreated($file)
{
    $phpCode = <<<EOT
    function aux_isJsonChartCreated()
    {
        return @is_file(\$this->SC_APP_info['chart'] ['json_base_dir'] . \$this->SC_APP_info['chart'] ['json_filename']);
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_isJsonChartCreated

/**
 * Verifica se a exibicao da pagina e mobile
 */
function fnChart_aux_isMobile($file)
{
    $phpCode = <<<EOT
    function aux_isMobile()
    {
        return \$_SESSION['scriptcase'] ['proc_mobile'];
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_isMobile

/**
 * Verifica se o grafico tem mais de uma serie de dados
 */
function fnChart_aux_isMultiSeries($file)
{
    $phpCode = <<<EOT
    function aux_isMultiSeries()
    {
        if (self::CHART_MODE_ANALYTIC == \$this->SC_APP_data['data_mode'] && !empty(\$this->SC_APP_data['md5_data'] ['data_analytic'])) {
            switch (\$this->SC_APP_data['type']) {
                case 'Area':
                case 'Bar';
                case 'Line':
                    if ('Spline' != \$this->SC_APP_info['types'] ['line'] ['format']) {
                        return true;
                    }
            }
        }

        return false;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_isMultiSeries

/**
 * Verifica se esta gerando um PDF
 */
function fnChart_aux_isPdf($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function aux_isPdf()
    {
        if ('pdf' == \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['opcao']) {
            return true;
        }

        return false;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_isPdf

/**
 * Verifica se a exibicao da pagina e responsiva
 */
function fnChart_aux_isResponsive($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function aux_isResponsive()
    {
        return \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['responsive_chart'] ['active'];
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_isResponsive

/**
 * Verifica se o conteudo da pagina esta no formato UTF-8
 */
function fnChart_aux_isUtf8($file)
{
    $phpCode = <<<EOT
    function aux_isUtf8()
    {
        return 'UTF-8' == \$_SESSION['scriptcase'] ['charset'];
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_isUtf8

/**
 * Ordena valores para graficos de multiplas series em aplicacoes de grafico
 */
function fnChart_aux_orderChartMultipleSeries($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function aux_orderChartMultipleSeries()
    {
        \$this->tempSortField = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['chart_combination_order_field'];
        \$this->tempSortRule = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['chart_combination_order_rule'];

        if ('label' == \$this->tempSortField || !isset(\$this->SC_APP_data['fusioncharts_json'] ['dataset'] [\$this->tempSortField])) {
            \$sortSerie = \$this->SC_APP_data['fusioncharts_json'] ['categories'] [0] ['category'];
            \$sortIndex = isset(\$a['label_sort_value']) ? 'label_sort_value' : 'label';

            uasort(\$sortSerie, function(\$a, \$b) {
                if ('asc' == \$this->tempSortRule) {
                    return strnatcmp(\$a[\$sortIndex], \$b[\$sortIndex]);
                } else {
                    return strnatcmp(\$b[\$sortIndex], \$a[\$sortIndex]);
                }
            });
        } else {
            \$sortSerie = \$this->SC_APP_data['fusioncharts_json'] ['dataset'] [\$this->tempSortField] ['data'];

            uasort(\$sortSerie, function(\$a, \$b) {
                if ('asc' == \$this->tempSortRule) {
                    return strnatcmp(\$a['value'], \$b['value']);
                } else {
                    return strnatcmp(\$b['value'], \$a['value']);
                }
            });
        }

        \$sortKeys = array_keys(\$sortSerie);

        \$categories = [];
        \$series = [];
        foreach (\$sortKeys as \$thisKey) {
            \$categories[] = \$this->SC_APP_data['fusioncharts_json'] ['categories'] [0] ['category'] [\$thisKey];
            foreach (\$this->SC_APP_data['fusioncharts_json'] ['dataset'] as \$datasetIndex => \$datasetInfo) {
                if (!isset(\$series[\$datasetIndex])) {
                    \$series[\$datasetIndex] = [];
                }

                \$series[\$datasetIndex] [] = \$datasetInfo['data'] [\$thisKey];
            }
        }

        \$this->SC_APP_data['fusioncharts_json'] ['categories'] [0] ['category'] = \$categories;
        foreach (\$this->SC_APP_data['fusioncharts_json'] ['dataset'] as \$datasetIndex => \$datasetInfo) {
            \$this->SC_APP_data['fusioncharts_json'] ['dataset'] [\$datasetIndex] ['data'] = \$series[\$datasetIndex];
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_orderChartMultipleSeries

/**
 * Ordena valores para graficos de serie simples em aplicacoes de grafico
 */
function fnChart_aux_orderChartSingleSerie($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function aux_orderChartSingleSerie()
    {
        \$this->tempSortField = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['chart_combination_order_field'];
        \$this->tempSortRule = \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['chart_combination_order_rule'];

        usort(\$this->SC_APP_data['fusioncharts_json'] ['data'], function(\$a, \$b) {
            if ('label' == \$this->tempSortField) {
                \$sortIndex = isset(\$a['label_sort_value']) ? 'label_sort_value' : 'label';
                if ('asc' == \$this->tempSortRule) {
                    return strnatcmp(\$a[\$sortIndex], \$b[\$sortIndex]);
                } else {
                    return strnatcmp(\$b[\$sortIndex], \$a[\$sortIndex]);
                }
            } elseif (\$a['value'] == \$b['value']) {
                \$sortIndex = isset(\$a['label_sort_value']) ? 'label_sort_value' : 'label';
                if ('asc' == \$this->tempSortRule) {
                    return strnatcmp(\$a[\$sortIndex], \$b[\$sortIndex]);
                } else {
                    return strnatcmp(\$b[\$sortIndex], \$a[\$sortIndex]);
                }
            } else {
                if ('asc' == \$this->tempSortRule) {
                    return strnatcmp(\$a['value'], \$b['value']);
                } else {
                    return strnatcmp(\$b['value'], \$a['value']);
                }
            }
        });
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_orderChartSingleSerie

/**
 * Ordena valores de series
 */
function fnChart_aux_orderSerie($file)
{
    $phpCode = <<<EOT
    function aux_orderSerie(&\$serie, \$direction)
    {
        \$this->tempSortRule = \$direction;

        uasort(\$serie, function(\$a, \$b) {
            if (\$a['value'] == \$b['value']) {
                if ('asc' == \$this->tempSortRule) {
                    return strnatcmp(\$a['label'], \$b['label']);
                } else {
                    return strnatcmp(\$b['label'], \$a['label']);
                }
            } else {
                if ('asc' == \$this->tempSortRule) {
                    return strnatcmp(\$a['value'], \$b['value']);
                } else {
                    return strnatcmp(\$b['value'], \$a['value']);
                }
            }
        });
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_orderSerie

function fnChart_aux_protectText($file)
{
    $phpCode = <<<EOT
    function aux_protectText(\$s)
    {
        if ('UTF-8' != \$_SESSION['scriptcase'] ['charset'])
        {
            \$s = sc_convert_encoding(\$s, 'UTF-8', \$_SESSION['scriptcase'] ['charset']);
        }

        return function_exists('html_entity_decode') ? html_entity_decode(\$s, ENT_COMPAT | ENT_HTML401, 'UTF-8') : \$s;
    }


EOT;

    nm_imprime_2($file, $phpCode);
}

/**
 * Reorganiza os indices do array de series
 */
function fnChart_aux_rearrangeOrderIndexes($file)
{
    $phpCode = <<<EOT
    function aux_rearrangeOrderIndexes(&\$serie)
    {
        \$newSerie = [];

        foreach (\$serie as \$itemIndex => \$itemInfo) {
            \$newSerie[] = \$itemInfo;
        }

        \$serie = \$newSerie;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_rearrangeOrderIndexes

/**
 * Reorganiza os indices do array de series e categorias
 */
function fnChart_aux_rearrangeOrderMultiIndexes($file)
{
    $phpCode = <<<EOT
    function aux_rearrangeOrderMultiIndexes(&\$serie, &\$category)
    {
        \$newSerie = [];
        \$newCategory = [];

        foreach (\$serie as \$itemIndex => \$itemInfo) {
            \$newSerie[] = \$itemInfo;
            \$newCategory[] = \$category[\$itemIndex];
        }

        \$serie = \$newSerie;
        \$category = \$newCategory;
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_rearrangeOrderMultiIndexes

/**
 * Define o tipo de dado do grafico, setando as informacoes necessarias para sua geracao
 */
function fnChart_aux_setChartType($file)
{
    global $summaryInfo;

    $barStacking = 'On';
    if ('Percent' == $summaryInfo['chart'] ['barStacking']) {
        $barStacking = 'Percent';
    }

    $phpCode = <<<EOT
    function aux_setChartType(\$chartType)
    {
        switch (\$chartType) {
            // bar
            case 'bar2d':
            case 'msbar2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Bar';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_orien'] = 'Horizontal';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_dimen'] = '2d';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_empil'] = 'Off';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_scroll'] = false;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_overlapped'] = false;
                break;

            case 'bar3d':
            case 'msbar3d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Bar';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_orien'] = 'Horizontal';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_dimen'] = '3d';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_empil'] = 'Off';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_scroll'] = false;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_overlapped'] = false;
                break;

            case 'column2d':
            case 'mscolumn2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Bar';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_orien'] = 'Vertical';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_dimen'] = '2d';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_empil'] = 'Off';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_scroll'] = false;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_overlapped'] = false;
                break;

            case 'column3d':
            case 'mscolumn3d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Bar';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_orien'] = 'Vertical';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_dimen'] = '3d';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_empil'] = 'Off';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_scroll'] = false;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_overlapped'] = false;
                break;

            case 'stackedbar2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Bar';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_orien'] = 'Horizontal';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_dimen'] = '2d';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_empil'] = '$barStacking';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_scroll'] = false;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_overlapped'] = false;
                break;

            case 'stackedbar3d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Bar';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_orien'] = 'Horizontal';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_dimen'] = '3d';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_empil'] = '$barStacking';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_scroll'] = false;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_overlapped'] = false;
                break;

            case 'stackedcolumn2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Bar';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_orien'] = 'Vertical';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_dimen'] = '2d';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_empil'] = '$barStacking';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_scroll'] = false;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_overlapped'] = false;
                break;

            case 'stackedcolumn3d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Bar';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_orien'] = 'Vertical';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_dimen'] = '3d';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_empil'] = '$barStacking';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_scroll'] = false;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_overlapped'] = false;
                break;

            case 'scrollbar2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Bar';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_orien'] = 'Horizontal';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_dimen'] = '2d';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_empil'] = 'Off';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_scroll'] = true;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_overlapped'] = false;
                break;

            case 'overlappedbar2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Bar';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_orien'] = 'Horizontal';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_dimen'] = '2d';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_empil'] = 'Off';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_scroll'] = false;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_overlapped'] = true;
                break;

            case 'scrollcolumn2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Bar';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_orien'] = 'Vertical';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_dimen'] = '2d';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_empil'] = 'Off';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_scroll'] = true;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_overlapped'] = false;
                break;

            case 'overlappedcolumn2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Bar';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_orien'] = 'Vertical';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_dimen'] = '2d';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_empil'] = 'Off';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_scroll'] = false;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_barra_is_overlapped'] = true;
                break;

            // line
            case 'line':
            case 'msline':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Line';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_forma'] = 'Line';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_is_scroll'] = false;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_is_zoom'] = false;
                break;

            case 'spline':
            case 'msspline':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Line';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_forma'] = 'Spline';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_is_scroll'] = false;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_is_zoom'] = false;
                break;

            case 'stepline':
            case 'msstepline':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Line';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_forma'] = 'Step';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_is_scroll'] = false;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_is_zoom'] = false;
                break;

            case 'scrollline2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Line';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_is_scroll'] = true;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_is_zoom'] = false;
                break;

            case 'zoomline':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Line';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_is_scroll'] = false;
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_linha_is_zoom'] = true;
                break;

            // area
            case 'area':
            case 'area2d':
            case 'msarea':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Area';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_area_forma'] = 'Area';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_area_empil'] = 'Off';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_area_is_scroll'] = false;
                break;

            case 'splinearea':
            case 'mssplinearea':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Area';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_area_forma'] = 'Spline';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_area_empil'] = 'Off';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_area_is_scroll'] = false;
                break;

            case 'scrollarea2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Area';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_area_forma'] = 'Area';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_area_empil'] = 'Off';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_area_is_scroll'] = true;
                break;

            case 'stackedarea':
            case 'stackedarea2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Area';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_area_forma'] = 'Area';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_area_empil'] = '$barStacking';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_area_is_scroll'] = false;
                break;

            // pie
            case 'pie2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Pie';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pizza_forma'] = 'Pie';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pizza_dimen'] = '2d';
                break;

            case 'pie3d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Pie';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pizza_forma'] = 'Pie';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pizza_dimen'] = '3d';
                break;

            case 'doughnut2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Pie';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pizza_forma'] = 'Donut';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pizza_dimen'] = '2d';
                break;

            case 'doughnut3d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Pie';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pizza_forma'] = 'Donut';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pizza_dimen'] = '3d';
                break;

            // gauge
            case 'angulargauge':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Gauge';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_gauge_forma'] = 'Circular';
                break;

            case 'semicirculargauge':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Gauge';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_gauge_forma'] = 'Semicircular';
                break;

            case 'hlineargauge':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Gauge';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_gauge_forma'] = 'LinearGauge';
                break;

            // heatmap
            case 'heatmap':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Heatmap';
                break;

            // treemap
            case 'treemap':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Treemap';
                break;

            // chord
            case 'chord':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Chord';
                break;

            // sankey
            case 'sankey':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Sankey';
                break;

            // sunburst
            case 'sunburst':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Sunburst';
                break;

            // pyramid
            case 'pyramid':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Pyramid';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pyram_dimen'] = '3d';
                break;

            case 'pyramid2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Pyramid';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_pyram_dimen'] = '2d';
                break;

            // funnel
            case 'funnel':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Funnel';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_funil_dimen'] = '3d';
                break;

            case 'funnel2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Funnel';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_funil_dimen'] = '2d';
                break;

            // radar
            case 'radar':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Radar';
                break;

            // scatter
            case 'scatter':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Scatter';
                break;

            // bubble
            case 'bubble':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Bubble';
                break;

            // combination
            case 'mscombidy2d':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Combination';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_combi_dimen'] = '2d';
                break;

            case 'mscolumn3dlinedy':
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo'] = 'Combination';
                \$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_combi_dimen'] = '3d';
                break;
        }
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_setChartType

/**
 * Define como sera a protecao para bug de shift dos valores do eixo x do Fusioncharts
 */
function fnChart_aux_setFusionchartsFix($file)
{
    global $summaryInfo;

    $phpCode = <<<EOT
    function aux_setFusionchartsFix()
    {
        \$this->SC_APP_info['chart'] ['fusioncharts_fix'] = '';

        if (\$this->aux_isPdf()) {
            return;
        }
        switch (\$_SESSION['sc_session'] [\$this->Ini->sc_page] ['{$summaryInfo['general'] ['app_name_session_var']}'] ['cfg_graf'] ['graf_tipo']) {
            case 'Bubble':
            case 'Chord':
            case 'Funnel':
            case 'Gauge';
            case 'Pie';
            case 'Pyramid':
            case 'Radar':
            case 'Sankey':
            case 'Scatter':
            case 'Sunburst':
            case 'Treemap':
                return;
        }

        \$this->SC_APP_info['chart'] ['fusioncharts_fix'] = '<br />';
    }


EOT;

    nm_imprime_2($file, $phpCode);
} // fnChart_aux_setFusionchartsFix