<?php

$arr = array();
$arr['pt_br']['title'] = "Versão de PHP Incompatível";
$arr['pt_br']['msg'] = "O Scriptcase requer o PHP 8.1 ou anterior para funcionar corretamente. A versão atual do PHP instalada no seu sistema não é compatível.";
$arr['pt_br']['btn1'] = "Baixar o instalador do Scriptcase com PHP 8.1";
$arr['pt_br']['btn2'] = "Saiba mais sobre os requisitos do sistema";
$arr['pt_br']['download'] = "https://www.scriptcase.com.br/download/";
$arr['pt_br']['mais'] = "https://www.scriptcase.com.br/docs/pt_br/v9/manual/02-instalacao-scriptcase/01-visao-geral/";

$arr['en_us']['title'] = "Incompatible PHP Version";
$arr['en_us']['msg'] = "Scriptcase requires PHP 8.1 or earlier to work properly. The current version of PHP installed on your system is not compatible.";
$arr['en_us']['btn1'] = "Download Scriptcase installer with PHP 8.1";
$arr['en_us']['btn2'] = "Learn more about system requirements";
$arr['en_us']['download'] = "https://www.scriptcase.net/download/";
$arr['en_us']['mais'] = "https://www.scriptcase.net/docs/en_us/v9/manual/02-scriptcase-installation/01-general-view/";

$arr['es_es']['title'] = "Versión PHP incompatible";
$arr['es_es']['msg'] = "Scriptcase requiere PHP 8.1 o anterior para funcionar correctamente. La versión actual de PHP instalada en su sistema no es compatible.";
$arr['es_es']['btn1'] = "Descargar el instalador de Scriptcase con PHP 8.1";
$arr['es_es']['btn2'] = "Obtenga más información sobre los requisitos del sistema";
$arr['es_es']['download'] = "https://www.scriptcase.net/download/";
$arr['es_es']['mais'] = "https://www.scriptcase.net/docs/en_us/v9/manual/02-scriptcase-installation/01-general-view/";
$str_lang = "en_us";
if(isset($_SESSION['nm_session']['status']['lang']) && !empty($_SESSION['nm_session']['status']['lang']))
{
    switch (strtolower($_SESSION['nm_session']['status']['lang']))
    {
        case 'pt_br':
        case 'es_es':
        case 'en_us':
                $str_lang = strtolower($_SESSION['nm_session']['status']['lang']);
        break;
    }
}
?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="Permissions-Policy" content="camera=(), microphone=(), geolocation=(), payment=(), usb=(), serial=(), bluetooth=()">

    <title><?php echo $arr[$str_lang]['title']; ?></title>
    <link rel="stylesheet" href="../../prod/third/semantic-ui/semantic.min.css">
</head>
<body>
<div class="ui container" style="margin-top: 50px; max-width: 800px;">
    <div class="ui centered card" style="width: 100%;">
        <div class="content">
            <h2 class="ui center aligned icon header">
                <i class="exclamation triangle icon"></i>
                <?php echo $arr[$str_lang]['title']; ?>
            </h2>
            <p style="text-align: center;">
                <?php echo $arr[$str_lang]['msg']; ?>
            </p>
        </div>
        <div class="extra content" style="text-align: center;">
            <a href="<?php echo $arr[$str_lang]['download']; ?>" target="_blank" class="ui primary button" style="margin-bottom: 10px; display: inline-block;"><?php echo $arr[$str_lang]['btn1']; ?></a>
            <a href="<?php echo $arr[$str_lang]['mais']; ?>" class="ui button" style="display: inline-block;"><?php echo $arr[$str_lang]['btn2']; ?></a>
        </div>
    </div>
</div>
<script src="../../prod/third/jquery/js/jquery.js"></script>
<script src="../../prod/third/semantic-ui/semantic.min.js"></script>
</body>
</html>