<?php
/**
 * Template scriptcase.
 *
 * Modulo de Seguranca.
 *
 * @package     Template
 * @subpackage  Scriptcase
 * @creation    2009/04/14
 * @copyright   NetMake Solucoes em Informatica
 * @author      Juliano Mesquita dos Santos <juliano@netmake.com.br>
 *
 * $Id: body_security_module_step_tipo.tpl.php,v 1.1.1.1 2011-05-12 20:31:15 diogo Exp $
 */

/* Protecao contra hacks */
if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976))
{
    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .
        'invalid access to system file.');
}

$profile_nivel_in_use = $this->GetVar('profile_nivel_in_use');
?>

<div class="ui grid">
    <div class="left floated twelve wide column" style="text-align: left;">

        <h3 class="ui header"><?php echo nm_get_text_lang("['tipo']"); ?></h3>
    </div>

    <div class="right floated four wide column" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
        <?php echo $this->GetVar('block_image_help'); ?>
    </div>
</div>
<div class="ui divider"></div>

<input type="hidden" name="tipo_nivel" value="">
<input type="hidden" name="tipo_nivel_ldap" value="">
<div class="ui  three cards" style="margin-bottom: 15px;margin-top: 15px;">
    <?php foreach(['grp', 'app', 'usr', 'ldap', 'ldap_app'] as $tipo ): ?>
    <?php $display_active = ($profile_nivel_in_use == $tipo ? ' group-scriptcase selected default ' : ''); ?>

            <div class="card <?php echo $display_active; ?>">
                <div class="content">
                    <div class="header">
                        <?php echo nm_get_text_lang("['". $tipo ."']['title']"); ?>
                    </div>
                    <div class="ui divider"></div>
                    <div class="meta">
                    </div>
                    <div class="description">
                        <?php echo nm_get_text_lang("['". $tipo ."']['desc']"); ?>
                    </div>
                </div>

                <div class="extra content">
                    <div class="ui  ">
                        <div class="ui  compact primary button" onclick="selectTipo('<?php echo $tipo; ?>')">
                        	 <?php echo nm_get_text_lang("['use_template']"); ?>
                        </div>
                    </div>
                </div>
            </div>
    <?php endforeach; ?>
</div>
<script>
    function selectTipo(tipo) {

        if(tipo == 'ldap' || tipo == 'ldap_app'){
            $('input[name=tipo_nivel]').val('ldap');
            $('input[name=tipo_nivel_ldap]').val(tipo);
        }
        $('input[name=tipo_nivel]').val(tipo);
        $('#form_security').submit();
    }

</script>
