PRAGMA foreign_keys = OFF;

-- ----------------------------
-- Table structure for "main"."accesslevel"
-- ----------------------------

CREATE TABLE "accesslevel" (
"accesslevelid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"description"  varchar(255) COLLATE NOCASE DEFAULT NULL
);

-- ----------------------------
-- Records of accesslevel
-- ----------------------------
INSERT INTO "accesslevel" VALUES (1, 'Administrators');

-- ----------------------------
-- Table structure for "main"."accesslevel_x_applications"
-- ----------------------------

CREATE TABLE "accesslevel_x_applications" (
"accesslevelid"  INTEGER NOT NULL,
"applicationid"  varchar(255) COLLATE NOCASE NOT NULL,
PRIMARY KEY ("accesslevelid", "applicationid" ASC),
CONSTRAINT "accesslevel_x_applications_ibfk_2" FOREIGN KEY ("accesslevelid") REFERENCES "accesslevel" ("accesslevelid"),
CONSTRAINT "accesslevel_x_applications_ibfk_1" FOREIGN KEY ("applicationid") REFERENCES "applications" ("applicationid")
);

-- ----------------------------
-- Records of accesslevel_x_applications
-- ----------------------------
INSERT INTO "accesslevel_x_applications" VALUES (1, 'blank');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'blank_add_cart');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'blank_bg');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'container');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'control_change_passwd');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'control_change_passwd_customer');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'control_change_passwd_customer_customer');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_accesslevel');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_address');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_address_customer');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_cardtype');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_cart');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_category');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_country');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_creditcards');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_creditcards_customer');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_customers');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_customers_customer');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_customers_new_customer');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_department');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_measure');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_orderitens');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_orders');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_orderstatus');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_producthome');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_products');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_products_dependent');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_shipping');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_shippingrates');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_shippingrates_detail');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_state');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_state_by_country');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_subcategory');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_subcategory_dependent');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'form_systemuser');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_accesslevel');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_address');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_address_customer');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_category');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_country');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_creditcards');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_creditcards_customer');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_customers');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_customers_customer');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_orderitens');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_orderitens_customers');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_orders');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_orders_customer');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_orders_success');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_products');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_products_dependent');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_products_destaq');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_products_list_cat');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_products_list_cat_search');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_products_list_subcat');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_product_detail');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_shippingrates');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_state');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_subcategory');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_subcategory_dependent');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'grid_systemuser');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'index');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'login');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'loja');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'menu');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'menu_customer');
INSERT INTO "accesslevel_x_applications" VALUES (1, 'treemenu_home');

-- ----------------------------
-- Table structure for "main"."address"
-- ----------------------------

CREATE TABLE "address" (
"addressid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"customersid"  INTEGER NOT NULL DEFAULT '0',
"description"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"address1"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"address2"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"city"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"states"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"country"  char(2) COLLATE NOCASE DEFAULT NULL,
"postalcode"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"phone1"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"phone2"  varchar(255) COLLATE NOCASE DEFAULT NULL,
CONSTRAINT "address_ibfk_1" FOREIGN KEY ("customersid") REFERENCES "customers" ("customersid"),
CONSTRAINT "address_ibfk_2" FOREIGN KEY ("states") REFERENCES "states" ("stateid"),
CONSTRAINT "address_ibfk_3" FOREIGN KEY ("country") REFERENCES "country" ("countryCode")
);

-- ----------------------------
-- Records of address
-- ----------------------------
INSERT INTO "address" VALUES (1, 1, 'Home', 'fifth avenue', 555, 'Bronx', 'NY', 'US', 555, '555-55-55', '');
INSERT INTO "address" VALUES (2, 2, 'Work', '201 Varick Street', '', 'Houston St Station', 'NY', 'US', '10014-4811', '330-5606', '');
INSERT INTO "address" VALUES (3, 4, 'home', 'xxx street', '', 'New York', 'NY', 'US', 5555555555555, 555555555555555, '');
INSERT INTO "address" VALUES (4, 5, 'home', 'st. Londres, 331', '', 'Downville', 'DE', 'US', 50741350, 55819194828025, '');
INSERT INTO "address" VALUES (5, 9, 'Home', '9 July', '', 'New york', 'NY', 'US', 555, '555-5555', '');
INSERT INTO "address" VALUES (6, 10, 'Home', 'Boba Street', '', 'Sitka', 'AK', 'US', 555, '555-5555', '');
INSERT INTO "address" VALUES (7, 11, 'Home', 'Boba Street', '', 'Sitka', 'AK', 'US', 555, '555-5555', '');
INSERT INTO "address" VALUES (8, 12, 'Home', 'Boba Street', '', 'Sitka', 'ID', 'US', 555, '555-5555', '');
INSERT INTO "address" VALUES (9, 13, 'Home', 'Boba Street', '', 'Sitka', 'KS', 'US', 555, '555-5555', '');
INSERT INTO "address" VALUES (10, 14, 'Home', 'Boba Street', '', 'Sitka', 'IA', 'US', 555, '555-5555', '');

-- ----------------------------
-- Table structure for "main"."applications"
-- ----------------------------

CREATE TABLE "applications" (
"applicationid"  varchar(255) COLLATE NOCASE NOT NULL,
"description"  varchar(255) COLLATE NOCASE DEFAULT NULL,
PRIMARY KEY ("applicationid")
);

-- ----------------------------
-- Records of applications
-- ----------------------------
INSERT INTO "applications" VALUES ('blank', 'blank');
INSERT INTO "applications" VALUES ('blank_add_cart', 'blank_add_cart');
INSERT INTO "applications" VALUES ('blank_bg', 'blank_bg');
INSERT INTO "applications" VALUES ('container', 'container');
INSERT INTO "applications" VALUES ('control_change_passwd', 'control_change_passwd');
INSERT INTO "applications" VALUES ('control_change_passwd_customer', 'control_change_passwd_customer');
INSERT INTO "applications" VALUES ('control_change_passwd_customer_customer', 'control_change_passwd_customer_customer');
INSERT INTO "applications" VALUES ('form_accesslevel', 'form_accesslevel');
INSERT INTO "applications" VALUES ('form_address', 'form_address');
INSERT INTO "applications" VALUES ('form_address_customer', 'form_address_customer');
INSERT INTO "applications" VALUES ('form_cardtype', 'form_cardtype');
INSERT INTO "applications" VALUES ('form_cart', 'form_cart');
INSERT INTO "applications" VALUES ('form_category', 'form_category');
INSERT INTO "applications" VALUES ('form_country', 'form_country');
INSERT INTO "applications" VALUES ('form_creditcards', 'form_creditcards');
INSERT INTO "applications" VALUES ('form_creditcards_customer', 'form_creditcards_customer');
INSERT INTO "applications" VALUES ('form_customers', 'form_customers');
INSERT INTO "applications" VALUES ('form_customers_customer', 'form_customers_customer');
INSERT INTO "applications" VALUES ('form_customers_new_customer', 'form_customers_new_customer');
INSERT INTO "applications" VALUES ('form_department', 'form_department');
INSERT INTO "applications" VALUES ('form_measure', 'form_measure');
INSERT INTO "applications" VALUES ('form_orderitens', 'form_orderitens');
INSERT INTO "applications" VALUES ('form_orders', 'form_orders');
INSERT INTO "applications" VALUES ('form_orderstatus', 'form_orderstatus');
INSERT INTO "applications" VALUES ('form_producthome', 'form_producthome');
INSERT INTO "applications" VALUES ('form_products', 'form_products');
INSERT INTO "applications" VALUES ('form_products_dependent', 'form_products_dependent');
INSERT INTO "applications" VALUES ('form_shipping', 'form_shipping');
INSERT INTO "applications" VALUES ('form_shippingrates', 'form_shippingrates');
INSERT INTO "applications" VALUES ('form_shippingrates_detail', 'form_shippingrates_detail');
INSERT INTO "applications" VALUES ('form_state', 'form_state');
INSERT INTO "applications" VALUES ('form_state_by_country', 'form_state_by_country');
INSERT INTO "applications" VALUES ('form_subcategory', 'form_subcategory');
INSERT INTO "applications" VALUES ('form_subcategory_dependent', 'form_subcategory_dependent');
INSERT INTO "applications" VALUES ('form_systemuser', 'form_systemuser');
INSERT INTO "applications" VALUES ('grid_accesslevel', 'grid_accesslevel');
INSERT INTO "applications" VALUES ('grid_address', 'grid_address');
INSERT INTO "applications" VALUES ('grid_address_customer', 'grid_address_customer');
INSERT INTO "applications" VALUES ('grid_category', 'grid_category');
INSERT INTO "applications" VALUES ('grid_country', 'grid_country');
INSERT INTO "applications" VALUES ('grid_creditcards', 'grid_creditcards');
INSERT INTO "applications" VALUES ('grid_creditcards_customer', 'grid_creditcards_customer');
INSERT INTO "applications" VALUES ('grid_customers', 'grid_customers');
INSERT INTO "applications" VALUES ('grid_customers_customer', 'grid_customers_customer');
INSERT INTO "applications" VALUES ('grid_orderitens', 'grid_orderitens');
INSERT INTO "applications" VALUES ('grid_orderitens_customers', 'grid_orderitens_customers');
INSERT INTO "applications" VALUES ('grid_orders', 'grid_orders');
INSERT INTO "applications" VALUES ('grid_orders_customer', 'grid_orders_customer');
INSERT INTO "applications" VALUES ('grid_orders_success', 'grid_orders_success');
INSERT INTO "applications" VALUES ('grid_products', 'grid_products');
INSERT INTO "applications" VALUES ('grid_products_dependent', 'grid_products_dependent');
INSERT INTO "applications" VALUES ('grid_products_destaq', 'grid_products_destaq');
INSERT INTO "applications" VALUES ('grid_products_list_cat', 'grid_products_list_cat');
INSERT INTO "applications" VALUES ('grid_products_list_cat_search', 'grid_products_list_cat_search');
INSERT INTO "applications" VALUES ('grid_products_list_subcat', 'grid_products_list_subcat');
INSERT INTO "applications" VALUES ('grid_product_detail', 'grid_product_detail');
INSERT INTO "applications" VALUES ('grid_shippingrates', 'grid_shippingrates');
INSERT INTO "applications" VALUES ('grid_state', 'grid_state');
INSERT INTO "applications" VALUES ('grid_subcategory', 'grid_subcategory');
INSERT INTO "applications" VALUES ('grid_subcategory_dependent', 'grid_subcategory_dependent');
INSERT INTO "applications" VALUES ('grid_systemuser', 'grid_systemuser');
INSERT INTO "applications" VALUES ('index', 'index');
INSERT INTO "applications" VALUES ('login', 'login');
INSERT INTO "applications" VALUES ('login_customer', 'login_customer');
INSERT INTO "applications" VALUES ('loja', 'loja');
INSERT INTO "applications" VALUES ('menu', 'menu');
INSERT INTO "applications" VALUES ('menu_customer', 'menu_customer');
INSERT INTO "applications" VALUES ('treemenu_home', 'treemenu_home');

-- ----------------------------
-- Table structure for "main"."cardtype"
-- ----------------------------

CREATE TABLE "cardtype" (
"cardtypeid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"description"  varchar(255) COLLATE NOCASE DEFAULT NULL
);

-- ----------------------------
-- Records of cardtype
-- ----------------------------
INSERT INTO "cardtype" VALUES (1, 'MasterCard');
INSERT INTO "cardtype" VALUES (2, 'Diners');
INSERT INTO "cardtype" VALUES (3, 'American Express');
INSERT INTO "cardtype" VALUES (4, 'Visa Platinum');
INSERT INTO "cardtype" VALUES (5, 'Visa');

-- ----------------------------
-- Table structure for "main"."cart"
-- ----------------------------

CREATE TABLE "cart" (
"cartid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"session_id"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"productid"  INTEGER DEFAULT NULL,
"quantity"  INTEGER DEFAULT NULL,
CONSTRAINT "cart_ibfk_1" FOREIGN KEY ("productid") REFERENCES "products" ("productid")
);

-- ----------------------------
-- Records of cart
-- ----------------------------
INSERT INTO "cart" VALUES (1, '522cd0dec88d93e8aec744cc35b2c618', 1, 5);
INSERT INTO "cart" VALUES (2, '522cd0dec88d93e8aec744cc35b2c618', 11, 1);
INSERT INTO "cart" VALUES (3, '43b1ed746726df3766d17bc54030894b', 36, 4);
INSERT INTO "cart" VALUES (4, '43b1ed746726df3766d17bc54030894b', 32, 1);
INSERT INTO "cart" VALUES (5, 'f5c31df02a97dff7b961ff3cbcb94eb1', 2, 1);
INSERT INTO "cart" VALUES (6, 'f5c31df02a97dff7b961ff3cbcb94eb1', 31, 1);
INSERT INTO "cart" VALUES (7, '522cd0dec88d93e8aec744cc35b2c618', 14, 1);
INSERT INTO "cart" VALUES (8, '522cd0dec88d93e8aec744cc35b2c618', 4, 1);
INSERT INTO "cart" VALUES (9, 'fa4393da7b68a3ae314134ec5d86920a', 18, 1);
INSERT INTO "cart" VALUES (10, 'fa4393da7b68a3ae314134ec5d86920a', 1, 1);
INSERT INTO "cart" VALUES (11, 'fa4393da7b68a3ae314134ec5d86920a', 4, 1);
INSERT INTO "cart" VALUES (12, '92a52dbc89ff749af951213481cee430', 94, 3);
INSERT INTO "cart" VALUES (13, '92a52dbc89ff749af951213481cee430', 212, 4);
INSERT INTO "cart" VALUES (14, 'cd2b5f960e136a3218e20d304b012899', 126, 1);
INSERT INTO "cart" VALUES (15, 'cd2b5f960e136a3218e20d304b012899', 150, 1);
INSERT INTO "cart" VALUES (16, 'cd2b5f960e136a3218e20d304b012899', 197, 5);
INSERT INTO "cart" VALUES (17, '4998492885272a62d06b3d1472d775ab', 29, 1);
INSERT INTO "cart" VALUES (18, '3f15d48a3f2695dc878b0c735531f906', 248, 1);
INSERT INTO "cart" VALUES (19, '3f15d48a3f2695dc878b0c735531f906', 109, 3);
INSERT INTO "cart" VALUES (20, '3f15d48a3f2695dc878b0c735531f906', 215, 1);
INSERT INTO "cart" VALUES (21, '4998492885272a62d06b3d1472d775ab', 86, 1);
INSERT INTO "cart" VALUES (22, '3f15d48a3f2695dc878b0c735531f906', 168, 1);
INSERT INTO "cart" VALUES (23, '3f15d48a3f2695dc878b0c735531f906', 253, 1);
INSERT INTO "cart" VALUES (24, '4998492885272a62d06b3d1472d775ab', 53, 1);
INSERT INTO "cart" VALUES (27, 'd2462618e55825170acc16ceb229db32', 16, 1);
INSERT INTO "cart" VALUES (28, '66fcb4fa0c171a11f22e586147fd8b91', 198, 1);
INSERT INTO "cart" VALUES (29, '38f2efab03aa07cd524e422c779a969c', 33, 1);
INSERT INTO "cart" VALUES (30, '9302752b668ce35938ddde0fbb63d602', 29, 1);
INSERT INTO "cart" VALUES (31, '85fed06abf75ed4689d3f121ecaaaf8b', 160, 12);
INSERT INTO "cart" VALUES (32, '496b6c94bbc8cc683c8adab73b8f91be', 210, 1);
INSERT INTO "cart" VALUES (33, '496b6c94bbc8cc683c8adab73b8f91be', 36, 1);
INSERT INTO "cart" VALUES (34, 'ucrckct2dpng02dl5l1a9bp4p2', 104, 1);
INSERT INTO "cart" VALUES (35, 'ucrckct2dpng02dl5l1a9bp4p2', 171, 1);
INSERT INTO "cart" VALUES (36, 'ucrckct2dpng02dl5l1a9bp4p2', 232, 1);
INSERT INTO "cart" VALUES (37, 'ucrckct2dpng02dl5l1a9bp4p2', 244, 1);

-- ----------------------------
-- Table structure for "main"."category"
-- ----------------------------

CREATE TABLE "category" (
"categoryid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"description"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"list_order"  INTEGER DEFAULT '0'
);

-- ----------------------------
-- Records of category
-- ----------------------------
INSERT INTO "category" VALUES (1, 'TV & VIDEO', 1);
INSERT INTO "category" VALUES (2, 'AUDIO', 2);
INSERT INTO "category" VALUES (3, 'CAR & GPS', 3);
INSERT INTO "category" VALUES (4, 'CAMERAS & CAMCORDES', 4);
INSERT INTO "category" VALUES (5, 'COMPUTERS', 5);
INSERT INTO "category" VALUES (6, 'PHONES', 6);
INSERT INTO "category" VALUES (7, 'VIDEO GAMES', 7);

-- ----------------------------
-- Table structure for "main"."country"
-- ----------------------------

CREATE TABLE "country" (
"countrycode"  char(2) NOT NULL,
"name"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"tax"  char(1) DEFAULT NULL,
"taxpercent"  numeric(10,2) DEFAULT NULL,
PRIMARY KEY ("countrycode")
);

-- ----------------------------
-- Records of country
-- ----------------------------
INSERT INTO "country" VALUES ('US', 'United States', 'Y', 0);

-- ----------------------------
-- Table structure for "main"."creditcards"
-- ----------------------------

CREATE TABLE "creditcards" (
"creditcardsid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"cardtypeid"  INTEGER NOT NULL DEFAULT '0',
"customersid"  INTEGER NOT NULL DEFAULT '0',
"expirationdate"  date DEFAULT NULL,
"cardnumber"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"cardholder"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"securitycode"  varchar(10) COLLATE NOCASE DEFAULT NULL,
"address1"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"address2"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"city"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"states"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"country"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"postalcode"  varchar(255) COLLATE NOCASE DEFAULT NULL,
CONSTRAINT "creditcards_ibfk_2" FOREIGN KEY ("customersid") REFERENCES "customers" ("customersid"),
CONSTRAINT "creditcards_ibfk_1" FOREIGN KEY ("cardtypeid") REFERENCES "cardtype" ("cardtypeid")
);

-- ----------------------------
-- Records of creditcards
-- ----------------------------
INSERT INTO "creditcards" VALUES (1, 3, 1, '2014-12-01', 5555555555555555, 'Michael T W Lewis', 325, 'fifth avenue', '', 'Bronx', 'NY', 'US', 555);
INSERT INTO "creditcards" VALUES (2, 4, 2, '2010-12-01', 1111111111111111, 'Richard G Better', 234, '201 Varick Street', '', 'New York', 'NY', 'US', '10014-4811');
INSERT INTO "creditcards" VALUES (3, 1, 5, '1988-11-01', 11111111111111,'William Joseph',175,'202 Varick Street','','Bronx','AS','US','50740370');
INSERT INTO "creditcards" VALUES (4, 3, 1, '1988-11-01', 1111111111111111, 'Catherine Holmes',17,'203 Varick Street','','Bronx','IA','US','50740370');

-- ----------------------------
-- Table structure for "main"."customers"
-- ----------------------------

CREATE TABLE "customers" (
"customersid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"name"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"email"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"passwd"  varchar(255) COLLATE NOCASE DEFAULT NULL
);

-- ----------------------------
-- Records of customers
-- ----------------------------
INSERT INTO "customers" VALUES (1, 'Michael Lewis', 'michael@lewis.com', '0acf4539a14b3aa27deeb4cbdf6e989f');
INSERT INTO "customers" VALUES (2, 'Richard Better', 'richard@better.com', '6ae199a93c381bf6d5de27491139d3f9');
INSERT INTO "customers" VALUES (4, 'Alex Bentham', 'alex@bentham.com', 'd41d8cd98f00b204e9800998ecf8427e');
INSERT INTO "customers" VALUES (5, 'Scott Sanders', 'scott@sanders.com', '698dc19d489c4e4db73e28a713eab07b');
INSERT INTO "customers" VALUES (6, 'Ralf', 'ralf@fontoura.com', '3cca634013591eb51173fb6207572e37');
INSERT INTO "customers" VALUES (7, 'Katie Mackenzie', 'katie@mackenzie.com', '8a52072cee5d17cc7bf85d6ca431fffa');
INSERT INTO "customers" VALUES (8, 'Rambo', 'rambo@rambo.net', '59931dbc55de73dc815ac4a0170e5443');
INSERT INTO "customers" VALUES (9, 'Peter Block', 'peter', 'd41d8cd98f00b204e9800998ecf8427e');
INSERT INTO "customers" VALUES (10, 'July Boba', 'july', 'd41d8cd98f00b204e9800998ecf8427e');
INSERT INTO "customers" VALUES (11, 'Pamela Lohan', 'pamela', 'd41d8cd98f00b204e9800998ecf8427e');
INSERT INTO "customers" VALUES (12, 'Michael Bay', 'michael', 'd41d8cd98f00b204e9800998ecf8427e');
INSERT INTO "customers" VALUES (13, 'Marcus Black', 'marcus', 'd41d8cd98f00b204e9800998ecf8427e');
INSERT INTO "customers" VALUES (14, 'July Boba', 'boba', 'd41d8cd98f00b204e9800998ecf8427e');
INSERT INTO "customers" VALUES (15, 'Mathew Boyle', 'mathew', 'd41d8cd98f00b204e9800998ecf8427e');

-- ----------------------------
-- Table structure for "main"."department"
-- ----------------------------

CREATE TABLE "department" (
"departmentid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"description"  varchar(255) COLLATE NOCASE DEFAULT NULL
);

-- ----------------------------
-- Records of department
-- ----------------------------
INSERT INTO "department" VALUES (1, 'TI Management');
INSERT INTO "department" VALUES (2, 'HR');
INSERT INTO "department" VALUES (3, 'Commercial');

-- ----------------------------
-- Table structure for "main"."emailtemplates"
-- ----------------------------

CREATE TABLE "emailtemplates" (
"emailtemplatesid"  INTEGER NOT NULL,
"status"  INTEGER NOT NULL,
"body"  text COLLATE NOCASE,
PRIMARY KEY ("emailtemplatesid")
);

-- ----------------------------
-- Records of emailtemplates
-- ----------------------------

-- ----------------------------
-- Table structure for "main"."measure"
-- ----------------------------

CREATE TABLE "measure" (
"measureid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"description"  varchar(255) COLLATE NOCASE DEFAULT NULL
);

-- ----------------------------
-- Records of measure
-- ----------------------------
INSERT INTO "measure" VALUES (1, 'Ounce');
INSERT INTO "measure" VALUES (2, 'Pound');
INSERT INTO "measure" VALUES (3, 'Ton');
INSERT INTO "measure" VALUES (4, 'Gram');
INSERT INTO "measure" VALUES (5, 'kilogram');
INSERT INTO "measure" VALUES (6, 'Unit.');

-- ----------------------------
-- Table structure for "main"."orderitens"
-- ----------------------------

CREATE TABLE "orderitens" (
"orderid"  INTEGER NOT NULL,
"productid"  INTEGER NOT NULL,
"quantity"  INTEGER DEFAULT NULL,
"unitprice"  numeric(10,2) DEFAULT NULL,
"total"  numeric(10,2) DEFAULT NULL,
PRIMARY KEY ("orderid", "productid"),
CONSTRAINT "orderitens_ibfk_2" FOREIGN KEY ("orderid") REFERENCES "orders" ("orderid"),
CONSTRAINT "orderitens_ibfk_1" FOREIGN KEY ("productid") REFERENCES "products" ("productid")
);

-- ----------------------------
-- Records of orderitens
-- ----------------------------
INSERT INTO "orderitens" VALUES (1, 98, 10, 359, 3590);
INSERT INTO "orderitens" VALUES (1, 147, 2, 249, 498);
INSERT INTO "orderitens" VALUES (1, 178, 1, 1799, 1799);
INSERT INTO "orderitens" VALUES (2, 47, 5, 3149, 15745);
INSERT INTO "orderitens" VALUES (2, 98, 2, 359, 718);
INSERT INTO "orderitens" VALUES (2, 104, 1, 179, 179);
INSERT INTO "orderitens" VALUES (3, 163, 2, 89, 178);
INSERT INTO "orderitens" VALUES (4, 121, 3, 449, 1347);
INSERT INTO "orderitens" VALUES (4, 219, 1, 379, 379);
INSERT INTO "orderitens" VALUES (4, 232, 2, 624, 1248);
INSERT INTO "orderitens" VALUES (4, 257, 2, 199, 398);
INSERT INTO "orderitens" VALUES (5, 43, 1, 3149, 3149);
INSERT INTO "orderitens" VALUES (5, 94, 1, 99.99, 99.99);
INSERT INTO "orderitens" VALUES (5, 150, 1, 249, 249);
INSERT INTO "orderitens" VALUES (9, 51, 1, 3149, 3149);
INSERT INTO "orderitens" VALUES (9, 113, 1, 899, 899);
INSERT INTO "orderitens" VALUES (10, 215, 1, 379, 379);
INSERT INTO "orderitens" VALUES (11, 59, 1, 749, 749);
INSERT INTO "orderitens" VALUES (11, 85, 1, 199, 199);
INSERT INTO "orderitens" VALUES (12, 126, 1, 169, 169);
INSERT INTO "orderitens" VALUES (13, 187, 1, 2499, 2499);
INSERT INTO "orderitens" VALUES (14, 251, 1, 349, 349);
INSERT INTO "orderitens" VALUES (15, 200, 1, 29, 29);
INSERT INTO "orderitens" VALUES (16, 259, 1, 199, 199);
INSERT INTO "orderitens" VALUES (17, 148, 1, 249, 249);
INSERT INTO "orderitens" VALUES (17, 254, 1, 199, 199);
INSERT INTO "orderitens" VALUES (18, 202, 1, 29, 29);
INSERT INTO "orderitens" VALUES (19, 26, 1, 1499, 1499);
INSERT INTO "orderitens" VALUES (19, 42, 1, 699, 699);
INSERT INTO "orderitens" VALUES (20, 27, 1, 1499, 1499);
INSERT INTO "orderitens" VALUES (21, 34, 1, 699, 699);
INSERT INTO "orderitens" VALUES (21, 43, 1, 3149, 3149);

-- ----------------------------
-- Table structure for "main"."orders"
-- ----------------------------

CREATE TABLE "orders" (
"orderid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"customerid"  INTEGER NOT NULL DEFAULT '0',
"status"  INTEGER NOT NULL,
"order_date"  datetime DEFAULT NULL,
"total"  numeric(10,2) DEFAULT NULL,
CONSTRAINT "orders_ibfk_2" FOREIGN KEY ("status") REFERENCES "orderstatus" ("statusid"),
CONSTRAINT "orders_ibfk_1" FOREIGN KEY ("customerid") REFERENCES "customers" ("customersid")
);

-- ----------------------------
-- Records of orders
-- ----------------------------
INSERT INTO "orders" VALUES (1, 1, 1, '2010-05-06 17:27:51', 5887);
INSERT INTO "orders" VALUES (2, 1, 1, '2010-05-11 14:58:18', 16642);
INSERT INTO "orders" VALUES (3, 1, 4, '2010-05-17 16:29:34:000', 178);
INSERT INTO "orders" VALUES (4, 2, 2, '2010-05-17 16:30:59', 3372);
INSERT INTO "orders" VALUES (5, 4, 2, '2010-05-18 15:37:20', 3497.99);
INSERT INTO "orders" VALUES (6, 4, 4, '2010-05-18 16:17:41:000', 0);
INSERT INTO "orders" VALUES (7, 7, 1, '2010-05-19 09:47:40', 0);
INSERT INTO "orders" VALUES (8, 7, 1, '2010-05-19 09:48:21', 0);
INSERT INTO "orders" VALUES (9, 7, 1, '2010-05-19 10:01:53', 4048);
INSERT INTO "orders" VALUES (10, 7, 1, '2010-05-19 11:01:44', 379);
INSERT INTO "orders" VALUES (11, 8, 1, '2010-05-19 17:05:52', 948);
INSERT INTO "orders" VALUES (12, 8, 1, '2010-05-19 17:06:41', 169);
INSERT INTO "orders" VALUES (13, 8, 1, '2010-05-19 17:11:12', 2499);
INSERT INTO "orders" VALUES (14, 1, 1, '2010-05-20 10:52:23', 349);
INSERT INTO "orders" VALUES (15, 1, 1, '2010-05-20 10:55:05', 29);
INSERT INTO "orders" VALUES (16, 10, 1, '2010-05-20 11:19:53', 199);
INSERT INTO "orders" VALUES (17, 1, 1, '2010-05-20 11:56:37', 448);
INSERT INTO "orders" VALUES (18, 1, 1, '2010-05-20 11:58:02', 29);
INSERT INTO "orders" VALUES (19, 1, 1, '2010-07-07 14:41:55', 2198);
INSERT INTO "orders" VALUES (20, 1, 1, '2010-07-07 14:42:13', 1499);
INSERT INTO "orders" VALUES (21, 1, 1, '2010-07-07 14:42:32', 3848);

-- ----------------------------
-- Table structure for "main"."orderstatus"
-- ----------------------------

CREATE TABLE "orderstatus" (
"statusid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"description"  varchar(255) COLLATE NOCASE DEFAULT NULL
);

-- ----------------------------
-- Records of orderstatus
-- ----------------------------
INSERT INTO "orderstatus" VALUES (1, 'PLACED');
INSERT INTO "orderstatus" VALUES (2, 'AUTHORIZED');
INSERT INTO "orderstatus" VALUES (3, 'SHIPPED');
INSERT INTO "orderstatus" VALUES (4, 'FINALIZED');
INSERT INTO "orderstatus" VALUES (5, 'CANCELED');

-- ----------------------------
-- Table structure for "main"."producthome"
-- ----------------------------

CREATE TABLE "producthome" (
"producthomeid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"picture"  BLOB NOT NULL,
"list_order"  INTEGER DEFAULT NULL,
"description"  text COLLATE NOCASE
);

-- ----------------------------
-- Records of producthome
-- ----------------------------
INSERT INTO "producthome" VALUES (1, '*nm*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', 1, 'Good cost x performance');
INSERT INTO "producthome" VALUES (2, '*nm*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', 2, 'APPLE iBook G4');
INSERT INTO "producthome" VALUES (3, '*nm*/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAZAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQAAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQICAgICAgICAgICAwMDAwMDAwMDAwEBAQEBAQECAQECAgIBAgIDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMD/8AAEQgAtAMHAwERAAIRAQMRAf/EAMEAAQABBQEBAQEAAAAAAAAAAAABBQYHCAkEAwIKAQEBAAMBAQEBAAAAAAAAAAAAAQIDBAUGBwgQAAAFAwEGAgcHAwIDBAkFAAECAwQFABEGE/AhMWESB0FRcYGRoSIUCLHB0eHxFRYyIwlCFyQlJlJiMydyQ1NFpUZ2tjeCNDVlGBEAAgECAwYDBwQBAgQEBwAAAAECEQMhMUFRYXGxEgTwgQWRocHRIhMG4fEyBxRCM1JygiNiNBUWkrLSQ7MkCP/aAAwDAQACEQMRAD8A/v4oBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQFtNZl0vmM7jx024MovGcTmW6pSqA6O6npTNGLxNY4qikZumljiApgUhTAY5+oxgEoFAuWgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUB8UXCDjU0FU1dFVRBUCGAwprJGEqiRwDeU5RDgNZShKFOpNVVVwMYzjKvS06Oj4ooOTzowLJBdMhFVlnSSZUjiIdSRf7jgbh/T/bL0gO+wmAbDXV2XbLubji6qKi8d+nz8jl73uf8W2ppVk5JU3a+N5VY6SaSjNN81UAyKhR6gNYDInKH9xJUL/AdMePhbeFwEBrReszs3HbmvqXv3o32r1u9bV2D+l+7iWMwzP5nJlWxzgEW5ErNmI2ACrJmMCTgR8nZzCHoEl+A16V30/o7NTX++sXw2eXzPNteo9feODf/AGHguO3z+Rd85NNoNkZ0vY6prkbNwGx3CttxQ49KZL3ObwDzEQAeDtu3n3Nzoj/HV7F4yO/ue5h21vrlnotr8ZkY/KDMRLV6boBY4GTcFIAgUq6RhIewCIiAHAAMAXHcYKd1Z/x78ra/jpwfig7W9/kWI3H/ACefFFUO4QTVRQOqmVZwJwQSEwAorpkFRQSE/qMBCFuI8ArSoScXJJ9Kzew3OcVJRbXU8ltPtWJkKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAWHHf/AJOy/wD+g+3H/wBwd06AvygFAKAUAoBQCgFAKAUAoChSeUY3DKt0JaeiI1d2ZQjVF7INWyrgyOnrFRTVVKZQUtYnVYBt1lvxCsJXLcP5tLiVRbyRaUz3d7fQLIX8nPaLYpAUE5Y2WVN0iBhD+2mxMfqsXha97Ba4hfRHvO3kqxlgtz+Rn9qewxJM/WH2Wim6a7WRnJ5RRcqItYeFUKukmKZzi6UNLrRLbQIJSlECqGVExwsQSgYS191aUXJVfl86D7UixXX16dp24mAMbz04kMAGAWeNFNYQEbgBcnUDd0iFhEBvbwEBHL/Ijg6NR24fMfbe1G4mPZDFZRjsLlUOuZaFn4dhOxrlZJRsdSNkmaT5osqguUiqBjNliiJTAAl4DXQ006PM11TxWRW6gFAKAUAoBQCgFAKAUAoBQCgFAWR28fzszi7TIZ6SYSKuTLOsjh04yKNEtYjFplYz3E4RRJWSl1nsrGY6o2JIvBX03sjrroItW50WiDLArVHQvehDhF9fH199+fpr79yWEduMlh3sW3goWbdROQYrBvIWPF+i7I1iowUGrXJVnOk1M6kXbiTVTWOqRJs3ZlbKmd7o2k4KeNG8X8FhspteO9Ixk2tMKePh4y1z+m//ADsdyMm7+QfZ7vf2twNxjcw1KQ2aYAGRQktGu1XSR03z2Dl5bJmz2PQjFDGUTQMk4MdO5Cj1dJdN6lqVMaeMTZbi5qup/RH267sYB3ViEZnCMjYy6KqZDqtCKppyTI5mzR0du9YicVkHLZF8jql36RjgU1jbqxjKMsmRxazMjVkQUAoBQCgFAKAUAoBQCgF6AUAoBQCgFAKAXoBQCgKbKyjeIa/OOgUFAFUkjikUDmJqm6QOJRMW5SjxtvtwAa3WLM78/twp1UrjuNN+9Ht4fcnXpqlhvPqxkWMkiC7Fyk5T3XFM3xEEQv0qJjZRI1vAwANY3LNyzLpuJpmVu7bvR6rTTRgVGdfR8u7kGSwlM4drrKpmuZFwRRY6nSsncOoB6tw7jBfcIDX08u2t3bEbVxYKKW9YaHy8e5u2r8rtp5yb3PHU9OTZCOQKs1ASM3I2bCUyJjAcAcqHEVjkMFuohikIAXAB3Vh2faf4sZKtW3nu0+Jn3vd/5UoulEllv1+BSWco+YoPGzVcyaL5LRcEDeBi3C5i/wDZOJLlEQ/0mEPRvuWbdyUZzVZRdV495ot37tqMoQdIyVGU8BtvAbCG8BDwEPG/KtppPfIyj2VVIu+XMsdNIiJL7ilImUAuBQ3AY5g6jD4mGtVqzbsR6baom6m27fuX5KVx1aVCvY9lSkCxftio66i6iarQDjZFJUSimsdWwgcwCUpLFC17cQrm7rsl3VyM26JKj2taU951dp3z7W1KCVW3VbE9a+4/EJKu3WUxr564Osuq6KiJzDuKVwU6AJplCxU0w1dxQAACr3NiEOynbtqkVGvsx+BO2vXJ97C5cbcnKntw+JmeSmI2JT1H7pNERARIlfrXUt/7NEl1DBfxtYPEQr56z296+6Wot79PafRXu4s2FW7JLm/I+7B4nIM271IpyJOUwVTKoBQUAgiPT1AUxigIgF9wjWN227Vx25YtMytXFdtq5H+MkeytZsFAL0AoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQCgFAKAUAoBQFhx/8A+Tsv/wDoPtx/9wd06AvygFAKAUAoBQC4UBAiBQETCBQDiIiAAHpEd1AWDO90cDx1TQksiaCuCq6B0WBHEoogs2PprpOwjUXQM1CKAYvSqJDCJDAACJDW0y7i1DBvHHLHLPIyUJPIwJlH1RIopqJ4rAGMpppCV7OnDoSUFUDKdcewWMCiB2wlAinzJLKKXEogSx+aXeSbpCNFTX5cN5tVlf6nga45h337i5IocDz60Wz1E3BWUKqpDII9CHy9xetzmfnSOJhOZNVYwCcxhAAEhAJzy7ic8W2o7tuPn40wMlCKyRinHHZAyGMA3VpddwHUKVYAKYpTBqdZSgoqW3xWDpHfa1xHS4rq6Hm8X+i3Y4a8TZlii8MycZhHdto5lns3AZBlwkkVZSYxiCfYxCOiLyjxaJTZwz+Wm3jD5KFWbMzid2qousidfqTFQEwxtRi7jiq9O9Kq4025+5oSpTE0MlJmHzfFlxjJcsnjeU4+7btZ7Ep0p0ZKFmGJ2KcpjeVY49LoqKNHAqNnzNyQyJwBZJXrKBy9kLaWMqtrzo+D/WprbwojF87luKdtcex5vNZInCRDdfDsCin+RTDmQWkpN85jcVxWLczkqo8kpqam3p0UjOHJ1FXCygqLGETqqDsj1pPpWeO/HOvy/RGLa1O+n0gSa736bYMFTqmGNYvmKOoc5uhNKMauQBMDnMdNPUcGMAD0mERERADCNercpS3LB1txeCpocsMXJf8AiZt7WkzFAKAUAoBQCgFAKAUAoBQC4UAoDQvuXnGf4X27+jpTCHk22SyLIcOx/KAiIcZdNSFc9ie4EgiV+mBNJFD98jmZynWBREFUyBpiqKRi4zbrh8fh+xutRU+pypgq+9FR+nHL+5HcLtp9Oc3kuXTGZuo9phhM6zDEogsFH5pJy3Yg8+7mM1gJqXZzeO4m6yCTaukUU2qkoWRXj01kSszP1gRfVXOi25+4XYRhJrFZ58ae0/na/wAoSgk+qbMkznBMNCRMXrAEzD1Znm1hApRKUNxQADAconuBhHiJeq23044+x4bNeXsOWf8ALyOSnZZbq+sTFeq4GMVUDhvMACCJCBfrMNh6SgHxCI3MAjuMFc3dJZKjSOmw10nePDsoyHFJdnM4tMSEHLtToik8jnSjdazdwg8TTWBM5SOGxnDQhjJKgZI/QHUUwBXBF0kbZKp27+jfvvmPeGIyiKzT5J3IYehjehNN0hbOpJCURkkDDJIlEW53hVYgVDKpgmU4rCHQUChfrtT6lR5o0Tj0vDI3VraYCgFAKAUB5+vwv79w7DVyGg6/z24VMNAOvft7PfQaDr29vl4U3ACfn9njuoB123+fv38KZkzI1Oe1vRVKTqfgPltuqcwNTb3b/CmQzI1Ofh7uG/20BPXt93uoK+wanPYfZVeYGpULkNTn47eNCbCiyWRRsQ4RbyCqjcV09RNYUjqIj0n6BIYyQHMBijYRuWwAIb66bPaXu4g5Wkmk8q4nNd7uzYmo3XSqz0KHlckwkcZkDMnjZ10C0UsisRQxbPECj1EAwnJYpt9wCursbV213sFdjKOea3M5u+u2rvZSduSdKZcUYZbPXLNUFmq6rdUu4FEVDENb/siJRC5R8QG4DX0U7cLkemaTjsZ87C5O2+q22pbjz6nDa/tGsqIxHXz29FMANTxpQE9f2++lCcB1228h8PGlEUgT+/b76tCZYH0SXOiqmskcxFUVCKpnKNjEUIYDEOUfASmABAaxcYyi4yX0tYmSbjLrWDT95KrlVdQyq6iiypx6jqqnMdQ424mOYRMYfXSMIxVIpKK0QlOUm3Jty2szxGy8XFwcSV4/atzFjWYimdYmrczchxsiURVHebwDjXy96xev9zcduMpLreNMM9uR9TZvWbPbQVyUYvoXHLZmVKLnWMyDg7AyiqTc4JmVMkZIhzmKJhKmCnScektr3KHEK0X+3u9u4q7RSe+vtobbHc2u4q7VXFYVyKr1+O341oN+4de3ptwtUGhHXt99ZFJ6/svt5DUIT1/r50I9gA/lu+/7+I0BGpx+30UoV+8dfj4fkNOIHX7fH9PTQGumK96M+zdpF5ZifaEsp20m5MiEXkSufxbLKncEEgaPVypPDFoUWgRYETO4IiaWB+oiULIAcwEoDMEhn+DxM8zxSVzPFI3KJLT/AG/G5DIohnPP9c3Sj8lDuHici61jbiaaZuoeFAeZz3L7dssjTw95nuFtMuVUQRSxZzlMEhkaizkpTNkU4NV+WTOo4IYBIUEhE4CFr00Gh95/uHgeJvmUZlObYljclIpGXj4/IMkh4d8+QIJinVZtJF43XcpEMmYBMQpgASj5UB5Jnuj22xtWLb5D3CweBXnGrZ7CoTOWQEWtLsnhhI0eRab2QQUkGrk4CCaiQHIcQsURpWoLele9eCQncqO7Zy03Fx0rJ4i4yxvIPpmGZxvQSYiolnDCLl8k5GYlv3UHDVICCCyCKhgEbb2GYTwoXd/P8G/kn8N/meKfy/o1f4r/ACOI/kmn06nX+xfOfunT0fFfStbfQYlF7s9wy9ru32RZ2aJUnf2FOOEsSk9JHnenkZdhEpJg9UbuiNwIo/A4mFM24tvG9AU7H84zfXer9x8Fg+3WONGArjkS/caKm2/z6j1k0asF0f2iJI0I6K5OILGVEAOQqfSJlAsDwLpf9wsEi41/NSea4lGw8XJHhZSVf5HDs42NmEyEVUiX79w8Tas5JNNQpjIKHKqBTAIlsIU3DI9C2cYc2x0uYOMtxlviR0SuCZQvOxaWOGQMcUgXLNndFjBSFUolA2pbqAQ40BQsh7oYnDduMi7oMJiMyXGYHH5afI9gJRlIs5UkW1WXKzj5Fmq5ZrOHq6ZUE+kxg1DgFNwPN2q7lI9zMHa5ctDOcUfFkJ+HyHGpRyks/wAZnMZmn8JMRckuVJAgLtnEcJxESE+AxREApjTAnErOPdyO32WuTs8UzvDcneJg4FRpj2Twk05TBoZEroToRr5yqUGxl0wUuHwCct7dQXMq3n1iO4eCT8jJw8Dm2IzcvClVPMRcRkkNJSMSRA4JrGk2LJ6s6YFSOPSYVSlAo7hsNBqfiP7jYBLTDbHYrOcOksgeMCSzSCj8mhXky6i1EQcpyTaLbPVHq7BRubUKsVMUxIPUA230GRbHbXvRg3dM8+3xmYjVX+PZHk8ErGll4d5IPGeMy/7OpkrNpHvnSymOSawpnbORACqEVJewmAKDeZX6+Abed6bxzJ1PHdvtt403LMFhx5//ADNy4b2/6E7c+7IO6X23oGy++vn529njTcB133hwAfP8acwOvn4UGQE+23jUGQ69t1vRVA1Pf6PVffQbjC3c3uPK4u4Ti4dFsRZZsY53y6fzCiGsAFIq3SFQqOo3Eb/3CnIYxi3CwCBuDuu6nan0QpXpr7apeynwNtu2pR6t5q9lme5PPJKN5OceuEliAio2KqDZkYpFTLJFOybAi2UMC4AOocgj8AAJh6QAOH7t2a6rkm2qJLR7G1Sm83qEVkkYuermUE5hAD/FvKYpjFUKsIk0xOKZhMUDDe1hNbjxrVBPOTdeVMcvC2GTxwLPeK2MQCqGMQAVMO8pBIW5zG6ipidMhwAglEQsHAekLXrYnNSay4a4UrWn7P2LF+8tN4sNyiYOoxbCXpLY1wNY5UynQECLgYP6wANxR3AIVsUYuP1bdNvlpu/ccD5wAnJkLAVAMI2FMQOYxSlAvQUxClMVQhFBL1FLcPh37gEAANX1KEqNV4eMP2KVvvFmmOvf5BhzGZaO8ixeFxaayKDbCqu+iYnNByVtjLuQS0hQBpOr4fKAlxEwNFLgJClMbHtorqU5J9Lb2U3+zdzLJ4UZz8lxSxHEXcZgWLQnRj0E5DEsIhRjcOx5dywjXCsDjLJZtHHiMTh3jhJJAVPlTtmJT6mmYpBKPoxzrL+WW9fHht2GjgUB47VcNyGWSTSWBNmodsCouyN3BEirGImsoQFFtJchBKcCdWokCggBxC6k23XY+GfHxvWBcDvf9GrRyx+mRisqCvRIsXckxVULp/MNVMbikSKJHsUDplWbnTvYOkxBJ/pr17tKW0qYWor3HHbrWTeXUzdMD7g891/O/urQbB1+NMsANTx5bcKAdfl9226hNw1PeO3sqFGp99vV+NUPeNQOW1qYlGpfx8vL8b0RKDr58A8PZzoABw+z8qmorUgT+usuZd5PXxC+3CoTUagfpR4hE6lttvCnmTM1/wAZTfr4h9NgIRSUhGoM8YXlHSgsTKRaZO0mTpNXhEnn9wSmerJImO2ErgorFCxkhW6ZJNNJbfgbNZbf1MYMGWMxw/SPDd1GkdAdzzZvM5Xh2OZG6dy00jnsV2fzjGZ0YWcwI2MYovIxmAZTJoWfRyrFZkqbpbIuSpqo4xTSSw88fY9H8Kmbx6msqaeOTP5yP8o1y/VZmoksc52pukqRiiJRWyfLAKJzF6TkNZMP9Ril4iBRA3V1wa6MdvJvy8tpyzr1U1OSnaMoI/WFhytgATlBTqLpiHwpIj1AYgGBQpgubdb+reF65u5q09nzxN9miiqncdiYqZSLBYbiW/w9QHEgn6ukbhYL2AQvwHffx4Mnib267Gdbf8dJulbuqHABZ4OIBcRt/dywOJhEfAK6LPj2s1XVidPNT0cPD0+HDfeuk1Dr5+/depxHMdfr23DTgKjr57eumu8MdfPl4eVMAeLU5+G3qpoMsxqcKAjU8KYjeTqeigGp50qCNTnQbidTn6ft3U0xDGpx89w28PGgyI1Le7jfn7N9M8hQnU2H9abgNTb0045AanP7PZQDU2/KnIYHyM7RKfoMskU+4egyhAPYeHwiN99vKslGTxSdDFygn0trqLE7gtwcRLZ6SxjM3QFEwbwBFyXoNvuIf+KQlen6RccO4lbeUo+9fpU8z1W2p2I3F/pl7n+tDDvX+VfRVPAoOv2UqOnUddKiiHX7KVqt4oh1enb186VHSOuldBQddWooh17bXqV2EoOv7aVLRDq5/fsFKiiHX7PVSvtFFQzthyBWOPtDH6SGdmUeHERAAHWN0pbxHfdBMlfL+o3Hd7uVMo0Xsz99T6b0+39rtI1wcsfb+lC6COklBEqSyRxKHxAQ5TCXeIbwKYbBeuHpksZJpHYpRlgmm0fTUDbhtuqGXMalMANXbjuoCNQfPby9tBqTqfl+dqEeY1PZQpGp6fy/SgwGpx3/AI8aA5yusj7b4uyjJ36Yu8cqhkcplsOWN+n5OZJMQUotO5Gz/ksUr22m2auTYKkm0dunK66AskGYkOexQABKBZ0hHQz1v3vw/un3pw/trNy/crMHstCZF2/iX2ayse8mzOMIyTDpd3MM8hn2/wCxkZBFmYNjqM9EESEKKe8Dxd/cyNPYV37ZTOZ4Fhs5jOSScKw7eR+Fxa3cvL/40tGjEZ9MS7lwtNt2843Im+QfMmaSDRsVIBdbj0BlbM5vFMYW+rOL7kxqqub5iEs5wlw4xaUmzTuD/wC2UUxxhrBO20U8QBpj0wg+F2AGIRmsJ1lTFDqUoC2XOYoPouNw6eynt72wYxX0/drEYx5PYVFZPnfdRtOYsuuvFY0eaXAjuIhn2q1Bk0Zv3PzbhQ9i9QBQH17TPcMhsh+mSf7gLY5Hx0v9KYwUXMZX+3JtZDKWOR9vlouLaPZSya02hFEODVIptbSuRIN9hAtLt/FRMlieNYln/e/EcO7gxfcllJzuFO+3sOXumTuOzzgsoD5nJDMlyeYNkTshDFk0Wx0lY5z0mEqdylA3F+rQAX+nzuEiJlCFVJjKYmSUOkqUD5ljpRMmqmYqiahQG4GAQEo7wtQiMd/UH2zhsR7FdzHLPIe4syMixxmPXbZh3KzjMWREVM4xhQyrRnkk5ItmbwdPp1kikVAgiUDWMNClA7w4xB9vu5vaU8a/w3s721b47mjOPnXmDQknhMV3DfLYykitNouHEPDw0xMYtGqoNZR0qKhioKoFH+4cQAxXIxEZjynbabh+8eMy3bRTu33TnJ7uCHb+MedtMSzmexnFkscTLCBKDjreK+bRldCUTcGatpCSMFynuYoFReMG0wVLtr2x7j4d3Uke8HeNhmOTjGw5cb7dsY3thAwmQ5K31cYXnGajbIZKOhUXirMymqu6OUwgocwg3g9uaN+5EGz+o7tvNRkarK9xInFe9UbDYAtNSDSThEMjx/F+88RFDIMmUmvKSMBDpLHbEIYyikgbpH4wAoHp7hZDj2cZ4ZPsKiUZcv0y97YqHcQONSGOgvJmNhxYmIiHC8VGkcSjIt00kkhEzJZYhTaQmCgPx2/a4JOPO1LuM734Q/msUx7Jggu3eNdu4XGssZNzYHLsJ7HMpSjZl7KwjVggJjrlfoppqPGxOkRVEgiB7cbg4OJ7E/RbJxUPFxkkp3J7QLrSDBi2ZvllpyKmCTSiztummuqaXIqYHPUYdcB+O9AZc+mlxg8XM93sUbDjMfnzHvF3hfKwCJI1nlLXDXWZJO4h4MemVOUTxldtIsjN1AL8oPWQCDcLAHM221Ofn+nsqgan6VBiWLHqf+ZeW79/8F7eB/8AH+548PXQF9amwjTkBqbDxoBqbbXpzG4jU4b9vsoCdTbwtTfoN+g1OfooDVDvif8A6iTsFhFg3KUSgIqCc4mJ0l+InTcTBYb2DcIiABv8fvn/APsLCtI/F+GdFtNwdHqa1vFSiYCkAyd1OkEh1FC2KXqFQhhImYpTAI/1AXpEQDfcChzvqo+t1lXbtWqy9lNUbd2haTlwHQ4WMIF6QIYCqh0mLqBqpAcwFEOoEzh8NxuUBvbpAasm0oqNat58M1TxiWpbjxQgFAVAEQ6Sj0gBxAwgXqKU3X1mt1CHDja/9N6seqcsHj4r4+JhqWw7WLcAACBawCUpiKdYCUBMKlv7ZFCqF3B0FtfgPALOS/i220/Gnz5oyVUUlGXawrlWadEcLNIOPkpVdOOj5CWljt2DRR85QZw0U2dyUm/WSZiCLRukq6XVLpokOc3TWCjLqUXgtf3/AEDK/wB8Z9N1i7U/Wumi6aEds0pBFwxWIV22TcCVwxf/ACrmPeAkiCiiKiZTpnIYqpAFO4ZdsnGX0tuGFeWe/wAYEm8DnVJPnGMw2TSuSTUtPM2TnJ8pS+QxdReTjMWbkWk2OOROPYewfTOUSEZHtTJNiptn8xIqCUhE1HBiJm9GrlXpSyXtpn7PFDSlRYsoU02cSrmAeoZBNRCMPILyDuNjixYtcnYu4WZiE4SeTmYmRk0o1s4lknyYMlGDsHrNABW09ZJSRnBRp/xNrhvwVOeozP6TvpgEB+lrtN0gBdbtlFqiFyiAGWjjHN8QlMQwAJuIlsPkNendj9uahVukY8kc0HVV3vmzZQFbgG/eIB9nuvWpZGZOrttyq6AanPlf8PVUGhGpz/WgJ1PMf0poM8hqbcPxoCNTn+QUBOptw++gzGpzqgjU47+HH3eW6oBqbX9FATqB6P1qAjU8xqjDInU/OgLI7cKFR7cYHqGAhUsIxjrMcQKBAJAseoTCIgAAWw38qi2jXA8eUknDZR23ewTFeQjE8mlSZWq3j8Xepx0U5xCbQbSaz+bm4yZiATmUWaHXEISDlUq5klW5UDqOmzGu4qyaZ/KR/lDuH1ZZuQ4FMJWKXVbpAgEVmZ9YoCZPrEw/LrBfiPUIgNhrfCqhinWudPFcPLGhqnWtW64ez3eevE5R9txTT+rTCx+HVOuQBE9jHBJQiCQmsW1uk1xsAiADbwtWu+qRwq1+3jgbbbw2HbaOAopkSMFih8VxEL2usYR6guXoPu4Dut66850csTfSkcDrT/jwP0O+6xR4/J4VcQ3B1AtlImsA3EQExx4iI1usOrdNnzMLmh031K6ao1EanooCdSgI1d3Hb9KBE6nP8fZVxBT9Xnt6PRUA1Of2ev30A1fDa4eYeFMQNXz2GnAo1AHxH8vCmJBqh58vXQcxq+Y/fupyA1Pz240A1P028aAatCchq+PhtbfTcyk6m3nuoCNX2fjQcywM8jfmWScokW6zL4F7BvM1UMHxcLiKCo3/APRMYfCvW9Kv9Fx2Jfxllx/VckeT6p2/XaV+P8o58P0fNmIwVHeFxABtcAvvALDv86+g6TwMSNSlCY65Fvy+WwsFJQERJLu0n+TO12MOm3ipd+is5bETUVK6eR7B0zi0ylVLY7tRBMw7imEQEAwlKEJKLeLeGD+GXmZxhOcXKOUVjivnj5Fwam2wVnQwxKNkOTQmKQz3IMikm0RCxiaar+RdiYrdqmqsk3TOoYpTGADrLELwHeasZyhbi5zdIIyhCdyShBNyeRUmr5u9at3rRUi7V2gi6bLEG5FkF0yqoqluACJFEzgIchrJJNVWRGpJ0eZ99SrQDUqUJiNTz299KDHzGoNWiA1Ps28KdJcRqejb11KEJ1RG1xvYAAL79wbgAB4bgpRCrM34fG/tcSRRQvS6f9DlW4bypiH/AA6Q7gH4EzdQhxAxhr5j1HuPv33GL/7cMFx1fjYfT+n9v9jt05fzli/gvGpdmr+PHwrgzPQyGqHn7KEGpz+z176FJ1ee1/GhCAV53/CgAK8+O/yoBq8NvKgQ1dg28KDiecEWpHJ3hWzcrtRMElHRUUyuVE/gEEzrgXVMmAkLuEbbg8gpuHMk6TVVZJwq3QVcNxPoLqIpmWQ6wsbRVMUTp9YcekQvQEgRAFxdAiiDk6YImcaRNcyQD1FRMr06gpgbeBRG1/CgMRZt2qe5u9mkXndDuDGYhkzJOOyPBYs2KJw76PBkVi7YspR3i7vKIRrLogIPAaPkzrah+kxOoLAZUaR0axbxrVoxaoIw7UjKKIREn/L2iaBGpEGhhAToJg3TKQQKIXKAANK+wcj1LEbuNLXQRX0FiOEdZNNXRcJ30l0usDaayfUPSYLGC+4aA/IpNRcFeGbtxdFTFEroUkxcFRETG0iriXUKn1GEem9riNAffVDz++lGBq8/vH7t1AfNYEXCZ0XCaa6KhRKoisQqiahfEpyHAxTByEBoOZ+dND5f5XQR+V0fl/ltIny+h0CnoaPTp6On8PRa3Tu4UwqCUgSQTIigmmgkmHSmkiQqaSZQ32IQgAUoBfgAWpyC3FPnGCk1DyUSjLSsErINFWqczBLNm8xGHVL0leRqzxo/aJu0B+IgqoKp3/qIYNwhv0Me4f2xDHskUzTI8zyfuFl/7GfGGM1kqWOMSQ8Aq9QkHcfFxmKwWPxqR5F61QUcuFU1nCugQOsCl6RChlBNJskss4SboJuHHT8wumimRZfoCxNZQpQUU6AHd1CNqA++pwttsNBuPkUiBVjuCoolcKkKmouVMgLqJkv0EMqAdZikvuAREAoN+p9dX8NvO1M8gNX2ev7acxiWQwUEO5GWDf8A+SO3wf8Ax7ub+NOIwZe2rz/P00KTq00xINXnzGgGrz5euiHEavmPvoOA1edAald7XSS+SKppHSWO0aNE3BSKFEzZUzczkElviMCSxkFE1BKJQNomA28pgt5He/V3Cj1UpHH25PPDxqdVnCFd5rhICp0KkJc1x6TFuAEuU4FMt1nKoCZhIO8RA2/fuABrmb+utPqrp48bzZpQs9wuADYhR6QATWDf0GEBOJkxMUyhhMY17G+IvADbt59WKefjbknns3GNdC2nhzdZwHqIBD9SnSc5ExKIJlSMcxhBNThvKHSNxDiBbmlZJpKiqqp4ZquBYrCpbTs4EKpwAol3G6TGJ0qXIQw/2hE/xAHUAgPSN7iNrjsw66xq6+H++3XAFOgVzmyFoYpzdCBjGSTLcCFUUU3kKAAVQChqW3iUT/0iBR6emXMYOL/k1j45lWZbn1BzGPP2zx7LRSQOu2s84XjZzLccVYoQcw/wRA8hk2EZDPxrVB0yWw/O3MS6mohc7cx15SJWXBRvINS7O0jJqraUXsezd7/fvWE2jRmamH0GTJZiUcouoeNahJsGkTjk46yFg0iYxZxJprNIl7PyuWybp02MdgziYtF0JSlbJoulxIc3U5Kf0JvL38fma8ihuVZI80R2SUbhCpRT1svDKxKSj5zLrv2KkZJDMfOiRszjmiDtuZmDM5nSroq2un8uCKtUYqFEsa7X+/ilDCrrjkf0xfS24BX6W+0HT4dsINMd3SFyxIFMH9IANh3XsN69W6+q6pbYxfuRohgntq+bNkCK/CXfv6S3D1BWnQz1P1q8/btzoBqhbbhxoNRq8/R7fuoOI1fL9eN/dQa0Aq8/w89/GgGr5+H4bqMDV3cefmFANUPPz+4eNMQNX3cAvSgGrfn678/bagGru48vC3PwoOQ1ef68ffTAcRqh57qag17y9SSh8Awd/j8q/jp1rhs9CxDBqMWuhLPP9sJmfZNVYmQjHqUwqyk8TbuCoIqtTnSSVL1qJmM3W1z/AINqtUtOGz9zdZ6eqk1VYV9qW1Uz8ZmG+zse/O/wifksPZ4YvD9xO+2HMoFh9VWX5njcVGxOdw+OlWCHwDC/9tMjkJSRi3ijaIyJ2zl2BtEXvVNLPW8U6emi883s4Y5655os28Vo0tPn76eWGf8AP3/k8ATfVrnagCboFuzKJhMBxBUHsuXpJ1f0kApN5Sh0gNrhfj0Jpw3Ln8qU8VOWX8vI5TYCBUvqrwZUSgAHcNxAxR6hOQTogmYbCYeoTG33tYb3rX3DpHcvLZ4+ZnayZ2tZG6EUTB8A6pyKDuKPxahQAoCIAIgJgsG7lXBL+WGw6Y/xx8YnWD/Hk46nnc/h1Gj8PMbiO8q+SlEREfMRH2VvsKkmjC5kmdN9Xjv23e2ug0k6oXuI/lTPiNw1d23G9C7hq+z0DupzINTblsNOY5lN1ue2776AavP2+igGrz9e7zoBq86AavOgJ1d337vKgI1ufr93vpiBq87+yhBqht6/C16FGrtsPOgQ1edBUav3eygKPOPpJmwUcxiaCyqPxqprkUUEUQAROZIE1U7nT42HiHDfuHp7WFm5dULzaTyphjvqjn7qd+3adyyk5LNNPLdiYpdZnOO0lETuESJLEMmqmm2QEpk1CiU5BFUqpukSiIcb179v07trclJJuSdU6vThQ8C56j3VxOLaUWqZLFedS1+sPOu7E4a0HXtt6KYipqb3uODPvf8ATc8ZvXrZ1KZNMxUkihKPkmr2NYtWrtsi5jCOgYKaLiQUMKgpahgOAGMJQKAef3VV3Vlp4uTTx04eZ39s69reqsFFNYLM1w7bl7qa3YqCkcc7vMnWDSveZLOJdSBn1GYmlmBFoAUn7gRZyazcyIlb65ipaxilTMNxtx2f8itqDjcTg59To9cv0O287FLs4yt0kodKqtM8C0Y/As4lcD7v48OHZZkpm+ItpNhmzuM7lY9kGRZAjlcRILwszjmSySjOam2EYLk4fJoHAhE+gTLGUTtrVm7Kzch0yl9Neqkk26p0abxdNnvM3etRu259UY1lRxrFpKjVU1km6Z+46M9kk4Rt2yxdCBjZ+JYpMtNVnkqU+jKEkSGEkqY6eSqrShGx5EqmkAiCIEsCQAn0hXsdqkrEVFNKmta788Tx+5lL70utxbrpSm7LDIyt1h58a6MTRUdew+2mIqNQKYip4JWYjIONfzMzIM4qJi2q7+SkpByi0YsWbZMyrh07dODpooIIJFExjmEClAN40xNPcd1Y7OxPuu6nC321uLlKUmoxjFKrbbwSSzbMfduO9fa/u5+8F7d5jHZKrALpt5dqgk+ZPWIrCoDdZVhKNGL0zJ0KJtFwVMUFukeg5rVE65Hi+hflf49+S/d/9D7q3flZaU0lKMo1rRuM4xl0uj6ZJdLo6NmUesN+3OrifQVAKdIgYLXKICFwAQuG8LlMAgIchCw0xeAUi7kM5yAogUVkXJhEClKo1TuYRGwAANwREREeHjXnT9M7RqtHFcfnU74ep92tVLy+VDLUe4fKNEVJEqCbs5etVJuU5U0urgmOoooInKX+rfa+7mPz95Wlcastu2tXr7l5H0Nl3XbTvpK41ktOeJ7RV58PD2VqRtGtsG71UA1fL7bfhQDW5+N+NANXntx4UA1auQJ1ee361BgRq86Aavnt7/GmmAGrcR3j4+NMhgNXnsNANbftz9dAhq8/Lb10BOr+e3OgW4jV586F3jV57ffQE6v4W/WoQjW24VRqNXn6vDf9+6gGr7/aFC5sa3p38PV9oUJgSKvOgI1vXt6qAavPb7qAavP9AD8KAnV58PRf8KAslgr/AOY2VDu34VgHune5P41Ay9dXa+2+qNRrbbXpmBrc7jQDW+7jtuoHmNX8P0oNRq8d9AjS/ugOpnWXEKACY8lFWKIDcwjiWOpEDqE5SAHWcA3+Jt4CAWHxO8/8xJ60XKj44Pd7TqtfwMNvx1ExApbGNcRBMSJAIXE5zGE/UUhE7hbp6QEQKG641otrpkpPTb48zYWU6E/WqBzdBymVuPSHSQRG4iHACAQ1x6R8/Cw3yclXVrfsRg/fUtZ+YqZjFOQonP0iHSc1gJ0qJG6bGESCUwcBAQCwgACAjVUqxUZ1T2ca68Hsx5ZYaFrPFDAIXGx1RUEwkMREhjmAxhEEh+HoET2Hd0gJw33ADF1xm4yXV/FPPkll+m3bViUyIWJ/I2QKEMcB6zHKFz2TBQhlEygciphN1KD8QAYwGER/1iA7rkZJUw6a12PHd+3AnMsXvstKuMfiIjIo+HnQd4+KOVSjBonGwR5JqlEIrJo4vMyeQySELPLOHyqCSjuQ+SRQFJw6VVORVXPt3j9OS27c8HhpT5UMJN0xNDpGdduknGRMjzcizPBazLFTRbWDknMi3F+6IcU8rSgH0ZMzBTEbFRlHLRmgIFMqdD+8qHSl0/QqVrnhz100VczVni8i25KScslFXyruTfs3qUNFtYhmwarNY5c8o9ZLTDYyMehNq/Ollm/z6jhwo0bNo0qiCSJvmzL5dFWk/wDT7/GzEKSVdp/Sl9FeUpz30sYa3IkZMcYxhjjyhxOQ2uojicNKmUIkiUvy6ZP3YEyk3jZPq3dXSX17sWnbnJ1crcX7v0Zy22qSSphJo3LBXcG/gFvX+dc5tGtz28aAavjfx9YUHMnV50BGtcfx8/zqACrz286oGrv4/hSmAGr6qDUa3t29/lQDV9npoBq86AnW5/bQDV2v6vuoCNbnTiNTEeW9yWPbfHcLF2kzMpkT2Rg2bqVlBhsfik8Z7eZr3Jm5TIJRNjLyDSMZ4p29fiUzZi9WM5FEhkyJGVXRLHHQ1XbrhKFuC6rlyfTFVoq9Lli8XlF0onjTSrVwYRLQuTxx5xvCw7GQjp3LYB2eOBF6glKw+QLwk8pGSxo6MXesZF/BEUBcUETOCJpmOQBKAASQtXfuwbyak4tZ4xbT0Wq2I/lf/wAlhwX+qfPRKU5R3JHETbikTmJkgiJi2NZZZETABhMBd1ukd1b7f126VWFfanXkWWEsMn451OVeLIil9TmDuCCQA+Za707mHV1m5ynN1B0/H08BG4W4BwrTdTpR4pr4Izi/pqdk2ioAKRekoXcFOBj3vYOv4QuA3E3UAgNwAB48uJ4xrxNyeNN51Z/x2ODfuXdApjX/AOXYqPHdcjzIAuBbAIAPVf0+mttnGr1E9iyOourz47XreaiNXnt7rUA1edAxq89vwoBq+F922+gKZrW8fLjut+VARrc/TtwoOZOsA+NuG3mNANXnf086EGt4cqFyI1gva/3+PtDjQbxrc/xpwG/QnW57XCgyI1t/Hxv9v3UGROt7fwpvA1ufLbxqAa3OqOJS32QRcdcHb1Ehwv8A2SjqLbuACkmBzluPiIAFb7Xa9xe/24trbp7Wc93urFlf9yUa7M37EYWmHMe4frLRpFUmyo9emqUhOlQbippFIc9khEbgG617WtavqO2V6FlQvtOa1WzfvPme4lYldcrKag9vw3FM6+db6miqHXzpUqoWipguGL5alni2ORS2YN2gMUMhVbFUkUGwJHQAiCx+oETaCpidZQA+mcxb9IiA6/tW/ufdcV92mepsV6at/aTf29hd3XzrbU1VTHX76lRVDr50qKodfP7dvGlRVGsPcX6yPp67YTC2PZFnqDudarAg+jMcj5HIlY5QDkIqm/dRbZeOart+u6iJ1gXL0iHR1bhnWlgfn3rv9p/g/wCPd0+x77vIy7yLpKFqMrri8KqTgnFNaxcupUeFcDJWCd58B7q4rIZV2vn2OaJMGyx1I1moqxlUn5GyizeNkY5+gjIRS7w6fQmZZECn/qL1FC9OquKPf9H/ACr0T8k9Nueo/j16HdxhF/RFuM1KjahKMkpQcqUXVGjzVUcks177513fxGEx7Ju6bORhu8j1xhncfts0w9GIkOxc8hmDVLEpgr1o3CWdY4EkizK6TfuzqvUdZIt1TgDfW5N5n8z+rfmPq/5P6Za7L1D1GNztfVZux3XaxsKEvT7ivpWZ9SXW7XWodauTbuR64r6n9GwvarFu6Zfq5xeYnZOFm8nxPBJjEO+kxhWLZBAYh+1I48zN2/byU3kCLI2WZ1OSK7Z67MgiRuRmg30S9CRujJV6q6n3H456b+RL+ze37nvLlq96h23Z3LPqE7Fm7bs9CtR/xlO5cUfvdxck43JuMVFQjDoVIunTzr5+NZ1Z/Qf0jr57eVuVKkqi4MbfxbB+DqSKsfTABbCQhVE01b2FZQomAwiQv9NgNv38QCuPvrfcXrP27DSrnjR02L4nZ2V3t7V7rvVwy1o95mFnNR8gF2bxFcbXEhT2VAA33MifpVIHpKFfN3e3vWXS7Frl7cj6S1fs3sbck/GzM92tz31p3G7iNbn+lEQnV5+/1fZQZjV5/f8Aheg4jW5/r99qFGt48Rvt52403EGtx3+zYOFBgWF3TyOTxfth3IyaGXI3mMdwLMJyJcHRTcJoSURj0i/YLHQXKdFcqbpuQwkOUSmALCFqDQwe/wAr7sdt8NgO6U9mzDPsQFrjkhnMG/xaMgJiJhZ08ei9nMbloJVs2XUgRfa6jV23ODhumfpVTP03AyDknfrHMceZAQcbzebgsPcizzPMoCEaPcXxVym3RdvUpFwvKtJR+MS0cEUejHNHoMyiOsJBKYADI/TzvpEFmZmLgMM7hZsyxx+1ishyPD4OOlIGJknTFnJixEzibYy0q5aR8ggquWPaPNEqpQNYw2oCyMQ72ljXuXRGTupfJshke++bYRg+NwjNk6mjw0QSNWL0NgVj0UIKBQVMd0+cqFTRKcNRS4lAQqbLv13xWL00Ym0WkitXAxyT9ZZsxVfFSUFom9cN0HS7dodcCgociShykERAhhCwhuMRdkMzyvMMfyt1masYebg+5ef4mckMmdOMbtsanl4pu3ZnWSRcuUEioCBVligsoFjGABGwAWf347jyeG5P2riCdxo/tjj+Ur5oXIcmkI6CfpJDCxDB5EoFGfRVaoC4eLinu6TG6w4iAUBmHt+4crY01er5837koyCiryPypm0gmrN0xUAiaSDb+OlCMcooqpH/ALpREwiYQEfhCgMB5MXvJB9wu2WGpd7Hy7XPP5n829UwDByrsP4vCISrf5ZMsdpqfNqLCQ/VwKFw31HQcy6E+98dhjJ+yyEM7zmOxCUcwua92GGKwjPFYiRB+PzKUkiwkWLtRLHU3abd4tHMHSLcUTaxwUKqBbzJlgXEh33xp9kWRYvD45n07JYrLykPOqwuJupCMYOYyFSmiHUlElvkBLLJraDNID/MrOA6RSKUSnM4l4lNX72ovkZuAdYrnXb3KXGEZRk+Lp5nFwrYJlvBMiGeLxi8NOZC0B5FKvG51WrkUXBSqAYU+m9goW12x7/kfYh2pQyzHs9Tlcvw6BTaZfJQMcxgsyzNLEU5iTjIo4SSD5OQl1Gbo7My7Joze9Ai3UOQSmEOJkU3e3ED4hgeZMU5mUZdx5CLicXjI5mgrOOJKSbvHSrRwyVeIpIKxCUe4+d/uiVEUDgAm3XIGNe2n1GqTPbwMqzjF8pj3v75MwzJRjjxBa5RIjm8zjkBjuLM0JZ++kchK3aJJOkzFTTIukscTlSIJgAy9hXc+PzGRmoFWByfD8mgG8c+kcby9lHtJMIyWO8TjJVotDys3ESEc7Wj109RB0oKaqRiKAUwWoN7Mi634W9PoGgJBba3K9MQWYxVt3CygfPDcD48pvuMP2DQF563jfYN/spoENb77+X5UyA1dvR4+Hnem8DVDzH28aAa3mO2/lQMa3vH3/femINSe5JSGzDKFBHrAHceoqBTCChCkxuEARKIAWwmTLawGAekxr33APh97/5iSpi0seKS9izyOu3hBefMw28TE5FExKBjGua4JgBTdQAZM6aYmSIBSmscvC5eFt1c6xVcUZljyRC6h1OspDAJz/AU/QUoicBEoFEoGJcvWAXsIiF77yhti1Rat/HxriYvMs6SIBDABilL1GOYCCJxKIAIiQ5C9IFASmMIAI2/pCwAG8bKVXRPT4U357/airItZ+X4uoopJ/AUDqfEKw3PuKAB0lImYCCBh+IxgHpAo7gHV1VatOtG8vJlLLdJN3b5Vq4ZvZFlKsf2Z43YOxYuyspxy2iniwvUH8S6aJMGblZyos3XReEIkc7UFHBU0jdFylF9VUue3Guewx1Ma/UI+M6ReHTDI4lxJy7Buo91mski5RhWxXhHbKPkV8hh4mCl0SDHODlZtHq6rk5tNNwKLsuFmNcMPb+mi+BjPBVxNBJqSarpHljrsilUiZU0ZlzdlFN1sVx2YioyRXknLrIHrkirdd3AIKnODc7dRRBuCzbTQOoHdCssG3hpXZh42Y4ml0LadSKTJ89Mg0QiVXL9JaabkjEnk1MvFv27F4abXPBvHThFHQi0G5nD9uc5WLPoVFsi0MJMWlJ1eNfOmFXzzzrlUmOR/QP/AI8cvbMvpQz99JOhRZYu/npNw96TLoto1n20xZ6oUpEincuHDVFmcTkKQ5lDCHR1iYAr271Pt2Z4f7UarZTb4qc9pUc444zeJ1C1t1vV9oVzam3jkNbn5bB66Aau27zoN+pOt9/PYKcgNbd5ejxqEyYBbbwHfe/heqyka33/AGUxqMUNbb7ePooCdfn9nt9FQEa3h51d4Gttf0UoMydbbfanIDW3ht7qAjW8+VuY/rQGlv1ZSa7HF+1Qt5EYZQ2W990glwbi9GI+T+i36uHiUmVl8y0B6LFViRXSFVIFOm3WXcYKknXq/j7PfR8mcncOnddonk+4e7/7N0zJ2FWRTxjK2jcHBW7Dur3PbIFdrmcuipDl8k6SK4XMAHWXKRwAHObecwCYeNqlKKm42WZV69quS5n80/8AkoZLN/qrz8HTYiJjpouCFTOkpdF26lnrVdQyAqCCy6LtNbpEQGw9JwAxa3WlWDi3g+O3RZezUzm6S9nI5dxKR0fqEwVUxxsDhv8AGNwABTUTBQpA6xARIY97lAB6RARDcI1pvN9L2+Nhnbo143HWUj4qiKJ94HFwimYvTuEw9IHLfiI9AiYBv5eiuN50emPkbE8K7cDqp/jne9cz3JIIj1BC44JrGvvTfSgfEG4AE3Xfh428K22lSTWhZ4xT1OqWqFuO26w+VbzUNcPP28qbyjW5/ZTPADW9f4UHIawe71UFPYUrW50FSNfnw2GiJQa9vH17qFJ1udBlwI1vTt+FANbnu25UCGt4X86AnX47x5eyjA1ufqoMSNbhvpwyA1t3t40zA1vD0fl403gsXI8aK6630YQpHG86zUNxHA8ROlwAiwjxDgbkPH2Ox9Rdulq/jb0ez9OXA8jvfTlcresKlzVbeG/nxMYmOcpjFMAlMURKYo3AxTAIgJRAbCAgPEK95NNVWR4DTWDwZGoNWqA1BpVEGoPnt5UqgNQfXSqKNQfPbw8qVQGoNKohpR9e3dnIu13YxUMVerxk3nGQNMNCWaGMk8jIt3GykjLuGTgof8M7cNI35UhyiCqZXBlExKchTFwnLDA/Jf7o/JO+/Hfw5r06crfd95fjY644ShBxnKbi9JOMOhPNdTlGjSa01+kj6QOz3fLsjJ5ZlEhPK5c/npqGK9ipUrYMUVjyNzMyljxTVbvXLlJyRyr80BwOkqUpAIICc2EYxaxzPyv+sv6u/FvzD8Ruep+ozvP1Od65b6oTp9lxp0/TRqTaak+utU0klm9VsXyHPfou+ol42cnOs4xSWCGymPanMRjmGGvxbPLpEOoBQJKRSqL1kKnxN3IJCcOohiVE+iR+b+n9761/U/51K3cq7nbXei9Ffxv2JUlh/wA8HG5br/GXS2qpo7hzHZ3Ce6s/hPcMJdwOGFVhO4KWIQbCFi4HNcpTKaRxvM8rkWccnO5Ao0aPSCm2XcGbiJCD02FYqu1pPHQ/r7uvxT0n8k73tPXFdl/6VW33Ks2424W795fVav3pRirlxxjJUjKTjgnTGSlsPqD57bqyqj7kag+fC9KrIDU2v+VKjifREqzhUiKJDKqqGApEyBcxhHgABy8/AKkrkIRcptKK1LGErklCCrJ5GWcex5KLArp10LSBi7h4ptQMFhKl/wBpQQHef1Buvf5vve/l3D+3bws8+O7d4X0nZdhDt0rlzG9y4b95dmtz9Nq83E9Ea3roK7Rrc/L18KAnW5+sBt6vXQDW38b+vdxD0cKZIEa/hf2+ylBvGtz8t9AWF3Wi5LJe1/cnHIVv87M5BgOYwsSz127f5uTlcdkWDFt8w7UQaoa7twQvWqciZb3MYAARBoDCUhFdzu5ODQvamW7duMCxpdjjkXm2RT+TYtJvHMHDixVk43GYvFJXINR9NCxBAF3iiCaCChzdBz9IUpiCx3naUIXIO47TIOzGS90W2Z5lk+VY/OY5naUJDuGWWuBkHmPZbGyGa48WKGNeOlktdJo7TctjE+ExynAQPRmuBZWE3LKdsu3ef9vM6duoNGMzbFe4cSTttJMo1NgySks1x9zkaSj8WMU3FJRuaGWXcikUdQwmAwAemE7T55g+a5n3hxiC+cyuS7oZYSSxdeXiOnN+1OQPoldqeKdupEsbATkQ8RUfNyrKtRW6VElw+JOgNw38g6axj160jXMm9bsXLptDILsUHj90i3OsjGIOHrttGIuXapQSKdZciBTmATKFJcwBoa89nf8AcfG4PuelMdspWHkpLMu4/cHGkJHJMLcNplbKZp/MxGOncQWRS5496GqmmsssQjcgmESnMAUKX/I5xm0TGYnIvO0k/OvZTH0V8nY4rN4g9fYpOrtWSruC05ucgm8uyB2ZRMXTZwcg6AG6BASjTAh4uyWKzOHYtNFnI9rAvMozfLMyTxVk4bu2mJMshkhcMseScshGPXUaN0yqLmbADf5lVQE+ooAcwH2zHHpyV7q9m8lYMteFxT/cP9+e/MtEvkP33HGsfF/8Ms4TduvmnaYk/spqdFrn6Q30wBrgPaAsC+zmByDslkfc8uQZdlE7juQQmfpQuOyMRlEq4mAjMvZvs0hDQ7yJO9OgsohGuk3RCFOQpjCIUBlFjg/cWIwj6io3FwDHMly/OMome3j0JBn1KMXeGYhERrxB03cOTxThV1EuEUjL6S6ChSqiBQ6TCw8wYyje1805y6AyDHe1GU4g0bdvO6MDkEpmubQ+QZLNZFkMLDNIgroTZZkC6jVR21XBJzqkBQ6ihlUW5AIKgZl1YvjvcHIMe7BYBOYBM4a27SLYLN5XkUxL4m+j5B3g2MKRcdFYunj2QTLt+rKypyHXUXSbJtm6ZwuZQyd24Hw7VYe4L3yz9Irtu8wLtJOz7nBWiJFSFist7usYrIctYlsYUDDjaKrhNIhblSTmDgFjCYhALZW7Z51Jdt4jt68wGSdvO1/dmX7gomWyKIiIHuPDSuWZo+/aMdm42fLMxMorAZgdQp3aLNJB0gQqh7GMAAZu7Q45DRczOTcb2hybtyo5io+NGVy/KW03MTCSTp06UjkWDXLcvBlHR65tQqii6RlDqjZO1xoDPmtt+POg3E627j4+6wbqAs5kr/1/kw3/APk/Bw9k13DHz50BeArc9t/h6KDUa3P7NvCgJ1uHv/OgqNa3jfz3hz8KAjW23e6geQ1ue2wUBrH3BSKplE2qYwhqPWIX6ky/+5oZNMxBOBjAoQwjYxbb7AG+vC7ude6nCiVEsca5J8PGJ12lSCZiWRJYypDFA2oQTGAoiQ6gHIbcbq0xTWEg/wCoQOAiA8RExuWCf+rx4/fYtj3FjSaZhEqggBR/19B+kvWI3EAIokmY5ziFzmKABe5bAJREdkXpKrfuNciypJMvwJntwOqQ42BRVwVOxg6SgCfxApuvYwCIgXcIAOMpOtM6UM1ii03QF6FTdImNpm6DFAbBcoAUnEQMqe5umwBa9rlE1xzg4p9eHTVVx4fuiFkPSnTkCCkq9RKkkRTUh0WjmQVBm5ZrAkm3VQftnBXKRRSU+ATgmsoJTEU6Thsm+l/Sva2qVw8Vz2bY9xgP6iV00GhE1jOGKrwmRM0G73L3xHZkpjKohoDmOSB5JN1QVVfFPGiZQrqHK8asWqbYrlZBO9s1XpX83XP2v2U0w2mNzLcaLyMmiBlXhXiTRXodugdOCtEGabdAkm2Seul0JeGi5qBhGqDyQcMfmRcJJ6aglSWBO/oTUElXFyxpsrhjSuzDPQ0KrZb5nyZXBXBDuECLPxbgkoo2UBuLw8oVSLdy7hw+Sk3sfLsnRAZMlSiyKsRIyJCFLqYUjFNYVr4aX6DFurP6FvoqhWg/Qx3segmKJ1MDydQQRMXpVO47GRiSyi/wGEVDgsI9PWYofCIgBxMAfQTUXGxDOLjFYpZYcTgt1j9yWqb+J011+deedhOt921qAa1vHa/L0VARreW7neqGNfn5eO7a1UpOt4X9/wCNTeSg1ue3qoCNbhv9/wCl940BOt4cfd+FANfw8Pt/WgIFbntemQGtz/WmYJ17+O/1+YUGpGt7vdyoDQjv0+PIY52dM/YrZEl/vn9WrFeHWfGRNLMGH0u/XSwRhQfqmuyRctmpGyZt5UCdIAHSULF7zi7lp912jTVP8h//AIb3Iz19PEowksZzF/FrKLR73ubmEiyUWVMuqdrKnYy7ZRRcyLYV1Fm74hxOCZAETf0lH4Qsk1g86GXat1uqWavzXvP58/8AJSQrr6qs4VEhBAWOONzAJNxit40omMpxIY1zhx3dJgEd4BWyH8Nvw8Z+Km+X89nx+Zy2Sb6XejDjlIBQ1WBLkEQAA+YQApTGEAL/AOrEQCwbrgHjWq+6x3U8eNTKCoqHSBs6AxkSgp/bK4SESiIgACdUpAMNgHj03AB4cr1ytxabWdDJJxdHkdUP8cjgSZT3LS6hsfH4JQoWsBuiRdlE28B3lFTfzGsrLqzOR1j1g866MTDeRr89g8RotxCdf3edCgVqIEa+4fVQmNCk6/P3frQo1vC/v3UG8a3lt+I0GA1ue70UA1vWFBuGvtt500BGv5jfmNATr7bXqga/Px8/fUHIa9uG36UA1vXtu9FqVYIFwIFMIAJhABEClEtz2DgHUJS3HmIBemDdMkTCmRi+eymWUVUZgmrGJBcpiXErlQu+xjqhaxDf9zcPmIV9F2fYdsoq7VXJbdF5fP3Hz/ed93MpO0k7cVpq/Pfu9rLN1uf2+P616nSjy6MavPbh76UQoxq+G3O40ohRjWH3beI3pRCjGtzvv+7nSiJRnO365PquyHs8nF9uO3TlJhmmRRX7xK5CZJNytjsCu4cs2pIxJYFG5ZmUcM1f7qhT/LIE6ik1FU1U8JumCPwn+4/7J778Ujb9A9Cah6vftdc7tE3attuKUE8PuTcZYtPoiqpdUoyjop3T+mX6ne3eLN++GSZU9mpFJNtJ5C7jMryN9muKfOKoKFdyjp2i2XUBqvpA5UauFvl1S9Rv7RBVDBxklU/G/wAk/rv+xPQfTY/mHqHczu30lO64Xrsu4s9TT6puSTdHTrcJS6Xi/pj1GZ+2HcV/9Z3Z3Jfp47izKB+6uOoIZf21yySMRP8AfnMGkq3K2lxTJ1Kybdq9VbuHBCqLLMnR1xIdRuoZWr6lR5n1n4565e/tn8V7j8E9dux/9y2Er/aXpYfcdtNUnRYzSk4ykk5Stzc2nKEnLXnAcW+tHspkUziXb7Fu5mNyU6KbWUQjMbLMQD7SEyKMilLOWEpjCehqiUsgiuQUgEQ1S7wqJSToj4b0X0z+2/xHv7vpfofbeo9v3F76ZqFr7luVMFJTcZ2cK0V2MlTLqR+fqS7DTfaTD+3+T9yMkcTPeLuNO5dKZcgvK/vAosW6EEZkRZ+cyp30g0cuFBcuCnMkodwCaYmKiBzpRoscyfn/AOFd5+L+ldj6j6/fld/Ku/vX53k59dIpW+lOWPVKLb6pJtNy6VVQUn2Q+kU8kX6bO0ISuqDr+KJilrXA/wC2i/fGhrAO/SGI0NP/ALlq2xX0o/qz+r13P/sD0v8Aya/c/wAZUr/wdUvt+XR003Gx2qPn7R/SrRH3tGNUR8ff5/hSiQoxrD57tvbSiFGSVwYpinIYxTFG5TAYQMBg3gICFhAQEL7qdKao8mF1RdVmX9juUSi6pGazdWRJuDXIAAsiURt1LHMJUjkDzMJTcxrxe+7Ht4Rd2MlB7NHw1Pa7Lvu5lJWpxc1tWa46e0yIK/Px2414aPboNfbYaAa/Pl40A1+dCjXv4+P6hffShBrc/fSoGv6vy8aDQnX5h4+NvbUGJGvz4/n66oGtz/DhQDXt4+ugGvx38aYE0Gvz/H8qby6jX2v+FN+oGvz+zl6aZZAa/hfb9KDeNfnx23+ygwGtz240AFfn5/du9NFkKDW50Q3ka3kNAUuKioeDCRCHjWUYEtLPZyT+SbpNxkJiROU76TdimUBcPXZiF61DXMaweABQFV1vG/5UHEa1/H3UQGvz3ev1UA1ufqDx5UBaLNb/AK7yMb8cSwoPZM5/+NNAXdrc/X7PxoCNbn6OXuoCQX57eig1qNfnt7aDUa/soBrcdvLhQGDM7KJplZUpjBqCQpigURA926HTYQAN4mSC9xH+kLBuEQ8DvPt/5U6/7lFyXw2fE67dehbDD8gmTVMIJiJgIIiIksUOkDCUpSh0qHAiaZgMb4gsN9wAFuSPVvz2vz565+ZswSLIk0bFMYOgBMmYTjcRMdQDplJ0gmAqCYSqdHxAJCgYADp6hrdbX0t3HWa8bPd5mL3FiySJTCoPQe4lTAb9Zz9RRMkkS4FAbiIgX/Vc3T8NgEazTX8HSiWfH9iJ7c/HjcWk5TC9ym3h09A6hhIU5i+IpikYwmE3TuvYeADvvj1NRrr48frQy1LJfpIA/MmsV0ZmqgsgqDAJAj9IjpdNsAIKRZQl2ygAsBgVR0VW5SirqFKQqxLK45J1a6qPZ7dOGPuxRMjVj6iXjlu3O3KQWKrkyzU7dAFmzI0m4Zh+5ftyqMcE/kzuNkY0iq7wUGaIx74ygnOdAUibO3p11SSaxePnpl86umLMLlMjnjOZrDwkCOVE+dyVy9mG8bGQeMOmUrJPpX9zBylEtmWOmE89KwsfFfMuUUgkV2rVg60CqNtXU9OFt3J0bSa1eGzbv0pyOVyoqqrrsxMV4d3cZZFNR8bIQ7/H5gyijAUlpRF1HKJN0WzGJh0nki6QkmE05SXO4cRJRdIt1GKtwUfukhXzudr9qHUnWDeninjJUMbd3rlRqkkf1U/41jtnv0ldzGDwrZ43d/ON1m6qSTls6SDtFjLZ20eJnREijYxSmJ0nARMUogYRAQ6vZ7hv7PbNJpK0qVbq1XBrlhrV5s5rVOu5FutZPTdijoPr8+fvrzjrGv439lENw1+fANvGhdRr+/n6KEGtz50A1+fh9lAeVZ90bifEYd+8dwbt3puPtD1DWLdMCpVPKEk46gCxDdNusRAQ8r8DWA5g9QXvbgA49byRl0o9RZEptxymJv436gtbxGwDvHkNZdS1J00xRaPcLP2Hb/GHs+7SM8ddKrWDhiLIN3k/OHaunEfCsfm1ECmdPRamsAXMBCmMBRAo1JSUY9QjFuVGWf2v74Y33EePsaGSxprncREQ05N4nD5Oyn3MfHzTRuug560k2bpZu3dLGaqqi3TT1yfAJ0zpKqozUsP9RZQcc8jNGv5Db86zMBrh589vZTeKDX5+dVA1A7zdsM+yvBsWN2mZ4vO5LhndrvDlQ47nWdSnbWMn2HcvDu/vanIW7XuHB9ru8jjEpSBT7yqy0eqpik4i4UjCM1kyFcGdoRYZZ/qcXe2+5k7V/tFbletXOpRnJxTXROFOpRm406ur+LrSmFarKPYPHu4GMYVIH7oRWI4/muR5bkeSy2O4Lmkx3FxmDReuSMolkyzqd7d9pZPJl1YeObuHSx8biCJOl1EE0lE0iuFsm6l7K33ELcp9yoRvzuSk1CTlFVeCUnGDeFMelbMaVfAn6/kDO/qa7inNcwAvHo9Jh6imBOIYGIUAESiQC6hR3gIdQAIDvEKxjJLjXHdjnlxOmSbeGiOZkwy+W7lY0sQfgRdMjJmAQtcyiYkMXee4CX4d4D8VxHdYRl764rCkchBuLxxe03cYuFD6AgYbgqACIXDge5RDcFxDcIcAAREQsNcSwlTQ6HSjep1O/wAcbwFMy7ilGwH/AItFCICI33SxwuAjxL8QW33DxvxHfaXTJmtyTS2nW3X57en1VvINfb0jy8aAa/Plb2+dANfnQUGvz9/3+VA/eUfX58/v9VqAa+/cP5+nlQDX57D58aAa/PYePjegGvztb7/RQDX50A193GmoGvz29tAhr87bcB303Aa+/iH30QGtzDbdwoK6E6/Pb1UBQp91FJsxGTTItcBBAgbnBlAC/wDYOFjkt4jfpAON+A9vYx7mV6nbum16eZx96+3jar3CTWi1ru8UMQmVKJjCUBKUTD0gYeoSlERsAm6SgYQDiNgv5V9SlhjmfL61WRGrSiJjTEjV9dKCjNXfqO78z/YZ92xyBWKiXvbWbyhWBz16YXC2SRxHDJRZgrCMk3CCaqaSaS7hURIsJhbglYgqlMOMn046H5v+f/mnf/hN707vpWrU/wAfvdy7fcyxd2NYtxduKaTSSlJ4Sr0qP09SZgqL/wAj2ATncjHcTYYfMMsPmJdGIe5tOyTRguwM8E7Vo+/j7dF6mEZ88dIVVVXqaiTYTHFLqL0VOtV3Hxfbf376H3n5B2/pljtb0PSbt1Ql3FycYuPVhGX2kpLo6qdUncTUay6aqhrx/kk7azTLPcd7qt26q+Nz8Gyxp+6IBjkjsgiFXyqCLgbiCKUlFrFFC24x26t99r43FjXQ+F//AKB/He8setWPyaEXL0+/ZjZk/wDguwcmk9inBrp2uMvOY3/IVkLztO07cr9tW+UZ69gwwz90cuzuoWaTdNf2hB26xpFko8k5F+3UBNZmRYiS6xhMUxSmBEHXhTUnb/3r3938Yh6BP0+Pc+tzs/4/W5dVu4nHoUnaUXKc5J0lbUkpSbaaT6DVvD4jNfp3+o7AGU2l+3ZNj2S4S5kmzZUFSjG5Yyi15KK1xKVJRRWEnVWTgSCYhVdQpTGAvUONHGR+b+ldr6x+B/n/AGNnvV9v1Gx3HbuaTr9F+MHOFcm3buStypVKXUk3Sp3r725H3Exbtnk+S9rouGm8tgmf7m3h5pm/fIP49qYFJVJo2jX8a6Wk0mIHVbkA5tU6emBTGOFtzTSwzP7Z/MO99f8ATfx7ufUPxu1aveqWYdahcjKSlFYzUVCUG5qNZRVX1NdNG2jmBgf01d9Pqgztr3P+opzKY/jAGbGCPkm4xUzJRKC2snAY9j5BQVxmIVKc3U4VImoOoKpCrKHMoGtRcnV5H85+if13+af2P61H8j/PZXbHp2H0zXRcnBOqtWrWDsweNZSSePUlOTcjsWwbM4tiyjI5sgyj45o3YsWbZMEm7Rm0RIg1bIJFACJIIIJlIQobgKABW2iP6usWbXbWYdvYioWLcVGMVgoxiqJJaJJJJbD1auwUNmPmNXn9/l40oKMCrttwqpCjPsguiVZMzgh1EAOAqppnBM5iX3gUwgNh+3lxrCcZOLUHSdMG8fHjMzh0qadxNwrilgZli3McZmmaMBMjYQ/pTCwlOFrgqG8+qHj1CIjxuPGvk+5V+N5rua/c3/DcfV9s7ErSfb0Vvd8d/EqOv4Xrn3m/Wo1+e3lQbhr87fqPt3UHEa/Pw9O16DMa/mN6Co1+fh53++nAaDWDb00A1+YXvyt4UA1+fh93LyoNwFfnw9tNwyGvt9nGmgGvu4+r0UG4a/Dl+HuoCde2wejnQaYka/Py4DwoBr87/pQU2ZDX4b+fj4frQDW504DeNfb9aDiNf8qYga/Pa9Mwhr8/fwGg5DXD37eXC9NKA+Kj5BESFWXRSFQTAmCihExUEhBOYCdZi9XQQoiNuABemgPom7TVIVVJQiqahQORRM5TkOUd4GKcoiUxRDgIXoKn61+dAWqzW/63yEb8cUw0PLhL52P30BdWv5fl93nQDX5+ugGv4X4+z0DQpOuPnz238aEI1w89vEKCo1+e3voTHQxjlyRVHKqxkzGDpKp1EufpAuokbqLqJiAGAgiJQMW4BfzGvnO9r/lzUf5Nr3RXz9x22v8AbXjVmI5BuZUwArvsqCximEQMIbxWMPUZP+sTh1WMX/tX6hsPIpO3LdTy8cEbMyzXaQiQ5CdJyqpFKPUBgEpjkvcqYgYigkE+6/SBhKG+1rdDaX1Pb+mnj2GO4sl8iVIxgsJi2ED9P93+4QDHEg3akuKYiW5AIIgO4BAR3Stz/S6T4cd78nt3MxVE8cvHAsx+3EhzicTABhECnGxusL2ECbhATp3Hq6hETCAiYQEQvlDqcayW5+N9NDL6dMiwpQqyTtJRJw0afLppLGXeIGWaotkFtVyOmSQYAmQiCRwKYVABIbHMVQCmIeNqMXN6V1rnT47vYRmkP1JLItm1ytk2ZWjSNVUjXjeFYSKDKEtItohAFo9vEScbi7yTYoMXDZ8qgzknigmdAZMCrdHbyVcH9dPHtq6V9ixprnWm45cyeQZ727kJdrj8OtluLzTt7IRv7TFSs1LxMytMG/lS5GTB3MzEs1nJd+q6RcrOXCEcVZui7W+bI4Sd+pDouJdckrnHBqnsWu/BUOZ9Ua0VY+PHMsbtjjM86ykMoyD55qVu/cOWoyrdxEycjkEug9kJKRXjUzQryKWk4Z29+dZmKTrcSCThNoWO6iueq/OP2Pt264NY1qvb8Ni24LVbj9fXLVcPHjif1Hf48pp2X6KPqDWaLuGjhnF9w1I121FVu4aLMeyEads7BwgoRVJcpiAoRTqTP1WEtrFEO+SUoWnLBOEFROmzL57kabbbnJLST37c/GrOqIL3C9+IB4/rXnnWNfmNUE64W4289goCNcR2+6lEgNfzH2/fQH5Oqcbl3l4gIeO/jfyEfLiHjv3Bi5bDKK1ZCaRlbjewbw6hHeJrCPSURA1zDbyG3GtZmfYWwgHEOkoDaw9IF3/CI3AbhvuYRG43HiPFkDBPfzv7hf09Y42kp9RGWzPIgdpYBgLZ0kWZyd00dRLB0++Wuq6QxuGez7Asi9BM6bQHiIH+JVMDG6Kuow1OTk7ma3cXtpP98u6WXZAhmOK5xPTsZHY9iBMjjsqi1ors/AZTisNJrRs4rjUPgDSbM/XTZoCK4FSUcHMmBSuNUscZZ6e7AyjV4LLYZZ7G59muLMoREuRx3c3EcidsXeIyDWQSa5gqLpksAT+Myk09CMfZnGHSXRVjzSQqZDAouWr109cIBIIVdUXu8e/9ivFeXu+X7rYdRsJzVLJ2SgKimlJMtJOQZ9K6K7dRRIqqKxkHSDVz8lINjFcNVDppKGQUAqySC5VES9EZdWGFTS49PAvfX5+us0Y6jX5+sedQFr426X/b3AokTOA5NlZVAUOZACJ/yuXKocnQip1nKS4lLYAOPExQ31OCGGpwr/wx/Ub9eneX6iP8pGEfWjN90ZTHOzPfbCIHsI07jdoYLta1iMVlJfvS3ct8WXh+3eCqZKwe4jjmMOTKnVfpCksg8TMAv1F3ci1lXHXabJKKimtnyLM+tlv859RPcw9urol2zclzHuFsagVeoDEAN5TORC1jfCNhKIh8c60vp2vxi+O72OpzzjLq6louPnTDZ4eBzey9gVHNceXJv6XbMpg+ESiGoUgGvYperqKUoCAjcRuPGs55Yfx8PxvJbblRvx+hso1PZYhQ3gJwuABcQHoOUBHyAAUuPKuJ5HQszqP/AI3lf+t+4w3Cw4wxta+68yU28TAW+83srdadcePMxao/Yddtfn5jyreQjX5+jl40A1+fH8reHhQDX57eA0HAa+/y91/zoKaFG1+Yh4UBOvzpmCNfxv7+V9++mQJ1+fo8NuFOQGvz+2+16VA19vP8qVGo1+dOIW4a/PblQD5j2U4Cg1+e7bhQEa/P7aAa/Pf6uNreum4cizpeAdPlzukn+qc1+lJyHSBCBvKmmomAlAoX3B0B5iN99ev2nqNqzBWpwpHbHm0/meR3fp129N3IzrLY/hT5FjvEHDBYW7kgEVAAN0gch7lNfpMAkMYLDzsNe3Zu278PuWnWPs5ni3bVyxP7dxUlxPJrVt6UaqjW29fqqUQqcEO/edMe6H1VysX3gnZiA7cYpmklhX/LkFXKkDjUI+XYLPmDIiDhQVZ121By4XKiut0LAJSqFSSTrS8ZY5H8Qfm/rVn8j/s27235XfvWPx/te8n2/wBKbdu1bk4uUY0brclHrlJRlKksFJRjEyN2e+sTD/p+wqUwaHwSOzmYichnGkNm8Mk2w9tleNHeHcRUlOuHEMpPryBDqGACLtgN8uVIgmAxREapJYZnv/if9selfgvo9z0btOyt973dq/cjb7i2lYV6y5VhO43bd1yxeEoV6VFNpo2h7JfWZiH1E5Ct2m7h9u4yJNkrV0WLavniGTY7PGaIC8XiJBpIxbQrd2KDc6qAmBRNUU+kOhToA+UWpOjP0n8O/tv0r8+79/i/r3YW7T7iL6Iykr1q70rqduUZwjSVE5Rqmm1TCVOqtdxsi+mP6OpBrKsO0oJ5nOMX0jjikRDHc6yiSgNnLZrk044cN4FNM6pPmE2gmUSRVKOiYDkKY+mJ1/kHff1z/U3cR7mz6XT1e9CU7ThbrVp0aV642raVV1KFXGLT6HVJ6jdgO3ed/VD3/W7/AGbxho7EWOStMmdPSoKIR0pI46LNvjuKQZlR1HzeNJHt03KvxlKg3MVQwKqFAcYpyddD8s/Bfx/1v+yfzh/nPrFt2/SodxG9KVGozna6Vas26/yUOmKnLFKMWpPqkq9qNYPxrdQ/r8awUoKsjWDb7qUBOtt6qUFSNalBV0GtSgPewZu5JQybUhDCQCicxlCEAhTDYBG49Yh6AGue/fs9tFSutqu5upvsdve7mVLSVVtoqF+wkMvFq6yj8RExbKt0S/2VAsPT1nUC5hAd4CBSiHnvGvC7zvodzDojDBZN5+VPmz3ez7G520uuU8dUsvf8kXSK/MNvtrzT0hr87VMAAX5+29MwRr8N/rH76oJ+Y29fvoCNf0eyqCdfjv8ATw4/hUoNCNfnxD28L00BOvz2v42oAK+/jx9G4aAjX9n5+mrzBOvz8NudSgRGvbx9Pu3crUBhbsg7VUjO4oqKnUEneruwQgqHMfoSJl78qaZOoR6SELuKAbgDhRlNbcUYPX+B9kprLcKyDuj22Q7dPGj3H4VP97cRuWqTALt8hlMXVdNjZEgaLTMgiYPmDNj9ZgTAxyiIhXctc9uZKA7QNsHgJvI8OV7rTbWRwZkd43l0pFHEciPIY+aOyeVhzxZ2DwhFxaKuEEkyhdIOgSAIGSey6zWPzruDEM4iewGNGMxh7E9t8jWWXdIpEGURkcyYiR/MQrZlLO1CtDpMHi5QVZ9a/Qc5S0BdvdzHO1KkbI5v3Ggm80pHQ6cSxBdV4s9Orru1Y2PxtkRwUiGRyMi/FNBZuQro6hiF6+khekC6u1SGSxnbfCWGYuF3GUNcbjEppR2sLh2DwrYnWk8cCYwuHjcggmqoJjCdQojc17iBqt8m0/2dDv70Kh3RDLf5MOT/ADK37iLP/ckYf+KisJun+M/xv/gfkwL8v0fFp33UBuhPxEVk8S8gppA7uLfgiR41I5dNBXTRcJOComXZLN3IJHURADlA4AoS5TXKYQFUGvHadrExHdbLGMFjLvtfFfw2JFLt89RSbHnV0Jh4VXO2reLcSOPJN0CLkYm+WdKuDGMAuSJf2gOBWu9WMymR5H21fJYPIdwMegj5gpkUHHy0PFHP8/GMG0SqY0zNwTdcU3pROBSqmOHQIgWgPBj2I4Ln8TiMjiEYfFY7DspzQs3i8uxWCUZTr3FJrD5SJkE/3ByRq8ZuX7dyIkVWTUTRL0DY/UAYmacEgAwzCsSxEHBHZsZxuFg1HiSRkE3i0ZHN2bh4VAyipkQdrIip0CYwl6rXGm/QF1a/Pz4/lQNFstFv+s58b8cYxEPZK5uNvfQFza/lf20GZOvz3eX3XoBr899ByHzHPcNKBjX4b/tqDIjX/Tb0VQWtPJpKFAwGAyiySxTF6Bsn0rrJgBgBQgmTOQ4muG+4WC28a+a75S/yrkqPBx/+Vca091WzstU+2vGpjJ8gUqinUUpiGVVsQ5R3lARARLcDEElj9NxG47wELVoUqpLNJJ+NjXsz0xMy0HzYAMdQwnAetYQExusDEKQpi9PT1CQAUMIAFrdO8RDxWp0+hU08b8A1XEsuQSG9rntYqql1BKRW2p1J6ipjHTIBeoRsPQkAhuHquG1/Sup0qsFnlt9pKVwVSyHaImU6dTp3HAeooGTKBiKAJgKBABQ1ymERAwbh33AQAybVU6VdPP8AbyfIRWDWRi/KUCIlU1ncSzScpsovVnEklmaq0pJIR6LBRmrIxqbtWXXc/Jt0fmCGXWXKTpOJgSPJy6koxcqvZ+wapmaK/Uy4KgQDOHDGPUItOSBk1MxkDlVjWGSxyj52ok5ZpIOwYszNxckMmLZgq4NHJHKgsdypu7WWarWPLRfPR+eWueORoa+0ShdyLg6h+tMqSioIOJJ9GlfiCbBaSkIiSf5GeOYgZm7XFZFuRmCyJw6THN2qTjhD+K2eN/6GqmGOZTk+jrblQEgAiodgY7IqpI9QsYMgd+kwcNHb9yzYITL8W4Rci5BNsZodNFuUEwObY5YN6P8AT3678dpGkdyf8eU+k4+i76mW2spqtf8AdNsAq6Crgf8AycjEiaaaxVHGoqmI6YfFvKG+1q9iV2c1BYK240o3SOG9UostcFsOSEIpyf8AqrXf48sd52E1+fo8OFaNDeTrj5/jy40Go19/H3+HhTeD8mcAUBMYbAUBMYfIAC4j6gpUby+ksLlFEElUl2LhwYhTqs03RdVv1FAwFOBilT6yAIAYeqwGGwXD4hwbbyMqKtWeL9ik25jqOGTgqSJ1CGUTTFVPrTOZM4ayXWQoFULa9+PDfwxaaMqonpAPh4CXda1umw+XhWBT4OVflyiBbC43CVM3Al7/ABqF3FMIAPwkG19wjute45vMHFL/ACZRj5LuN2qz5f8Adv2TFu3s9BOpBokqLc8/luf4dkMbGrPCEUQcyEi47bJnZR5elZ65QuS4IaSqrzTzz9/zJLKlCv8A02/StjXdr6cu3GSymQ5VhncSKcZe2b5BBowaYFcMp93AHaZDiUiTJ8aVQO0hwaSDBoqRJVudVqoqoW5qn2Y3KSlXqrXXbXd+qrWtcclccapUo/Hjy2ItfIuxXc3sC+kCQkVjsxiGRyYDLx2QIvpXtPPmlppKPSIsrebyXF8qkwFgZRCYZPWTtYARNOKN0EWyOMoSjj7/ANPZuLGcXlgtmvtZzpi+/PfH6/O/c/gnbvun3S+lv6Ovp2yl1gfcPuR277jNY/v13y7uxL28z23w7uwt+35HHdsoB8p1Ad0s4SfGWBwcr1J5FNIzJSiopv8Ak8fFOQo3hps/c7tYr30iMGjsc7et5mGkloGJjYdjHZz3cZz3cqXZs2oskJGTnMqzLIcqyeTcKIAdd29UcPnZzGOInETHLVcpgqE+2nV4ov6R7/y6IIIxfa3PZhdQwC4fR+OZOnBxxClA6ia7uSxhnKvX4/6E2TBy0UC/U8SNYKO864RdaD7SWLeHkXJ2AyqWyvt4vOTaLlrIuO43eRA7N5HLRLlk1ju7+cRsYyWj3Kq7lsZpGNUUwBQ5lBKUBMPUI1ui241NUkk6Ga9fwv4fZcPPhVJwP5+vq7Ai3fzukPESZW3SERAAPf8Ah2ILj0p6nWYClWHeABfyHx1uPUmt/wC/u9tDCbaknu8e855581D+TwLgwF6VHLIhQ3ipb5goXMPV8IWKIFsAXub12NHDpdcn5fui4qVd/j38TNTcgahTAUwgQSjYvD4RESlALCACI+gB4X4CHK8jdFNs6J/47ZF8h3kymMIuYI932xmXrhHSREFXkfleGosldYxBXILdGVcB0FMCZtW5gEQJbOw/qppQTSa3nZQV7+PPl6K6lgjWNfdx4/dTgCNffxtu4fZ7L0BOvz23/jQYka/hfb8bUrTHUFG17eI+6lQTr8/PbzoORAL8N/Oj3ga/hwDb8acwTr87fpupwGJGv4X28PGqBr7t4/nsNTgBr8w5cagGvt4W9tUEivz9NAPmLhx29vhSmIGvz57esKApspMJxrU65/iOPwIp3uKioh8N/IheIj5c7V09p20u4vK3H+Or2L57Dn7ruI9tadx4y0W1mKV3qrlZRdY4nVVOJzmNxERHw8igG4A8A3V9VC3G3FQgkopHyk5zuzc5usmfLW9FZpMwGtSjBqN3q+j7tL3hyFfNZZ3O4pkC6KX7zJY+7j0GsqRogCKbuTayTB6gDpFqkQorJil1EIHX1CFwxcKn5X+Yf1J+Lflvfy9Z7qV/te+kl9ydqUVGaiqdU4zjJdSSS6k1gsamm3entF9PX0+NcKy3CZ/HszyTF8raqZLgWazMDlzrNsaegVpINV4JFgMc0Wjy3MmqZmimXVOp1CqkiWsHFRPyH8x/E/wL8Ct9n6r6Pfsd56j23dRd7te4uWr8u4sy+mUXaUemLji03bilVyq5Rgi1PpZwNXup9SzrunimLnw7tli+TS2SIt0kehiwFwR2EHjLE5Si0M8E7lNVZFH+23QKYC9ICkAoqsqrI8v+svQp/lH9iT/JvS+2fafjfbdzO8kl9Ma9X27MX/HqxUpRjhCKdKLpr1zzntzgXctGHbZ5i8Zk7eBkwl4pCTIqoi3ffLqtjiqkmqmR42WRWEFG6wKN1BKQxyCYhBLsca5n9V+tfjnof5FCzb9b7a33Nuxc+5BTrRSo44pNdUWnjGVYvBtNxTV4s0Wce1bMGDVqxYs0U2zRmzQSbNWrdEoESQbN0CkRRRSIUAKUoAUACwBVoz17Nm129qNixCMLMElGMUoxSWSSSSSWSSR6dbmGw1KOpsGt66tARrVOlga1XpYJ1g3b/spRga1KMHrYySzBym5QH4iDvKN+lRMf6kz24lMHs48QrTfsQv23bnk/FTbYvzsXFdhmvfuMsM5JJ63TcomHoUKI2H+og8DFMHABKPt48K+UvWp2LjtzzXip9ZZuxv21ch/F+7cenXt47bvR41q3m0nX5/lz9lBvHzHhfdv8duFARr87j7/ypwyA1+fj+flQDXv4+j0U44AnXHz8drUwJgR8x439+8abijX57fhQAHHHf7/ttvoBr8wHb7qe4YDX28Rtx9VK1Y0GvzvtewUaBhM/b/NoV7lSWCZ1FQUDmU3JZC/ay2LOJqWgZeaBM0w7xqRQyKJbECQdgZcqbpuuVBYwmLcDCFBme5DCMvxOMxiH7bZfExULjmPMoAYPKsZUyBnIKM9b/nR3kZN4/JNZJfVEVCkOKBxAB6C0BbinZyYTawjyNzdo2zBh3Alu5EtPPcUB/GS07MQTnHXCKMA2yCLNHMUI1RMiRRdrHDRATGMYwjQF74phclFZLJZplWUfyrKX8O2x5Bw0hksdh4mCbPFpH5GOiSPpRfUdv1hVXWXdLqGEpSl6Cl6RAoWa9u8pybNYbLo3Noli2x1oQIPHp7DnWSxsXNCZyC+RtiN8vx5BSXVbLlRSUWRVO2IURRMQTmEQLubRWZi6w51JZu2WGEVnT5S0jcZJGsMwTkGrlvDJAi4mpVzBBBKKJqiJFnAuTpjfoKaxQRj3/aOX0f4j/LWn+1g5V/Lv44MCr/I+v+Rfyv8AjP8AI/3n5L+OfyD+9/8AsPmtD+xqf+toDMWQJTT+IdtsemUYCZUFsdnKuYtOabNzIu0F1k3EYo5ZfNIPG6Z0D9KyZylUExDAYAGnIGP4XCcoHIJbNMqyuNe5W5xZfEYM+PY8tEQuORzl2SQcOEmUhMzT6TfupJqgscyrkpABECFKAXEQPa4h+57SKxtvDdwIRzKRcX8jPO8nw1R61yR70IlCYBGIyKHdRDgpiHNpEWWSN12ENwCLgCr4FihcJhXLFSTVmpaXmZfJMhmlWxGQys9OOhdPnSTBFRZGPaFDoSQQIcwJIplATGNcwtQXrr89vzpv0A1+ewen0U03jkW21X/6vnDAPHG8UD2SeZbvHzoGXJr/AG0BPzHPbwpoCNfy3bcaMg1+YejfQpOv4XttxpnmBr8/w8/TegXvPq8TKrHIGAo3FJc4gHUbUH51cgmEtw4EIPDfuCwhXzPfyT72UcU8t2MVwpv+OnbZ/wBtUyMcSjIAMqqAHExB+IpUwBQwhYvxF+ISh0AFwC/SIbg3jfmjJwl0tr4bTPBlnPm2r1k6DHN0aYEAevTMUnXqCKYDppAcLmEAMJQAL7gNeKTTck1VeXu2bP1G4s2RbiBVzGTDoKQSCJkrEU6SnETdIlAnSofqN07+neUNxbVko9aX1NtZ4+2nuq9fcMmWY5YmAwCIqf3yCdVLoOcU+IH6kygFyJGNbquFwNuDiNbU029Hlnhu89yMXpxqY+yRo8KJRYJttU6zMqwK6gAZkd+h+7pETTN1KvjxSioNybimciXUAU+stSSjV7vdht45bPMqrhU5v/UuopGonVdLRSbQMgVIKLCHfHUBOckito5ANF8udB+tOSJFnbwyJkFwUFQ6aBRM4Lu7af1uMf4uKrxy8tMtnFGqawrvNDnZXDdmus4cSoIIR71pKLiku8n5IjBuCKElDBiLsPlHLzScLFQYsCPHDgxNJJBVMhDd8aZ1x/Xxu+Gp7DyOkH51iIqLOiHcKHVO/jU2rZq3aR0mVwzizNH72SAyski6UbuHTREDLpJKCBmZytNO4U3rRsnI6sfQCzl2X0h/VOqms4BueT7rKiJDm0wIr2kaD0lEqhg6SGHqAwB0m3b99dnc/c67coLB26V0WOOzHdzNdqnTJN/6q78uR3d1/b6fZ6N9b9ARr8+Hoqga9vHYPCgIFbqAwCIgAgIDbjvC32DTcgZ0KAO2bR4JCkO7ZsngAA3D/imyTgiRjfDvEFgLutv9AVpTcXRm3M/DWQfsyCVB0qUoLPS9JxKqX/8AkHe8CKgcoGES7xAKyiyNI+zuY12zj5uPZOlflTgmtogRwCxE/wC2qKlj3EBD+koFvfdYN1ZPIlDF5tR0CpCpHOiQDHdOhADFUMYTgo0TETCY5ygndQwh/q6S3MB+jXxKar/Wd/DS/Tp3BPlpsebGUjGbDEHM62aOzRGVvZFmhHTMCk4K5MjMxSQGdkUaFK6Ki3OBTAA2CN4VLQof0aonZfTf27E7dVoMh/K5oiKx9U4N5zNsjlmigLaDUq6S7R4Q6ZypJEOmYBImQolKGy224Js1uidEbMr6DpBZs6SSctnCKiDhsuQiqC7dYpk1UlkVCmIqkqmYSmKYBKYBsIVnoQ5vxP0axvZvJO+uRR+XhkfbTux3QHuDgvbMkY/wWf7KS2cqOpvvAzxbvDimQp5Y5xzNu4btzkTZmk3jzwzh89bt1xRdG6dM4ZyXjz5G6FzFJlsTEhjHZdeTh+7HcnJ8+7eEct3xO33fXtbjveSRatJd4gyausDyjtZAEzwYEJN0nHtpDLorInKLtQiBnIrqIlrU26V5+OZsVOetPb+hTIpf6Ts6nF1O2UrO4M8YpJODSMcxz5njiar5s4WItDzkU8j50yCZTLJuCKO0m7Vy2VQ0m6pFCmxag5VxTT2unu0w3e8sW0qYPDWlfebx/TV0tu1p0CvVn/R3J72gL5d5Lv1XZw7z56BnHzOQPpSdMmsa4pkeunTpJMSkVXVOUVDdcKdKocrVG88zPmvx339n51luIcKPqnSKbvt3UVV3lWyxsHxETPcP4FgZS2ASmExiiYQKFhDf4jWqVJOmqfjx4clVUdcGjn93Fal/e4cpgEQbrJnsNwuYqodAmMUqYCBhNcLWvbhasZPpg+nKq/UytqrVd5khqYusSxTDcqYgFwKAAIjYCh4G8/AQC1aK1y2GarWmp0C/x9HFPvdP8Q/8qciCwbgARy3AL7riAf01nZ/n5PmhPKu87Ha47bWrrNZOvv4/n996DgRr2338d/r50z4FGvz2ChOY1w8/D1UxGJRRX+7ltxoBr86BE6/P3/nTIIfMc/03e6g5kfMeICHtppuA1+d/QPt50BOvx3/ZuDwoBr89vzoK4EfMc/fTiVj5jwvVIPmOe2w1KBE/McfZt66Z5BEa9w3iA38L+4aZE3aFBnXDJsxVOZu2Out/aREyKZjAc4GuoA9IiAplARv52r0fT1fu30lKStrF4vLZ5s4O/dmzYcnGLuPBYLPb5ZmONUNudfTUdT5qrGqHDbhUFWUfIIeJymDl8bnWib+GnI55FSbNX+hdk+QO3XTvuMQ4pnESmCxiGsYBAQClDk7/ALHtvU+yvend9BT7O/blCcXrGSo1uzweaeKxND8J/wAeXbKDlDP8wyiezhqk5Mq0hyIJY1HnQ1BMm3lVGTp7JPTFTsBjIOGgHMAj0gA9IYK2tT8N9F//AJ+/G+x7n7/q/c3+9tKVY26KzBquCm4ylOWFKuMrdXosjKv069vs87OZX3M7dLsFHXaEsmXJe3eQKvmx1GikqZMXmOi1OuMioKKRi9ammVIFm5z3uuAVYqSqtD6f+vvx/wBd/EPVPUvx+5bc/wAS+597tLrlH6XOnVZ6a9bos3RR6oSdazNs9UAt57emssT9WqydUPzq4irI1Q28/wAagqxqh58fD8qtGxiNUPDblTEVY1Q86UYq9g1Q916mIqyQVAN4CA2G9hABC4eYDuGlGyputTKMaszcNEXKDZun1l+ME0UydKgDZQvwlAbAYBt5havk+6+/avStXJSdHq3lofVdt9i7ajdtxjGqxolg9UVPX22865TqJ1+f48vVQDX522t7N1ABcc9v0oN4+YHz3+kfsoBr7b/K3LdvowR8wHn9g0BOv9vrD9aYAfMc/Hnu3hTAZ5Ea/PbzoN5OvzDdz8/0ogxr8bjyttbyoMwC/P1+A+mg4jX3bh/XdUWYGvzq72OQ+Y57cfdTkNw+Y53+70b6AfMW8R4fcHrpuABfn9u199ANfn7PDx40GA1+dvKmpdBr89t1OZMCNcPP1gNN4zJ1/G/kPt8abhxGv79vCg4ZDX5+nw9VCDX5/pu+yhS3my3/AFXNDfjj2MB7JHLvb/VSuwFw/Mc/K3sAOXGqQa9QtR8xz+6goRr8d/P18aBjX8h+7z/Cg4jX4eHroC8kETrQMcqAGOIpvSCBgAUipkknYlAbGERDWN1CHSIjYR3WuPy3qCr3s4rKq44xit+xaHba/wBteNWWXKNP7iljWE4nALAJdPrKHSIKiYvRYDDbhYdwcuJyTjGqy9vj9TbTUs98xsVVS1gUG9hBMpyHKQqYmE5jW6gUA4msBgE3HzDbBqX0vLx4RGvaWi6ZEOc1kxETqluFhMImsQTCUhFRMUTEIBTWvcdwD1XpGTg6xyfjf5CmjLbdR39wgiUogmUwgU3xH6gTDVDUOmYTGN19JRIAB4jYBqr6oY1c65134eHvHDIxLn8RGSkRMRkxGNJmJlIZ+xl4iRjm0mxlop2go3kIt2wdJLtX7R2xEyKjc6YkVIPSYBE3VRSpGjzx4+/i8PbmSmqOZH1FfNqrJyDOLbM2c6wNKz7t2ZwwycZYpYFvCNXcUnHuE5Mp4ZNyi+dOpBJ1HHZNmxEHKSyyrLf2bj1NVeOXD5+W3gap1oaDO0BTA7dNMrvK4vFioJZHLY69QaK/up1UQKSYapNY47Z9MY6RZ/FsHIqtSFbqLIpkcMVFfUWMm3/GuVcPnU05YHgVK2M/lEYxL9sfi/jpKXdhCKJkk9VJux6hkxatGEw9WiIFJkoqks4WZoIolOBC/LgMcnk6rw/Ht2kZ2Y/x+lA30VfVZ19IqB/u+UhFQS6/h7PtiaSZiF6zqEUKFhEBMexQCwGNXfcuvqim5OKtquqxrR6tVplgvcaoRwb16uXjxidhfmN3HbzreUnXtt6RoMxr+N9vEKAgHHPnu3/pagNmIhuqeAx9YC9RFMdhlblG4gVONZEUuG4fhEwXt4D6baZp1qZpqh9E23W0KIEExBUeiqIFDpL1Sj4odRilCwiJdwiN7+PAAjqqNbClJeN0ynTLpAcpk3ACU5AUKIf8PcLj8RQ6QEbgNw32tVTcniUwv3MLkmmxZ4xKkghO9btTnRaFWKi2dMlnChylEprGFcpAEOkbkuQLdZjDp7h3ulKy0nWlXosfGXszWy19tSrP+KRpj367MZj3kbRGC9x3zedhYVVhP6MQ1/ZRlYqWkvkVmruX/ZFIozhRPFl0jJtFAfx5VwcKkKKzNQ3EpeqRkl0RlFPOtMKvY9m7DVM3tdk1XqknTLPTevjibPQyDOKh4qMj4xpBsI6NYsWMIwRbN2EOzZtUm7aKZN2RSM0GkegmCKREilSKQgAUALYK9iP8U2qYZbDgee4qYL+Y+3f+dXEnAt3KmKc1CuGKhDn61WihQTMUpwMk6RMaxj/CBRTAwGEbWKI7wHeGFyPVFp4mUG1JMwU7xD6dPqWj35ZGPwvuohjDhzBfuZoszl5isvZdGSSg5l9HILtjqnKUTqM1ToHVbEEbmSKIc9i9Y7jq+2+rpdG0n7nrhswN9+3dsdKuJxqq/qWxkP00YxCNDO8BhnKb4CJsQ/bp1nBvmseiZJWPBqnJ45k+MyTiJXapA3UfMDqplMZQFimA+rsla6f44mCu1wkXj9KiM1G9nk2WQsHkXLody++pXDR8uVy4FP8A3w7iCydg5IxiiOm8ix0nCKgNW2oiqU2ilfoLthXpVTVL+WBsbrh4jt6hCsiYnEz6pEzB3v7lq9NiqZUxNcLD1X7c9uviG1xDfu+Ly3btwaXSrptMZS+pQ1Sr7W927f5YGhvcpACvYtS3T1qN0w6b8CdYX6zfEcwcL2AtgDx6qqSpL/lfj3Gdtuq4orrRxYCmA10xApija1ureAjwMBTX334XDhXHFuL6Xkjbr1LM6Bf4/V795501wA3+1uREEA8y5ZgfC/Kw+ut9pf8AceynxRjJ1Vd52F1/Dy53Hx99dRrGvt9lABcB57b6D4k6/r2+2g3Ea/OgKNr8/f7uNANfwvQDX5++gGvz+79aAfMc9vRRga/PblvpgM0NfntsFAR8xz9H58KAa/P3+qhCdfntzoVD5jnSgAL+N7+d/C/kHCjA1+fCgKRIsE5JVM6zhUhEyiUqaYEsAiIiY1zdW824PQFdva97LtYuMIpybzfuOPuezj3Uk5ykklki35aNZR7TVIqudUyhEyAodPpuNzGHpKmU24pR8fGvT7Lvu47q90SUVBKron89u48zvOys9tZ64uTuN0VWvkWzrB669ajPJq6jW9/CrQVY1g22vSjJVjWDbypRlqxrB6PXSjFWNYNh4eulGKsaoe/3VKE6hrBVoy1GqHmH5UoydTI1g23Uoy1GsHnSjJVl2sYhi9ZoONVwU6hPjAp0hKByiJT2KKXUAdRRtceFeJ3HqPcdvflapFxTwweWa1Pc7f0+x3FiN3qmm1jlnroV6OaljiqJprnVTUMBwIp0h0mDcYwCW39ZQC/orze67p901KUUpLDDxoeh23bLtU4xk3F7Sp/Mc9vXXKdQ1+dARr+N/u3+oabhqNfn5UFUTr86bwNfn76aga/Og1Gvz9/r9lAY6fd38CjpGQinM2v89FOzsZBFtB5A+K1eETTVO3UXYxLhvqlTVIYQA42AwedAX61kUXjVs8bHMdu7QScoHMmokY6K6ZVUjGRVImsmJiGARKcpTF4CADuoD4Izce5fvotu+bKyUWkyXkWJFSmcskpIHAsFHKQD1pEdg1VFMR/q0zW4UCPfr89reigGvz99ANfn76ApszOsoGIlJyTVMjHQ0a+ln6pE1FjpMo5qq8dKFRSKZVUyaCJhApQExhCwBeiB6Wckg/ZtHzY4nbPWyDtucSimJkHCRVkjCUwAYomTOA2EAEKAoSecY0riw5snKpGxcI9WVGXBJzohHolOZVzomQB10kBMd2n1buFAXEk8IskmqkcDJKpkUTOF/jTUKByGC4AIXKa+/fQH71+dAUWeyiLxlkjIS650Gq8jFxSRyIquBF7MP0I1gmJESnOBVXbkhRMIWKA3GwBV1B6pedjoGLfzUs6KyjItqq9fuzkUORu1QIKiqpiIkUVMUhAEbFKI8qmA5lrwXdHB8kkE4iJyFsrKLoncNo523fRT52gmHUoqyayzVks9TTKAiYUin6QARHgNAXdISzWKj30o/V0GMczcv3q/QorotGaJ3DlXSRIosppJJmHpIUxhtYAEd1QH1bv0naCDpA+og5RTXRPYxetFYgKJn6DlKcvUQwDYQAQ8QCqN59vmOe3376Aa/wCfp8/OmoHzHPb3UHAoLdf/AKmlzXDfA44HskMpH76Ar2uPnt7KDcNfxv76Aa/PbeI+NARr87/j+FATr86AjX8hoDLUIJD41FHHpMIJPiXMUekonk5QBuImG5QTN/SHSG8REBvcflvUE33001hhyXjXYdtn/bRbcm2G50yAA3TFLpAAsBAMU5TJ23D1H6QD+vw6OImHi+lSbknReP1VfM200qWu7aEuBhIFv6biYlihpgZTr6DmTJY3UPV8I9IAN+mwBYU6G1m2tfFUw61oWi9agmY5NIwdJilDpAtw6ylEqQicbJiRW9vi/o+Eu8RvP9S6n9GPu8YL4lwa3ltuEkhOpZUAOQBt0gJiqCYSGAP6SHMJ0xsBRMX4RELAIbsk8d3jyMcTF+XNLoORETiIJj1dWsUeo51gN8RwuIjYPiMUeoprhx35TlCMOnFPFrf7PPXRoqVcDlT9SEQ9ctJ1GakReNHUyLqP/Zyy2JvoqISFquzjHEjFT4yUm8I6brKqu01WaTtI5UBRImCgH6+1eFFVPnllhljlXCu855rA0TkE3sulkcUgSZgXDEx4pDIfkIpcpl5CHjH6Mzj6LokpHv2cY5liJHM8bFSB80VTFJRMpVD98WqKWafz9pi88SkLqgEgMeRnIEKVgpJi7Mh/yZKy6TYY0z0yhjllzhZQEhADHS3iBRCwI5VMaYbzrh9BFw+i/wCrFM2ksCiXeG6djJlASdplUEyAYg9SYEuFidQWC3EoXDtU3CSnFV+jGqqlnmng/ga0lKLUsFX5bMUdfhX37h3XH02rrpgY5DX58fX9lAR8xzoBr8+O3soDc3D1EHWIY5pnIsn+xRzZQSGAQBRuzSauUhMQdx0V0jEMAbwMUQ8KmaBWWCfQifqKHV85KCA23gVWScqbhEL2MFh8hoispEw1TA7cCJJ2BF2dT4Eyh06zIpLgUpQMBDKAAcR941hNUWBlF7TVzvfE5G7I1DHsjHGnR5Riqq5K2+aXM2aM0nBgRTMu30kzqlSKcwdfUU4BbpEwDy37fcXIJdu1GdVVvZs1z4G+1O1CTd1NxpptNeVZ/vawmzGlIfEsxx9QyZAkIp6rBZOVICJEUcPI1RmEIYWxSm6SIH61y9P9J79WqNz1KzJRuW4XIayi6Ux2PN0xwW4zce0uJuM3CS0arXz09rMsJuTmImZQoEUMQonTA/WBDiACcgHACdfSa4ANgvxtXpKtMTieDP3r893vqggVgMUxTgUxTAJTFMACUxRCwlMUdwgIUBo19JP0093OwPc/6tsy7id62PczFO+/d82e9rsNY4obHz9r8b+ZyFwaJlJQZFynkMs7QmmrRRVNu3LpRSapjKqLnBPXbtW7TbtxjGrq6avazbcuyuKKk26KmOnDU3m1+f3+HurYai2scdHAs0kocOlPJZgiBegiYlIqoV6IWAAE4mUXOa43MN71EymgOKf5WfpazL66st/x+Q49yTd3MQfDjDvOVMNTU7MSHc4mETfcpx2iYZmymHks2z5tgeJTsib5+LZRBwg3bZN+d98u1cWsaqNV1tVpq0s3wVVXii9LcepfxrT21+Rhz6pW4h3gzk4AUxnE8zWKHWYbh/AO36IDbpBMhyiA7hvcoAPVcLBqo23Tb8EapuKkttN2VXTfo93nU0Q7jpHO4iygUxQKchj3AfhKDgDWN8Ihcbbrha/Kscnj4zRnHLDx4/U9JY4TnAG5R6jCS4B1fEcROJhEPiAOoTe/juCuZxbW42qariddfob7MOMJxpx3PnVSHmc3jCNIVsUiXVG4yD4XHWZcDKiqacUZtnAdJiEBJNO5b11WrfSqvNmEnU331+d9vPfW4xHzH3ee16AfMc/RQZoa/P3/AHUaA1/G/v3UBRdfdxEdvvCg1HzHPbxoUfMc9rcqEAr8x286AjX23cbUINf3bcqIpOvz3enf7aAfMekfQNAPmOe33UA1/f8AZRe4oFfn6vZQg19vvoGNcKYga/P7vTz8KYAoUu3cyJ25EhIVJMDGMdQ4gAnOIBYClAxhEpS+Vt9el2Hc2e1jKU6ubwSWzxyPN7/tb3dSjC3RW1XN688iju4ojNms4UXFRQnR0lKQCkudQhLCIiYxgADcq77HqMu47iNqMaRdcW6vBN+Mzgv+mrt+2lelKs1TTDFpeMi39YK9am88rAjWClATqhypQDWClN40GqFKAawbDSm8DWDwpRgawbbcaUYGsFKAuUsKVZugui56RVRTUEihbgAnIUwh1lsIAAj/ANka8Z+qu3dlbuRqoyaqnsex/M9iPpSu2o3Lc6OUU6NbVtXyKzEJuWSKjdfoEAV60jEP1FEDgAGALgUwWMW+8A415/fX7PcXFctVr00dVTI9DsLF7t7bt3aUrVUdfH6lX1+forhO7cQK/PdTiMsSfmOe/wAthoXUfMc/LbnQg1+f20wFR8xz8aBj5jyGgxGvz2t5UFSPmPdtu5UBrvhjPN3c73YVxrK4KCY/7oyxVWkpiDifXVdhjmLCdyR4llUGVJI6JkyglpGEpiCbrHqsUCldxstybFMxSxWMy8qLTuM2jiuX70zldbtqsZ+0h3M6yuRwkzjMhKuKLNJdQiSMiXqKYCiawHn+QPjWcd6ciZTGUvHeHYNiM4yZuJ5+ujMOWcDmC6LSZTERPJt9RgXoIcfhMocQ3moD14QTuUrIYRkCaGWrM5IG7rLpCdzyImoCYiJOKWV+di8dbuToQyyL5VBVsVkkiAIgJDge96AtmMcZcHZ/E8yX7iZm4nskf4PGKKmkGpWsc0kcwjGix2bYWRwXenbdRVFnRnAqgoYpg0xAgAXnKzBe3uS5hFP8nzR3izntiOQuDrzDqcyCPmlp1XHyL4y7kjqmj3TsHhATRAStiOCkMBSFAaAsCcf5VDp5nBPm+WRkHP8AZLuVI/teX5qOavVH8XGtSJP01TuH5oZYqMgdNRBNydA/VfoKYoDQG1+LL2xjG9/CBiPZ+3tvT40BqKwY5yP0zKOCZbAkx7/b+RUGFNhzk8iLEEnWo0/fP5WVHXOADZb5Oxb/ANA23gX1mUm8lnEy2xcncJ1K4lisWEi6h84HEcWgXjmH/d2Sgsk3JTT0iZmqVZUijdwl0dBBEvUNmI4n0x9/k2e5NiqL7M8jhmLzshgGXSjTHXDaPCQnZSRlxdr9ajZz8kmsJC6gIFTOoUhCCfoASmoLXkE3uS9ucT7izE/kbmYn85wx8tEjMvCY0wbLZ7HoNolDHSnCMT/akEyl1tP5kyxBMc43EtQGdu8q3V2o7hB54lNB7WSvCgLb7smQN28g1kQTHJG01g58NMW3zxciNMxRESR4AOqc6rMVgWKUBu21BHcAiDmCzTr5K6x/vblymb5WmriMl3WaY7DtX6TaKZlZY65+TVWArcz5yoxVcFUbF1ipNlEimIQDdQmA9cl3Bm8DVkXcg/dyieXdtoabwxu9cmWKGbxrdlCPINkRUpwvMuZZg6EtxufWN0jfeBQSfz1/NzWHqrZzPnwWFxKN+fx/PWmLuFZqVgUpeQyGSO5ct3k2Zw/cnSbprCqzIm2EopmN1CAGx2GL5GGKQBcvKmXJk4xslN6SiCpDyCRNNZYDtRFuIuBL1j0fAAmEA3UBc+vz8aAoiC3/AFFKjfjCwAex/kv41cwVsFuf2cfwqNgjXv4+j7eNMg0Tr8/x+ygGvw3/AK0A1/Id16Aj5jn5jtv40HIz/ihQUxGDU+ETaEiUoGNcLjNS4byWuIDa177gv518p6j/AOeuZ0VMf+lUXjjodtr/AGkynS7UCmVHoCxgMe3QW9lOoQsUpFblIcbGv1XNb4bdNcXU19SzXw4fubS0FiHKUgiUTlKTpv1EA9g6g6UlCEuJ+oeo28QMPEwD0hUcVKVVh8/fT9TJOi2llyxgKUivQBzhYxTG6OkDpmIJCCmYpg6B6hABuUA3AIhcKyrRUrTHxvMUWqZIoiIdQ9RSgoXdf/QYvV/T/wCEfUC9wAd4Bu3jRVapSqGCMQ9xm04XHZQuMrwbPITMjfsjvII5/IwCbwVSgkeQYxUvBybpr0iPUVF0gf4QMBrWAc5UetZNUpquGzLTeFXTI5ofUvBMHrlrKGRWO4iwf/IHK9eIFAkg3Ki5K7j2jhOOlboEsUXSawoGudEpD7x6O2nNPpbblmlot2mHiq01ypTBI0AOcmTwEqtjknIwSiy+SY+zm3ePO457DzcHKPMcePm0FmMO2JJIMpZgqo0OsksxkmyYLpHWbqkUP6VaZY/Hz2cjTg8Dzyz2LaP4mLeuDIPMlXkEYRmZs7dpqqRzFxMOU1HKLU7RgLeNIYSncKoGXCxEzGVsFRVzWS+fwDWGJ2B/x0R7R99Mv1BxL1IVWchLdx2bxMTmSFdo87eHbLNxOQySqR1kDCQOkwHTuHTv6RrquSXVGLS6GlrlVPDDz3cKmuCwe2r+Hj9jpn8xz9vOvRNdBr8/Z+tANfdx28aAa+1+fOmAeJf+I9zZ3EUPkESt5KLFyDj5N8K3W2KY4ndIxzlNQotCujGE1jkWTIceopN5gMBmCE714y5OISraQiVXSx1VFOgsgwaFTbkTTAV24keqitoB/S1+E57D8ICegLvPn2FPo57INMljUlGrZ6miZwf5V4RQqKbjqbRsgiRw7MB00xJ0oKAY5ekoCNy1NC5Z5GqOSZU/yeRPIPz77ARBEvSBEEigUpQDoImQ6pgIHWfpATCHACgUoUMt/wCY+3z+2hBr8/P7KEGvw92+hR8xzv7Pt5UBVI+MlpUS/IMXLkp1DJAqRMQblUKTUMQ7k/SgmYEzANjGDcIeYULRl9RPbHIZFQCKim3JpkMcyRTOTJKHEoFSOICk36uNxBUQDp8hAaCm007m+5GQ4h3mzTtQGAZVJ/s+WIJnyGJx6Tk49RnItYJ01cvXR04uBgEnsG9F6VZaQWOHSZNNFycohXmvvbq7qXb/AGpdMWvqWOeWGFNaurpR4M749nH/ABl3DuJNp4OiyqsMW3ivfoWWn9FH0nJfVUf63k+xmEk+qlTFD4abvECD/wDff2k8Z+wKPyxnz/8AGSZgpi94U2QAxCeNBGGMF5+3iLYfRp9VdfPlkefwoasfVQ3AO6U6ob4iO12Kpi9Vzm6cZxNKyaYk39JW/C/xCPmBQDHNtb/LLxia5L6q0zSxri8Xglu99dxoT3DSEFmhhMPUAEKJAEpibzHER3XEwlAtijbcA38QEcGqPSvvM7b00Nnvp/7Tqdwc7jWBSl/Zo9wjJ5A4Oo11Eo1sbr00Wy6LgHBHLhIiFhTOQDKl1BtSEaZkwkztG3K3Zt27Rqkk3atUEm7ZugQqaKDdEhUkUUkyABU0kkygUpQCwAFq3Iy1Ptr+N/Kg4jX5+33UA1+fp5+jjuoBr/hxoCNfhv28PtoMCj6/PbytypyGo1wDxpyA1/LdQEa/Pb8RoB8xzpoNBrh5+G3CgHzHp9u/eNTmBr7eX21eQyxGvz3eO3ooCfmOf28PVQaka4bDTEciNfnw2vvqjefrX4b/AB231AfnX5791vfzoCdbnSoKdKarloZBEOo6h0/ECgBQOBhEREQ3BbnXX2N23Z7hXbjpFJ8qHJ31q5e7d27eMm1zPA0h0E+k7o+ufxIURKkX0juOe3qDlXXf9VuT+mwumO15/JeMTksel24qt/6pbMl+vu4FpnP0nMUeJTCX1gIh91e/GTlFNZNHgyrGTi9D9qgogJQVIKYmIBygbcPQYRABEOIXEB476xhdjdTdtppOj4mc7dy3RXItNquOw+WqHnWzE11Y1Q2286mIriNTn5ePj7auIqfUgKqEUUTIY5EgKKgl39IGvYRDjbcO/wAK1yuQhKMJtKUst9DONuc4ynGLcY57j6shKq7bJmDqIZYgGKPAxLgJy8Q3CUKw7mcrfbzmsJKLpx095n20Fdvwg1VOSrw1K+8hUzXO0P0D/wCxVERJ6CH3mKHIb+mvI7f1aa+nuFVbVn5rXypwPXv+lRf1du6PY/n868StslDpNG6atynTTKQxbgNhL8PELgIbvCvM7mUZ9xOUMYt1PR7aE4WIQmqSUUn5Hq1+e2wVpN5PzHP9fZ4WqAa/Pftvqgj5jmPtoB8x5D+tqr3jMa/Pz94X+0aCvsGvtcOXvqVA+YvzDl7PRQDX299ANfnu8fRQYmPHfbLC3chIyh2s23eS708hImjcyzOIQdP1E0UFHRmcVkDNkVYySBCiJUy/CUA8KDmVEMFxD5WfZqxHzaOUNWjKeNIP5OTcSLRi0KyZIKPH7xy8STaIF/tgmoToUEVAsoImEMSDYRjX7sxmyJSSb9lHtIlQyc9NgjKx7AqpWDfIG4yAo5AVmLg4lM8BY5hMImE1BwPHEducSgn7R9GoSyKcesq4i4o+SZC4gIpZZNRNVSNgXEmrEteoqxukCo9KfV8AF3WAqZMOxZLHovFCRnTAQy8a5jGAvZEfll4h8nIx5/mjO/nVvl3qJT2UUOBrWMBi3CgPrL4pjM86fO5eLSfLyMCpjLwyq7sCLQijsHxmmim4IimYruyhViFKuQwAJThYKaAoCHbDCUvmTuGUnJunsHK407kJjI8jlZBxBTKSaD+MM7eyqypG5kUilT6BKKG8UxIYxhMBf7UqDJs2ZtiaTZogk2bp9Rz6aCCZUkidZzHUN0EIAXMIiPjegLeTxLGkcTHB047pxYY1WIGL+dfjePWKcqrf50XQyIdQKD8er1hfcahMCkynbrD5h84fvGT8DvmLaOlWrOcm46Om2jJEzdknOR7CQbNJYWiBhIQy5TmAoAAiIAAA5FK1E4xjsE5aPIqP+VcsMbi8QaKfNvltLHYVRZWMj+hw5WTP8so4OOsYBXPf4zmsFgRbR+1eCKvBdKRj05CzBJ9tHfv+QJwsfMkehInkY2ESlCRbJwu9J1qCmkAH3lEOkxgEC95mOjsgipCEl2/zcXKtFmL9tqroa7VwQU1ktZsqi4T6yDbqIYpg8BoC14bt7hsE/bSrKLXXkmZDpsXszMzuROI8ipQTUCOUn5OTGPE6fwiKPQIlEQvYRAQKsGMY8EZkcMEfaOy1eXc5C2+bff8AMF55v8rKnFX5r5hqLtD4bIHTBPiQCjvqg/MjiuNSxMcJIxaLouJPmcjj2oq5A0c8YI6DVUpyrlM4BJO3wLCoQxilMYBMUBADwz2D45kMiSYdpyjKWK2BgrJwE9NY6+dx5TGOVg/cQj9gd61KdQRKVXqElx6RC43iBc8a1ZxDBnFx6fy7Jg3TatURVWWFNBIoFIUyy51V1TWDeY5jHMO8REd9Ae3X57eNBzKQiv8A8+khv/7ohC8fEr3IPxpoNCr/ADHHx29tAPmB28N3p50Gm8fMc7bflQD5jn+ocaY1A16Aa/Pb76ENncJEp8EgDCQwiYH4ActhAD/vMxYvgJBEb8OrrDcNhKA18p6m1/mTWKVFXj0rxV4rgd1lP7a2n4ljXKBAOFi7h4Aa5QIYSGMc5THN0HuABfjvC/SNcSyrWiNpZT1UCFMcpiG6QDpEogfqEDqAUliAYVSdRbHAB3/6Q6rALBZ1VcvZ5aY5eRaPIsGVT6TB1/GYRAu8QUL/AFlEDiBTGIoAgpcd4hbgIDvrKPTSryXjx7hjkW+5scQAhALbUIJz9PX/AGwEeo4kTsYomIIdX9VgGwbukcVFRpXDdn4x8bDx+ZjPMRAjI9zAAnJ1AmAdJjgIkKJAFUCEOHSICPiJiXONhEKzcerLL2/Om4lTmb3qx5+SRy2RdZJKTDOal2L2NhH7eERjMTbtoOJhHkTCLx8THzTlnKyMapKrqSTp8om9kFipKItipIpbu2aUo9cKSSx3vPyfjMwms3U03ydnkDKIlXGMxEdNzzSPXViISWnHGMsZSTSRAzdi/nUISfUiEFlU+kyxWLoSiO8ggO7tVxdS6sIvk8a5qu/2KmunpXkeOQjQEFkyAoIAI3MUxwA5QWOBBEvUJQTBVQRsIiCZgtbjW2MlSkKUfjl8yLOkjpX/AI9VFGfZTvq1IUiaSmSZt1J3PqkRXxh0kmA8S7ygI6nUYQMAAHwjv29cY3YVenl8aVrTLblmiTcGdIBcB57eXvr2DnGvz2t9o0GBQcmkZBjCvn8W3fPHjFBV6RnGpsF3z4jRFRwqzaJSjtgxO6cppiRIFF0iiqJQ6vAeP1Cdy32k7lqXTNY1zoqqujwpWuB0drCE78YXFWLwpltps13msiXcrucXKMgdKMO4bHGn8TAftDeUxeLm1IiaYuZNGaZx+L4vgbVy1Zy7JdBY8k8zGYu5RIVGOaJEUO7+WXq/dqte4juwjp/0a6Or4I91+ndvgvt+9/8A1abKLizqtDYOedhIWcQgY5unNxEZLg0XaNW6jMJNkg++UVTWKCxFmuvpnAxQEDFGvr7blOCnl1JP2nz80oycXo2j1uO1IOQKJoFimqWxRO2fnbkOUAG3UgksVLUEw3EwAFw3WrZR0oYPpZT1uzh1UzEJHkQMNrKoyRhULYwCNgWVWSG4BbeUdw7rDvpSQ+ktLJO1amPsEZNy6Wasxl8diXBxM1fHJ/I8kh8dTdFIRViAJR4youFQuJjppiUvxCACx1oSieWZri4zPGodgzHNMrw3tnkCikRBSUJ3Py2Gwj9vz2Q7a9t+5T3ECOJNwLl8rFMO58e2UOm2+Z1iKiLYhdLVtaKrHTV0XzNTP8dX1xYd/kh7fdxc57X4LmmCue1mUxOJZfjed/spXjeRmYJOcaLs5CHkn8eq0ApF0D65mygKtzWIYogYbXGm4vThmqG487l/bbFSLqZH3X7esgYmtJt4+cHIZCPAhwKsDljj7eROiqmNwAFBTAThbqAax6o7fHkXoeRjo/1KfThI49FrwPeHBCyCXciSj30tLy4IHYQcN28mszxucc4w0kXEpJYu/wA/gGEO9TTZujuUpFduZO5iHJFci0866eOPKmpl0dLxxXj4YmS8Z/yC/TnjWFNGubZ60mcmh5jLcfO9a4/NZE9yWHx3Lp6CxHLXLqDiX0d8znmJMI+ZETOABIX4kW01CnKV923Xz92nHAdDcqLBM8GK/wCSLDu6WfQfbrthis+5fTEg5ZfNzqTSCvFs2a75WXgGCK8upNEBs1UAyKi8cslYBMUtj9GP3ayUYqrbK7aiqyLinsklZjP+57SWcN3hsZzYMej3iLdu3UdRaOKYtKslHYtrkcOALLCXUH4hTAt+FZquNdWa5Vw4Ghf0s/Un9XndzK3+M/Un/j8zH6R2LTEn0+0zN99Q3Y3vjikpOtJeCj0sObG7aS4ZE2k3zGVcPUnDiORa6MeqUxyqGSKbOTt9VIOTdNY0+LDVMU8PG8sj6qkunPzrdI2ctEFzDvLcUIyJSECmINwMAIltcQEOO+2/W061rg38F4+OzGfTSqp1U5N68Tn93AJ8w6YIDYetZsTrIULFEyigAYExKQpQALCIXC9twXvWMqea8fAwhnx8fHidmvpkwkML7XxD50Voaay9JPInqzF0q7bBGvutfHW5DnAEirJQiyJ3IJdSQPFVQIdRMCHHZFYGVKYamxGuPn7bD6eG6qUa/P8AHYKbwNfnQMn5jnQEa/kO3mFANffx3/jz9NNByKLr+X3VQTr+rx5emoBr87bcaAa/PnbYaAa/P9L+yg5jX286Aa/PdtYKDAa9917eP20GNRr8/wAAoFmNcdvEPVQDXv4+Hj9lQAF+YejxHjV5Co1/upxyA1/05+NBhkNfn+dAxr8+fpoBr79w7bxpoKlMQZoIrquT2UUOqocgCHwJAY4mAAAb3MADx8PCu673125ajYjhBRSe10XLccNrsbVu7K9LGbk2tiq+e/2HknCiqmisQBMYh9MQKFzCCn9G4L3+MLf/AKq6fSbyhOVqTpFqvsz93I5/VbLnCNyKrJOnty9/M+jKPSTbqAuUDKrkEphDfpFGwgUo8OopgARHzCsO69RnO8nadLcHhv47jPtvT4RstXlW5JY7uG9FDRaqHefKHuAEMIqm8ASAbiYP/SAQtzGvWu95CPa/5MXmsFv2eWvA8m32k5d1/jyzTxe7b56FYk2JTk1mxLHTKAGSKH9ZChYBKH/tCh7Q58fM7D1Bwl9q+6xbzeje3d44el33YqUfu2I0klilqls3o9EOGkzA4h8S5hUG/HoD4SB5W6QEfXWn1K79zuelZQVPPN/I3em2vt9upPObr5ZL5n0BmiR4m7Ssn0iYTpB/SYTEMUDlDd0iBh4cKw/z7su2l29zFOlHrnWj2mf+Daj3Me4t4UrVaZabM+BUgX57e+uHmd2A17eO3hTMU2DX47/f7vRTDMcyPmOfv28qA/WuAePv8acCEa/PdQoFfzH20A1w8wCgyzGvz3en9fGnMajX5+NtuPhTHUV2DX/Xdv8AfQDX5+j08vCgGv5jy9H2U4F4AV9rh7aE3DX38ePPa9AsM8xrh5357W30zGPmNfgFw9P3W9I0HMa/h40A1/C+3nQVGv439XKg3DX5+W/bdQVqxr8/Ebc70A1+fHw++gJ1+fl6PGgI1/Hh5eyg5jX5+v1U3ga232UA17+P5em3OlBpQfMc/f4/jSgGvz9/EfvEaDBD5jn7/wA/CnIaFLSW/wCdyA+cXEe53OfjTQFU1+e3HypuA1+e7bf66Aa/P86Bj5jnv8ft376ZgAvz28OFBwGv/wB73+NuPhTEMy3ifcxlEQiMNJsVx+QMsRg5ZETVFVBy5cPVSuyruUASUSdLmsZO/WmIAIFEoifxu99NuX733LTVHmno6JYYapLw6Lot3Yxj0yrUyjGx7rMY5eXxdRtJM0HizASgZZk4I5TSTdnICEii1SMn/wAYAlNqDYTiG8AsHBH0vupRUnGktjar7qqlN+j3G371vKuBbkrjuUNdTWxifKAdIqFaImljKJh1kNpjDqSBTAJT36eoTGKNhKAhYNdz0/u4rGH1JYUVeVfG0yV2283h7DEGRu/lFkUZAVGJyHHqbvkhYLCsJ1Assm90hExEkxG3QBwvvA3xDXNKDhVTTi6YVqthmscViWg9f9ZSGRMIgcUhOcoicqYGPxKZU6fFZT4RG1zgJRG97ZW4utWk3XFVz+ZGzE3czKwgMSyjJf2qeyT+PY3kWRfx3EYxWfy2fTgIx1MBAYrCpKojN5ZLfIg3jGJFEgdvViJAYonvVUJfxao20q4UT31091MS1SxNLO8UO1ybF3rJ63eIxc1ELs5Bmdd9DyLdjLMXTZy3K7ZKt5SNeAmqchzJKlct1bCmchi9VZWl03k2/qWK0q6rwstFTQwliqM06nE8J7PYAV7kM21w7AO3mMRcepO5TNOVkIqEiUWMJHrzE/MrOX8geyaaZnTpy5cu3CoGOodQ/Ub0LcnJ/wDbxlJ+OGzWmHE1v/xZI8OZ4IfIUY9kaayvHBisggp8i+IzScM+kf2OWbvj47LqlaOhksYm024NZVkUOl20OJNQhTgcKmqY4Y44UyVfLz00Gu3B+/x7ToL9CjN8z7Y94U0TCZq7yjIgOiBDgAipEvDLiUpjHVKmZMwXAwGLu6gMAiAUvdb7i3N/y8U+PjEkKdDSyOgGv+fGvfOWpGvx3+Hn47woCBWKbcIAIBYbCAD/AEjcPPgIeqgy4n6RjE5xdCL1DNyuliGPoOTMFlkmwi9WapviHRFqq7SbimU4mApTmATDa9aL1m3ctuMkmnu3m23OUZqSbwMoSv8Av5ikc9eRferKJHG/mxCElGXYjG+5w4YyXK0Qa47mOA4aniHcaUCIVE4JvI4VzC3Ld2JDJiqtUpxok/oWxe6mYfS3VrF7zX/J8x/yGayrTt59W/8Aj6yFcRWK1b5j2g7q9v5gxidJtKRiWfdXP3EW7TKP9xExDqJDuMAiFVSfVSqHSqVozCsnlH+dBuoKTD//ABtkTcTCT9zxxksmkiA9IFfJI5F3FxmQWRSA/X0GZqmMAW0jG+Eb1TWmm1Dphky8cc7A/wCTbuFGEa/UL9csPAxztzBzBMc7HfTv2+XlWrvH5pjkbD5fOMyZY4m1KjMRLU6ofIvU1RQ0hMKR1AUfW/p/0vxu4hdKdVn4+Bnjt/8ATT247JkjcgyaayDuPmzWR+eT7s/U73Qx57nasuOOYxiDiRg5pGOl3ONzK+J4dEsl3cW1bvnLSPQBy4dHSKYyiWeW9+PnvFW3h7kfz3/4asNwJx9Wv+S76d5Dt32knWuM9yFn0WxybtBNd5sWdGwPvD3ZwWWlsdKk+imEzFzjOUiHCcg4T6XCB0zJFT+YMmGcqSacqP6aYLZ7NPMqwVMU/Z42eMf6NW/aSUxBn8pgEd9P2AoAmGnHRX0M5ZFx5TmDp6xQge8MCkcpTAI3FIREAtcA4IrGqX0/8vj2iq1r/wDEWi9xvuhEfFIZr9JGpcnU8nPpdn8GFdwoJQV00si7o5Er/cVsIFKse42C4jca1uu6nAtHTWvE8kTlc7ETSaUv3f8AonhnoAVQD4/hUSfIxT1CmEyUWrlbVybePgoFvO9SOdW40oOFTKLbKIJsmzlXGc4bkMu0WdKQ0hp4Z22wqCfOmbhotMtoddy/kJiaK1cKF6lvm0+g5iACZTn6t0W5KsvqVa0yXzye0jXGuW18DX/BMWcdv8QxPFXOXKdzJJtjrFzP9yiNmjJLLZ051W6shpi4M5cpqxrdsZs4AzhFRnpdCxylLWEFRtZpt4+Zhcacql3KvSI269Yw8f7Tddblb+ymfhWZhT2Gonf7t7lPcTKYMmMRDlyQsS7+afvCgxjCGKJCptzunJCHQXKDf+kSD1CqQSdXSoBMXnr4z+Akqrx5fEsWO+iOGkpdB/n+SKTkOi3WbqY1BKy+LGcFVBVEqimUQ8k2n2ChG6onTGPOzcIuQKoVwYCiU0lFvLBPzEEotN4tePgbrYdjWP4DiOLYLiUcSFxXC8chMSxmIScO3acVj2OxjWHhY1N0/XcvnKbGOZpJAosooqcC3OYxhERyjFQSjHJLDyLKTk3KWbLk1x8N3r241cCa4jX5+NBgNfnt7aDQnXvuvtvtxpkCNfnbdu93ppiB8wPC/v3/AIU3jkUfX9nj4ff40A1/z/OnEm4jXHz9V/b7BoZaE6991/V+VCYVGvu4+j2UCwGvz9vPl6AoBr7rX2376Aa/ht7POgAr89udF7gRr24Dfy240BOuPntv/GgGvzpghmUdbKIBvJpQi89DoTK3QKMQtJsU5NUFAunpsDrg6U6w3lsQb+FBv1PUymo2SKB46RYvyHbtnZTsnaDogtHmr8m5KZA5wM3dAifTP/SfoN0iNhoD7BJNTO1GJXLcXyTdF2oyBZMXabRdVZFB0o3A2sRuus2UKQ4h0mMmYAERKNqD9Kv26BkSLuEUTulvl2xFlSJmcOBTUX0ECnEBVW0UTn6S3N0kMNrAI1ORAk/brmXIguisdst8u5KkqRQzdwCSa4oLlIYRSW0ViH6TWN0mKNrCFC4H219vC3vpUEaweI38vTe4eFBgTrc7fdsNBgfgFCgcVAAAOYoFEwf1CUomEoDyARGsuuTioVfQnWnEx6YqTnRdTSVeGR+gX9A+va1YsyALWta27dYPdwDduo8eIyVCdcfPwpgBr86DcNfb7aDcNfhcfX50A1+fCg1I1uY+i/C3poCdfmFANfnx/KmfAcwK3Pb2UG4a/O3p2Gg3IjX9+1qFJ1uO3p8fChK0Gvz8N3P8qAa+3lv9dMANfn+PnRAjX47/AA4beVN4J16AjW+6gGvzoOY1+fn+g+NOIJ19t3o9tANcfAfstwpvA1+f6eQ0A19uPqpkBr8/O+/nxoOA1+ew0FBr86AjX3cQ23jQDX57fZvGg0GvtupxGQ1+f3ejhQaE6/OgKckt/wA2ej//AF0WHscy/wCNAVHX8t96cQNfn+HuoHgNfzHbfQEa/P1+P4caAkF9r7cabxqRr8N/o93tpxHEnW5/dQGyPaPu5iGGQAQMu3mknTuaWduX6KbZ7HJkdJs2pXJiFUbPm6TdFsGokRNycegTlMInBIgZme2PePtpIOkmbfK2ZFVuvoO9ayUa1DTTOqbVeyLJqyQuUggHWoXqNYoXMIAIFXV7gYQqYGiWRwcmq46kis2UnHPFF+r4BSKkVyJVesB/p39QVxd131ntVW5G41rSLotMW6R95tt2pTeDS4v4Z+4xtksZg8kdUVO3GJLLnKoQ8g+gmgujFOYBMUjlq3ZvCEOb+oSrWOPmG8fn73qdqcUrVm3Fb88Mv49NPa17Dvt9q1Kk5yfDfsrXkfza/wCRv6xPqE+jv6mnGO4Z9Hs53y7A5T26xHI47KsQ7mY7hS2IZ4SWyuNy3F/kctbSaj5MsVHRMoRVV0kQqsgcqV+k5S5dtbsXrXXdk4zrXaqP358sczG5WM3COKNE1v8ALNEzzcqM99HnfnF1wROiomTuJ9Mcmk36iiPQVV33ox1c5bAO8yACBf8ASPTepTto0c5p4p4bFt8tMOORk7U28MsvH6FwY99bfbnNnKcYn2t7jMgfAoiqlNz/AGBM2MioJgEHhY/vS/SM3MdUQH4Th1+Jh3VrjesttRbwxVPLKuVEt74lfbzWzx5fodNor6cstyKFiJ5KQx9BKbjmEygi5fLuHTdKSQRkG5FzNGLuPUcIJLgBzIOFkjKFumoYljG9S123cXbcb0XHplFNVzxWuDo9ddmOZxylGMnB5p4m3nYLt/F9psAyGClUzu8jyV1KOXqjKRUfsEVXzczBFRKQVjoR2oVNuYVtFRsoBFBFPrU3rDnHse7lOLuuCjF40bbw/wClLHXwg7lqKah1OvjaZK1932778q9k5iNfxoCdfyEaag/aTsyKqSxNMToqEWTBVIi6XWmYDFBRFYp0VkxEPiIcDEOW4GAQEQoKl9lmVlxausU7lv8ABnSLJT57Fs4xt5nOCqrEUbkTZ4zkOOzEH3PxtJVNIvy7Zy7koeOR60kWYiVMxtTg1/F+PI2qa/1IvA0n3RdEBCa7mdp3aIFEl2eTSLhMxDEJ1CUsqwMumbqD/XcREt7jxqUm6rDx5CsFRrMtySx7HBKUJ7uQyIdURODfHUVZcN1hESSMVHxp45co2AogcBvvva98ujWvMvXEs5SK7TN+lU0X3By1wJxFcmT59Ox7Q5QABKUyUDJEVdpAYv8A4axzlAo2L0233oiv3Zg5s9sPkcHiSztfAu3vbvBV3RATVkcexGIbzqie43Q6nDtjyD0AULf+6Ywjb4ureI5KKWVERyriapdrPpp7Z9nvqA7z/U5hqmVId3+/LiUUz6cc5M+COWbTcrGT0tHMICPCPhk2r6fiUnonXRcuE1xMCapEzCnSiDk348cDZ7+Uz/XqfvcsJhMJviknhiXHePwGXEghfwsIU6UOqR7087ypG2jPSSVv9JXBugb3AbkG5PiAd+7fSi0HU/FCrE7o5WCaRDvG7kURTMQ7xm3dnBRIxTkUAy5FBKcFCAbdawgFuAVaOubqh100R61e579c5HysXE/vZCkIWVTjo5FQxElxXTTU0mJXapCCIiUDLiAHG/AACo6t4sKSphmWC+lXck7XfvlzuXTlQVVl1BATHOIBYAAAApCFKAAUpQApSgAFAAAArLFmPM8utz2/KoOI19/EbbDQDX228qAa/jfblTcCNfnQUGvz8wDfuoCdfn+Ho86Aa/O/HbzoOI1/LbwoBr7eFMQUfX57e3dQpOvz9+2/3UIRrc+X41QNbnw8fZuqDAnW58agI19vXv4VQNb8+VATr8/HzH00JkRr/pUKTrc7beG7wtVA1/tDhUBGvz4flerxHExDh8zjLGPVhshdRSWTqZnJnkI9+Lc0o8nnGSOF4aQRanAzhyU7c7Y7VchRImgUthIVMekDF+Lz79lD48yNKLRMGrj3aRrMyiBkmqkTGP22cncrhIGKAsSPpBizbGWMP9oiwiUSGHqACsykqqxzJJxEZE6c4iONYwhkmVN3ycrLtY0uXZymnpSFhILBOTAGrt3/AHF27Yom3iB1SBkZL7gmduF+3hI14izdHztEzZ4s2F+in/0jlw9Zm4OWorgZO4B/cLxAbjwEDGSsnkUW9nWSkmyK2fdypJOcmTyrjCWKiqWC4krGMlJVuxyJxEEdnE1unpFZRApNQvX0GDAqTKWzBz1aGUjMPIbAJObZIY89bSkXkMwxyCfaxLdzILRTZaQAyDRFByZJNtrrFNvAvEC4u28vKO5I/wAxksPLM3MC2dKx6GYOcplU5MjhMqkksgtjsF+xIuE1xTVbFDTKqQAIQggegMx633U0Go1+f5+O4KbwNbb8+NOY0Gvz4UA17DxvxvvsNANbbzEaAa/Pj6PP7aAa3Db8KAa3Cg5jW57eNANbn6aYgAvz5XoBr8/V6KAa/P0ct9BqTr8/H1e+1AQK/OgGtzoAK/Pbf50CwGv5bh2+2gGvz23eumAoNfnv8qoGvuDfx+39ambA1ue3LfQbyda3jx5/d40BALc923DwoBrc6BgV+fgP3e6iA1ufCg5jXD1DTFjmTrc/18PCg1I1vw+37aZga3Pb0UYGvz8rUYGvw5DxqBjW8L/dV1ITrc7ev3240LuPOX4XSznrvqt2yHRb+n5dR0p1Abq39fzNrWC1ue4ND76/Ow7emgGvz/T2UA1+e3uoGTr893hvHy91BoNbf6d3o9e6gI1+G+m4InW58dvRTUEa/Py33vxoKDX2AfX9lAyQXt4iH5+igPyKoDuGw+d9/wB1qlEKstubxLD8mFL+SYpjWQCgfUQ/e4KLlhQU6enrS+fauBTP07rhYbVi7Vpusoxb4IyUpJYN0DfEsPZpppNMUxpokmAAmm3gotBNMA3ABCJNSlJYPKqoRpgkTF7alVRj4luIChGRyAhvAUWTZIQvbh0JhYfhD2VelVwSGO0qAL2AAvYAsG7gAcA3eAbqJLQmo1+f6VeRMhrc9232VeZeY1h8/PbyqAa2710wA1tvV+NANf8AXbz9VUE63P7uNTmCNfnTjkOI1t96Aa+23nQE63MKEqNbn579vGnAtGRrc6ccwNfw/Xh48aB5jW5/bw+2mIGttt+NK6ga4+fD9acBvGv57b/Cg4E6/H7h8fb99ARreN9v1oNw1vX+VANfxAaZAnW4/fx9FANbntyoGRrW4Dz9fHjQZjW5+/d7alcBzKTrW8ftq8gNYfPhuGmAzGtz50A1t3H8Q+6qBrb/AA5eXH2VKBDW8L++oBrVQ2Nbn9tOI3jW57cfXSntINbnQqArc7BtwoQa3P3e7nehT5iZMVAVEhBVKXoKqJAE5SmG4lA9uoC38L2oD9nUKcpiHADlOAlMUwAIGKYLGKYB+EQEB3gO6iBBVCkKUhAApCgBSFKAAUpQDpApSlsBSgHhQan61vs23+qgPwc5FCiRQCqEELGIcpTFMHkJRAQHh40KfoqgFKBSgBSFDpKAAAAUobgKABuAALwAKEx8z8kMkmJzEIQhlDdahiEKUTnH/UcQABMb005A/et9nnQDW5/fQEa3P7KpSdbn7/KhNRrB58KgxGt4X+ymTG8a3O3P3UFRreF/f6fPdQDWDz+/8KMZjW51dBrvGv4bfrU3oZsa3Md35e+heY1h8x/HYaDMa3P7rc6E5DW28PH7aAa2/j5X86VGQ1uew0FRrc/Vfdv++gxGtf10LgNbjtwpzIBW52+7woBre2+2+mfAYjW8b7fdU3Aa3Pb7wGqBrc/Zb9ONANb0UGQ1ue34jRga3Hf7/P7bUA1vG/47DQDXtxEaAa3Pjz9+/jTQDW/XbhQDW5+HqoBreN/V6KajAa3P7aAa/PYfXQDWv4+Hju9fsowNbjv9AbDagGtz9FABW5/pUS0CY1vAR23+yqBrc94B5/ZQDW5+z3jQjxQ1h8+Hl5W4UyKNb3bcd1BoTr8+fG/3240FCNbb2b6Aa9M+IGt4Xvt4eynAZcRrc/0oBrbuW3Md9BlkNbn7+XPfQDW5++hKajWHzoUa35hz8926gQ1rbcaAgFr228RGgJ1vMfPx286ACtz/AC4WpQDW57e0KEGtw37caFGtv9vHYKAa3PbnTcNwBa48dr/nTHUPAa3P89r0A1vC/wBnt8PKgGtt+O+gGtx339ewbqbwNbntf7aAa3304DEa227w996DEa3PytUA1+e2+qCBW5+z7KbwTrU5AaweoOH4UxA1tvDjQDW8fKnMHg+PnxoUj4/xv91FuIvePjsFuft/CnAaj4/x9/C3OmAwqPjuPq4+nxvVYJ+PnwCpzDI+O3Lx4cPwpqB8fPjzv+tMal0Hx+/9ff7qcych8e/j76EQ+P1btvRTmUD1W8Ng325WoXXcPj9fPzsNUjHx+Hn4+rjUW8D4rjtsFTkNd4+O3q8OFZIYVHxb/V5+QcagHx8/f5/bQYVIHr9Xje/LhVHMn4/D18duFTDyHHIn4/Vz/PfanMD4/t4/nQKpHx7enfahMNR8frt67eNuVC4j49/H13vb8aAn47fbb0B67UwBAdW635cd16Y6jEfHu428PPwoOIDq5X9fC9BwHx23eqg13j477efhyvTCg4j+5f7fR66uA5kj17/Vbj7udQnAj49/HjzoUn4/C1t/lbx++nEcyPj3+gKo0wHxeHq8vH1VOIx8h8dh8t9/RTgQfHtx5c6uBQPXz8fPjUQ1Hx237eXGmuA4D47bvf6qDXHMfH4cN/nbhvtypzC31JDr2tQYeZHxXH1Xv66P3EwHx38fD7edCofHfnfwpyK92Q+P1+Nr3vuvTkQfFv8Av8t3G9HUYD+5tta96oHx+Pn4+Xr3VOA1xHx+vbyoEPj5+/z8fC1OYA9f2/by3U1GNcMx8d9vu5U0Gg+La/qpiB8d/b5+7lVA+Lxttb1XtQLcT8dx28vuqAB1+Hn91OJeZHx35X8L/dzqEJDq3cPXteqOJHx8/D0bXoy8Cfj8eXp8PXTQx4D493D1+kLUfvLzHx8/f9+6gI+Pb8/G3GgRHx+7xvfx++rh5jlUn49vLf5cqiHIfH+PosPCnEIn49vuoEPjtu24X53pxCI+Llfx4eW6nAmo+Pbjb7aIo/ufj6PCmgW4fH48uPu9dNR48eMgHVf7PLh7L1WMB8f4cfP8KnIKhPx77+vb00HAfHz+/wAPdTUH5+L1b/zoCR6vHy9frpwC3bR8dvC/jxpxKT8fLjv9N6EA6m/bz8t9OGQI+K3tt6PtowB6rD6/bQD4+ewfhQD47D6d9MBiPi9dvH86cgT8e3u5UwIR8XhtvG3vpoVAOvw++1A8yfj+zz42pqUgOvf6fC9MCP3gOvda3H3ePr+6rxzAHr9XvqIp/9k=', 3, 'FreeAgent drives give you the fastest data transfer rates available and a sleek, stand-out design.');
INSERT INTO "producthome" VALUES (4, '*nm*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', 4, 'Vibrant, professional color is now within your reach. The compact CLP-315  printer can fit comfortably on a corner of your home office desk or bookcase.');
INSERT INTO "producthome" VALUES (5, '*nm*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', 5, 'Lenovo IdeaPad U Series- thin, light, travel-ready, energy-efficient and feature-rich laptops. Surprisingly affordable with just the right mix of style.');
INSERT INTO "producthome" VALUES (6, '*nm*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', 6, 'A wireless mouse built for at-home and on-the-road comfort. Say good-bye to the touchpad.');

-- ----------------------------
-- Table structure for "main"."products"
-- ----------------------------

CREATE TABLE "products" (
"productid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"shippingid"  INTEGER NOT NULL,
"measure"  INTEGER NOT NULL,
"categoryid"  INTEGER NOT NULL,
"subcategoryid"  INTEGER NOT NULL DEFAULT '0',
"name"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"description"  text COLLATE NOCASE NOT NULL,
"picture"  blob,
"price"  numeric(10,2) DEFAULT NULL,
"taxable"  char(1) COLLATE NOCASE DEFAULT NULL,
"onhandquantity"  INTEGER DEFAULT NULL,
"prod_active"  char(1) COLLATE NOCASE DEFAULT NULL,
"overview"  text COLLATE NOCASE,
"specifications"  text COLLATE NOCASE,
"acessories"  text COLLATE NOCASE,
CONSTRAINT "products_ibfk_3" FOREIGN KEY ("subcategoryid") REFERENCES "subcategory" ("subcategoryid"),
CONSTRAINT "products_ibfk_1" FOREIGN KEY ("shippingid") REFERENCES "shipping" ("shippingid"),
CONSTRAINT "products_ibfk_2" FOREIGN KEY ("categoryid") REFERENCES "category" ("categoryid")
);

-- ----------------------------
-- Records of products
-- ----------------------------
INSERT INTO "products" VALUES (1, 1, 6, 2, 7, 'Sony - E-Series Walkman 8GB* MP3 Player - Black', X'3C703E546869732057616C6B6D616E204D503320706C61796572206665617475726573203847422A206F66206D656D6F72792C20736F20796F752063616E2073746F726520796F7572200A6661766F72697465206D6F7669657320616E642074756E65732E20546865206C6172676520322220636F6C6F7220515647412073637265656E20616C6C6F777320796F7520746F200A656173696C79206E61766967617465207468726F7567682066756E6374696F6E732E3C2F703E0A3C703E4D65617375726573206A75737420302E3422207468696E20616E6420776569676873206A75737420312E39206F7A2E3B20757020746F20333020686F757273206D75736963200A706C61796261636B3B20322220636F6C6F722051564741204C434420646973706C61793B2057696E646F7773204D6564696120506C61796572206D75736963200A6D616E6167656D656E7420736F6674776172653B2055534220322E3020636F6E6E65637469766974793B20506C617973466F725375726520636F6D70617469626C652E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (2, 1, 6, 2, 7, 'Sony - E-Series Walkman 8GB* MP3 Player - Black', X'3C703E546869732057616C6B6D616E204D503320706C61796572206665617475726573203847422A206F66206D656D6F72792C20736F20796F752063616E2073746F726520796F7572200A6661766F72697465206D6F7669657320616E642074756E65732E20546865206C6172676520322220636F6C6F7220515647412073637265656E20616C6C6F777320796F7520746F200A656173696C79206E61766967617465207468726F7567682066756E6374696F6E732E3C2F703E0A3C703E4D65617375726573206A75737420302E3422207468696E20616E6420776569676873206A75737420312E39206F7A2E3B20757020746F20333020686F757273206D75736963200A706C61796261636B3B20322220636F6C6F722051564741204C434420646973706C61793B2057696E646F7773204D6564696120506C61796572206D75736963200A6D616E6167656D656E7420736F6674776172653B2055534220322E3020636F6E6E65637469766974793B20506C617973466F725375726520636F6D70617469626C652E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (3, 1, 6, 2, 7, 'Sony - E-Series Walkman 8GB* MP3 Player - Black', X'3C703E546869732057616C6B6D616E204D503320706C61796572206665617475726573203847422A206F66206D656D6F72792C20736F20796F752063616E2073746F726520796F7572200A6661766F72697465206D6F7669657320616E642074756E65732E20546865206C6172676520322220636F6C6F7220515647412073637265656E20616C6C6F777320796F7520746F200A656173696C79206E61766967617465207468726F7567682066756E6374696F6E732E3C2F703E0A3C703E4D65617375726573206A75737420302E3422207468696E20616E6420776569676873206A75737420312E39206F7A2E3B20757020746F20333020686F757273206D75736963200A706C61796261636B3B20322220636F6C6F722051564741204C434420646973706C61793B2057696E646F7773204D6564696120506C61796572206D75736963200A6D616E6167656D656E7420736F6674776172653B2055534220322E3020636F6E6E65637469766974793B20506C617973466F725375726520636F6D70617469626C652E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (4, 1, 6, 2, 7, 'Sony - E-Series Walkman 8GB* MP3 Player - Black', X'3C703E546869732057616C6B6D616E204D503320706C61796572206665617475726573203847422A206F66206D656D6F72792C20736F20796F752063616E2073746F726520796F7572200A6661766F72697465206D6F7669657320616E642074756E65732E20546865206C6172676520322220636F6C6F7220515647412073637265656E20616C6C6F777320796F7520746F200A656173696C79206E61766967617465207468726F7567682066756E6374696F6E732E3C2F703E0A3C703E4D65617375726573206A75737420302E3422207468696E20616E6420776569676873206A75737420312E39206F7A2E3B20757020746F20333020686F757273206D75736963200A706C61796261636B3B20322220636F6C6F722051564741204C434420646973706C61793B2057696E646F7773204D6564696120506C61796572206D75736963200A6D616E6167656D656E7420736F6674776172653B2055534220322E3020636F6E6E65637469766974793B20506C617973466F725375726520636F6D70617469626C652E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (5, 1, 6, 2, 7, 'Sony - E-Series Walkman 8GB* MP3 Player - Black', X'3C703E546869732057616C6B6D616E204D503320706C61796572206665617475726573203847422A206F66206D656D6F72792C20736F20796F752063616E2073746F726520796F7572200A6661766F72697465206D6F7669657320616E642074756E65732E20546865206C6172676520322220636F6C6F7220515647412073637265656E20616C6C6F777320796F7520746F200A656173696C79206E61766967617465207468726F7567682066756E6374696F6E732E3C2F703E0A3C703E4D65617375726573206A75737420302E3422207468696E20616E6420776569676873206A75737420312E39206F7A2E3B20757020746F20333020686F757273206D75736963200A706C61796261636B3B20322220636F6C6F722051564741204C434420646973706C61793B2057696E646F7773204D6564696120506C61796572206D75736963200A6D616E6167656D656E7420736F6674776172653B2055534220322E3020636F6E6E65637469766974793B20506C617973466F725375726520636F6D70617469626C652E3C2F703E', '*nm*/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAhABGAwERAAIRAQMRAf/EAKIAAAIDAQEBAAAAAAAAAAAAAAUGAwQHAgEAAQEBAQEBAQAAAAAAAAAAAAAAAQIDBAUQAAIBAwICBgQHCQwLAQAAAAECAxEEBQASIQYxQWEiEwdRMhS0cYGhciO1F5FCYoJjcxUlNrFS0jNDhJSkFiYnKMHR4aKDJHQ1laUIOBEBAQABBAEDBAMAAAAAAAAAAAERMUECAyFRYZHBEwQU8OES/9oADAMBAAIRAxEAPwBu578x+aMTk1VLx3S5kvCkakxLGlvey2yKNhFe7EKk9et+IhbXzg5prxuZB/xZP4WmZ6LhIvm/zOxAFzJUkAfSy9J/G0yYFpudvMGGYRSS0Z3SKMi4lKvJIWVFVlJBqY249HbpmGEX9vufybcB6m6O22pcyd9xH4hQd71wp9U8fujTMMF3O+efNOMt96y+NKz7IgLibY1Okgg9FNMxAA//AEjzqemJf6Tc/wALVyDPJ/nlzrm8/Bjt4tVkjmkMqzTSkeDC0g7sjFTUrTjpMUaxYeauVufLLJ58qBkLExxK1OBd5kh3U+F66xurLvN99uXsu1sn9a3OtVIEY3ltLuwgui0lZl3UFKdJHo7NZVY/smg4hpfk/wBWgvWfKIuEkd8lJBN3lCSO1XUbTTd6O8eBOg8u+SjbwNcR5RJ3RlASN28Qk92q1UcFHX6NMjOeY8JNd5JgjSGGD6NOjp+/PR6dMgX/AGXnUE9/gK9H+zTII+VBrzta/wDT3vusmtzVK2DBsh8k+Y1B7wntyf6dFrG6gvnI1Mnj/n5X61uNauiQAxCXFytvbRSBGdT3nYqihQWZmIrwCqTwFfRx1lVnJQQW1vbT22TW/E+4SCKO4jETKfVLTIgY0IPDUFK0jvL27jtLd6zSkhd8gjQUBYlnchVAUEkk6oi59tL/AJWxYmmuklnn3wxmFw6LMKd0MG3MVB3GqjsrpgZjgMXfZjILZQ3Ekfd3O4DyvxdY1VI1O53eSRVUVHTUkAE6o6zuMucTfLB7YbqF93hzLujNYpWhkR4yzbWSSNgeJHQQSDoGzyoanPFr2wXo/qkutTVK1fl+v2Q808f5e299h1jdQvznamTx3z8r9a3Gt1IVrC5aGOCVQrNHRlVxuWo9IPTrCpbzJzXCqjLFFEhLLFBGkSbjwLEIBU0FKnQQWeVusfeRXtqypcQkmNmRJFG5SpqjhlYUY9I1M4Cr5i87ZnmO9itr6eOaKxd5KxwQw1nmC+IzGFE3GiqOPbq5MFazvbizn8aAruKlHSRFkjdG9ZHRwysp9BHb06o9vL64vJ0km2DYojiiiRYo40BJCoiAKoqSe0kk8dA8eVX7cWf5m89zm1qapWr8vv8A4Pc0t+WtvfYdY3UH86mplsePQ2V+trjW7okLnLtvFeXMFtKCytFKwXf4dWSNnUbtr0qy9SknoHHWFWuYMbb2NnBMiGN5ZZECmVnqiorAlHjidDVu0dVag6WAp5Ui/XmabJ21sZ4sZYX1xLKY/EhjYWshj8SoKgMwpx15/wAi+Pf+nbpnn+eoF5kZ7mDmHyj5ezOcxtvjJrnMXPsaWtqLSKS39mjIlUD1w77u9rHVMdnjTztj0dO254e/j6kPk/C4bKtlf0pLLGLOya4tRFPBbl5gwAVnuAUpTXsw8jvmrB4TG2eFnxskzy30Uz3kc1xbXOxo3VUCtagKAQSeOmAd8qxTniy/MXnuc2tTUrVcBDIPJjmckcDPbAH+fQjWN1BPO40zOP8AnZX62udbqEWOQGBQeIp0axVRmRRXaAPg1BTu+e+ZcNbX2Jw+SlsrPJRbMrHEQPFQggKSRUd1jWlOB1m8JdWpzsBsxzlzNnMZjcblMlLeY7ER+DjbdyNkKABQF2gVooAqeNOGrx65LmHLnaDEKekDhxFdbZeoF3VAHEipGg0Hyr/bi0/MXvuc2rNUbLhafYTzC35aA/12LWFKHnkf13YfOyn1tc667Mk7l+fFR5OzfLrvxqk+0rsaThtbb3EeJmG6lQHGrOvKivmDm+UL0W91hUVJk3+2NHaNZKUCqEGwyyqx3buKqOFAa6v2jLOMTdJFnrS9uWCok6yyswLKAD1qoJIHYNbvSLnN9/Y5HIw3FmIdohEb+zpIijazbVYzfSSMqkDe5ZiKVPDSdIn5Ay+Dw3MLXubto7qzNpcQxpLaRX6pPKlIpTbTMkb7G48TpekXPMXL8p5zKRZLl+3WxCxw20tpFaRWMblEJecQQlkQljQ947uzbxfZF3ysNOd7U/kL33ObXCajaMKjfYPzBHUb/FgXsr7bENYUmeebfr2y7Gyn1tc66bJGdq30a/Br6HT154ygdlZSVWEdfeb4B0a7celYs4PH8qXOPuP0tfy2N+GdbUKjPGwaIeEzbUagWWu/jxXo05dfKXxFeZXFcs29gsmOy7X14CPEhMDxCh28QWFOHe049fK3zAE8PW/tD0J3h8OperwHHyt/bS2P5C99zm18aMtowjt9inMXZc2/v8WsKSPPNv17Z9j5T62uddLpEhZscVipMNb3UkqtcSMYzbCYLLu6m2EUCGtKlta4/nc+N/xJ4k1x4+fVM+cYv0EstyDyxaZ+/wAZNlBI1tNDHDexvG9vLFLGZDKGR3ps20Kjca+jXefn9nt8N5Qr5dYeVoBa30E3tRCWym42yO5AqpTa2ziSAWPVp+/2e3wZR4/kLA31v4kN9GkhZ1CzXCRodjMvB271SE3ep0Mvp4P3+z2+DLtPL3ByW4lTI2/iNMYVjNztrQ03Big6wekU7eIGn7/Z7fBlctvKvBzYy4vjnMfDJbG5DWb3f0zG2LDuDaAwk21T06fv9nt8GS55VmvONq3RW2vTT+Zy68sZbThSB5Fcwy+maBv69EdYUiedpeTmGABGWkmS27hTcpylwwZT1jjrpdIkZpcQTlNqqTXp1FUzayJ3du3sqBoj4Qyg1XgfSGFf3dQcmGU9ND8Y0H3gyddD8Y0H3gOeofdGgavLYtBzZbyMrMPAu1og3tVrWRRwHw6sG14dD9gOfSo3b4F7K+2RawpF855P7wWlT0JfU+PJ3OumzJNxGatceszT421yKylQj3YY7Cla7Nv77d3uH3NRVTN3X6YyKTWOPgtAUEa2diG2cCTuow3VoeJPo1BJa8rSSLuub2C3NK+GoaZx0cDs7lfxtBzc8ruihre9hn/BYNE1fR3qj5dFSYXJSYtXt7jC2N6RJ4ni38RdlNUoAwPFaIe7+ET6NEcX2VjbFixjxthEaHdeRRn2g1kD+s3RQDbw6idBb8uzTmu1P5O592k1YNow1fsD5gP5SD3yLWFZ/wCd/wD3+z7Uva/+SuddLpGSphxyrJDJ+nHu4yqQrZ+yBW6n8bcGoPXKkcfTrKuLqPAvkLRMIbgrtl9s8fgOk7NnXt2UB3ffV6qaKnt5gjGN+n0dJ+4NBzdTIsaxr3aCgWhHD49ESWdxy6lnKMtHczXKj/ko4X2R1O7dvY1px29A/wBOipr6TkI46U2KX65TumASFTABv+kD1O6nh+qR19OgreXn7U2v5q592k1YjaMMP8AM/wDPg98i1hWeedrf3iteyO7+srrXS7MlHlqwt764uUuFLwxQF9qttIYuibgewMeGoo7FY4e3tna1QUIO6SpckrwpuNevVE8HKOavUmusPZT5FLTb7WbaNpWXdWhZVBbjtNOGmDIfdcvZhreLIT2kkOPnO23ncABz3hwFdw/i26R1agrmxtzCTPTaldzHgBQ0JroB+dsYrSG0aE0WcP4gqSaowp8h1FXvL39qbf8AM3Pu0mrEbRhx/l/z3z4PfItYVnHnWd3McAHUl39ZXWul2ZhP5anaLIMlSPGidKDr20kp8ezUUfuLyIRNGAArA9HboK8Gbykhe0gupra3nK+1RQSPGHCVpuCldwFTSugtpnslAiWcs0klklDBauxZE6eCgmg9duj0nQXLa4tpUIdV3NUsKcKkknhpgL3OsiC9tbVTwgh3EADgZTu4/ihTqK78vf2nhPohuvd5NWI2jD//AJ+zx/Cg97i1hWbecRLcxx9ntg/9jc66XZmEJGkikWWNtkkbBkYdIYGoOoosZRdxGeAU2is8A6Yz6R6UPUeroPaFvHW6bS8i1FOnUHd1HE0CTRLQEVrQg0Pprx0HsVxFaWwvr3+IH8RFWj3DD71fwP379A6OnVyYDY8BzTm7s3QspXe8u4LZpmXw4xPervgU19VXTvKaU2/FrF7OM3XAty1ibzDc8y4y8KG5s1u4pGibfGxWBwSj0G4avDlOUlhZhr2IH+XvO/DB73FqCl51+U+TTLtkrFmksAJXG5SzBpZnnYVXq3SGnDWsoxp8BkSSFiZj6NrD90aZVAcRlIJVkSN4pE4q6naR8fDTIu299lYCPFtI7gA1aoeMn4fCZB8mmUSzZrKMCLfHW1tWlGKyTsKejx3kX/d0UJuLLK3c7TXJeeZuDO7bjQdA+Ds0Q14vmfzDt7a1tra5Ph2tpPYxhkaQtDcUHf6dzxKoWJj6iig4a43p4W5w1/qiOLsOfLx8QktrJeRYW1kssZF4SxBIpF20d1G5+rp463x4zjbZulrZsfyLnYfJXKYdo/1jcrG6R061nSQ8PxdUbHf+xezt7Zs8Cne30p8ugW0+z3edvsu7r9XQUr/7LuPtHstev1dAEuPsYqd/s/xU0FX/AASr/IfJoL1p9jdR4fs9e3boGDH/AGccPZvZa9Xq6BhtP0JQezeB2bdugvd3b1bfk0H/2Q==', 80, 'Y', 10, 'Y', X'3C68323E50726F647563742046656174757265733C2F68323E0A3C756C3E0A3C6C693E3C7374726F6E673E3847422A20696E7465726E616C20666C617368206D656D6F72793C2F7374726F6E673E3C6272202F3E466F722073746F72696E6720736F6E677320616E64206D6F766965732E3C2F6C693E0A3C6C693E3C7374726F6E673E556C747261636F6D706163742064657369676E3C2F7374726F6E673E3C6272202F3E4D65617375726573206A75737420302E3422207468696E20616E6420776569676873200A6F6E6C7920312E39206F756E63657320666F7220706F72746162696C69747920746F207468652067796D2C20746F20776F726B206F72207768656E2074726176656C696E672E3C2F6C693E0A3C6C693E3C7374726F6E673E537570706F7274656420666F726D6174733C2F7374726F6E673E3C6272202F3E496E636C756465204D50332C205741562C204141432C20574D41202844524D292C204C2D50434D2C0A20482E3236342F4156432C204D503420616E6420574D56202844524D2920736F20796F752063616E2074616B6520796F7572206D65646961206F6E2074686520676F2E3C2F6C693E0A3C6C693E3C7374726F6E673E322220636F6C6F722051564741204C43442073637265656E3C2F7374726F6E673E3C6272202F3E416C6C6F777320796F7520746F20656173696C79206E61766967617465200A7468726F7567682066656174757265732E3C2F6C693E0A3C6C693E3C7374726F6E673E4275696C742D696E20464D2074756E65723C2F7374726F6E673E3C6272202F3E466F72206C697374656E696E6720746F20796F7572206661766F7269746520726164696F200A73746174696F6E73206F6E2074686520676F2E3C2F6C693E0A3C6C693E3C7374726F6E673E486967682D73706565642055534220322E3020696E746572666163653C2F7374726F6E673E3C6272202F3E466F7220626C617A696E672D66617374207472616E73666572200A7370656564732E3C2F6C693E0A3C6C693E3C7374726F6E673E436C65617220417564696F20746563686E6F6C6F676965733C2F7374726F6E673E3C6272202F3E44656C6976657220696D70726F76656420736F756E64200A706572666F726D616E63652E3C2F6C693E0A3C6C693E3C7374726F6E673E4275696C742D696E2074696D65723C2F7374726F6E673E3C6272202F3E48656C707320796F75206B65657020747261636B206F66207468652074696D652E3C2F6C693E0A3C6C693E3C7374726F6E673E526563686172676561626C65206C69746869756D2D696F6E20626174746572793C2F7374726F6E673E3C6272202F3E50726F766964657320757020746F20333020686F757273200A6F66206D7573696320706C61796261636B2E3C2F6C693E0A3C6C693E3C7374726F6E673E57696E646F7773204D6564696120506C617965723C2F7374726F6E673E3C6272202F3E4D757369632D6D616E6167656D656E7420736F66747761726520696E636C756465642E3C2F6C693E0A3C6C693E3C7374726F6E673E506C617973466F725375726520636F6D70617469626C653C2F7374726F6E673E3C6272202F3E466F722072656C6961626C6520706C61796261636B2E3C2F6C693E0A3C6C693E3C7374726F6E673E504320636F6D70617469626C653C2F7374726F6E673E3C6272202F3E466F72206D756C746966756E6374696F6E616C207573652E3C2F6C693E0A3C6C693E3C7370616E20636C6173733D224C6567616C223E2A466F726D6174746564206361706163697479206D617920766172792E3C2F7370616E3E3C2F6C693E0A3C2F756C3E', X'3C756C3E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E57617272616E7479205465726D73202D2050617274733C2F6469763E0A3C64697620636C6173733D2264617461223E3120796561723C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E57617272616E7479205465726D73202D204C61626F723C2F6469763E0A3C64697620636C6173733D2264617461223E393020646179733C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E50726F64756374204865696768743C2F6469763E0A3C64697620636C6173733D2264617461223E302E34223C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E50726F647563742057696474683C2F6469763E0A3C64697620636C6173733D2264617461223E312E37353C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E50726F64756374205765696768743C2F6469763E0A3C64697620636C6173733D2264617461223E312E39206F7A2E3C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E50726F647563742044657074683C2F6469763E0A3C64697620636C6173733D2264617461223E332E353C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E53746F7261676520547970653C2F6469763E0A3C64697620636C6173733D2264617461223E466C617368206D656D6F72793C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E4275696C742D496E0A2053746F726167652043617061636974793C2F6469763E0A3C64697620636C6173733D2264617461223E3847422028666F726D6174746564206361706163697479206D61792076617279293C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E496E636C756465640A2052656D6F7661626C65204D656D6F72793C2F6469763E0A3C64697620636C6173733D2264617461223E4E6F6E653C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E52656D6F7661626C650A204D656D6F727920547970653C2F6469763E0A3C64697620636C6173733D2264617461223E4E6F6E653C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E4469676974616C0A20417564696F20466F726D61742055706772616461626C653C2F6469763E0A3C64697620636C6173733D2264617461223E4E6F3C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E436F6D70757465720A20436F6D7061746962696C6974793C2F6469763E0A3C64697620636C6173733D2264617461223E50433C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E4D757369632D4D616E6167656D656E740A20536F6674776172653C2F6469763E0A3C64697620636C6173733D2264617461223E57696E646F7773204D6564696120506C617965723C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E4D75736963205365727669636520436F6D7061746962696C6974793C2F6469763E0A3C64697620636C6173733D2264617461223E4E6F6E653C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E4469676974616C0A20417564696F20466F726D6174733C2F6469763E0A3C64697620636C6173733D2264617461223E4D50332C205741562C204141432C20574D41202844524D292C204C2D50434D2C204D50343C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E506C617973466F725375726520436F6D7061746962696C6974793C2F6469763E0A3C64697620636C6173733D2264617461223E5965733C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E426174746572792053697A653C2F6469763E0A3C64697620636C6173733D2264617461223E526563686172676561626C65206C69746869756D2D696F6E2028696E636C75646564293C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E42617474657279205175616E746974793C2F6469763E0A3C64697620636C6173733D2264617461223E313C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E42617474657279204C6966653C2F6469763E0A3C64697620636C6173733D2264617461223E557020746F20333020686F757273206D7573696320706C61796261636B3C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E417661696C61626C650A20457870616E73696F6E20536C6F74733C2F6469763E0A3C64697620636C6173733D2264617461223E4E6F6E653C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E436F6E6E656374696F6E0A205472616E7366657220526174653C2F6469763E0A3C64697620636C6173733D2264617461223E55534220322E303C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E54756E65720A20547970653C2F6469763E0A3C64697620636C6173733D2264617461223E464D3C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E4865616470686F6E6520547970653C2F6469763E0A3C64697620636C6173733D2264617461223E4561726275643C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E464D2074756E65723C2F6469763E0A3C64697620636C6173733D2264617461223E5965733C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E53797374656D20526571756972656D656E74733C2F6469763E0A3C64697620636C6173733D2264617461223E50432077697468204D6963726F736F66742057696E646F77733C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E426C7565746F6F74682D456E61626C65643C2F6469763E0A3C64697620636C6173733D2264617461223E4E6F3C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E436F6C6F722043617465676F72793C2F6469763E0A3C64697620636C6173733D2264617461223E426C61636B3C2F6469763E0A3C2F6C693E0A3C2F756C3E', X'3C6469762069643D22626F78636F6E74656E7473223E0A3C68323E57686174277320496E636C756465643C2F68323E0A3C756C20636C6173733D22702D76223E0A3C6C6920636C6173733D2270726F706572747920696E636C756465642D6974656D223E536F6E7920452D5365726965732057616C6B6D616E0A203847422A204D503320506C617965723C2F6C693E0A3C6C6920636C6173733D2270726F706572747920696E636C756465642D6974656D223E3120706169722065617220627564200A6865616470686F6E65733C2F6C693E0A3C6C6920636C6173733D2270726F706572747920696E636C756465642D6974656D223E526563686172676561626C65200A6C69746869756D2D696F6E20626174746572793C2F6C693E0A3C6C6920636C6173733D2270726F706572747920696E636C756465642D6974656D223E55534220746F200A574D2D706F7274206361626C653C2F6C693E0A3C6C6920636C6173733D2270726F706572747920696E636C756465642D6974656D223E4F776E65722773206D616E75616C3C2F6C693E0A3C2F756C3E0A3C2F6469763E');
INSERT INTO "products" VALUES (6, 1, 6, 2, 7, 'Sony - E-Series Walkman 8GB* MP3 Player - Black', X'3C703E546869732057616C6B6D616E204D503320706C61796572206665617475726573203847422A206F66206D656D6F72792C20736F20796F752063616E2073746F726520796F7572200A6661766F72697465206D6F7669657320616E642074756E65732E20546865206C6172676520322220636F6C6F7220515647412073637265656E20616C6C6F777320796F7520746F200A656173696C79206E61766967617465207468726F7567682066756E6374696F6E732E3C2F703E0A3C703E4D65617375726573206A75737420302E3422207468696E20616E6420776569676873206A75737420312E39206F7A2E3B20757020746F20333020686F757273206D75736963200A706C61796261636B3B20322220636F6C6F722051564741204C434420646973706C61793B2057696E646F7773204D6564696120506C61796572206D75736963200A6D616E6167656D656E7420736F6674776172653B2055534220322E3020636F6E6E65637469766974793B20506C617973466F725375726520636F6D70617469626C652E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (7, 1, 6, 2, 7, 'Sony - E-Series Walkman 8GB* MP3 Player - Black', X'3C703E546869732057616C6B6D616E204D503320706C61796572206665617475726573203847422A206F66206D656D6F72792C20736F20796F752063616E2073746F726520796F7572200A6661766F72697465206D6F7669657320616E642074756E65732E20546865206C6172676520322220636F6C6F7220515647412073637265656E20616C6C6F777320796F7520746F200A656173696C79206E61766967617465207468726F7567682066756E6374696F6E732E3C2F703E0A3C703E4D65617375726573206A75737420302E3422207468696E20616E6420776569676873206A75737420312E39206F7A2E3B20757020746F20333020686F757273206D75736963200A706C61796261636B3B20322220636F6C6F722051564741204C434420646973706C61793B2057696E646F7773204D6564696120506C61796572206D75736963200A6D616E6167656D656E7420736F6674776172653B2055534220322E3020636F6E6E65637469766974793B20506C617973466F725375726520636F6D70617469626C652E3C2F703E', '*nm*/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAhABGAwERAAIRAQMRAf/EAKIAAAIDAQEBAAAAAAAAAAAAAAUGAwQHAgEAAQEBAQEBAQAAAAAAAAAAAAAAAQIDBAUQAAIBAwICBgQHCQwLAQAAAAECAxEEBQASIQYxQWEiEwdRMhS0cYGhciO1F5FCYoJjcxUlNrFS0jNDhJSkFiYnKMHR4aKDJHQ1laUIOBEBAQABBAEDBAMAAAAAAAAAAAERMUECAyFRYZHBEwQU8OES/9oADAMBAAIRAxEAPwBu578x+aMTk1VLx3S5kvCkakxLGlvey2yKNhFe7EKk9et+IhbXzg5prxuZB/xZP4WmZ6LhIvm/zOxAFzJUkAfSy9J/G0yYFpudvMGGYRSS0Z3SKMi4lKvJIWVFVlJBqY249HbpmGEX9vufybcB6m6O22pcyd9xH4hQd71wp9U8fujTMMF3O+efNOMt96y+NKz7IgLibY1Okgg9FNMxAA//AEjzqemJf6Tc/wALVyDPJ/nlzrm8/Bjt4tVkjmkMqzTSkeDC0g7sjFTUrTjpMUaxYeauVufLLJ58qBkLExxK1OBd5kh3U+F66xurLvN99uXsu1sn9a3OtVIEY3ltLuwgui0lZl3UFKdJHo7NZVY/smg4hpfk/wBWgvWfKIuEkd8lJBN3lCSO1XUbTTd6O8eBOg8u+SjbwNcR5RJ3RlASN28Qk92q1UcFHX6NMjOeY8JNd5JgjSGGD6NOjp+/PR6dMgX/AGXnUE9/gK9H+zTII+VBrzta/wDT3vusmtzVK2DBsh8k+Y1B7wntyf6dFrG6gvnI1Mnj/n5X61uNauiQAxCXFytvbRSBGdT3nYqihQWZmIrwCqTwFfRx1lVnJQQW1vbT22TW/E+4SCKO4jETKfVLTIgY0IPDUFK0jvL27jtLd6zSkhd8gjQUBYlnchVAUEkk6oi59tL/AJWxYmmuklnn3wxmFw6LMKd0MG3MVB3GqjsrpgZjgMXfZjILZQ3Ekfd3O4DyvxdY1VI1O53eSRVUVHTUkAE6o6zuMucTfLB7YbqF93hzLujNYpWhkR4yzbWSSNgeJHQQSDoGzyoanPFr2wXo/qkutTVK1fl+v2Q808f5e299h1jdQvznamTx3z8r9a3Gt1IVrC5aGOCVQrNHRlVxuWo9IPTrCpbzJzXCqjLFFEhLLFBGkSbjwLEIBU0FKnQQWeVusfeRXtqypcQkmNmRJFG5SpqjhlYUY9I1M4Cr5i87ZnmO9itr6eOaKxd5KxwQw1nmC+IzGFE3GiqOPbq5MFazvbizn8aAruKlHSRFkjdG9ZHRwysp9BHb06o9vL64vJ0km2DYojiiiRYo40BJCoiAKoqSe0kk8dA8eVX7cWf5m89zm1qapWr8vv8A4Pc0t+WtvfYdY3UH86mplsePQ2V+trjW7okLnLtvFeXMFtKCytFKwXf4dWSNnUbtr0qy9SknoHHWFWuYMbb2NnBMiGN5ZZECmVnqiorAlHjidDVu0dVag6WAp5Ui/XmabJ21sZ4sZYX1xLKY/EhjYWshj8SoKgMwpx15/wAi+Pf+nbpnn+eoF5kZ7mDmHyj5ezOcxtvjJrnMXPsaWtqLSKS39mjIlUD1w77u9rHVMdnjTztj0dO254e/j6kPk/C4bKtlf0pLLGLOya4tRFPBbl5gwAVnuAUpTXsw8jvmrB4TG2eFnxskzy30Uz3kc1xbXOxo3VUCtagKAQSeOmAd8qxTniy/MXnuc2tTUrVcBDIPJjmckcDPbAH+fQjWN1BPO40zOP8AnZX62udbqEWOQGBQeIp0axVRmRRXaAPg1BTu+e+ZcNbX2Jw+SlsrPJRbMrHEQPFQggKSRUd1jWlOB1m8JdWpzsBsxzlzNnMZjcblMlLeY7ER+DjbdyNkKABQF2gVooAqeNOGrx65LmHLnaDEKekDhxFdbZeoF3VAHEipGg0Hyr/bi0/MXvuc2rNUbLhafYTzC35aA/12LWFKHnkf13YfOyn1tc667Mk7l+fFR5OzfLrvxqk+0rsaThtbb3EeJmG6lQHGrOvKivmDm+UL0W91hUVJk3+2NHaNZKUCqEGwyyqx3buKqOFAa6v2jLOMTdJFnrS9uWCok6yyswLKAD1qoJIHYNbvSLnN9/Y5HIw3FmIdohEb+zpIijazbVYzfSSMqkDe5ZiKVPDSdIn5Ay+Dw3MLXubto7qzNpcQxpLaRX6pPKlIpTbTMkb7G48TpekXPMXL8p5zKRZLl+3WxCxw20tpFaRWMblEJecQQlkQljQ947uzbxfZF3ysNOd7U/kL33ObXCajaMKjfYPzBHUb/FgXsr7bENYUmeebfr2y7Gyn1tc66bJGdq30a/Br6HT154ygdlZSVWEdfeb4B0a7celYs4PH8qXOPuP0tfy2N+GdbUKjPGwaIeEzbUagWWu/jxXo05dfKXxFeZXFcs29gsmOy7X14CPEhMDxCh28QWFOHe049fK3zAE8PW/tD0J3h8OperwHHyt/bS2P5C99zm18aMtowjt9inMXZc2/v8WsKSPPNv17Z9j5T62uddLpEhZscVipMNb3UkqtcSMYzbCYLLu6m2EUCGtKlta4/nc+N/xJ4k1x4+fVM+cYv0EstyDyxaZ+/wAZNlBI1tNDHDexvG9vLFLGZDKGR3ps20Kjca+jXefn9nt8N5Qr5dYeVoBa30E3tRCWym42yO5AqpTa2ziSAWPVp+/2e3wZR4/kLA31v4kN9GkhZ1CzXCRodjMvB271SE3ep0Mvp4P3+z2+DLtPL3ByW4lTI2/iNMYVjNztrQ03Big6wekU7eIGn7/Z7fBlctvKvBzYy4vjnMfDJbG5DWb3f0zG2LDuDaAwk21T06fv9nt8GS55VmvONq3RW2vTT+Zy68sZbThSB5Fcwy+maBv69EdYUiedpeTmGABGWkmS27hTcpylwwZT1jjrpdIkZpcQTlNqqTXp1FUzayJ3du3sqBoj4Qyg1XgfSGFf3dQcmGU9ND8Y0H3gyddD8Y0H3gOeofdGgavLYtBzZbyMrMPAu1og3tVrWRRwHw6sG14dD9gOfSo3b4F7K+2RawpF855P7wWlT0JfU+PJ3OumzJNxGatceszT421yKylQj3YY7Cla7Nv77d3uH3NRVTN3X6YyKTWOPgtAUEa2diG2cCTuow3VoeJPo1BJa8rSSLuub2C3NK+GoaZx0cDs7lfxtBzc8ruihre9hn/BYNE1fR3qj5dFSYXJSYtXt7jC2N6RJ4ni38RdlNUoAwPFaIe7+ET6NEcX2VjbFixjxthEaHdeRRn2g1kD+s3RQDbw6idBb8uzTmu1P5O592k1YNow1fsD5gP5SD3yLWFZ/wCd/wD3+z7Uva/+SuddLpGSphxyrJDJ+nHu4yqQrZ+yBW6n8bcGoPXKkcfTrKuLqPAvkLRMIbgrtl9s8fgOk7NnXt2UB3ffV6qaKnt5gjGN+n0dJ+4NBzdTIsaxr3aCgWhHD49ESWdxy6lnKMtHczXKj/ko4X2R1O7dvY1px29A/wBOipr6TkI46U2KX65TumASFTABv+kD1O6nh+qR19OgreXn7U2v5q592k1YjaMMP8AM/wDPg98i1hWeedrf3iteyO7+srrXS7MlHlqwt764uUuFLwxQF9qttIYuibgewMeGoo7FY4e3tna1QUIO6SpckrwpuNevVE8HKOavUmusPZT5FLTb7WbaNpWXdWhZVBbjtNOGmDIfdcvZhreLIT2kkOPnO23ncABz3hwFdw/i26R1agrmxtzCTPTaldzHgBQ0JroB+dsYrSG0aE0WcP4gqSaowp8h1FXvL39qbf8AM3Pu0mrEbRhx/l/z3z4PfItYVnHnWd3McAHUl39ZXWul2ZhP5anaLIMlSPGidKDr20kp8ezUUfuLyIRNGAArA9HboK8Gbykhe0gupra3nK+1RQSPGHCVpuCldwFTSugtpnslAiWcs0klklDBauxZE6eCgmg9duj0nQXLa4tpUIdV3NUsKcKkknhpgL3OsiC9tbVTwgh3EADgZTu4/ihTqK78vf2nhPohuvd5NWI2jD//AJ+zx/Cg97i1hWbecRLcxx9ntg/9jc66XZmEJGkikWWNtkkbBkYdIYGoOoosZRdxGeAU2is8A6Yz6R6UPUeroPaFvHW6bS8i1FOnUHd1HE0CTRLQEVrQg0Pprx0HsVxFaWwvr3+IH8RFWj3DD71fwP379A6OnVyYDY8BzTm7s3QspXe8u4LZpmXw4xPervgU19VXTvKaU2/FrF7OM3XAty1ibzDc8y4y8KG5s1u4pGibfGxWBwSj0G4avDlOUlhZhr2IH+XvO/DB73FqCl51+U+TTLtkrFmksAJXG5SzBpZnnYVXq3SGnDWsoxp8BkSSFiZj6NrD90aZVAcRlIJVkSN4pE4q6naR8fDTIu299lYCPFtI7gA1aoeMn4fCZB8mmUSzZrKMCLfHW1tWlGKyTsKejx3kX/d0UJuLLK3c7TXJeeZuDO7bjQdA+Ds0Q14vmfzDt7a1tra5Ph2tpPYxhkaQtDcUHf6dzxKoWJj6iig4a43p4W5w1/qiOLsOfLx8QktrJeRYW1kssZF4SxBIpF20d1G5+rp463x4zjbZulrZsfyLnYfJXKYdo/1jcrG6R061nSQ8PxdUbHf+xezt7Zs8Cne30p8ugW0+z3edvsu7r9XQUr/7LuPtHstev1dAEuPsYqd/s/xU0FX/AASr/IfJoL1p9jdR4fs9e3boGDH/AGccPZvZa9Xq6BhtP0JQezeB2bdugvd3b1bfk0H/2Q==', 80, 'Y', 10, 'Y', X'3C68323E50726F647563742046656174757265733C2F68323E0A3C756C3E0A3C6C693E3C7374726F6E673E3847422A20696E7465726E616C20666C617368206D656D6F72793C2F7374726F6E673E3C6272202F3E466F722073746F72696E6720736F6E677320616E64206D6F766965732E3C2F6C693E0A3C6C693E3C7374726F6E673E556C747261636F6D706163742064657369676E3C2F7374726F6E673E3C6272202F3E4D65617375726573206A75737420302E3422207468696E20616E6420776569676873200A6F6E6C7920312E39206F756E63657320666F7220706F72746162696C69747920746F207468652067796D2C20746F20776F726B206F72207768656E2074726176656C696E672E3C2F6C693E0A3C6C693E3C7374726F6E673E537570706F7274656420666F726D6174733C2F7374726F6E673E3C6272202F3E496E636C756465204D50332C205741562C204141432C20574D41202844524D292C204C2D50434D2C0A20482E3236342F4156432C204D503420616E6420574D56202844524D2920736F20796F752063616E2074616B6520796F7572206D65646961206F6E2074686520676F2E3C2F6C693E0A3C6C693E3C7374726F6E673E322220636F6C6F722051564741204C43442073637265656E3C2F7374726F6E673E3C6272202F3E416C6C6F777320796F7520746F20656173696C79206E61766967617465200A7468726F7567682066656174757265732E3C2F6C693E0A3C6C693E3C7374726F6E673E4275696C742D696E20464D2074756E65723C2F7374726F6E673E3C6272202F3E466F72206C697374656E696E6720746F20796F7572206661766F7269746520726164696F200A73746174696F6E73206F6E2074686520676F2E3C2F6C693E0A3C6C693E3C7374726F6E673E486967682D73706565642055534220322E3020696E746572666163653C2F7374726F6E673E3C6272202F3E466F7220626C617A696E672D66617374207472616E73666572200A7370656564732E3C2F6C693E0A3C6C693E3C7374726F6E673E436C65617220417564696F20746563686E6F6C6F676965733C2F7374726F6E673E3C6272202F3E44656C6976657220696D70726F76656420736F756E64200A706572666F726D616E63652E3C2F6C693E0A3C6C693E3C7374726F6E673E4275696C742D696E2074696D65723C2F7374726F6E673E3C6272202F3E48656C707320796F75206B65657020747261636B206F66207468652074696D652E3C2F6C693E0A3C6C693E3C7374726F6E673E526563686172676561626C65206C69746869756D2D696F6E20626174746572793C2F7374726F6E673E3C6272202F3E50726F766964657320757020746F20333020686F757273200A6F66206D7573696320706C61796261636B2E3C2F6C693E0A3C6C693E3C7374726F6E673E57696E646F7773204D6564696120506C617965723C2F7374726F6E673E3C6272202F3E4D757369632D6D616E6167656D656E7420736F66747761726520696E636C756465642E3C2F6C693E0A3C6C693E3C7374726F6E673E506C617973466F725375726520636F6D70617469626C653C2F7374726F6E673E3C6272202F3E466F722072656C6961626C6520706C61796261636B2E3C2F6C693E0A3C6C693E3C7374726F6E673E504320636F6D70617469626C653C2F7374726F6E673E3C6272202F3E466F72206D756C746966756E6374696F6E616C207573652E3C2F6C693E0A3C6C693E3C7370616E20636C6173733D224C6567616C223E2A466F726D6174746564206361706163697479206D617920766172792E3C2F7370616E3E3C2F6C693E0A3C2F756C3E', X'3C756C3E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E57617272616E7479205465726D73202D2050617274733C2F6469763E0A3C64697620636C6173733D2264617461223E3120796561723C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E57617272616E7479205465726D73202D204C61626F723C2F6469763E0A3C64697620636C6173733D2264617461223E393020646179733C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E50726F64756374204865696768743C2F6469763E0A3C64697620636C6173733D2264617461223E302E34223C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E50726F647563742057696474683C2F6469763E0A3C64697620636C6173733D2264617461223E312E37353C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E50726F64756374205765696768743C2F6469763E0A3C64697620636C6173733D2264617461223E312E39206F7A2E3C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E50726F647563742044657074683C2F6469763E0A3C64697620636C6173733D2264617461223E332E353C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E53746F7261676520547970653C2F6469763E0A3C64697620636C6173733D2264617461223E466C617368206D656D6F72793C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E4275696C742D496E0A2053746F726167652043617061636974793C2F6469763E0A3C64697620636C6173733D2264617461223E3847422028666F726D6174746564206361706163697479206D61792076617279293C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E496E636C756465640A2052656D6F7661626C65204D656D6F72793C2F6469763E0A3C64697620636C6173733D2264617461223E4E6F6E653C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E52656D6F7661626C650A204D656D6F727920547970653C2F6469763E0A3C64697620636C6173733D2264617461223E4E6F6E653C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E4469676974616C0A20417564696F20466F726D61742055706772616461626C653C2F6469763E0A3C64697620636C6173733D2264617461223E4E6F3C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E436F6D70757465720A20436F6D7061746962696C6974793C2F6469763E0A3C64697620636C6173733D2264617461223E50433C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E4D757369632D4D616E6167656D656E740A20536F6674776172653C2F6469763E0A3C64697620636C6173733D2264617461223E57696E646F7773204D6564696120506C617965723C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E4D75736963205365727669636520436F6D7061746962696C6974793C2F6469763E0A3C64697620636C6173733D2264617461223E4E6F6E653C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E4469676974616C0A20417564696F20466F726D6174733C2F6469763E0A3C64697620636C6173733D2264617461223E4D50332C205741562C204141432C20574D41202844524D292C204C2D50434D2C204D50343C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E506C617973466F725375726520436F6D7061746962696C6974793C2F6469763E0A3C64697620636C6173733D2264617461223E5965733C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E426174746572792053697A653C2F6469763E0A3C64697620636C6173733D2264617461223E526563686172676561626C65206C69746869756D2D696F6E2028696E636C75646564293C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E42617474657279205175616E746974793C2F6469763E0A3C64697620636C6173733D2264617461223E313C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E42617474657279204C6966653C2F6469763E0A3C64697620636C6173733D2264617461223E557020746F20333020686F757273206D7573696320706C61796261636B3C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E417661696C61626C650A20457870616E73696F6E20536C6F74733C2F6469763E0A3C64697620636C6173733D2264617461223E4E6F6E653C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E436F6E6E656374696F6E0A205472616E7366657220526174653C2F6469763E0A3C64697620636C6173733D2264617461223E55534220322E303C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E54756E65720A20547970653C2F6469763E0A3C64697620636C6173733D2264617461223E464D3C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E4865616470686F6E6520547970653C2F6469763E0A3C64697620636C6173733D2264617461223E4561726275643C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E464D2074756E65723C2F6469763E0A3C64697620636C6173733D2264617461223E5965733C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E53797374656D20526571756972656D656E74733C2F6469763E0A3C64697620636C6173733D2264617461223E50432077697468204D6963726F736F66742057696E646F77733C2F6469763E0A3C2F6C693E0A3C6C6920636C6173733D2262616E646564223E0A3C64697620636C6173733D226C6162656C223E426C7565746F6F74682D456E61626C65643C2F6469763E0A3C64697620636C6173733D2264617461223E4E6F3C2F6469763E0A3C2F6C693E0A3C6C693E0A3C64697620636C6173733D226C6162656C223E436F6C6F722043617465676F72793C2F6469763E0A3C64697620636C6173733D2264617461223E426C61636B3C2F6469763E0A3C2F6C693E0A3C2F756C3E', X'3C6469762069643D22626F78636F6E74656E7473223E0A3C68323E57686174277320496E636C756465643C2F68323E0A3C756C20636C6173733D22702D76223E0A3C6C6920636C6173733D2270726F706572747920696E636C756465642D6974656D223E536F6E7920452D5365726965732057616C6B6D616E0A203847422A204D503320506C617965723C2F6C693E0A3C6C6920636C6173733D2270726F706572747920696E636C756465642D6974656D223E3120706169722065617220627564200A6865616470686F6E65733C2F6C693E0A3C6C6920636C6173733D2270726F706572747920696E636C756465642D6974656D223E526563686172676561626C65200A6C69746869756D2D696F6E20626174746572793C2F6C693E0A3C6C6920636C6173733D2270726F706572747920696E636C756465642D6974656D223E55534220746F200A574D2D706F7274206361626C653C2F6C693E0A3C6C6920636C6173733D2270726F706572747920696E636C756465642D6974656D223E4F776E65722773206D616E75616C3C2F6C693E0A3C2F756C3E0A3C2F6469763E');
INSERT INTO "products" VALUES (8, 1, 6, 2, 7, 'Sony - E-Series Walkman 8GB* MP3 Player - Black', X'3C703E546869732057616C6B6D616E204D503320706C61796572206665617475726573203847422A206F66206D656D6F72792C20736F20796F752063616E2073746F726520796F7572200A6661766F72697465206D6F7669657320616E642074756E65732E20546865206C6172676520322220636F6C6F7220515647412073637265656E20616C6C6F777320796F7520746F200A656173696C79206E61766967617465207468726F7567682066756E6374696F6E732E3C2F703E0A3C703E4D65617375726573206A75737420302E3422207468696E20616E6420776569676873206A75737420312E39206F7A2E3B20757020746F20333020686F757273206D75736963200A706C61796261636B3B20322220636F6C6F722051564741204C434420646973706C61793B2057696E646F7773204D6564696120506C61796572206D75736963200A6D616E6167656D656E7420736F6674776172653B2055534220322E3020636F6E6E65637469766974793B20506C617973466F725375726520636F6D70617469626C652E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (9, 1, 6, 2, 7, 'Sony - E-Series Walkman 8GB* MP3 Player - Black', X'3C703E546869732057616C6B6D616E204D503320706C61796572206665617475726573203847422A206F66206D656D6F72792C20736F20796F752063616E2073746F726520796F7572200A6661766F72697465206D6F7669657320616E642074756E65732E20546865206C6172676520322220636F6C6F7220515647412073637265656E20616C6C6F777320796F7520746F200A656173696C79206E61766967617465207468726F7567682066756E6374696F6E732E3C2F703E0A3C703E4D65617375726573206A75737420302E3422207468696E20616E6420776569676873206A75737420312E39206F7A2E3B20757020746F20333020686F757273206D75736963200A706C61796261636B3B20322220636F6C6F722051564741204C434420646973706C61793B2057696E646F7773204D6564696120506C61796572206D75736963200A6D616E6167656D656E7420736F6674776172653B2055534220322E3020636F6E6E65637469766974793B20506C617973466F725375726520636F6D70617469626C652E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (10, 2, 6, 2, 2, 'Sony - 360W Mini Shelf System with Built-In Apple iPod Dock', X'3C703E506C6179732043442C2043442D522F525720616E64204D503320666F726D6174733B20414D2F464D2074756E6572207769746820333020707265736574733B20332D776179200A626173732D7265666C657820737065616B6572733C2F703E0A3C703E54686973206D696E69207368656C662073797374656D2066656174757265732074776F20332D77617920626173732D7265666C657820737065616B65727320666F722072696368200A617564696F20796F752063616E20726F636B206F757420746F2E20546865206275696C742D696E2069506F6420646F636B20616C6C6F777320796F7520746F206C697374656E200A746F20796F7572206661766F726974652074756E657320616E642074686520414D2F464D2074756E657220776974682033302073746174696F6E2070726573657473206D616B65730A206974206561737920746F2066696E642073746174696F6E732061742074686520746F756368206F66206120627574746F6E2E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (11, 2, 6, 2, 2, 'Sony - 360W Mini Shelf System with Built-In Apple iPod Dock', X'3C703E506C6179732043442C2043442D522F525720616E64204D503320666F726D6174733B20414D2F464D2074756E6572207769746820333020707265736574733B20332D776179200A626173732D7265666C657820737065616B6572733C2F703E0A3C703E54686973206D696E69207368656C662073797374656D2066656174757265732074776F20332D77617920626173732D7265666C657820737065616B65727320666F722072696368200A617564696F20796F752063616E20726F636B206F757420746F2E20546865206275696C742D696E2069506F6420646F636B20616C6C6F777320796F7520746F206C697374656E200A746F20796F7572206661766F726974652074756E657320616E642074686520414D2F464D2074756E657220776974682033302073746174696F6E2070726573657473206D616B65730A206974206561737920746F2066696E642073746174696F6E732061742074686520746F756368206F66206120627574746F6E2E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (12, 2, 6, 2, 2, 'Sony - 360W Mini Shelf System with Built-In Apple iPod Dock', X'3C703E506C6179732043442C2043442D522F525720616E64204D503320666F726D6174733B20414D2F464D2074756E6572207769746820333020707265736574733B20332D776179200A626173732D7265666C657820737065616B6572733C2F703E0A3C703E54686973206D696E69207368656C662073797374656D2066656174757265732074776F20332D77617920626173732D7265666C657820737065616B65727320666F722072696368200A617564696F20796F752063616E20726F636B206F757420746F2E20546865206275696C742D696E2069506F6420646F636B20616C6C6F777320796F7520746F206C697374656E200A746F20796F7572206661766F726974652074756E657320616E642074686520414D2F464D2074756E657220776974682033302073746174696F6E2070726573657473206D616B65730A206974206561737920746F2066696E642073746174696F6E732061742074686520746F756368206F66206120627574746F6E2E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (13, 2, 6, 2, 2, X'536F6E79202D2033363057204D696E69205368656C662053797374656D2077697468204275696C742D496E204170706C650A69506F6420446F636B', X'3C703E506C6179732043442C2043442D522F525720616E64204D503320666F726D6174733B20414D2F464D2074756E657220776974682033300A707265736574733B20332D77617920626173732D7265666C657820737065616B6572733C2F703E203C703E54686973206D696E69207368656C662073797374656D2066656174757265732074776F0A332D77617920626173732D7265666C657820737065616B65727320666F72207269636820617564696F20796F752063616E20726F636B206F757420746F2E20546865206275696C742D696E2069506F640A646F636B20616C6C6F777320796F7520746F206C697374656E20746F20796F7572206661766F726974652074756E657320616E642074686520414D2F464D2074756E657220776974682033300A73746174696F6E2070726573657473206D616B6573206974206561737920746F2066696E642073746174696F6E732061742074686520746F756368206F66206120627574746F6E2E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (14, 2, 6, 2, 2, X'536F6E79202D2033363057204D696E69205368656C662053797374656D2077697468204275696C742D496E204170706C650A69506F6420446F636B', X'3C703E506C6179732043442C2043442D522F525720616E64204D503320666F726D6174733B20414D2F464D2074756E657220776974682033300A707265736574733B20332D77617920626173732D7265666C657820737065616B6572733C2F703E203C703E54686973206D696E69207368656C662073797374656D2066656174757265732074776F0A332D77617920626173732D7265666C657820737065616B65727320666F72207269636820617564696F20796F752063616E20726F636B206F757420746F2E20546865206275696C742D696E2069506F640A646F636B20616C6C6F777320796F7520746F206C697374656E20746F20796F7572206661766F726974652074756E657320616E642074686520414D2F464D2074756E657220776974682033300A73746174696F6E2070726573657473206D616B6573206974206561737920746F2066696E642073746174696F6E732061742074686520746F756368206F66206120627574746F6E2E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (15, 2, 6, 2, 2, X'536F6E79202D2033363057204D696E69205368656C662053797374656D2077697468204275696C742D496E204170706C650A69506F6420446F636B', X'3C703E506C6179732043442C2043442D522F525720616E64204D503320666F726D6174733B20414D2F464D2074756E657220776974682033300A707265736574733B20332D77617920626173732D7265666C657820737065616B6572733C2F703E203C703E54686973206D696E69207368656C662073797374656D2066656174757265732074776F0A332D77617920626173732D7265666C657820737065616B65727320666F72207269636820617564696F20796F752063616E20726F636B206F757420746F2E20546865206275696C742D696E2069506F640A646F636B20616C6C6F777320796F7520746F206C697374656E20746F20796F7572206661766F726974652074756E657320616E642074686520414D2F464D2074756E657220776974682033300A73746174696F6E2070726573657473206D616B6573206974206561737920746F2066696E642073746174696F6E732061742074686520746F756368206F66206120627574746F6E2E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (16, 2, 6, 2, 2, X'536F6E79202D2033363057204D696E69205368656C662053797374656D2077697468204275696C742D496E204170706C650A69506F6420446F636B', X'3C703E506C6179732043442C2043442D522F525720616E64204D503320666F726D6174733B20414D2F464D2074756E657220776974682033300A707265736574733B20332D77617920626173732D7265666C657820737065616B6572733C2F703E203C703E54686973206D696E69207368656C662073797374656D2066656174757265732074776F0A332D77617920626173732D7265666C657820737065616B65727320666F72207269636820617564696F20796F752063616E20726F636B206F757420746F2E20546865206275696C742D696E2069506F640A646F636B20616C6C6F777320796F7520746F206C697374656E20746F20796F7572206661766F726974652074756E657320616E642074686520414D2F464D2074756E657220776974682033300A73746174696F6E2070726573657473206D616B6573206974206561737920746F2066696E642073746174696F6E732061742074686520746F756368206F66206120627574746F6E2E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (17, 2, 6, 2, 2, X'536F6E79202D2033363057204D696E69205368656C662053797374656D2077697468204275696C742D496E204170706C650A69506F6420446F636B', X'3C703E506C6179732043442C2043442D522F525720616E64204D503320666F726D6174733B20414D2F464D2074756E657220776974682033300A707265736574733B20332D77617920626173732D7265666C657820737065616B6572733C2F703E203C703E54686973206D696E69207368656C662073797374656D2066656174757265732074776F0A332D77617920626173732D7265666C657820737065616B65727320666F72207269636820617564696F20796F752063616E20726F636B206F757420746F2E20546865206275696C742D696E2069506F640A646F636B20616C6C6F777320796F7520746F206C697374656E20746F20796F7572206661766F726974652074756E657320616E642074686520414D2F464D2074756E657220776974682033300A73746174696F6E2070726573657473206D616B6573206974206561737920746F2066696E642073746174696F6E732061742074686520746F756368206F66206120627574746F6E2E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (18, 2, 6, 2, 2, X'536F6E79202D2033363057204D696E69205368656C662053797374656D2077697468204275696C742D496E204170706C650A69506F6420446F636B', X'3C703E506C6179732043442C2043442D522F525720616E64204D503320666F726D6174733B20414D2F464D2074756E657220776974682033300A707265736574733B20332D77617920626173732D7265666C657820737065616B6572733C2F703E203C703E54686973206D696E69207368656C662073797374656D2066656174757265732074776F0A332D77617920626173732D7265666C657820737065616B65727320666F72207269636820617564696F20796F752063616E20726F636B206F757420746F2E20546865206275696C742D696E2069506F640A646F636B20616C6C6F777320796F7520746F206C697374656E20746F20796F7572206661766F726974652074756E657320616E642074686520414D2F464D2074756E657220776974682033300A73746174696F6E2070726573657473206D616B6573206974206561737920746F2066696E642073746174696F6E732061742074686520746F756368206F66206120627574746F6E2E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (19, 2, 6, 2, 2, X'536F6E79202D2033363057204D696E69205368656C662053797374656D2077697468204275696C742D496E204170706C650A69506F6420446F636B', X'3C703E506C6179732043442C2043442D522F525720616E64204D503320666F726D6174733B20414D2F464D2074756E657220776974682033300A707265736574733B20332D77617920626173732D7265666C657820737065616B6572733C2F703E203C703E54686973206D696E69207368656C662073797374656D2066656174757265732074776F0A332D77617920626173732D7265666C657820737065616B65727320666F72207269636820617564696F20796F752063616E20726F636B206F757420746F2E20546865206275696C742D696E2069506F640A646F636B20616C6C6F777320796F7520746F206C697374656E20746F20796F7572206661766F726974652074756E657320616E642074686520414D2F464D2074756E657220776974682033300A73746174696F6E2070726573657473206D616B6573206974206561737920746F2066696E642073746174696F6E732061742074686520746F756368206F66206120627574746F6E2E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (20, 2, 6, 2, 2, X'536F6E79202D2033363057204D696E69205368656C662053797374656D2077697468204275696C742D496E204170706C650A69506F6420446F636B', X'3C703E506C6179732043442C2043442D522F525720616E64204D503320666F726D6174733B20414D2F464D2074756E657220776974682033300A707265736574733B20332D77617920626173732D7265666C657820737065616B6572733C2F703E203C703E54686973206D696E69207368656C662073797374656D2066656174757265732074776F0A332D77617920626173732D7265666C657820737065616B65727320666F72207269636820617564696F20796F752063616E20726F636B206F757420746F2E20546865206275696C742D696E2069506F640A646F636B20616C6C6F777320796F7520746F206C697374656E20746F20796F7572206661766F726974652074756E657320616E642074686520414D2F464D2074756E657220776974682033300A73746174696F6E2070726573657473206D616B6573206974206561737920746F2066696E642073746174696F6E732061742074686520746F756368206F66206120627574746F6E2E3C2F703E', '*nm*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
INSERT INTO "products" VALUES (21, 2, 6, 1, 27, 'Samsung - 55" Class / 1080p / 120Hz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nm*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', 1499, 'Y', 5, 'Y', X'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', X'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', X'3C703E3C7370616E207374796C653D22666F6E742D66616D696C793A20417269616C2C2056657264616E612C2048656C7665746963612C2073616E732D73657269663B20666F6E742D73697A653A20313170783B223E0A3C6832207374796C653D226D617267696E2D746F703A203070783B206D617267696E2D72696768743A203070783B206D617267696E2D626F74746F6D3A203770783B206D617267696E2D6C6566743A203070783B20666F6E742D73697A653A20313570783B20666F6E742D7765696768743A20626F6C643B2070616464696E673A203070783B223E57686174277320496E636C756465643C2F68323E0A3C756C20636C6173733D22702D7622207374796C653D226D617267696E2D6C6566743A20313670783B206D617267696E2D746F703A203570783B206D617267696E2D626F74746F6D3A203570783B2070616464696E672D6C6566743A203070783B223E0A3C6C6920636C6173733D2270726F706572747920696E636C756465642D6974656D22207374796C653D2270616464696E672D626F74746F6D3A203570783B223E53616D73756E672035352220436C617373202F203130383070202F20313230487A202F204C434420484454563C2F6C693E0A3C6C6920636C6173733D2270726F706572747920696E636C756465642D6974656D22207374796C653D2270616464696E672D626F74746F6D3A203570783B223E5461626C65746F70207374616E643C2F6C693E0A3C6C6920636C6173733D2270726F706572747920696E636C756465642D6974656D22207374796C653D2270616464696E672D626F74746F6D3A203570783B223E52656D6F74653C2F6C693E0A3C6C6920636C6173733D2270726F706572747920696E636C756465642D6974656D22207374796C653D2270616464696E672D626F74746F6D3A203570783B223E4F776E65722773206D616E75616C3C2F6C693E0A3C2F756C3E0A3C2F7370616E3E3C2F703E');
INSERT INTO "products" VALUES (22, 2, 6, 1, 27, 'Samsung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nm*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